/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.jarxlauncher;

import io.vlinx.jarxlauncher.PidChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class Launcher {
    public static boolean DEBUG = false;
    public static byte[] zipxMagic = new byte[]{86, 90, 88, 69};

    public static void main(String[] args) throws Exception {
        String mainClass;
        boolean includeVlxApp = false;
        boolean includeJaxbApi = false;
        boolean includeJaxbCore = false;
        boolean includeJaxbImpl = false;
        boolean includeJaxwsApi = false;
        String javaHome = System.getProperty("java.home");
        String appFolder = new File(javaHome).getParent();
        String libFolderPath = System.getProperty("VlxLib");
        File libFolder = new File(appFolder + File.separator + "vlxlib");
        if (libFolderPath != null && !libFolderPath.isEmpty()) {
            libFolder = new File(appFolder + File.separator + libFolderPath);
        }
        if ((mainClass = System.getProperty("VlxMainClass")) == null || mainClass.isEmpty()) {
            System.err.println("Can't find main class");
            System.exit(1);
        }
        if (System.getProperty("LauncherDebug") != null) {
            DEBUG = true;
        }
        if (DEBUG) {
            System.out.println("[VLX] JarxLauncher 1.6.0");
        }
        if (DEBUG) {
            System.out.println("[VLX] LibFolder: " + libFolderPath);
        }
        if (System.getProperty("DisableParentCheck") == null) {
            if (System.getProperty("VlxPid") == null) {
                System.err.println("[VLX] Invalid VlxPid");
            }
            int vlxPid = Integer.parseInt(System.getProperty("VlxPid"));
            if (DEBUG) {
                System.out.println("[VLX] VlxPid: " + vlxPid);
            }
            PidChecker.startCheck(vlxPid);
        } else if (DEBUG) {
            System.out.println("[VLX] Disable parent process check");
        }
        if (DEBUG) {
            System.out.println("[VLX] Main-Class: " + mainClass);
        }
        if (!libFolder.exists() || libFolder.isFile()) {
            System.err.println("[VLX] Invalid lib folder: " + libFolderPath);
            System.exit(1);
        }
        StringBuilder cpBuilder = new StringBuilder();
        cpBuilder.append(appFolder + File.separator + "launcher.jarx");
        ArrayList<String> classpath = new ArrayList<String>();
        File[] files = libFolder.listFiles();
        for (File file : files) {
            if (file.getName().equals("vlxapp.jar")) {
                includeVlxApp = true;
                continue;
            }
            if (file.getName().equals("jaxb-api-2.3.0.jar")) {
                includeJaxbApi = true;
                continue;
            }
            if (file.getName().equals("jaxb-impl-2.3.0.jar")) {
                includeJaxbImpl = true;
                continue;
            }
            if (file.getName().equals("jaxb-core-2.3.0.jar")) {
                includeJaxbCore = true;
                continue;
            }
            if (file.getName().equals("jaxws-api-2.2.6.jar")) {
                includeJaxwsApi = true;
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar") && !file.getName().toLowerCase().endsWith(".jarx") && !file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".zipx") && !file.getName().toLowerCase().endsWith(".war") && !file.getName().toLowerCase().endsWith(".warx")) continue;
            classpath.add(file.getAbsolutePath());
        }
        if (includeVlxApp) {
            classpath.add(0, libFolder.getAbsolutePath() + File.separator + "vlxapp.jar");
        }
        if (includeJaxbApi) {
            classpath.add(libFolder.getAbsolutePath() + File.separator + "jaxb-api-2.3.0.jar");
        }
        if (includeJaxbImpl) {
            classpath.add(libFolder.getAbsolutePath() + File.separator + "jaxb-impl-2.3.0.jar");
        }
        if (includeJaxbCore) {
            classpath.add(libFolder.getAbsolutePath() + File.separator + "jaxb-core-2.3.0.jar");
        }
        if (includeJaxwsApi) {
            classpath.add(libFolder.getAbsolutePath() + File.separator + "jaxws-api-2.2.6.jar");
        }
        for (String cpItem : classpath) {
            cpBuilder.append(File.pathSeparator + cpItem);
        }
        String cp = cpBuilder.toString();
        if (DEBUG) {
            System.out.println("[VLX] FailedCheckTimes: 20");
            System.out.println("[VLX] Classpath: " + cp);
        }
        System.setProperty("$vlxcp", cp);
        System.setProperty("java.class.path", cp);
        Class<?> c = Class.forName(mainClass, true, Launcher.class.getClassLoader());
        Method main = c.getMethod("main", args.getClass());
        main.invoke(null, new Object[]{args});
    }

    public static boolean isValidJarxFile(File file) throws IOException {
        if (file.length() < 4L) {
            return false;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] magic = new byte[4];
        fis.read(magic);
        fis.close();
        return Arrays.equals(magic, zipxMagic);
    }
}

