/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.InternalLock;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private static final StackTraceElement[] UNASSIGNED_STACK = new StackTraceElement[0];
    private Throwable cause = this;
    private StackTraceElement[] stackTrace = UNASSIGNED_STACK;
    private static final List<Throwable> SUPPRESSED_SENTINEL = Collections.unmodifiableList(new ArrayList(0));
    private List<Throwable> suppressedExceptions = SUPPRESSED_SENTINEL;
    private static final String NULL_CAUSE_MESSAGE = "Cannot suppress a null exception.";
    private static final String SELF_SUPPRESSION_MESSAGE = "Self-suppression not permitted";
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    protected Throwable(String string, Throwable throwable, boolean bl, boolean bl2) {
        if (bl2) {
            this.fillInStackTrace();
        } else {
            this.stackTrace = null;
        }
        this.detailMessage = string;
        this.cause = throwable;
        if (!bl) {
            this.suppressedExceptions = null;
        }
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public synchronized Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause with " + Objects.toString(throwable, "a null"), this);
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted", this);
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new WrappedPrintStream(printStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter printStreamOrWriter) {
        Set<Throwable> set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(this);
        Object object = printStreamOrWriter.lock();
        synchronized (object) {
            printStreamOrWriter.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (StackTraceElement serializable : stackTraceElementArray) {
                printStreamOrWriter.println("\tat " + serializable);
            }
            for (Serializable serializable : this.getSuppressed()) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray, SUPPRESSED_CAPTION, "\t", set);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray, CAUSE_CAPTION, "", set);
            }
        }
    }

    private void printEnclosedStackTrace(PrintStreamOrWriter printStreamOrWriter, StackTraceElement[] stackTraceElementArray, String string, String string2, Set<Throwable> set) {
        assert (Thread.holdsLock(printStreamOrWriter.lock()));
        if (set.contains(this)) {
            printStreamOrWriter.println("\t[CIRCULAR REFERENCE:" + this + "]");
        } else {
            set.add(this);
            StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
            int n = stackTraceElementArray2.length - 1;
            for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
            }
            int n2 = stackTraceElementArray2.length - 1 - n;
            printStreamOrWriter.println(string2 + string + this);
            for (int i = 0; i <= n; ++i) {
                printStreamOrWriter.println(string2 + "\tat " + stackTraceElementArray2[i]);
            }
            if (n2 != 0) {
                printStreamOrWriter.println(string2 + "\t... " + n2 + " more");
            }
            for (Throwable throwable : this.getSuppressed()) {
                throwable.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray2, SUPPRESSED_CAPTION, string2 + "\t", set);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray2, CAUSE_CAPTION, string2, set);
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(new WrappedPrintWriter(printWriter));
    }

    public synchronized Throwable fillInStackTrace() {
        if (this.stackTrace != null || this.backtrace != null) {
            this.fillInStackTrace(0);
            this.stackTrace = UNASSIGNED_STACK;
        }
        return this;
    }

    private native Throwable fillInStackTrace(int var1);

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == UNASSIGNED_STACK || this.stackTrace == null && this.backtrace != null) {
            int n = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[n];
            for (int i = 0; i < n; ++i) {
                this.stackTrace[i] = this.getStackTraceElement(i);
            }
        } else if (this.stackTrace == null) {
            return UNASSIGNED_STACK;
        }
        return this.stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.stackTrace == null && this.backtrace == null) {
                return;
            }
            this.stackTrace = stackTraceElementArray2;
        }
    }

    native int getStackTraceDepth();

    native StackTraceElement getStackTraceElement(int var1);

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.suppressedExceptions != null) {
            StackTraceElement[] stackTraceElementArray = null;
            if (this.suppressedExceptions.isEmpty()) {
                stackTraceElementArray = SUPPRESSED_SENTINEL;
            } else {
                stackTraceElementArray = new ArrayList<Throwable>(1);
                for (Throwable throwable : this.suppressedExceptions) {
                    if (throwable == null) {
                        throw new NullPointerException(NULL_CAUSE_MESSAGE);
                    }
                    if (throwable == this) {
                        throw new IllegalArgumentException(SELF_SUPPRESSION_MESSAGE);
                    }
                    stackTraceElementArray.add(throwable);
                }
            }
            this.suppressedExceptions = stackTraceElementArray;
        }
        if (this.stackTrace != null) {
            if (this.stackTrace.length == 0) {
                this.stackTrace = (StackTraceElement[])UNASSIGNED_STACK.clone();
            } else if (this.stackTrace.length == 1 && SentinelHolder.STACK_TRACE_ELEMENT_SENTINEL.equals(this.stackTrace[0])) {
                this.stackTrace = null;
            } else {
                for (StackTraceElement stackTraceElement : this.stackTrace) {
                    if (stackTraceElement != null) continue;
                    throw new NullPointerException("null StackTraceElement in serial stream. ");
                }
            }
        } else {
            this.stackTrace = (StackTraceElement[])UNASSIGNED_STACK.clone();
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        StackTraceElement[] stackTraceElementArray = this.stackTrace;
        try {
            if (this.stackTrace == null) {
                this.stackTrace = SentinelHolder.STACK_TRACE_SENTINEL;
            }
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.stackTrace = stackTraceElementArray;
        }
    }

    public final synchronized void addSuppressed(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException(SELF_SUPPRESSION_MESSAGE, throwable);
        }
        if (throwable == null) {
            throw new NullPointerException(NULL_CAUSE_MESSAGE);
        }
        if (this.suppressedExceptions == null) {
            return;
        }
        if (this.suppressedExceptions == SUPPRESSED_SENTINEL) {
            this.suppressedExceptions = new ArrayList<Throwable>(1);
        }
        this.suppressedExceptions.add(throwable);
    }

    public final synchronized Throwable[] getSuppressed() {
        if (this.suppressedExceptions == SUPPRESSED_SENTINEL || this.suppressedExceptions == null) {
            return EMPTY_THROWABLE_ARRAY;
        }
        return this.suppressedExceptions.toArray(EMPTY_THROWABLE_ARRAY);
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return SharedSecrets.getJavaIOPrintWriterAccess().lock(this.printWriter);
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return SharedSecrets.getJavaIOPrintStreamAccess().lock(this.printStream);
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        abstract Object lock();

        boolean isLockedByCurrentThread() {
            Object lock = this.lock();
            if (lock instanceof InternalLock) {
                InternalLock locker = (InternalLock)lock;
                return locker.isHeldByCurrentThread();
            }
            return Thread.holdsLock(lock);
        }

        abstract void println(Object var1);
    }

    private static class SentinelHolder {
        public static final StackTraceElement STACK_TRACE_ELEMENT_SENTINEL = new StackTraceElement("", "", null, Integer.MIN_VALUE);
        public static final StackTraceElement[] STACK_TRACE_SENTINEL = new StackTraceElement[]{STACK_TRACE_ELEMENT_SENTINEL};

        private SentinelHolder() {
        }
    }
}

