/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    char[] value;
    int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int n) {
        this.value = new char[n];
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n) {
        if (n > 0) {
            this.ensureCapacityInternal(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        if (n - this.value.length > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(n));
        }
    }

    private int newCapacity(int n) {
        int n2 = (this.value.length << 1) + 2;
        if (n2 - n < 0) {
            n2 = n;
        }
        return n2 <= 0 || 0x7FFFFFF7 - n2 < 0 ? this.hugeCapacity(n) : n2;
    }

    private int hugeCapacity(int n) {
        if (Integer.MAX_VALUE - n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? n : 0x7FFFFFF7;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacityInternal(n);
        if (this.count < n) {
            Arrays.fill(this.value, this.count, n, '\u0000');
        }
        this.count = n;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public int codePointAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointAtImpl(this.value, n, this.count);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointBeforeImpl(this.value, n, 0);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, n, n2 - n);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, 0, this.count, n, n2);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public AbstractStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public AbstractStringBuilder append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n = string.length();
        this.ensureCapacityInternal(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        int n = stringBuffer.length();
        this.ensureCapacityInternal(this.count + n);
        stringBuffer.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    AbstractStringBuilder append(AbstractStringBuilder abstractStringBuilder) {
        if (abstractStringBuilder == null) {
            return this.appendNull();
        }
        int n = abstractStringBuilder.length();
        this.ensureCapacityInternal(this.count + n);
        abstractStringBuilder.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof AbstractStringBuilder) {
            return this.append((AbstractStringBuilder)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    private AbstractStringBuilder appendNull() {
        int n = this.count;
        this.ensureCapacityInternal(n + 4);
        char[] cArray = this.value;
        cArray[n++] = 110;
        cArray[n++] = 117;
        cArray[n++] = 108;
        cArray[n++] = 108;
        this.count = n;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n + ", end " + n2 + ", s.length() " + charSequence.length());
        }
        int n3 = n2 - n;
        this.ensureCapacityInternal(this.count + n3);
        int n4 = n;
        int n5 = this.count;
        while (n4 < n2) {
            this.value[n5] = charSequence.charAt(n4);
            ++n4;
            ++n5;
        }
        this.count += n3;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray) {
        int n = cArray.length;
        this.ensureCapacityInternal(this.count + n);
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            this.ensureCapacityInternal(this.count + n2);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public AbstractStringBuilder append(boolean bl) {
        if (bl) {
            this.ensureCapacityInternal(this.count + 4);
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            this.ensureCapacityInternal(this.count + 5);
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    @Override
    public AbstractStringBuilder append(char c) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public AbstractStringBuilder append(int n) {
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int n2 = n < 0 ? Integer.stringSize(-n) + 1 : Integer.stringSize(n);
        int n3 = this.count + n2;
        this.ensureCapacityInternal(n3);
        Integer.getChars(n, n3, this.value);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder append(long l) {
        if (l == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int n = l < 0L ? Long.stringSize(-l) + 1 : Long.stringSize(l);
        int n2 = this.count + n;
        this.ensureCapacityInternal(n2);
        Long.getChars((long)l, (int)n2, (char[])this.value);
        this.count = n2;
        return this;
    }

    public AbstractStringBuilder append(float f) {
        FloatingDecimal.appendTo((float)f, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double d) {
        FloatingDecimal.appendTo((double)d, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int n) {
        int n2 = this.count;
        if (Character.isBmpCodePoint(n)) {
            this.ensureCapacityInternal(n2 + 1);
            this.value[n2] = (char)n;
            this.count = n2 + 1;
        } else if (Character.isValidCodePoint(n)) {
            this.ensureCapacityInternal(n2 + 2);
            Character.toSurrogates(n, this.value, n2);
            this.count = n2 + 2;
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public AbstractStringBuilder deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        this.ensureCapacityInternal(n4);
        System.arraycopy(this.value, n2, this.value, n + n3, this.count - n2);
        string.getChars(this.value, n);
        this.count = n4;
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new String(this.value, n, n2 - n);
    }

    public AbstractStringBuilder insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n3 < 0 || n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException("offset " + n2 + ", len " + n3 + ", str.length " + cArray.length);
        }
        this.ensureCapacityInternal(this.count + n3);
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count += n3;
        return this;
    }

    public AbstractStringBuilder insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public AbstractStringBuilder insert(int n, String string) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.length();
        this.ensureCapacityInternal(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(this.value, n);
        this.count += n2;
        return this;
    }

    public AbstractStringBuilder insert(int n, char[] cArray) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = cArray.length;
        this.ensureCapacityInternal(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count += n2;
        return this;
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n, (String)charSequence);
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n < 0 || n > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + n);
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n2 + ", end " + n3 + ", s.length() " + charSequence.length());
        }
        int n4 = n3 - n2;
        this.ensureCapacityInternal(this.count + n4);
        System.arraycopy(this.value, n, this.value, n + n4, this.count - n);
        for (int i = n2; i < n3; ++i) {
            this.value[n++] = charSequence.charAt(i);
        }
        this.count += n4;
        return this;
    }

    public AbstractStringBuilder insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public AbstractStringBuilder insert(int n, char c) {
        this.ensureCapacityInternal(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public AbstractStringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public AbstractStringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public AbstractStringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public AbstractStringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, 0, this.count, string, n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, 0, this.count, string, n);
    }

    public AbstractStringBuilder reverse() {
        boolean bl = false;
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c;
            int n2 = n - i;
            char c2 = this.value[i];
            this.value[i] = c = this.value[n2];
            this.value[n2] = c2;
            if (!Character.isSurrogate(c2) && !Character.isSurrogate(c)) continue;
            bl = true;
        }
        if (bl) {
            this.reverseAllValidSurrogatePairs();
        }
        return this;
    }

    private void reverseAllValidSurrogatePairs() {
        for (int i = 0; i < this.count - 1; ++i) {
            char c;
            char c2 = this.value[i];
            if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c = this.value[i + 1])) continue;
            this.value[i++] = c;
            this.value[i] = c2;
        }
    }

    @Override
    public abstract String toString();

    final char[] getValue() {
        return this.value;
    }
}

