#include <winapifamily.h>

/*++

Copyright (c) Microsoft Corporation. All rights reserved.

Module Name:

    ksmedia.h

Abstract:

    WDM-CSA Multimedia Definitions.

--*/

#if !defined(_KS_)
#error KS.H must be included before KSMEDIA.H
#endif // !defined(_KS_)

#if !defined(_KSMEDIA_)
#define _KSMEDIA_


#pragma warning(disable:4201) // nameless struct/union
#pragma warning(disable:4214) // bit field types other than int

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

typedef struct {
    KSPROPERTY      Property;
    KSMULTIPLE_ITEM MultipleItem;
} KSMULTIPLE_DATA_PROP, *PKSMULTIPLE_DATA_PROP;

#define STATIC_KSMEDIUMSETID_MidiBus \
    0x05908040L, 0x3246, 0x11D0, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("05908040-3246-11D0-A5D6-28DB04C10000", KSMEDIUMSETID_MidiBus);
#define KSMEDIUMSETID_MidiBus DEFINE_GUIDNAMED(KSMEDIUMSETID_MidiBus)

#define STATIC_KSMEDIUMSETID_VPBus \
    0xA18C15ECL, 0xCE43, 0x11D0, 0xAB, 0xE7, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("A18C15EC-CE43-11D0-ABE7-00A0C9223196", KSMEDIUMSETID_VPBus);
#define KSMEDIUMSETID_VPBus DEFINE_GUIDNAMED(KSMEDIUMSETID_VPBus)

#define STATIC_KSINTERFACESETID_Media \
    0x3A13EB40L, 0x30A7, 0x11D0, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("3A13EB40-30A7-11D0-A5D6-28DB04C10000", KSINTERFACESETID_Media);
#define KSINTERFACESETID_Media DEFINE_GUIDNAMED(KSINTERFACESETID_Media)

typedef enum {
    KSINTERFACE_MEDIA_MUSIC,                    //Reserved for system use
    KSINTERFACE_MEDIA_WAVE_BUFFERED,            //Reserved for system use
    KSINTERFACE_MEDIA_WAVE_QUEUED
} KSINTERFACE_MEDIA;


#if (NTDDI_VERSION >= NTDDI_WINXP)

#if !defined(INIT_USBAUDIO_MID)
// {4e1cecd2-1679-463b-a72f-a5bf64c86eba}
#define INIT_USBAUDIO_MID(guid, id)\
{\
    (guid)->Data1 = 0x4e1cecd2 + (USHORT)(id);\
    (guid)->Data2 = 0x1679;\
    (guid)->Data3 = 0x463b;\
    (guid)->Data4[0] = 0xa7;\
    (guid)->Data4[1] = 0x2f;\
    (guid)->Data4[2] = 0xa5;\
    (guid)->Data4[3] = 0xbf;\
    (guid)->Data4[4] = 0x64;\
    (guid)->Data4[5] = 0xc8;\
    (guid)->Data4[6] = 0x6e;\
    (guid)->Data4[7] = 0xba;\
}
#define EXTRACT_USBAUDIO_MID(guid)\
    (USHORT)((guid)->Data1 - 0x4e1cecd2)
#define DEFINE_USBAUDIO_MID_GUID(id)\
    0x4e1cecd2+(USHORT)(id), 0x1679, 0x463b, 0xa7, 0x2f, 0xa5, 0xbf, 0x64, 0xc8, 0x6e, 0xba

#define INIT_EXBUS_MANUFACTURER_ID INIT_USBAUDIO_MID

#define IS_COMPATIBLE_USBAUDIO_MID(guid)\
    (((guid)->Data1 >= 0x4e1cecd2) &&\
    ((guid)->Data1 < 0x4e1cecd2 + 0xffff) &&\
    ((guid)->Data2 == 0x1679) &&\
    ((guid)->Data3 == 0x463b) &&\
    ((guid)->Data4[0] == 0xa7) &&\
    ((guid)->Data4[1] == 0x2f) &&\
    ((guid)->Data4[2] == 0xa5) &&\
    ((guid)->Data4[3] == 0xbf) &&\
    ((guid)->Data4[4] == 0x64) &&\
    ((guid)->Data4[5] == 0xc8) &&\
    ((guid)->Data4[6] == 0x6e) &&\
    ((guid)->Data4[7] == 0xba))
#endif // !defined(INIT_USBAUDIO_MID)

#if !defined(INIT_USBAUDIO_PID)
// {abcc5a5e-c263-463b-a72f-a5bf64c86eba}
#define INIT_USBAUDIO_PID(guid, id)\
{\
    (guid)->Data1 = 0xabcc5a5e + (USHORT)(id);\
    (guid)->Data2 = 0xc263;\
    (guid)->Data3 = 0x463b;\
    (guid)->Data4[0] = 0xa7;\
    (guid)->Data4[1] = 0x2f;\
    (guid)->Data4[2] = 0xa5;\
    (guid)->Data4[3] = 0xbf;\
    (guid)->Data4[4] = 0x64;\
    (guid)->Data4[5] = 0xc8;\
    (guid)->Data4[6] = 0x6e;\
    (guid)->Data4[7] = 0xba;\
}
#define EXTRACT_USBAUDIO_PID(guid)\
    (USHORT)((guid)->Data1 - 0xabcc5a5e)
#define DEFINE_USBAUDIO_PID_GUID(id)\
    0xabcc5a5e+(USHORT)(id), 0xc263, 0x463b, 0xa7, 0x2f, 0xa5, 0xbf, 0x64, 0xc8, 0x6e, 0xba

#define INIT_EXBUS_PRODUCT_ID INIT_USBAUDIO_PID

#define IS_COMPATIBLE_USBAUDIO_PID(guid)\
    (((guid)->Data1 >= 0xabcc5a5e) &&\
    ((guid)->Data1 < 0xabcc5a5e + 0xffff) &&\
    ((guid)->Data2 == 0xc263) &&\
    ((guid)->Data3 == 0x463b) &&\
    ((guid)->Data4[0] == 0xa7) &&\
    ((guid)->Data4[1] == 0x2f) &&\
    ((guid)->Data4[2] == 0xa5) &&\
    ((guid)->Data4[3] == 0xbf) &&\
    ((guid)->Data4[4] == 0x64) &&\
    ((guid)->Data4[5] == 0xc8) &&\
    ((guid)->Data4[6] == 0x6e) &&\
    ((guid)->Data4[7] == 0xba))
#endif // !defined(INIT_USBAUDIO_PID)

#if !defined(INIT_USBAUDIO_PRODUCT_NAME)
// {FC575048-2E08-463B-A72F-A5BF64C86EBA}
#define INIT_USBAUDIO_PRODUCT_NAME(guid, vid, pid, strIndex)\
{\
    (guid)->Data1 = 0XFC575048 + (USHORT)(vid);\
    (guid)->Data2 = 0x2E08     + (USHORT)(pid);\
    (guid)->Data3 = 0x463B     + (USHORT)(strIndex);\
    (guid)->Data4[0] = 0xA7;\
    (guid)->Data4[1] = 0x2F;\
    (guid)->Data4[2] = 0xA5;\
    (guid)->Data4[3] = 0xBF;\
    (guid)->Data4[4] = 0x64;\
    (guid)->Data4[5] = 0xC8;\
    (guid)->Data4[6] = 0x6E;\
    (guid)->Data4[7] = 0xBA;\
}
#define DEFINE_USBAUDIO_PRODUCT_NAME(vid, pid, strIndex)\
    0xFC575048+(USHORT)(vid), 0x2E08+(USHORT)(pid), 0x463B+(USHORT)(strIndex), 0xA7, 0x2F, 0xA5, 0xBF, 0x64, 0xC8, 0x6E, 0xBA
#endif // !defined(INIT_USBAUDIO_PRODUCT_NAME)

#define INIT_EXBUS_PRODUCT_NAME INIT_USBAUDIO_PRODUCT_NAME

// USB Component ID
#define STATIC_KSCOMPONENTID_USBAUDIO \
    0x8F1275F0, 0x26E9, 0x4264, 0xBA, 0x4D, 0x39, 0xFF, 0xF0, 0x1D, 0x94, 0xAA
DEFINE_GUIDSTRUCT("8F1275F0-26E9-4264-BA4D-39FFF01D94AA", KSCOMPONENTID_USBAUDIO);
#define KSCOMPONENTID_USBAUDIO DEFINE_GUIDNAMED(KSCOMPONENTID_USBAUDIO)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

// USB Terminals
#define INIT_USB_TERMINAL(guid, id)\
{\
    (guid)->Data1 = 0xDFF219E0 + (USHORT)(id);\
    (guid)->Data2 = 0xF70F;\
    (guid)->Data3 = 0x11D0;\
    (guid)->Data4[0] = 0xb9;\
    (guid)->Data4[1] = 0x17;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}
#define EXTRACT_USB_TERMINAL(guid)\
    (USHORT)((guid)->Data1 - 0xDFF219E0)
#define DEFINE_USB_TERMINAL_GUID(id)\
    0xDFF219E0+(USHORT)(id), 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96

#define STATIC_KSNODETYPE_INPUT_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0200)
DEFINE_GUIDSTRUCT("DFF21BE0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_INPUT_UNDEFINED);
#define KSNODETYPE_INPUT_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_INPUT_UNDEFINED)

#define STATIC_KSNODETYPE_MICROPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0201)
DEFINE_GUIDSTRUCT("DFF21BE1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_MICROPHONE);
#define KSNODETYPE_MICROPHONE DEFINE_GUIDNAMED(KSNODETYPE_MICROPHONE)

#define STATIC_KSNODETYPE_DESKTOP_MICROPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0202)
DEFINE_GUIDSTRUCT("DFF21BE2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DESKTOP_MICROPHONE);
#define KSNODETYPE_DESKTOP_MICROPHONE DEFINE_GUIDNAMED(KSNODETYPE_DESKTOP_MICROPHONE)

#define STATIC_KSNODETYPE_PERSONAL_MICROPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0203)
DEFINE_GUIDSTRUCT("DFF21BE3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_PERSONAL_MICROPHONE);
#define KSNODETYPE_PERSONAL_MICROPHONE DEFINE_GUIDNAMED(KSNODETYPE_PERSONAL_MICROPHONE)

#define STATIC_KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0204)
DEFINE_GUIDSTRUCT("DFF21BE4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE);
#define KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE DEFINE_GUIDNAMED(KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE)

#define STATIC_KSNODETYPE_MICROPHONE_ARRAY\
    DEFINE_USB_TERMINAL_GUID(0x0205)
DEFINE_GUIDSTRUCT("DFF21BE5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_MICROPHONE_ARRAY);
#define KSNODETYPE_MICROPHONE_ARRAY DEFINE_GUIDNAMED(KSNODETYPE_MICROPHONE_ARRAY)

#define STATIC_KSNODETYPE_PROCESSING_MICROPHONE_ARRAY\
    DEFINE_USB_TERMINAL_GUID(0x0206)
DEFINE_GUIDSTRUCT("DFF21BE6-F70F-11D0-B917-00A0C9223196", KSNODETYPE_PROCESSING_MICROPHONE_ARRAY);
#define KSNODETYPE_PROCESSING_MICROPHONE_ARRAY DEFINE_GUIDNAMED(KSNODETYPE_PROCESSING_MICROPHONE_ARRAY)

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR \
    0x830a44f2, 0xa32d, 0x476b,  0xbe, 0x97, 0x42, 0x84, 0x56, 0x73, 0xb3, 0x5a
DEFINE_GUIDSTRUCT("830a44f2-a32d-476b-be97-42845673b35a", KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR);
#define KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR DEFINE_GUIDNAMED(KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_OUTPUT_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0300)
DEFINE_GUIDSTRUCT("DFF21CE0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_OUTPUT_UNDEFINED);
#define KSNODETYPE_OUTPUT_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_OUTPUT_UNDEFINED)

#define STATIC_KSNODETYPE_SPEAKER\
    DEFINE_USB_TERMINAL_GUID(0x0301)
DEFINE_GUIDSTRUCT("DFF21CE1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_SPEAKER);
#define KSNODETYPE_SPEAKER DEFINE_GUIDNAMED(KSNODETYPE_SPEAKER)

#define STATIC_KSNODETYPE_HEADPHONES\
    DEFINE_USB_TERMINAL_GUID(0x0302)
DEFINE_GUIDSTRUCT("DFF21CE2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_HEADPHONES);
#define KSNODETYPE_HEADPHONES DEFINE_GUIDNAMED(KSNODETYPE_HEADPHONES)

#define STATIC_KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x0303)
DEFINE_GUIDSTRUCT("DFF21CE3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO);
#define KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO)

#define STATIC_KSNODETYPE_DESKTOP_SPEAKER\
    DEFINE_USB_TERMINAL_GUID(0x0304)
DEFINE_GUIDSTRUCT("DFF21CE4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DESKTOP_SPEAKER);
#define KSNODETYPE_DESKTOP_SPEAKER DEFINE_GUIDNAMED(KSNODETYPE_DESKTOP_SPEAKER)

#define STATIC_KSNODETYPE_ROOM_SPEAKER\
    DEFINE_USB_TERMINAL_GUID(0x0305)
DEFINE_GUIDSTRUCT("DFF21CE5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_ROOM_SPEAKER);
#define KSNODETYPE_ROOM_SPEAKER DEFINE_GUIDNAMED(KSNODETYPE_ROOM_SPEAKER)

#define STATIC_KSNODETYPE_COMMUNICATION_SPEAKER\
    DEFINE_USB_TERMINAL_GUID(0x0306)
DEFINE_GUIDSTRUCT("DFF21CE6-F70F-11D0-B917-00A0C9223196", KSNODETYPE_COMMUNICATION_SPEAKER);
#define KSNODETYPE_COMMUNICATION_SPEAKER DEFINE_GUIDNAMED(KSNODETYPE_COMMUNICATION_SPEAKER)

#define STATIC_KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER\
    DEFINE_USB_TERMINAL_GUID(0x0307)
DEFINE_GUIDSTRUCT("DFF21CE7-F70F-11D0-B917-00A0C9223196", KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER);
#define KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER DEFINE_GUIDNAMED(KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER)

#define STATIC_KSNODETYPE_BIDIRECTIONAL_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0400)
DEFINE_GUIDSTRUCT("DFF21DE0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_BIDIRECTIONAL_UNDEFINED);
#define KSNODETYPE_BIDIRECTIONAL_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_BIDIRECTIONAL_UNDEFINED)

#define STATIC_KSNODETYPE_HANDSET\
    DEFINE_USB_TERMINAL_GUID(0x0401)
DEFINE_GUIDSTRUCT("DFF21DE1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_HANDSET);
#define KSNODETYPE_HANDSET DEFINE_GUIDNAMED(KSNODETYPE_HANDSET)

#define KSNODETYPE_HEADSET_MICROPHONE   KSNODETYPE_PERSONAL_MICROPHONE
#define KSNODETYPE_HEADSET_SPEAKERS     KSNODETYPE_COMMUNICATION_SPEAKER

#define STATIC_KSNODETYPE_HEADSET\
    DEFINE_USB_TERMINAL_GUID(0x0402)
DEFINE_GUIDSTRUCT("DFF21DE2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_HEADSET);
#define KSNODETYPE_HEADSET DEFINE_GUIDNAMED(KSNODETYPE_HEADSET)

#define STATIC_KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION\
    DEFINE_USB_TERMINAL_GUID(0x0403)
DEFINE_GUIDSTRUCT("DFF21DE3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION);
#define KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION DEFINE_GUIDNAMED(KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION)

#define STATIC_KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0404)
DEFINE_GUIDSTRUCT("DFF21DE4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE);
#define KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE DEFINE_GUIDNAMED(KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE)

#define STATIC_KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0405)
DEFINE_GUIDSTRUCT("DFF21DE5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE);
#define KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE DEFINE_GUIDNAMED(KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE)

#define STATIC_KSNODETYPE_TELEPHONY_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0500)
DEFINE_GUIDSTRUCT("DFF21EE0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_TELEPHONY_UNDEFINED);
#define KSNODETYPE_TELEPHONY_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_TELEPHONY_UNDEFINED)

#define STATIC_KSNODETYPE_PHONE_LINE\
    DEFINE_USB_TERMINAL_GUID(0x0501)
DEFINE_GUIDSTRUCT("DFF21EE1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_PHONE_LINE);
#define KSNODETYPE_PHONE_LINE DEFINE_GUIDNAMED(KSNODETYPE_PHONE_LINE)

#define STATIC_KSNODETYPE_TELEPHONE\
    DEFINE_USB_TERMINAL_GUID(0x0502)
DEFINE_GUIDSTRUCT("DFF21EE2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_TELEPHONE);
#define KSNODETYPE_TELEPHONE DEFINE_GUIDNAMED(KSNODETYPE_TELEPHONE)

#define STATIC_KSNODETYPE_DOWN_LINE_PHONE\
    DEFINE_USB_TERMINAL_GUID(0x0503)
DEFINE_GUIDSTRUCT("DFF21EE3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DOWN_LINE_PHONE);
#define KSNODETYPE_DOWN_LINE_PHONE DEFINE_GUIDNAMED(KSNODETYPE_DOWN_LINE_PHONE)

#define STATIC_KSNODETYPE_EXTERNAL_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0600)
DEFINE_GUIDSTRUCT("DFF21FE0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_EXTERNAL_UNDEFINED);
#define KSNODETYPE_EXTERNAL_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_EXTERNAL_UNDEFINED)

#define STATIC_KSNODETYPE_ANALOG_CONNECTOR\
    DEFINE_USB_TERMINAL_GUID(0x601)
DEFINE_GUIDSTRUCT("DFF21FE1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_ANALOG_CONNECTOR);
#define KSNODETYPE_ANALOG_CONNECTOR DEFINE_GUIDNAMED(KSNODETYPE_ANALOG_CONNECTOR)

#define STATIC_KSNODETYPE_DIGITAL_AUDIO_INTERFACE\
    DEFINE_USB_TERMINAL_GUID(0x0602)
DEFINE_GUIDSTRUCT("DFF21FE2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DIGITAL_AUDIO_INTERFACE);
#define KSNODETYPE_DIGITAL_AUDIO_INTERFACE DEFINE_GUIDNAMED(KSNODETYPE_DIGITAL_AUDIO_INTERFACE)

#define STATIC_KSNODETYPE_LINE_CONNECTOR\
    DEFINE_USB_TERMINAL_GUID(0x0603)
DEFINE_GUIDSTRUCT("DFF21FE3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_LINE_CONNECTOR);
#define KSNODETYPE_LINE_CONNECTOR DEFINE_GUIDNAMED(KSNODETYPE_LINE_CONNECTOR)

#define STATIC_KSNODETYPE_LEGACY_AUDIO_CONNECTOR\
    DEFINE_USB_TERMINAL_GUID(0x0604)
DEFINE_GUIDSTRUCT("DFF21FE4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_LEGACY_AUDIO_CONNECTOR);
#define KSNODETYPE_LEGACY_AUDIO_CONNECTOR DEFINE_GUIDNAMED(KSNODETYPE_LEGACY_AUDIO_CONNECTOR)

#define STATIC_KSNODETYPE_SPDIF_INTERFACE\
    DEFINE_USB_TERMINAL_GUID(0x0605)
DEFINE_GUIDSTRUCT("DFF21FE5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_SPDIF_INTERFACE);
#define KSNODETYPE_SPDIF_INTERFACE DEFINE_GUIDNAMED(KSNODETYPE_SPDIF_INTERFACE)

#define STATIC_KSNODETYPE_1394_DA_STREAM\
    DEFINE_USB_TERMINAL_GUID(0x0606)
DEFINE_GUIDSTRUCT("DFF21FE6-F70F-11D0-B917-00A0C9223196", KSNODETYPE_1394_DA_STREAM);
#define KSNODETYPE_1394_DA_STREAM DEFINE_GUIDNAMED(KSNODETYPE_1394_DA_STREAM)

#define STATIC_KSNODETYPE_1394_DV_STREAM_SOUNDTRACK\
    DEFINE_USB_TERMINAL_GUID(0x0607)
DEFINE_GUIDSTRUCT("DFF21FE7-F70F-11D0-B917-00A0C9223196", KSNODETYPE_1394_DV_STREAM_SOUNDTRACK);
#define KSNODETYPE_1394_DV_STREAM_SOUNDTRACK DEFINE_GUIDNAMED(KSNODETYPE_1394_DV_STREAM_SOUNDTRACK)

#define STATIC_KSNODETYPE_EMBEDDED_UNDEFINED\
    DEFINE_USB_TERMINAL_GUID(0x0700)
DEFINE_GUIDSTRUCT("DFF220E0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_EMBEDDED_UNDEFINED);
#define KSNODETYPE_EMBEDDED_UNDEFINED DEFINE_GUIDNAMED(KSNODETYPE_EMBEDDED_UNDEFINED)

#define STATIC_KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE\
    DEFINE_USB_TERMINAL_GUID(0x0701)
DEFINE_GUIDSTRUCT("DFF220E1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE);
#define KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE DEFINE_GUIDNAMED(KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE)

#define STATIC_KSNODETYPE_EQUALIZATION_NOISE\
    DEFINE_USB_TERMINAL_GUID(0x0702)
DEFINE_GUIDSTRUCT("DFF220E2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_EQUALIZATION_NOISE);
#define KSNODETYPE_EQUALIZATION_NOISE DEFINE_GUIDNAMED(KSNODETYPE_EQUALIZATION_NOISE)

#define STATIC_KSNODETYPE_CD_PLAYER\
    DEFINE_USB_TERMINAL_GUID(0x0703)
DEFINE_GUIDSTRUCT("DFF220E3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_CD_PLAYER);
#define KSNODETYPE_CD_PLAYER DEFINE_GUIDNAMED(KSNODETYPE_CD_PLAYER)

#define STATIC_KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE\
    DEFINE_USB_TERMINAL_GUID(0x0704)
DEFINE_GUIDSTRUCT("DFF220E4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE);
#define KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE DEFINE_GUIDNAMED(KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE)

#define STATIC_KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE\
    DEFINE_USB_TERMINAL_GUID(0x0705)
DEFINE_GUIDSTRUCT("DFF220E5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE);
#define KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE DEFINE_GUIDNAMED(KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE)

#define STATIC_KSNODETYPE_MINIDISK\
    DEFINE_USB_TERMINAL_GUID(0x0706)
DEFINE_GUIDSTRUCT("DFF220E6-F70F-11D0-B917-00A0C9223196", KSNODETYPE_MINIDISK);
#define KSNODETYPE_MINIDISK DEFINE_GUIDNAMED(KSNODETYPE_MINIDISK)

#define STATIC_KSNODETYPE_ANALOG_TAPE\
    DEFINE_USB_TERMINAL_GUID(0x0707)
DEFINE_GUIDSTRUCT("DFF220E7-F70F-11D0-B917-00A0C9223196", KSNODETYPE_ANALOG_TAPE);
#define KSNODETYPE_ANALOG_TAPE DEFINE_GUIDNAMED(KSNODETYPE_ANALOG_TAPE)

#define STATIC_KSNODETYPE_PHONOGRAPH\
    DEFINE_USB_TERMINAL_GUID(0x0708)
DEFINE_GUIDSTRUCT("DFF220E8-F70F-11D0-B917-00A0C9223196", KSNODETYPE_PHONOGRAPH);
#define KSNODETYPE_PHONOGRAPH DEFINE_GUIDNAMED(KSNODETYPE_PHONOGRAPH)

#define STATIC_KSNODETYPE_VCR_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x0708)
DEFINE_GUIDSTRUCT("DFF220E9-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VCR_AUDIO);
#define KSNODETYPE_VCR_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_VCR_AUDIO)

#define STATIC_KSNODETYPE_VIDEO_DISC_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070A)
DEFINE_GUIDSTRUCT("DFF220EA-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_DISC_AUDIO);
#define KSNODETYPE_VIDEO_DISC_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_DISC_AUDIO)

#define STATIC_KSNODETYPE_DVD_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070B)
DEFINE_GUIDSTRUCT("DFF220EB-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DVD_AUDIO);
#define KSNODETYPE_DVD_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_DVD_AUDIO)

#define STATIC_KSNODETYPE_TV_TUNER_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070C)
DEFINE_GUIDSTRUCT("DFF220EC-F70F-11D0-B917-00A0C9223196", KSNODETYPE_TV_TUNER_AUDIO);
#define KSNODETYPE_TV_TUNER_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_TV_TUNER_AUDIO)

#define STATIC_KSNODETYPE_SATELLITE_RECEIVER_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070D)
DEFINE_GUIDSTRUCT("DFF220ED-F70F-11D0-B917-00A0C9223196", KSNODETYPE_SATELLITE_RECEIVER_AUDIO);
#define KSNODETYPE_SATELLITE_RECEIVER_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_SATELLITE_RECEIVER_AUDIO)

#define STATIC_KSNODETYPE_CABLE_TUNER_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070E)
DEFINE_GUIDSTRUCT("DFF220EE-F70F-11D0-B917-00A0C9223196", KSNODETYPE_CABLE_TUNER_AUDIO);
#define KSNODETYPE_CABLE_TUNER_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_CABLE_TUNER_AUDIO)

#define STATIC_KSNODETYPE_DSS_AUDIO\
    DEFINE_USB_TERMINAL_GUID(0x070F)
DEFINE_GUIDSTRUCT("DFF220EF-F70F-11D0-B917-00A0C9223196", KSNODETYPE_DSS_AUDIO);
#define KSNODETYPE_DSS_AUDIO DEFINE_GUIDNAMED(KSNODETYPE_DSS_AUDIO)

#define STATIC_KSNODETYPE_RADIO_RECEIVER\
    DEFINE_USB_TERMINAL_GUID(0x0710)
DEFINE_GUIDSTRUCT("DFF220F0-F70F-11D0-B917-00A0C9223196", KSNODETYPE_RADIO_RECEIVER);
#define KSNODETYPE_RADIO_RECEIVER DEFINE_GUIDNAMED(KSNODETYPE_RADIO_RECEIVER)

#define STATIC_KSNODETYPE_RADIO_TRANSMITTER\
    DEFINE_USB_TERMINAL_GUID(0x0711)
DEFINE_GUIDSTRUCT("DFF220F1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_RADIO_TRANSMITTER);
#define KSNODETYPE_RADIO_TRANSMITTER DEFINE_GUIDNAMED(KSNODETYPE_RADIO_TRANSMITTER)

#define STATIC_KSNODETYPE_MULTITRACK_RECORDER\
    DEFINE_USB_TERMINAL_GUID(0x0712)
DEFINE_GUIDSTRUCT("DFF220F2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_MULTITRACK_RECORDER);
#define KSNODETYPE_MULTITRACK_RECORDER DEFINE_GUIDNAMED(KSNODETYPE_MULTITRACK_RECORDER)

#define STATIC_KSNODETYPE_SYNTHESIZER\
    DEFINE_USB_TERMINAL_GUID(0x0713)
DEFINE_GUIDSTRUCT("DFF220F3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_SYNTHESIZER);
#define KSNODETYPE_SYNTHESIZER DEFINE_GUIDNAMED(KSNODETYPE_SYNTHESIZER)

#define STATIC_KSNODETYPE_HDMI_INTERFACE\
    0xd1b9cc2a, 0xf519, 0x417f, 0x91, 0xc9, 0x55, 0xfa, 0x65, 0x48, 0x10, 0x01
DEFINE_GUIDSTRUCT("D1B9CC2A-F519-417f-91C9-55FA65481001", KSNODETYPE_HDMI_INTERFACE);
#define KSNODETYPE_HDMI_INTERFACE DEFINE_GUIDNAMED(KSNODETYPE_HDMI_INTERFACE)

#define STATIC_KSNODETYPE_DISPLAYPORT_INTERFACE\
    0xe47e4031, 0x3ea6, 0x418d, 0x8f, 0x9b, 0xb7, 0x38, 0x43, 0xcc, 0xba, 0x97
DEFINE_GUIDSTRUCT("E47E4031-3EA6-418d-8F9B-B73843CCBA97", KSNODETYPE_DISPLAYPORT_INTERFACE);
#define KSNODETYPE_DISPLAYPORT_INTERFACE DEFINE_GUIDNAMED(KSNODETYPE_DISPLAYPORT_INTERFACE)

#define STATIC_KSNODETYPE_AUDIO_LOOPBACK\
    0x8f42c0b2, 0x91ce, 0x4bcf, 0x9c, 0xcd, 0xe, 0x59, 0x90, 0x37, 0xab, 0x35
DEFINE_GUIDSTRUCT("8F42C0B2-91CE-4BCF-9CCD-0E599037AB35", KSNODETYPE_AUDIO_LOOPBACK);
#define KSNODETYPE_AUDIO_LOOPBACK DEFINE_GUIDNAMED(KSNODETYPE_AUDIO_LOOPBACK)

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
#define STATIC_KSNODETYPE_AUDIO_KEYWORDDETECTOR\
    0x3817e0b8, 0xdf58, 0x4375, 0xb6, 0x69, 0xc4, 0x96, 0x34, 0x33, 0x1f, 0x9d
DEFINE_GUIDSTRUCT("3817E0B8-DF58-4375-B669-C49634331F9D", KSNODETYPE_AUDIO_KEYWORDDETECTOR);
#define KSNODETYPE_AUDIO_KEYWORDDETECTOR DEFINE_GUIDNAMED(KSNODETYPE_AUDIO_KEYWORDDETECTOR)
#endif

#if (NTDDI_VERSION >= NTDDI_WIN10_19H1)
#define STATIC_KSNODETYPE_AUDIO_MODULE\
    0x45aab42e, 0xcaeb, 0x4052, 0x8a, 0xa9, 0xb3, 0x8c, 0xb5, 0x10, 0x96, 0x19
DEFINE_GUIDSTRUCT("45AAB42E-CAEB-4052-8AA9-B38CB5109619", KSNODETYPE_AUDIO_MODULE);
#define KSNODETYPE_AUDIO_MODULE DEFINE_GUIDNAMED(KSNODETYPE_AUDIO_MODULE)
#endif

// USB MIDI Nodes
#define STATIC_KSNODETYPE_MIDI_JACK\
    0x265e0c3f, 0xfa39, 0x4df3, 0xab, 0x04, 0xbe, 0x01, 0xb9, 0x1e, 0x29, 0x9a
DEFINE_GUIDSTRUCT("265E0C3F-FA39-4df3-AB04-BE01B91E299A", KSNODETYPE_MIDI_JACK);
#define KSNODETYPE_MIDI_JACK DEFINE_GUIDNAMED(KSNODETYPE_MIDI_JACK)

#define STATIC_KSNODETYPE_MIDI_ELEMENT\
    0x01c6fe66, 0x6e48, 0x4c65, 0xac, 0x9b, 0x52, 0xdb, 0x5d, 0x65, 0x6c, 0x7e
DEFINE_GUIDSTRUCT("01C6FE66-6E48-4c65-AC9B-52DB5D656C7E", KSNODETYPE_MIDI_ELEMENT);
#define KSNODETYPE_MIDI_ELEMENT DEFINE_GUIDNAMED(KSNODETYPE_MIDI_ELEMENT)

// Hardware Audio Engine Node
#define STATIC_KSNODETYPE_AUDIO_ENGINE\
    0x35caf6e4, 0xf3b3, 0x4168, 0xbb, 0x4b, 0x55, 0xe7, 0x7a, 0x46, 0x1c, 0x7e
DEFINE_GUIDSTRUCT("35CAF6E4-F3B3-4168-BB4B-55E77A461C7E", KSNODETYPE_AUDIO_ENGINE);
#define KSNODETYPE_AUDIO_ENGINE DEFINE_GUIDNAMED(KSNODETYPE_AUDIO_ENGINE)

// KS Node type for speakers node with static jack
#define STATIC_KSNODETYPE_SPEAKERS_STATIC_JACK\
    0x28e04f87, 0x4dbe, 0x4f8d, 0x85, 0x89, 0x2, 0x5d, 0x20, 0x9d, 0xfb, 0x4a
DEFINE_GUIDSTRUCT("28E04F87-4DBE-4f8d-8589-025D209DFB4A", KSNODETYPE_SPEAKERS_STATIC_JACK);
#define KSNODETYPE_SPEAKERS_STATIC_JACK DEFINE_GUIDNAMED(KSNODETYPE_SPEAKERS_STATIC_JACK)

// GUID for Spdif Out pin name
#define STATIC_PINNAME_SPDIF_OUT\
    0x3a264481, 0xe52c, 0x4b82, 0x8e, 0x7a, 0xc8, 0xe2, 0xf9, 0x1d, 0xc3, 0x80
DEFINE_GUIDSTRUCT("3A264481-E52C-4b82-8E7A-C8E2F91DC380", PINNAME_SPDIF_OUT);
#define PINNAME_SPDIF_OUT DEFINE_GUIDNAMED(PINNAME_SPDIF_OUT)

// GUID for Spdif In pin name
#define STATIC_PINNAME_SPDIF_IN\
    0x15dc9025, 0x22ad, 0x41b3, 0x88, 0x75, 0xf4, 0xce, 0xb0, 0x29, 0x9e, 0x20
DEFINE_GUIDSTRUCT("15DC9025-22AD-41b3-8875-F4CEB0299E20", PINNAME_SPDIF_IN);
#define PINNAME_SPDIF_IN DEFINE_GUIDNAMED(PINNAME_SPDIF_IN)

// GUID for HDMI Out pin name
#define STATIC_PINNAME_HDMI_OUT\
    0x387bfc03, 0xe7ef, 0x4901, 0x86, 0xe0, 0x35, 0xb7, 0xc3, 0x2b, 0x0, 0xef
DEFINE_GUIDSTRUCT("387BFC03-E7EF-4901-86E0-35B7C32B00EF", PINNAME_HDMI_OUT);
#define PINNAME_HDMI_OUT DEFINE_GUIDNAMED(PINNAME_HDMI_OUT)

// GUID for Display Port Out pin name
#define STATIC_PINNAME_DISPLAYPORT_OUT\
    0x21fbb329, 0x1a4a, 0x48da, 0xa0, 0x76, 0x23, 0x18, 0xa3, 0xc5, 0x9b, 0x26
DEFINE_GUIDSTRUCT("21FBB329-1A4A-48da-A076-2318A3C59B26", PINNAME_DISPLAYPORT_OUT);
#define PINNAME_DISPLAYPORT_OUT DEFINE_GUIDNAMED(PINNAME_DISPLAYPORT_OUT)

#if (NTDDI_VERSION < NTDDI_VISTA)

// Microsoft's WDMAUD virtual swsynth pin name guid

#define STATIC_KSNODETYPE_SWSYNTH\
    0x423274A0L, 0x8B81, 0x11D1, 0xA0, 0x50, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("423274A0-8B81-11D1-A050-0000F8004788", KSNODETYPE_SWSYNTH);
#define KSNODETYPE_SWSYNTH DEFINE_GUIDNAMED(KSNODETYPE_SWSYNTH)

// Microsoft's SWMIDI midi pin and node name guid

#define STATIC_KSNODETYPE_SWMIDI\
    0xCB9BEFA0L, 0xA251, 0x11D1, 0xA0, 0x50, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("CB9BEFA0-A251-11D1-A050-0000F8004788", KSNODETYPE_SWMIDI);
#define KSNODETYPE_SWMIDI DEFINE_GUIDNAMED(KSNODETYPE_SWMIDI)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_DRM_DESCRAMBLE\
    0xFFBB6E3FL, 0xCCFE, 0x4D84, 0x90, 0xD9, 0x42, 0x14, 0x18, 0xB0, 0x3A, 0x8E
DEFINE_GUIDSTRUCT("FFBB6E3F-CCFE-4D84-90D9-421418B03A8E", KSNODETYPE_DRM_DESCRAMBLE);
#define KSNODETYPE_DRM_DESCRAMBLE DEFINE_GUIDNAMED(KSNODETYPE_DRM_DESCRAMBLE)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)


#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

//
// Nodetypes for Windows Phone Cellular Streaming.
//

// {686D7CC0-D903-4258-B443-3A3D3580741C}
#define STATIC_KSNODETYPE_TELEPHONY_BIDI \
    0x686d7cc0, 0xd903, 0x4258, 0xb4, 0x43, 0x3a, 0x3d, 0x35, 0x80, 0x74, 0x1c
DEFINE_GUIDSTRUCT("686D7CC0-D903-4258-B443-3A3D3580741C", KSNODETYPE_TELEPHONY_BIDI);
#define KSNODETYPE_TELEPHONY_BIDI DEFINE_GUIDNAMED(KSNODETYPE_TELEPHONY_BIDI)

//
// Nodetype for FM Receiver.
//

// {834A733C-F485-41C0-A62B-513025014E40}
#define STATIC_KSNODETYPE_FM_RX \
    0x834a733c, 0xf485, 0x41c0, 0xa6, 0x2b, 0x51, 0x30, 0x25, 0x1, 0x4e, 0x40
DEFINE_GUIDSTRUCT("834A733C-F485-41C0-A62B-513025014E40", KSNODETYPE_FM_RX);
#define KSNODETYPE_FM_RX DEFINE_GUIDNAMED(KSNODETYPE_FM_RX)

#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)


// General categories
#define STATIC_KSCATEGORY_AUDIO \
    0x6994AD04L, 0x93EF, 0x11D0, 0xA3, 0xCC, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("6994AD04-93EF-11D0-A3CC-00A0C9223196", KSCATEGORY_AUDIO);
#define KSCATEGORY_AUDIO DEFINE_GUIDNAMED(KSCATEGORY_AUDIO)


#define STATIC_KSCATEGORY_VIDEO \
    0x6994AD05L, 0x93EF, 0x11D0, 0xA3, 0xCC, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("6994AD05-93EF-11D0-A3CC-00A0C9223196", KSCATEGORY_VIDEO);
#define KSCATEGORY_VIDEO DEFINE_GUIDNAMED(KSCATEGORY_VIDEO)

#if (NTDDI_VERSION >= NTDDI_VISTA)
#define STATIC_KSCATEGORY_REALTIME \
    0xEB115FFCL, 0x10C8, 0x4964, 0x83, 0x1D, 0x6D, 0xCB, 0x02, 0xE6, 0xF2, 0x3F
DEFINE_GUIDSTRUCT("EB115FFC-10C8-4964-831D-6DCB02E6F23F", KSCATEGORY_REALTIME);
#define KSCATEGORY_REALTIME DEFINE_GUIDNAMED(KSCATEGORY_REALTIME)
#endif

#define STATIC_KSCATEGORY_TEXT \
    0x6994AD06L, 0x93EF, 0x11D0, 0xA3, 0xCC, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("6994AD06-93EF-11D0-A3CC-00A0C9223196", KSCATEGORY_TEXT);
#define KSCATEGORY_TEXT DEFINE_GUIDNAMED(KSCATEGORY_TEXT)

#define STATIC_KSCATEGORY_NETWORK \
    0x67C9CC3CL, 0x69C4, 0x11D2, 0x87, 0x59, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("67C9CC3C-69C4-11D2-8759-00A0C9223196", KSCATEGORY_NETWORK);
#define KSCATEGORY_NETWORK DEFINE_GUIDNAMED(KSCATEGORY_NETWORK)

#define STATIC_KSCATEGORY_TOPOLOGY \
    0xDDA54A40L, 0x1E4C, 0x11D1, 0xA0, 0x50, 0x40, 0x57, 0x05, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("DDA54A40-1E4C-11D1-A050-405705C10000", KSCATEGORY_TOPOLOGY);
#define KSCATEGORY_TOPOLOGY DEFINE_GUIDNAMED(KSCATEGORY_TOPOLOGY)

#define STATIC_KSCATEGORY_VIRTUAL \
    0x3503EAC4L, 0x1F26, 0x11D1, 0x8A, 0xB0, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("3503EAC4-1F26-11D1-8AB0-00A0C9223196", KSCATEGORY_VIRTUAL);
#define KSCATEGORY_VIRTUAL DEFINE_GUIDNAMED(KSCATEGORY_VIRTUAL)

#define STATIC_KSCATEGORY_ACOUSTIC_ECHO_CANCEL \
    0xBF963D80L, 0xC559, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("BF963D80-C559-11D0-8A2B-00A0C9255AC1", KSCATEGORY_ACOUSTIC_ECHO_CANCEL);
#define KSCATEGORY_ACOUSTIC_ECHO_CANCEL DEFINE_GUIDNAMED(KSCATEGORY_ACOUSTIC_ECHO_CANCEL)

#if (NTDDI_VERSION < NTDDI_VISTA)

#define STATIC_KSCATEGORY_SYSAUDIO \
    0xA7C7A5B1L, 0x5AF3, 0x11D1, 0x9C, 0xED, 0x00, 0xA0, 0x24, 0xBF, 0x04, 0x07
DEFINE_GUIDSTRUCT("A7C7A5B1-5AF3-11D1-9CED-00A024BF0407", KSCATEGORY_SYSAUDIO);
#define KSCATEGORY_SYSAUDIO DEFINE_GUIDNAMED(KSCATEGORY_SYSAUDIO)

#define STATIC_KSCATEGORY_WDMAUD \
    0x3E227E76L, 0x690D, 0x11D2, 0x81, 0x61, 0x00, 0x00, 0xF8, 0x77, 0x5B, 0xF1
DEFINE_GUIDSTRUCT("3E227E76-690D-11D2-8161-0000F8775BF1", KSCATEGORY_WDMAUD);
#define KSCATEGORY_WDMAUD DEFINE_GUIDNAMED(KSCATEGORY_WDMAUD)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#define STATIC_KSCATEGORY_AUDIO_GFX \
    0x9BAF9572L, 0x340C, 0x11D3, 0xAB, 0xDC, 0x00, 0xA0, 0xC9, 0x0A, 0xB1, 0x6F
DEFINE_GUIDSTRUCT("9BAF9572-340C-11D3-ABDC-00A0C90AB16F", KSCATEGORY_AUDIO_GFX);
#define KSCATEGORY_AUDIO_GFX DEFINE_GUIDNAMED(KSCATEGORY_AUDIO_GFX)

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#define STATIC_KSCATEGORY_AUDIO_SPLITTER \
    0x9EA331FAL, 0xB91B, 0x45F8, 0x92, 0x85, 0xBD, 0x2B, 0xC7, 0x7A, 0xFC, 0xDE
DEFINE_GUIDSTRUCT("9EA331FA-B91B-45F8-9285-BD2BC77AFCDE", KSCATEGORY_AUDIO_SPLITTER);
#define KSCATEGORY_AUDIO_SPLITTER DEFINE_GUIDNAMED(KSCATEGORY_AUDIO_SPLITTER)

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#define STATIC_KSCATEGORY_SYNTHESIZER STATIC_KSNODETYPE_SYNTHESIZER
#define KSCATEGORY_SYNTHESIZER KSNODETYPE_SYNTHESIZER

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSCATEGORY_DRM_DESCRAMBLE STATIC_KSNODETYPE_DRM_DESCRAMBLE
#define KSCATEGORY_DRM_DESCRAMBLE KSNODETYPE_DRM_DESCRAMBLE

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#if (NTDDI_VERSION < NTDDI_VISTA)

#define STATIC_KSCATEGORY_AUDIO_DEVICE \
    0xFBF6F530L, 0x07B9, 0x11D2, 0xA7, 0x1E, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("FBF6F530-07B9-11D2-A71E-0000F8004788", KSCATEGORY_AUDIO_DEVICE);
#define KSCATEGORY_AUDIO_DEVICE DEFINE_GUIDNAMED(KSCATEGORY_AUDIO_DEVICE)

#define STATIC_KSCATEGORY_PREFERRED_WAVEOUT_DEVICE \
    0xD6C5066EL, 0x72C1, 0x11D2, 0x97, 0x55, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("D6C5066E-72C1-11D2-9755-0000F8004788", KSCATEGORY_PREFERRED_WAVEOUT_DEVICE);
#define KSCATEGORY_PREFERRED_WAVEOUT_DEVICE DEFINE_GUIDNAMED(KSCATEGORY_PREFERRED_WAVEOUT_DEVICE)

#define STATIC_KSCATEGORY_PREFERRED_WAVEIN_DEVICE \
    0xD6C50671L, 0x72C1, 0x11D2, 0x97, 0x55, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("D6C50671-72C1-11D2-9755-0000F8004788", KSCATEGORY_PREFERRED_WAVEIN_DEVICE);
#define KSCATEGORY_PREFERRED_WAVEIN_DEVICE DEFINE_GUIDNAMED(KSCATEGORY_PREFERRED_WAVEIN_DEVICE)

#define STATIC_KSCATEGORY_PREFERRED_MIDIOUT_DEVICE \
    0xD6C50674L, 0x72C1, 0x11D2, 0x97, 0x55, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("D6C50674-72C1-11D2-9755-0000F8004788", KSCATEGORY_PREFERRED_MIDIOUT_DEVICE);
#define KSCATEGORY_PREFERRED_MIDIOUT_DEVICE DEFINE_GUIDNAMED(KSCATEGORY_PREFERRED_MIDIOUT_DEVICE)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

// Special pin category for wdmaud

#define STATIC_KSCATEGORY_WDMAUD_USE_PIN_NAME \
    0x47A4FA20L, 0xA251, 0x11D1, 0xA0, 0x50, 0x00, 0x00, 0xF8, 0x00, 0x47, 0x88
DEFINE_GUIDSTRUCT("47A4FA20-A251-11D1-A050-0000F8004788", KSCATEGORY_WDMAUD_USE_PIN_NAME);
#define KSCATEGORY_WDMAUD_USE_PIN_NAME DEFINE_GUIDNAMED(KSCATEGORY_WDMAUD_USE_PIN_NAME)

// Escalante Platform Interface

#define STATIC_KSCATEGORY_ESCALANTE_PLATFORM_DRIVER \
    0x74f3aea8L, 0x9768, 0x11d1, 0x8e, 0x07, 0x00, 0xa0, 0xc9, 0x5e, 0xc2, 0x2e
DEFINE_GUIDSTRUCT("74f3aea8-9768-11d1-8e07-00a0c95ec22e", KSCATEGORY_ESCALANTE_PLATFORM_DRIVER);
#define KSCATEGORY_ESCALANTE_PLATFORM_DRIVER DEFINE_GUIDNAMED(KSCATEGORY_ESCALANTE_PLATFORM_DRIVER)

// -- major types ---

// 'vids' == MEDIATYPE_Video,
#define STATIC_KSDATAFORMAT_TYPE_VIDEO\
    0x73646976L, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("73646976-0000-0010-8000-00aa00389b71", KSDATAFORMAT_TYPE_VIDEO);
#define KSDATAFORMAT_TYPE_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_VIDEO)

// 'auds' == MEDIATYPE_Audio
#define STATIC_KSDATAFORMAT_TYPE_AUDIO\
    0x73647561L, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("73647561-0000-0010-8000-00aa00389b71", KSDATAFORMAT_TYPE_AUDIO);
#define KSDATAFORMAT_TYPE_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_AUDIO)

// 'txts' == MEDIATYPE_Text
#define STATIC_KSDATAFORMAT_TYPE_TEXT\
    0x73747874L, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("73747874-0000-0010-8000-00aa00389b71", KSDATAFORMAT_TYPE_TEXT);
#define KSDATAFORMAT_TYPE_TEXT DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_TEXT)

#if !defined( DEFINE_WAVEFORMATEX_GUID )
#define DEFINE_WAVEFORMATEX_GUID(x) (USHORT)(x), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
#endif

#if !defined( STATIC_KSDATAFORMAT_SUBTYPE_WAVEFORMATEX )
#define STATIC_KSDATAFORMAT_SUBTYPE_WAVEFORMATEX\
    0x00000000L, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000000-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_WAVEFORMATEX);
#define KSDATAFORMAT_SUBTYPE_WAVEFORMATEX DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_WAVEFORMATEX)
#endif

#if !defined( INIT_WAVEFORMATEX_GUID )
#define INIT_WAVEFORMATEX_GUID(Guid, x)\
{\
    *(Guid) = KSDATAFORMAT_SUBTYPE_WAVEFORMATEX;\
    (Guid)->Data1 = (USHORT)(x);\
}
#endif

#if !defined( EXTRACT_WAVEFORMATEX_ID )
#define EXTRACT_WAVEFORMATEX_ID(Guid)\
    (USHORT)((Guid)->Data1)
#endif

#if !defined( IS_VALID_WAVEFORMATEX_GUID )
#define IS_VALID_WAVEFORMATEX_GUID(Guid)\
    (!memcmp(((PUSHORT)&KSDATAFORMAT_SUBTYPE_WAVEFORMATEX) + 1, ((PUSHORT)(Guid)) + 1, sizeof(GUID) - sizeof(USHORT)))
#endif

#if !defined(INIT_MMREG_MID)
//{d5a47fa7-6d98-11d1-a21a-00a0c9223196}
#define INIT_MMREG_MID(guid, id)\
{\
    (guid)->Data1 = 0xd5a47fa7 + (USHORT)(id);\
    (guid)->Data2 = 0x6d98;\
    (guid)->Data3 = 0x11d1;\
    (guid)->Data4[0] = 0xa2;\
    (guid)->Data4[1] = 0x1a;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}
#define EXTRACT_MMREG_MID(guid)\
    (USHORT)((guid)->Data1 - 0xd5a47fa7)
#define DEFINE_MMREG_MID_GUID(id)\
    0xd5a47fa7+(USHORT)(id), 0x6d98, 0x11d1, 0xa2, 0x1a, 0x00, 0xa0, 0xc9, 0x22, 0x31, 0x96

#define IS_COMPATIBLE_MMREG_MID(guid)\
    (((guid)->Data1 >= 0xd5a47fa7) &&\
    ((guid)->Data1 < 0xd5a47fa7 + 0xffff) &&\
    ((guid)->Data2 == 0x6d98) &&\
    ((guid)->Data3 == 0x11d1) &&\
    ((guid)->Data4[0] == 0xa2) &&\
    ((guid)->Data4[1] == 0x1a) &&\
    ((guid)->Data4[2] == 0x00) &&\
    ((guid)->Data4[3] == 0xa0) &&\
    ((guid)->Data4[4] == 0xc9) &&\
    ((guid)->Data4[5] == 0x22) &&\
    ((guid)->Data4[6] == 0x31) &&\
    ((guid)->Data4[7] == 0x96))
#endif // !defined(INIT_MMREG_MID)

#if !defined(INIT_MMREG_PID)
//{e36dc2ac-6d9a-11d1-a21a-00a0c9223196}
#define INIT_MMREG_PID(guid, id)\
{\
    (guid)->Data1 = 0xe36dc2ac + (USHORT)(id);\
    (guid)->Data2 = 0x6d9a;\
    (guid)->Data3 = 0x11d1;\
    (guid)->Data4[0] = 0xa2;\
    (guid)->Data4[1] = 0x1a;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}
#define EXTRACT_MMREG_PID(guid)\
    (USHORT)((guid)->Data1 - 0xe36dc2ac)
#define DEFINE_MMREG_PID_GUID(id)\
    0xe36dc2ac+(USHORT)(id), 0x6d9a, 0x11d1, 0xa2, 0x1a, 0x00, 0xa0, 0xc9, 0x22, 0x31, 0x96

#define IS_COMPATIBLE_MMREG_PID(guid)\
    (((guid)->Data1 >= 0xe36dc2ac) &&\
    ((guid)->Data1 < 0xe36dc2ac + 0xffff) &&\
    ((guid)->Data2 == 0x6d9a) &&\
    ((guid)->Data3 == 0x11d1) &&\
    ((guid)->Data4[0] == 0xa2) &&\
    ((guid)->Data4[1] == 0x1a) &&\
    ((guid)->Data4[2] == 0x00) &&\
    ((guid)->Data4[3] == 0xa0) &&\
    ((guid)->Data4[4] == 0xc9) &&\
    ((guid)->Data4[5] == 0x22) &&\
    ((guid)->Data4[6] == 0x31) &&\
    ((guid)->Data4[7] == 0x96))
#endif // !defined(INIT_MMREG_PID)

#define STATIC_KSDATAFORMAT_SUBTYPE_ANALOG\
    0x6dba3190L, 0x67bd, 0x11cf, 0xa0, 0xf7, 0x00, 0x20, 0xaf, 0xd1, 0x56, 0xe4
DEFINE_GUIDSTRUCT("6dba3190-67bd-11cf-a0f7-0020afd156e4", KSDATAFORMAT_SUBTYPE_ANALOG);
#define KSDATAFORMAT_SUBTYPE_ANALOG DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_ANALOG)

#if !defined( STATIC_KSDATAFORMAT_SUBTYPE_PCM )
#define STATIC_KSDATAFORMAT_SUBTYPE_PCM\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_PCM)
DEFINE_GUIDSTRUCT("00000001-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_PCM);
#define KSDATAFORMAT_SUBTYPE_PCM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_PCM)
#endif

#if defined(_INC_MMREG)
#if !defined( STATIC_KSDATAFORMAT_SUBTYPE_IEEE_FLOAT )
#define STATIC_KSDATAFORMAT_SUBTYPE_IEEE_FLOAT\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_IEEE_FLOAT)
DEFINE_GUIDSTRUCT("00000003-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEEE_FLOAT);
#define KSDATAFORMAT_SUBTYPE_IEEE_FLOAT DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEEE_FLOAT)
#endif

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSDATAFORMAT_SUBTYPE_DRM\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_DRM)
DEFINE_GUIDSTRUCT("00000009-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_DRM);
#define KSDATAFORMAT_SUBTYPE_DRM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_DRM)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSDATAFORMAT_SUBTYPE_ALAW\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_ALAW)
DEFINE_GUIDSTRUCT("00000006-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_ALAW);
#define KSDATAFORMAT_SUBTYPE_ALAW DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_ALAW)

#define STATIC_KSDATAFORMAT_SUBTYPE_MULAW\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_MULAW)
DEFINE_GUIDSTRUCT("00000007-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MULAW);
#define KSDATAFORMAT_SUBTYPE_MULAW DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MULAW)

#define STATIC_KSDATAFORMAT_SUBTYPE_ADPCM\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_ADPCM)
DEFINE_GUIDSTRUCT("00000002-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_ADPCM);
#define KSDATAFORMAT_SUBTYPE_ADPCM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_ADPCM)

#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_MPEG)
DEFINE_GUIDSTRUCT("00000050-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MPEG);
#define KSDATAFORMAT_SUBTYPE_MPEG DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG)
#endif // defined(_INC_MMREG)

#define STATIC_KSDATAFORMAT_SPECIFIER_VC_ID\
    0xAD98D184L, 0xAAC3, 0x11D0, 0xA4, 0x1C, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("AD98D184-AAC3-11D0-A41C-00A0C9223196", KSDATAFORMAT_SPECIFIER_VC_ID);
#define KSDATAFORMAT_SPECIFIER_VC_ID DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_VC_ID)

#define STATIC_KSDATAFORMAT_SPECIFIER_WAVEFORMATEX\
    0x05589f81L, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a
DEFINE_GUIDSTRUCT("05589f81-c356-11ce-bf01-00aa0055595a", KSDATAFORMAT_SPECIFIER_WAVEFORMATEX);
#define KSDATAFORMAT_SPECIFIER_WAVEFORMATEX DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_WAVEFORMATEX)

#define STATIC_KSDATAFORMAT_SPECIFIER_DSOUND\
    0x518590a2L, 0xa184, 0x11d0, 0x85, 0x22, 0x00, 0xc0, 0x4f, 0xd9, 0xba, 0xf3
DEFINE_GUIDSTRUCT("518590a2-a184-11d0-8522-00c04fd9baf3", KSDATAFORMAT_SPECIFIER_DSOUND);
#define KSDATAFORMAT_SPECIFIER_DSOUND DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DSOUND)

#if defined(_INC_MMSYSTEM) || defined(_INC_MMREG)
#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
#include <pshpack1.h>
#endif
// Convenient wrapper structure for the case in which the WaveFormatEx is
// known not to contain extra data.
typedef struct {
    KSDATAFORMAT    DataFormat;
    WAVEFORMATEX    WaveFormatEx;
} KSDATAFORMAT_WAVEFORMATEX, *PKSDATAFORMAT_WAVEFORMATEX;

#ifndef _WAVEFORMATEXTENSIBLE_
#define _WAVEFORMATEXTENSIBLE_
typedef struct {
    WAVEFORMATEX    Format;
    union {
        WORD wValidBitsPerSample;       /* bits of precision  */
        WORD wSamplesPerBlock;          /* valid if wBitsPerSample==0 */
        WORD wReserved;                 /* If neither applies, set to zero. */
    } Samples;
    DWORD           dwChannelMask;      /* which channels are */
                                        /* present in stream  */
    GUID            SubFormat;
} WAVEFORMATEXTENSIBLE, *PWAVEFORMATEXTENSIBLE;
#endif // !_WAVEFORMATEXTENSIBLE_

#ifndef _WAVEFORMATEXTENSIBLE_IEC61937_
#define _WAVEFORMATEXTENSIBLE_IEC61937_
typedef struct {
    WAVEFORMATEXTENSIBLE  FormatExt;    /* Format of encoded data as it is */
                                        /* intended to be streamed over the link */
    DWORD   dwEncodedSamplesPerSec;     /* Sampling rate of the post-decode audio. */
    DWORD   dwEncodedChannelCount;      /* Channel count of the post-decode audio. */
    DWORD   dwAverageBytesPerSec;       /* Byte rate of the content, can be 0. */
} WAVEFORMATEXTENSIBLE_IEC61937, *PWAVEFORMATEXTENSIBLE_IEC61937;
#endif // !_WAVEFORMATEXTENSIBLE_IEC61937_

#if !defined(WAVE_FORMAT_EXTENSIBLE)
#define  WAVE_FORMAT_EXTENSIBLE                 0xFFFE
#endif // !defined(WAVE_FORMAT_EXTENSIBLE)

// Convenient wrapper structure for the case in which the WaveFormatExt is
// known not to contain extra data.
typedef struct 
{
    KSDATAFORMAT            DataFormat;
    WAVEFORMATEXTENSIBLE    WaveFormatExt;
} KSDATAFORMAT_WAVEFORMATEXTENSIBLE, *PKSDATAFORMAT_WAVEFORMATEXTENSIBLE;

// DirectSound buffer description
typedef struct {
    ULONG               Flags;
    ULONG               Control;
    WAVEFORMATEX        WaveFormatEx;
} KSDSOUND_BUFFERDESC, *PKSDSOUND_BUFFERDESC;

// DirectSound format
typedef struct {
    KSDATAFORMAT        DataFormat;
    KSDSOUND_BUFFERDESC BufferDesc;
} KSDATAFORMAT_DSOUND, *PKSDATAFORMAT_DSOUND;

#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
#include <poppack.h>
#endif
#endif // defined(_INC_MMSYSTEM) || defined(_INC_MMREG)



// DirectSound buffer flags
#define KSDSOUND_BUFFER_PRIMARY             0x00000001
#define KSDSOUND_BUFFER_STATIC              0x00000002
#define KSDSOUND_BUFFER_LOCHARDWARE         0x00000004
#define KSDSOUND_BUFFER_LOCSOFTWARE         0x00000008

// DirectSound buffer control flags
#define KSDSOUND_BUFFER_CTRL_3D             0x00000001
#define KSDSOUND_BUFFER_CTRL_FREQUENCY      0x00000002
#define KSDSOUND_BUFFER_CTRL_PAN            0x00000004
#define KSDSOUND_BUFFER_CTRL_VOLUME         0x00000008
#define KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY 0x00000010

typedef struct {
#if defined(_NTDDK_)
    ULONGLONG        PlayOffset;
    ULONGLONG        WriteOffset;
#else // !_NTDDK_
    DWORDLONG        PlayOffset;
    DWORDLONG        WriteOffset;
#endif // !_NTDDK_
} KSAUDIO_POSITION, *PKSAUDIO_POSITION;

//The KSAUDIO_PRESENTATION_POSITION structure specifies the current positions of audio data being rendered to the KS pin instance.
typedef struct
{
  UINT64 u64PositionInBlocks; // The block offset from the start of the stream to the current post-decoded uncompressed 
                              // position in the stream, where a block is the group of channels in the same sample; for a PCM stream, 
                  // a block is same as a frame. For compressed formats, a block is a single sample within a frame 
                              // (eg. each MP3 frame has 1152 samples or 1152 blocks) 
  UINT64 u64QPCPosition;      // The value of the performance counter at the time that the audio endpoint device read the device 
                              // position (*pu64Position) in response to the KSAUDIO_PRESENTATION_POSITION call.
} KSAUDIO_PRESENTATION_POSITION, *PKSAUDIO_PRESENTATION_POSITION;


typedef enum {
    CONSTRICTOR_OPTION_DISABLE = 0,
    CONSTRICTOR_OPTION_MUTE
} CONSTRICTOR_OPTION;

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
#ifdef DEFINE_DEVPROPKEY
// {13E004D6-B066-43BD-913B-A415CD13DA87},2
DEFINE_DEVPROPKEY(DEVPKEY_KsAudio_PacketSize_Constraints, 0x13e004d6, 0xb066, 0x43bd, 0x91, 0x3b, 0xa4, 0x15, 0xcd, 0x13, 0xda, 0x87, 2);     // DEVPROP_TYPE_BINARY
#endif

#if (NTDDI_VERSION >= NTDDI_WIN10_RS5)
#ifdef DEFINE_DEVPROPKEY
// {13E004D6-B066-43BD-913B-A415CD13DA87},3
// This property is the symbolic link to an interface of type 'GUID_KSCATEGORY_AUDIO_CONTROLLER_INTERFACE' published
// by the KS Filter or miniport drivers on the KSCATEGORY_AUDIO interface to indicate the audio system about the 'controller'
// device interface symbolic link that will provide extended information about this audio endpoint
DEFINE_DEVPROPKEY(DEVPKEY_KsAudio_Controller_DeviceInterface_Path, 0x13e004d6, 0xb066, 0x43bd, 0x91, 0x3b, 0xa4, 0x15, 0xcd, 0x13, 0xda, 0x87, 3); // DEVPROP_TYPE_STRING
#endif // DEFINE_DEVPROPKEY
#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS5)

typedef struct _KSAUDIO_PACKETSIZE_SIGNALPROCESSINGMODE_CONSTRAINT
{
    GUID    ProcessingMode;
    ULONG   SamplesPerProcessingPacket;
    ULONG   ProcessingPacketDurationInHns;
} KSAUDIO_PACKETSIZE_PROCESSINGMODE_CONSTRAINT;

typedef struct _KSAUDIO_PACKETSIZE_CONSTRAINTS
{
    ULONG   MinPacketPeriodInHns;
    ULONG   PacketSizeFileAlignment;
    ULONG   Reserved;
    ULONG   NumProcessingModeConstraints;
    _Field_size_(NumProcessingModeConstraints) KSAUDIO_PACKETSIZE_PROCESSINGMODE_CONSTRAINT ProcessingModeConstraints[ANYSIZE_ARRAY];
} KSAUDIO_PACKETSIZE_CONSTRAINTS;
#endif

#if (NTDDI_VERSION >= NTDDI_WIN10_RS1)
#ifdef DEFINE_DEVPROPKEY
// {9404F781-7191-409B-8B0B-80BF6EC229AE},2
DEFINE_DEVPROPKEY(DEVPKEY_KsAudio_PacketSize_Constraints2, 0x9404f781, 0x7191, 0x409b, 0x8b, 0xb, 0x80, 0xbf, 0x6e, 0xc2, 0x29, 0xae, 2);     // DEVPROP_TYPE_BINARY
#endif

typedef struct _KSAUDIO_PACKETSIZE_CONSTRAINTS2
{
    ULONG   MinPacketPeriodInHns;
    ULONG   PacketSizeFileAlignment;
    ULONG   MaxPacketSizeInBytes;
    ULONG   NumProcessingModeConstraints;
    _Field_size_(NumProcessingModeConstraints) KSAUDIO_PACKETSIZE_PROCESSINGMODE_CONSTRAINT ProcessingModeConstraints[ANYSIZE_ARRAY];
} KSAUDIO_PACKETSIZE_CONSTRAINTS2;
#endif

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

//===========================================================================
// Microphone array pin descriptor

#if (NTDDI_VERSION >= NTDDI_VISTA)
typedef enum {
    KSMICARRAY_MICTYPE_OMNIDIRECTIONAL,
    KSMICARRAY_MICTYPE_SUBCARDIOID,
    KSMICARRAY_MICTYPE_CARDIOID,
    KSMICARRAY_MICTYPE_SUPERCARDIOID,
    KSMICARRAY_MICTYPE_HYPERCARDIOID,
    KSMICARRAY_MICTYPE_8SHAPED,
    KSMICARRAY_MICTYPE_VENDORDEFINED = 0x0F
} KSMICARRAY_MICTYPE;

typedef struct {
        USHORT usType;           // Type of Microphone
        SHORT  wXCoord;          // X Coordinate of Mic
        SHORT  wYCoord;          // Y Coordinate of Mic
        SHORT  wZCoord;          // Z Coordinate of Mic
        SHORT  wVerticalAngle;   // MRA Vertical Angle
        SHORT  wHorizontalAngle; // MRA Horizontal Angle
} KSAUDIO_MICROPHONE_COORDINATES, *PKSAUDIO_MICROPHONE_COORDINATES;

typedef enum {
    KSMICARRAY_MICARRAYTYPE_LINEAR,
    KSMICARRAY_MICARRAYTYPE_PLANAR,
    KSMICARRAY_MICARRAYTYPE_3D
} KSMICARRAY_MICARRAYTYPE;

typedef struct {
        USHORT usVersion;             // Version of Mic array specification (0x0100)
        USHORT usMicArrayType;        // Type of Mic Array
        SHORT  wVerticalAngleBegin;   // Work Volume Vertical Angle Begin
        SHORT  wVerticalAngleEnd;     // Work Volume Vertical Angle End
        SHORT  wHorizontalAngleBegin; // Work Volume HorizontalAngle Begin
        SHORT  wHorizontalAngleEnd;   // Work Volume HorizontalAngle End
        USHORT usFrequencyBandLo;     // Low end of Freq Range
        USHORT usFrequencyBandHi;     // High end of Freq Range
        
        USHORT usNumberOfMicrophones;  // Count of microphone 
                                   // coordinate structures 
                                   // to follow.

        KSAUDIO_MICROPHONE_COORDINATES KsMicCoord[1]; // Array of Microphone 
                                                  // Coordinate structures
} KSAUDIO_MIC_ARRAY_GEOMETRY, *PKSAUDIO_MIC_ARRAY_GEOMETRY;

#endif // (NTDDI_VERSION >= NTDDI_VISTA)

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

//===========================================================================
// DirectSound3D HAL


typedef struct _DS3DVECTOR {
    union {
        FLOAT x;
        FLOAT dvX;
    };
    union {
        FLOAT y;
        FLOAT dvY;
    };
    union {
        FLOAT z;
        FLOAT dvZ;
    };
} DS3DVECTOR, *PDS3DVECTOR;


//===========================================================================
//===========================================================================

// KSPROPSETID_DirectSound3DListener : {437B3414-D060-11d0-8583-00C04FD9BAF3}

#define STATIC_KSPROPSETID_DirectSound3DListener\
    0x437b3414L, 0xd060, 0x11d0, 0x85, 0x83, 0x00, 0xc0, 0x4f, 0xd9, 0xba, 0xf3
DEFINE_GUIDSTRUCT("437b3414-d060-11d0-8583-00c04fd9baf3",KSPROPSETID_DirectSound3DListener);
#define KSPROPSETID_DirectSound3DListener DEFINE_GUIDNAMED(KSPROPSETID_DirectSound3DListener)

typedef enum {
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALL,
    KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION,
    KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION
} KSPROPERTY_DIRECTSOUND3DLISTENER;

typedef struct {
    DS3DVECTOR  Position;
    DS3DVECTOR  Velocity;
    DS3DVECTOR  OrientFront;
    DS3DVECTOR  OrientTop;
    FLOAT       DistanceFactor;
    FLOAT       RolloffFactor;
    FLOAT       DopplerFactor;
} KSDS3D_LISTENER_ALL, *PKSDS3D_LISTENER_ALL;

typedef struct {
    DS3DVECTOR  Front;
    DS3DVECTOR  Top;
} KSDS3D_LISTENER_ORIENTATION, *PKSDS3D_LISTENER_ORIENTATION;


//===========================================================================
//===========================================================================
// KSPROPSETID_DirectSound3DBuffer : {437B3411-D060-11d0-8583-00C04FD9BAF3}

#define STATIC_KSPROPSETID_DirectSound3DBuffer\
    0x437b3411L, 0xd060, 0x11d0, 0x85, 0x83, 0x00, 0xc0, 0x4f, 0xd9, 0xba, 0xf3
DEFINE_GUIDSTRUCT("437b3411-d060-11d0-8583-00c04fd9baf3", KSPROPSETID_DirectSound3DBuffer);
#define KSPROPSETID_DirectSound3DBuffer DEFINE_GUIDNAMED(KSPROPSETID_DirectSound3DBuffer)


typedef enum {
    KSPROPERTY_DIRECTSOUND3DBUFFER_ALL,
    KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION,
    KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MODE
} KSPROPERTY_DIRECTSOUND3DBUFFER;


typedef struct {
    DS3DVECTOR  Position;
    DS3DVECTOR  Velocity;
    ULONG       InsideConeAngle;
    ULONG       OutsideConeAngle;
    DS3DVECTOR  ConeOrientation;
    LONG        ConeOutsideVolume;
    FLOAT       MinDistance;
    FLOAT       MaxDistance;
    ULONG       Mode;
} KSDS3D_BUFFER_ALL, *PKSDS3D_BUFFER_ALL;

typedef struct {
    ULONG  InsideConeAngle;
    ULONG  OutsideConeAngle;
} KSDS3D_BUFFER_CONE_ANGLES, *PKSDS3D_BUFFER_CONE_ANGLES;

#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_HEADPHONE   (-1)
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_MIN         5
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW      10
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_WIDE        20
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_MAX         180

#define KSDSOUND_3D_MODE_NORMAL          0x00000000
#define KSDSOUND_3D_MODE_HEADRELATIVE    0x00000001
#define KSDSOUND_3D_MODE_DISABLE         0x00000002

//===========================================================================
// Definitions intended for hardware acceleration of the HRTF 3D algorithm
//===========================================================================

#define KSDSOUND_BUFFER_CTRL_HRTF_3D        0x40000000

typedef struct {
    ULONG                   Size;           // This is the size of the struct in bytes
    ULONG                   Enabled;
    BOOL                    SwapChannels;
    BOOL                    ZeroAzimuth;
    BOOL                    CrossFadeOutput;
    ULONG                   FilterSize;     // This is the additional size of the filter coeff in bytes
} KSDS3D_HRTF_PARAMS_MSG, *PKSDS3D_HRTF_PARAMS_MSG;

// HRTF filter quality levels
typedef enum {
    FULL_FILTER,
    LIGHT_FILTER,
    KSDS3D_FILTER_QUALITY_COUNT
} KSDS3D_HRTF_FILTER_QUALITY;

typedef struct {
    ULONG                       Size;       // This is the size of the struct in bytes
    KSDS3D_HRTF_FILTER_QUALITY  Quality;
    FLOAT                       SampleRate;
    ULONG                       MaxFilterSize;
    ULONG                       FilterTransientMuteLength;
    ULONG                       FilterOverlapBufferLength;
    ULONG                       OutputOverlapBufferLength;
    ULONG                       Reserved;
} KSDS3D_HRTF_INIT_MSG, *PKSDS3D_HRTF_INIT_MSG;

// Coefficient formats
typedef enum {
    FLOAT_COEFF,
    SHORT_COEFF,
    KSDS3D_COEFF_COUNT
} KSDS3D_HRTF_COEFF_FORMAT;

// Filter methods
typedef enum {
    DIRECT_FORM,
    CASCADE_FORM,
    KSDS3D_FILTER_METHOD_COUNT
} KSDS3D_HRTF_FILTER_METHOD;

// Filter methods
typedef enum {
    DS3D_HRTF_VERSION_1
} KSDS3D_HRTF_FILTER_VERSION;

typedef struct {
    KSDS3D_HRTF_FILTER_METHOD    FilterMethod;
    KSDS3D_HRTF_COEFF_FORMAT     CoeffFormat;
    KSDS3D_HRTF_FILTER_VERSION   Version;
    ULONG                        Reserved;
} KSDS3D_HRTF_FILTER_FORMAT_MSG, *PKSDS3D_HRTF_FILTER_FORMAT_MSG;

#define STATIC_KSPROPSETID_Hrtf3d\
    0xb66decb0L, 0xa083, 0x11d0, 0x85, 0x1e, 0x00, 0xc0, 0x4f, 0xd9, 0xba, 0xf3
DEFINE_GUIDSTRUCT("b66decb0-a083-11d0-851e-00c04fd9baf3", KSPROPSETID_Hrtf3d);
#define KSPROPSETID_Hrtf3d DEFINE_GUIDNAMED(KSPROPSETID_Hrtf3d)

typedef enum {
    KSPROPERTY_HRTF3D_PARAMS = 0,
    KSPROPERTY_HRTF3D_INITIALIZE,
    KSPROPERTY_HRTF3D_FILTER_FORMAT
} KSPROPERTY_HRTF3D;


//===========================================================================
// Definitions related to the obsolete Interaural Time Delay 3D algorithm
//===========================================================================

// DirectSound3D FIR context
typedef struct {
    LONG                Channel;
    FLOAT               VolSmoothScale;
    FLOAT               TotalDryAttenuation;
    FLOAT               TotalWetAttenuation;
    LONG                SmoothFrequency;
    LONG                Delay;
} KSDS3D_ITD_PARAMS, *PKSDS3D_ITD_PARAMS;

typedef struct {
    ULONG                 Enabled;
    KSDS3D_ITD_PARAMS     LeftParams;
    KSDS3D_ITD_PARAMS     RightParams;
    ULONG                 Reserved;
} KSDS3D_ITD_PARAMS_MSG, *PKSDS3D_ITD_PARAMS_MSG;

#define STATIC_KSPROPSETID_Itd3d\
    0x6429f090L, 0x9fd9, 0x11d0, 0xa7, 0x5b, 0x00, 0xa0, 0xc9, 0x03, 0x65, 0xe3
DEFINE_GUIDSTRUCT("6429f090-9fd9-11d0-a75b-00a0c90365e3", KSPROPSETID_Itd3d);
#define KSPROPSETID_Itd3d DEFINE_GUIDNAMED(KSPROPSETID_Itd3d)

typedef enum {
    KSPROPERTY_ITD3D_PARAMS = 0
} KSPROPERTY_ITD3D;


typedef struct {
   KSDATARANGE              DataRange;
   ULONG                    MaximumChannels;
   ULONG                    MinimumBitsPerSample;
   ULONG                    MaximumBitsPerSample;
   ULONG                    MinimumSampleFrequency;
   ULONG                    MaximumSampleFrequency;
} KSDATARANGE_AUDIO, *PKSDATARANGE_AUDIO;

//---------------------------------------------------------------------------

#define STATIC_KSDATAFORMAT_SUBTYPE_RIFF\
    0x4995DAEEL, 0x9EE6, 0x11D0, 0xA4, 0x0E, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("4995DAEE-9EE6-11D0-A40E-00A0C9223196", KSDATAFORMAT_SUBTYPE_RIFF);
#define KSDATAFORMAT_SUBTYPE_RIFF DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_RIFF)

#define STATIC_KSDATAFORMAT_SUBTYPE_RIFFWAVE\
    0xe436eb8bL, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70
DEFINE_GUIDSTRUCT("e436eb8b-524f-11ce-9f53-0020af0ba770", KSDATAFORMAT_SUBTYPE_RIFFWAVE);
#define KSDATAFORMAT_SUBTYPE_RIFFWAVE DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_RIFFWAVE)

//===========================================================================
//===========================================================================

#define STATIC_KSPROPSETID_Bibliographic \
    0x07BA150EL, 0xE2B1, 0x11D0, 0xAC, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("07BA150E-E2B1-11D0-AC17-00A0C9223196", KSPROPSETID_Bibliographic);
#define KSPROPSETID_Bibliographic DEFINE_GUIDNAMED(KSPROPSETID_Bibliographic)

//Repeatable tags contain all entries within the property, each preceeded by length
typedef enum {
    KSPROPERTY_BIBLIOGRAPHIC_LEADER = 'RDL ',
    KSPROPERTY_BIBLIOGRAPHIC_LCCN = '010 ',
    KSPROPERTY_BIBLIOGRAPHIC_ISBN = '020 ',
    KSPROPERTY_BIBLIOGRAPHIC_ISSN = '220 ',
    KSPROPERTY_BIBLIOGRAPHIC_CATALOGINGSOURCE = '040 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINPERSONALNAME = '001 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINCORPORATEBODY = '011 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINMEETINGNAME = '111 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINUNIFORMTITLE = '031 ',
    KSPROPERTY_BIBLIOGRAPHIC_UNIFORMTITLE = '042 ',
    KSPROPERTY_BIBLIOGRAPHIC_TITLESTATEMENT = '542 ',
    KSPROPERTY_BIBLIOGRAPHIC_VARYINGFORMTITLE = '642 ',
    KSPROPERTY_BIBLIOGRAPHIC_PUBLICATION = '062 ',
    KSPROPERTY_BIBLIOGRAPHIC_PHYSICALDESCRIPTION = '003 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTITLE = '044 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENT = '094 ',
    KSPROPERTY_BIBLIOGRAPHIC_GENERALNOTE = '005 ',
    KSPROPERTY_BIBLIOGRAPHIC_BIBLIOGRAPHYNOTE = '405 ',
    KSPROPERTY_BIBLIOGRAPHIC_CONTENTSNOTE = '505 ',
    KSPROPERTY_BIBLIOGRAPHIC_CREATIONCREDIT = '805 ',
    KSPROPERTY_BIBLIOGRAPHIC_CITATION = '015 ',
    KSPROPERTY_BIBLIOGRAPHIC_PARTICIPANT = '115 ',
    KSPROPERTY_BIBLIOGRAPHIC_SUMMARY = '025 ',
    KSPROPERTY_BIBLIOGRAPHIC_TARGETAUDIENCE = '125 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDFORMAVAILABLE = '035 ',
    KSPROPERTY_BIBLIOGRAPHIC_SYSTEMDETAILS = '835 ',
    KSPROPERTY_BIBLIOGRAPHIC_AWARDS = '685 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYPERSONALNAME = '006 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTOPICALTERM = '056 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYGEOGRAPHIC = '156 ',
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMGENRE = '556 ',
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMCURRICULUM = '856 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYUNIFORMTITLE = '037 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYRELATED = '047 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTPERSONALNAME = '008 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTUNIFORMTITLE = '038 '
} KSPROPERTY_BIBLIOGRAPHIC;

#define STATIC_KSPROPSETID_TopologyNode\
    0x45FFAAA1L, 0x6E1B, 0x11D0, 0xBC, 0xF2, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00
DEFINE_GUIDSTRUCT("45FFAAA1-6E1B-11D0-BCF2-444553540000", KSPROPSETID_TopologyNode);
#define KSPROPSETID_TopologyNode DEFINE_GUIDNAMED(KSPROPSETID_TopologyNode)

typedef enum {
    KSPROPERTY_TOPOLOGYNODE_ENABLE = 1
#if (NTDDI_VERSION >= NTDDI_WINXP)
    , KSPROPERTY_TOPOLOGYNODE_RESET
#endif // (NTDDI_VERSION >= NTDDI_WINXP)
} KSPROPERTY_TOPOLOGYNODE;

//===========================================================================

#if (NTDDI_VERSION >= NTDDI_WINXP)

#if defined(_NTDDK_)
typedef NTSTATUS (CALLBACK *PRTAUDIOGETPOSITION)(_In_ PFILE_OBJECT PinFileObject,
                                                 _Out_ PUCHAR *ppPlayPosition,
                                                 _Out_ PLONG plOffset);
#endif // defined(_NTDDK_)

#define STATIC_KSPROPSETID_RtAudio\
    0xa855a48c, 0x2f78, 0x4729, 0x90, 0x51, 0x19, 0x68, 0x74, 0x6b, 0x9e, 0xef
DEFINE_GUIDSTRUCT("A855A48C-2F78-4729-9051-1968746B9EEF", KSPROPSETID_RtAudio);
#define KSPROPSETID_RtAudio DEFINE_GUIDNAMED(KSPROPSETID_RtAudio)

typedef enum {
    KSPROPERTY_RTAUDIO_GETPOSITIONFUNCTION,
#if (NTDDI_VERSION >= NTDDI_VISTA)
    KSPROPERTY_RTAUDIO_BUFFER,
    KSPROPERTY_RTAUDIO_HWLATENCY,
    KSPROPERTY_RTAUDIO_POSITIONREGISTER,
    KSPROPERTY_RTAUDIO_CLOCKREGISTER,
    KSPROPERTY_RTAUDIO_BUFFER_WITH_NOTIFICATION,
    KSPROPERTY_RTAUDIO_REGISTER_NOTIFICATION_EVENT,
    KSPROPERTY_RTAUDIO_UNREGISTER_NOTIFICATION_EVENT,
#endif
#if (NTDDI_VERSION >= NTDDI_WIN7)
    KSPROPERTY_RTAUDIO_QUERY_NOTIFICATION_SUPPORT,
#endif
#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
    KSPROPERTY_RTAUDIO_PACKETCOUNT,
    KSPROPERTY_RTAUDIO_PRESENTATION_POSITION,
    KSPROPERTY_RTAUDIO_GETREADPACKET,
    KSPROPERTY_RTAUDIO_SETWRITEPACKET,
#endif
#if (NTDDI_VERSION >= NTDDI_WIN10_RS5)
    KSPROPERTY_RTAUDIO_PACKETVREGISTER,
#endif
} KSPROPERTY_RTAUDIO;

#if (NTDDI_VERSION >= NTDDI_VISTA)
typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
    ULONG       RequestedBufferSize;
} KSRTAUDIO_BUFFER_PROPERTY, *PKSRTAUDIO_BUFFER_PROPERTY;

typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
    ULONG       RequestedBufferSize;
} KSRTAUDIO_BUFFER_PROPERTY32, *PKSRTAUDIO_BUFFER_PROPERTY32;

typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
    ULONG       RequestedBufferSize;
    ULONG       NotificationCount;
} KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION, *PKSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION;

typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
    ULONG       RequestedBufferSize;
    ULONG       NotificationCount;
} KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION32, *PKSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION32;

typedef struct {
    PVOID   BufferAddress;
    ULONG   ActualBufferSize;
    BOOL    CallMemoryBarrier;
} KSRTAUDIO_BUFFER, *PKSRTAUDIO_BUFFER;

typedef struct {
    ULONG   BufferAddress;
    ULONG   ActualBufferSize;
    BOOL    CallMemoryBarrier;
} KSRTAUDIO_BUFFER32, *PKSRTAUDIO_BUFFER32;

typedef struct {
    ULONG   FifoSize;
    ULONG   ChipsetDelay;
    ULONG   CodecDelay;
} KSRTAUDIO_HWLATENCY, *PKSRTAUDIO_HWLATENCY;

typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
} KSRTAUDIO_HWREGISTER_PROPERTY, *PKSRTAUDIO_HWREGISTER_PROPERTY;

typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
} KSRTAUDIO_HWREGISTER_PROPERTY32, *PKSRTAUDIO_HWREGISTER_PROPERTY32;

typedef struct {
    PVOID       Register;
    ULONG       Width;
    ULONGLONG   Numerator;
    ULONGLONG   Denominator;
    ULONG       Accuracy;
} KSRTAUDIO_HWREGISTER, *PKSRTAUDIO_HWREGISTER;

typedef struct {
    ULONG       Register;
    ULONG       Width;
    ULONGLONG   Numerator;
    ULONGLONG   Denominator;
    ULONG       Accuracy;
} KSRTAUDIO_HWREGISTER32, *PKSRTAUDIO_HWREGISTER32;

typedef struct {
    KSPROPERTY  Property;
    HANDLE      NotificationEvent;
} KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY, *PKSRTAUDIO_NOTIFICATION_EVENT_PROPERTY;

typedef struct {
    KSPROPERTY  Property;
    ULONG       NotificationEvent;
} KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY32, *PKSRTAUDIO_NOTIFICATION_EVENT_PROPERTY32;
#endif

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
typedef struct {
    ULONG       PacketNumber;
    DWORD       Flags;
    ULONG64     PerformanceCounterValue;
    BOOL        MoreData;
} KSRTAUDIO_GETREADPACKET_INFO, *PKSRTAUDIO_GETREADPACKET_INFO;

typedef struct {
    ULONG       PacketNumber;
    DWORD       Flags;
    ULONG       EosPacketLength;
} KSRTAUDIO_SETWRITEPACKET_INFO, *PKSRTAUDIO_SETWRITEPACKET_INFO;
#endif

#if (NTDDI_VERSION >= NTDDI_WIN10_RS5)
typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
} KSRTAUDIO_PACKETVREGISTER_PROPERTY, *PKSRTAUDIO_PACKETVREGISTER_PROPERTY;

typedef struct {
    PULONG64    CompletedPacketCount;
    PULONG64    CompletedPacketQPC;
    PULONG64    CompletedPacketHash;
} KSRTAUDIO_PACKETVREGISTER, *PKSRTAUDIO_PACKETVREGISTER;
#endif

#if (NTDDI_VERSION >= NTDDI_WIN7)

//===========================================================================

//===========================================================================

#define STATIC_KSPROPSETID_BtAudio\
    0x7FA06C40, 0xB8F6, 0x4C7E, 0x85, 0x56, 0xE8, 0xC3, 0x3A, 0x12, 0xE5, 0x4D
DEFINE_GUIDSTRUCT("7FA06C40-B8F6-4C7E-8556-E8C33A12E54D", KSPROPSETID_BtAudio);
#define KSPROPSETID_BtAudio DEFINE_GUIDNAMED(KSPROPSETID_BtAudio)

typedef enum {
    KSPROPERTY_ONESHOT_RECONNECT,
    KSPROPERTY_ONESHOT_DISCONNECT,
} KSPROPERTY_BTAUDIO;


#endif

//===========================================================================
#define STATIC_KSPROPSETID_DrmAudioStream\
    0x2f2c8ddd, 0x4198, 0x4fac, 0xba, 0x29, 0x61, 0xbb, 0x5, 0xb7, 0xde, 0x6
DEFINE_GUIDSTRUCT("2F2C8DDD-4198-4fac-BA29-61BB05B7DE06", KSPROPSETID_DrmAudioStream);
#define KSPROPSETID_DrmAudioStream DEFINE_GUIDNAMED(KSPROPSETID_DrmAudioStream)

typedef enum {
    KSPROPERTY_DRMAUDIOSTREAM_CONTENTID
} KSPROPERTY_DRMAUDIOSTREAM;

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
//===========================================================================
#define STATIC_KSPROPSETID_SoundDetector\
    0x113c425e, 0xfd17, 0x4057, 0xb4, 0x22, 0xed, 0x40, 0x74, 0xf1, 0xaf, 0xdf
DEFINE_GUIDSTRUCT("113C425E-FD17-4057-B422-ED4074F1AFDF", KSPROPSETID_SoundDetector);
#define KSPROPSETID_SoundDetector DEFINE_GUIDNAMED(KSPROPSETID_SoundDetector)

#if (NTDDI_VERSION >= NTDDI_WIN10_19H1)
#define STATIC_KSPROPSETID_SoundDetector2\
    0xfe07e322, 0x450c, 0x4bd5, 0x84, 0xca, 0xa9, 0x48, 0x50, 0xe, 0xa6, 0xaa
DEFINE_GUIDSTRUCT("FE07E322-450C-4BD5-84CA-A948500EA6AA", KSPROPSETID_SoundDetector2);
#define KSPROPSETID_SoundDetector2 DEFINE_GUIDNAMED(KSPROPSETID_SoundDetector2)

#define STATIC_KSPROPSETID_InterleavedAudio\
    0xe9ebe550, 0xd619, 0x4c0a, 0x97, 0x6b, 0x70, 0x62, 0x32, 0x2b, 0x30, 0x6
DEFINE_GUIDSTRUCT("E9EBE550-D619-4C0A-976B-7062322B3006", KSPROPSETID_InterleavedAudio);
#define KSPROPSETID_InterleavedAudio DEFINE_GUIDNAMED(KSPROPSETID_InterleavedAudio)

typedef enum {
    KSPROPERTY_INTERLEAVEDAUDIO_FORMATINFORMATION = 1,
} KSPROPERTY_INTERLEAVEDAUDIO;

typedef struct {
    ULONG Size;
    DWORD PrimaryChannelCount;
    DWORD PrimaryChannelStartPosition;
    DWORD PrimaryChannelMask;
    DWORD InterleavedChannelCount;
    DWORD InterleavedChannelStartPosition;
    DWORD InterleavedChannelMask;
} INTERLEAVED_AUDIO_FORMAT_INFORMATION;

typedef struct {
    KSPROPERTY  Property;
    GUID        EventId;
} KSSOUNDDETECTORPROPERTY, *PKSSOUNDDETECTORPROPERTY;

#endif // (NTDDI_VERSION >= NTDDI_WIN10_19H1)


typedef enum {
    KSPROPERTY_SOUNDDETECTOR_SUPPORTEDPATTERNS = 1,
    KSPROPERTY_SOUNDDETECTOR_PATTERNS,
    KSPROPERTY_SOUNDDETECTOR_ARMED,
    KSPROPERTY_SOUNDDETECTOR_MATCHRESULT,
#if (NTDDI_VERSION >= NTDDI_WIN10_19H1)
    KSPROPERTY_SOUNDDETECTOR_RESET,
    KSPROPERTY_SOUNDDETECTOR_STREAMINGSUPPORT,
#endif // (NTDDI_VERSION >= NTDDI_WIN10_19H1)
} KSPROPERTY_SOUNDDETECTOR;

typedef struct {
    ULONG   Size;
    GUID    PatternType;
} SOUNDDETECTOR_PATTERNHEADER;

#define STATIC_KSEVENTSETID_SoundDetector\
    0x69785c9b, 0xfc2d, 0x49d6, 0xac, 0x32, 0x47, 0x99, 0xf8, 0x7d, 0xe9, 0xf6
DEFINE_GUIDSTRUCT("69785C9B-FC2D-49D6-AC32-4799F87DE9F6", KSEVENTSETID_SoundDetector);
#define KSEVENTSETID_SoundDetector DEFINE_GUIDNAMED(KSEVENTSETID_SoundDetector)

typedef enum {
    KSEVENT_SOUNDDETECTOR_MATCHDETECTED = 1,
} KSEVENT_SOUNDDETECTOR;
#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#if (NTDDI_VERSION >= NTDDI_WIN10_19H1)
// The payload of this notification is a SOUNDDETECTOR_PATTERNHEADER
#define STATIC_KSNOTIFICATIONID_SoundDetector\
    0x6389d844, 0xbb32, 0x4c4c, 0xa8, 0x2, 0xf4, 0xb4, 0xb7, 0x7a, 0xfe, 0xad
DEFINE_GUIDSTRUCT("6389D844-BB32-4C4C-A802-F4B4B77AFEAD", KSNOTIFICATIONID_SoundDetector);
#define KSNOTIFICATIONID_SoundDetector DEFINE_GUIDNAMED(KSNOTIFICATIONID_SoundDetector)
#endif // (NTDDI_VERSION >= NTDDI_WIN10_19H1)

//===========================================================================
#define STATIC_KSPROPSETID_Audio\
    0x45FFAAA0L, 0x6E1B, 0x11D0, 0xBC, 0xF2, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00
DEFINE_GUIDSTRUCT("45FFAAA0-6E1B-11D0-BCF2-444553540000", KSPROPSETID_Audio);
#define KSPROPSETID_Audio DEFINE_GUIDNAMED(KSPROPSETID_Audio)

typedef enum {
    KSPROPERTY_AUDIO_LATENCY = 1,
    KSPROPERTY_AUDIO_COPY_PROTECTION,
    KSPROPERTY_AUDIO_CHANNEL_CONFIG,
    KSPROPERTY_AUDIO_VOLUMELEVEL,
    KSPROPERTY_AUDIO_POSITION,
    KSPROPERTY_AUDIO_DYNAMIC_RANGE,
    KSPROPERTY_AUDIO_QUALITY,
    KSPROPERTY_AUDIO_SAMPLING_RATE,
    KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE,
    KSPROPERTY_AUDIO_MIX_LEVEL_TABLE,
    KSPROPERTY_AUDIO_MIX_LEVEL_CAPS,
    KSPROPERTY_AUDIO_MUX_SOURCE,
    KSPROPERTY_AUDIO_MUTE,
    KSPROPERTY_AUDIO_BASS,
    KSPROPERTY_AUDIO_MID,
    KSPROPERTY_AUDIO_TREBLE,
    KSPROPERTY_AUDIO_BASS_BOOST,
    KSPROPERTY_AUDIO_EQ_LEVEL,
    KSPROPERTY_AUDIO_NUM_EQ_BANDS,
    KSPROPERTY_AUDIO_EQ_BANDS,
    KSPROPERTY_AUDIO_AGC,
    KSPROPERTY_AUDIO_DELAY,
    KSPROPERTY_AUDIO_LOUDNESS,
    KSPROPERTY_AUDIO_WIDE_MODE,                 //Reserved for system use
    KSPROPERTY_AUDIO_WIDENESS,
    KSPROPERTY_AUDIO_REVERB_LEVEL,
    KSPROPERTY_AUDIO_CHORUS_LEVEL,
    KSPROPERTY_AUDIO_DEV_SPECIFIC,
    KSPROPERTY_AUDIO_DEMUX_DEST,
    KSPROPERTY_AUDIO_STEREO_ENHANCE,            //Reserved for system use
    KSPROPERTY_AUDIO_MANUFACTURE_GUID,          //Reserved for system use
    KSPROPERTY_AUDIO_PRODUCT_GUID,              //Reserved for system use
    KSPROPERTY_AUDIO_CPU_RESOURCES,
    KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY,
    KSPROPERTY_AUDIO_SURROUND_ENCODE,
    KSPROPERTY_AUDIO_3D_INTERFACE

#if (NTDDI_VERSION >= NTDDI_WINXP)
    , KSPROPERTY_AUDIO_PEAKMETER
    , KSPROPERTY_AUDIO_ALGORITHM_INSTANCE
    , KSPROPERTY_AUDIO_FILTER_STATE
    , KSPROPERTY_AUDIO_PREFERRED_STATUS
    
#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#if (NTDDI_VERSION >= NTDDI_VISTA)
    , KSPROPERTY_AUDIO_PEQ_MAX_BANDS
    , KSPROPERTY_AUDIO_PEQ_NUM_BANDS
    , KSPROPERTY_AUDIO_PEQ_BAND_CENTER_FREQ
    , KSPROPERTY_AUDIO_PEQ_BAND_Q_FACTOR
    , KSPROPERTY_AUDIO_PEQ_BAND_LEVEL
    , KSPROPERTY_AUDIO_CHORUS_MODULATION_RATE
    , KSPROPERTY_AUDIO_CHORUS_MODULATION_DEPTH
    , KSPROPERTY_AUDIO_REVERB_TIME
    , KSPROPERTY_AUDIO_REVERB_DELAY_FEEDBACK
    , KSPROPERTY_AUDIO_POSITIONEX
    , KSPROPERTY_AUDIO_MIC_ARRAY_GEOMETRY
#endif // (NTDDI_VERSION >= NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WIN8)
    , KSPROPERTY_AUDIO_PRESENTATION_POSITION
    , KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_POSITION
    , KSPROPERTY_AUDIO_LINEAR_BUFFER_POSITION
    , KSPROPERTY_AUDIO_PEAKMETER2
#endif // (NTDDI_VERSION >= NTDDI_WIN8)

#if (NTDDI_VERSION >= NTDDI_WINBLUE)
    , KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION
    , KSPROPERTY_AUDIO_VOLUMELIMIT_ENGAGED 
#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)

#if (NTDDI_VERSION >= NTDDI_WIN10_RS1)
    , KSPROPERTY_AUDIO_MIC_SENSITIVITY // deprecated in favor of KSPROPERTY_AUDIO_MIC_SENSITIVITY2
    , KSPROPERTY_AUDIO_MIC_SNR
#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS1)

#if (NTDDI_VERSION >= NTDDI_WIN10_RS4)
    , KSPROPERTY_AUDIO_MIC_SENSITIVITY2
#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS4)

} KSPROPERTY_AUDIO;

// Audio quality constants
#define KSAUDIO_QUALITY_WORST               0x0
#define KSAUDIO_QUALITY_PC                  0x1
#define KSAUDIO_QUALITY_BASIC               0x2
#define KSAUDIO_QUALITY_ADVANCED            0x3

// Audio CPU resource constants
#define KSAUDIO_CPU_RESOURCES_NOT_HOST_CPU  0x00000000
#define KSAUDIO_CPU_RESOURCES_HOST_CPU      0x7FFFFFFF

typedef struct {
    BOOL    fCopyrighted;
    BOOL    fOriginal;
} KSAUDIO_COPY_PROTECTION, *PKSAUDIO_COPY_PROTECTION;

typedef struct {
    LONG    ActiveSpeakerPositions;
} KSAUDIO_CHANNEL_CONFIG, *PKSAUDIO_CHANNEL_CONFIG;

// Speaker Positions:
#define SPEAKER_FRONT_LEFT              0x1
#define SPEAKER_FRONT_RIGHT             0x2
#define SPEAKER_FRONT_CENTER            0x4
#define SPEAKER_LOW_FREQUENCY           0x8
#define SPEAKER_BACK_LEFT               0x10
#define SPEAKER_BACK_RIGHT              0x20
#define SPEAKER_FRONT_LEFT_OF_CENTER    0x40
#define SPEAKER_FRONT_RIGHT_OF_CENTER   0x80
#define SPEAKER_BACK_CENTER             0x100
#define SPEAKER_SIDE_LEFT               0x200
#define SPEAKER_SIDE_RIGHT              0x400
#define SPEAKER_TOP_CENTER              0x800
#define SPEAKER_TOP_FRONT_LEFT          0x1000
#define SPEAKER_TOP_FRONT_CENTER        0x2000
#define SPEAKER_TOP_FRONT_RIGHT         0x4000
#define SPEAKER_TOP_BACK_LEFT           0x8000
#define SPEAKER_TOP_BACK_CENTER         0x10000
#define SPEAKER_TOP_BACK_RIGHT          0x20000

// Bit mask locations reserved for future use
#define SPEAKER_RESERVED                0x7FFC0000

// Used to specify that any possible permutation of speaker configurations
#define SPEAKER_ALL                     0x80000000

// DirectSound Speaker Config
#if (NTDDI_VERSION >= NTDDI_WINXP)
#define KSAUDIO_SPEAKER_DIRECTOUT       0
#endif
#define KSAUDIO_SPEAKER_MONO            (SPEAKER_FRONT_CENTER)
#define KSAUDIO_SPEAKER_1POINT1         (SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY)
#define KSAUDIO_SPEAKER_STEREO          (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT)
#define KSAUDIO_SPEAKER_2POINT1         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_LOW_FREQUENCY)
#define KSAUDIO_SPEAKER_3POINT0         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER)
#define KSAUDIO_SPEAKER_3POINT1         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY)
#define KSAUDIO_SPEAKER_QUAD            (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_BACK_LEFT  | SPEAKER_BACK_RIGHT)
#define KSAUDIO_SPEAKER_SURROUND        (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_BACK_CENTER)
#define KSAUDIO_SPEAKER_5POINT0         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
                                         SPEAKER_SIDE_LEFT  | SPEAKER_SIDE_RIGHT)
#define KSAUDIO_SPEAKER_5POINT1         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | \
                                         SPEAKER_BACK_LEFT  | SPEAKER_BACK_RIGHT)
#define KSAUDIO_SPEAKER_7POINT0         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
                                         SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT | \
                                         SPEAKER_SIDE_LEFT | SPEAKER_SIDE_RIGHT)
#define KSAUDIO_SPEAKER_7POINT1         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | \
                                         SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT | \
                                         SPEAKER_FRONT_LEFT_OF_CENTER | SPEAKER_FRONT_RIGHT_OF_CENTER)

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

#define KSAUDIO_SPEAKER_5POINT1_SURROUND (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | \
                                         SPEAKER_SIDE_LEFT  | SPEAKER_SIDE_RIGHT)
#define KSAUDIO_SPEAKER_7POINT1_SURROUND (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                         SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | \
                                         SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT | \
                                         SPEAKER_SIDE_LEFT | SPEAKER_SIDE_RIGHT)
// The following are obsolete 5.1 and 7.1 settings (they lack side speakers).  Note this means
// that the default 5.1 and 7.1 settings (KSAUDIO_SPEAKER_5POINT1 and KSAUDIO_SPEAKER_7POINT1 are
// similarly obsolete but are unchanged for compatibility reasons).
#define KSAUDIO_SPEAKER_5POINT1_BACK     KSAUDIO_SPEAKER_5POINT1
#define KSAUDIO_SPEAKER_7POINT1_WIDE     KSAUDIO_SPEAKER_7POINT1

#endif // XP SP2 and later (chronologically)

// DVD Speaker Positions
#define KSAUDIO_SPEAKER_GROUND_FRONT_LEFT   SPEAKER_FRONT_LEFT
#define KSAUDIO_SPEAKER_GROUND_FRONT_CENTER SPEAKER_FRONT_CENTER
#define KSAUDIO_SPEAKER_GROUND_FRONT_RIGHT  SPEAKER_FRONT_RIGHT
#define KSAUDIO_SPEAKER_GROUND_REAR_LEFT    SPEAKER_BACK_LEFT
#define KSAUDIO_SPEAKER_GROUND_REAR_RIGHT   SPEAKER_BACK_RIGHT
#define KSAUDIO_SPEAKER_TOP_MIDDLE          SPEAKER_TOP_CENTER
#define KSAUDIO_SPEAKER_SUPER_WOOFER        SPEAKER_LOW_FREQUENCY

typedef struct {
    ULONG   QuietCompression;
    ULONG   LoudCompression;
} KSAUDIO_DYNAMIC_RANGE, *PKSAUDIO_DYNAMIC_RANGE;

typedef struct {
    BOOL    Mute;
    LONG    Level;
} KSAUDIO_MIXLEVEL, *PKSAUDIO_MIXLEVEL;

typedef struct {
    BOOL    Mute;
    LONG    Minimum;
    LONG    Maximum;
    union {
        LONG    Reset;
        LONG    Resolution;
    };
} KSAUDIO_MIX_CAPS, *PKSAUDIO_MIX_CAPS;

typedef struct {
    ULONG               InputChannels;
    ULONG               OutputChannels;
    KSAUDIO_MIX_CAPS    Capabilities[1];
} KSAUDIO_MIXCAP_TABLE, *PKSAUDIO_MIXCAP_TABLE;

#if (NTDDI_VERSION < NTDDI_VISTA)

typedef enum {              // preferred device index
    KSPROPERTY_SYSAUDIO_NORMAL_DEFAULT = 0,
    KSPROPERTY_SYSAUDIO_PLAYBACK_DEFAULT,
    KSPROPERTY_SYSAUDIO_RECORD_DEFAULT,
    KSPROPERTY_SYSAUDIO_MIDI_DEFAULT,
    KSPROPERTY_SYSAUDIO_MIXER_DEFAULT
} KSPROPERTY_SYSAUDIO_DEFAULT_TYPE;

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

typedef struct {
    BOOL                             Enable;
    KSPROPERTY_SYSAUDIO_DEFAULT_TYPE DeviceType;
    ULONG                            Flags;
    ULONG                            Reserved;
} KSAUDIO_PREFERRED_STATUS, *PKSAUDIO_PREFERRED_STATUS;

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_VISTA)
typedef struct {
    LARGE_INTEGER       TimerFrequency;
    LARGE_INTEGER       TimeStamp1;
    KSAUDIO_POSITION    Position;
    LARGE_INTEGER       TimeStamp2;
} KSAUDIO_POSITIONEX, *PKSAUDIO_POSITIONEX;
#endif // (NTDDI_VERSION >= NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#define STATIC_KSPROPSETID_TelephonyControl\
    0xb6df7eb1, 0xd099, 0x489f, 0xa6, 0xa0, 0xc0, 0x10, 0x6f, 0x8, 0x87, 0xa7
DEFINE_GUIDSTRUCT("B6DF7EB1-D099-489F-A6A0-C0106F0887A7", KSPROPSETID_TelephonyControl);
#define KSPROPSETID_TelephonyControl DEFINE_GUIDNAMED(KSPROPSETID_TelephonyControl)

typedef enum {
    KSPROPERTY_TELEPHONY_PROVIDERID = 0,
    KSPROPERTY_TELEPHONY_CALLINFO,
    KSPROPERTY_TELEPHONY_CALLCONTROL,
    KSPROPERTY_TELEPHONY_PROVIDERCHANGE,
    KSPROPERTY_TELEPHONY_CALLHOLD,
    KSPROPERTY_TELEPHONY_MUTE_TX
} KSPROPERTY_TELEPHONY_CONTROL;

typedef enum {
    TELEPHONY_CALLTYPE_CIRCUITSWITCHED = 0,
    TELEPHONY_CALLTYPE_PACKETSWITCHED_LTE,
    TELEPHONY_CALLTYPE_PACKETSWITCHED_WLAN
} TELEPHONY_CALLTYPE;

typedef enum {
    TELEPHONY_CALLCONTROLOP_DISABLE = 0,
    TELEPHONY_CALLCONTROLOP_ENABLE
} TELEPHONY_CALLCONTROLOP;

typedef struct _tagKSTELEPHONY_CALLCONTROL
{
    TELEPHONY_CALLTYPE         CallType;
    TELEPHONY_CALLCONTROLOP    CallControlOp;
} KSTELEPHONY_CALLCONTROL, *PKSTELEPHONY_CALLCONTROL;

typedef enum {
    TELEPHONY_PROVIDERCHANGEOP_END = 0,
    TELEPHONY_PROVIDERCHANGEOP_BEGIN,
    TELEPHONY_PROVIDERCHANGEOP_CANCEL
} TELEPHONY_PROVIDERCHANGEOP;

typedef struct _tagKSTELEPHONY_PROVIDERCHANGE
{
    TELEPHONY_CALLTYPE            CallType;
    TELEPHONY_PROVIDERCHANGEOP    ProviderChangeOp;
} KSTELEPHONY_PROVIDERCHANGE, *PKSTELEPHONY_PROVIDERCHANGE;

typedef enum {
    TELEPHONY_CALLSTATE_DISABLED = 0, 
    TELEPHONY_CALLSTATE_ENABLED,
    TELEPHONY_CALLSTATE_HOLD,
    TELEPHONY_CALLSTATE_PROVIDERTRANSITION
} TELEPHONY_CALLSTATE;

typedef struct _tagKSTELEPHONY_CALLINFO
{
    TELEPHONY_CALLTYPE     CallType;
    TELEPHONY_CALLSTATE    CallState;
} KSTELEPHONY_CALLINFO, *PKSTELEPHONY_CALLINFO;

#define STATIC_KSPROPSETID_TelephonyTopology\
    0xabf25c7e, 0x0e64, 0x4e32, 0xb1, 0x90, 0xd0, 0xf6, 0xd7, 0xc5, 0x3e, 0x97
DEFINE_GUIDSTRUCT("ABF25C7E-0E64-4E32-B190-D0F6D7C53E97", KSPROPSETID_TelephonyTopology);
#define KSPROPSETID_TelephonyTopology DEFINE_GUIDNAMED(KSPROPSETID_TelephonyTopology)

typedef enum
{
    KSPROPERTY_TELEPHONY_ENDPOINTIDPAIR = 0,
    KSPROPERTY_TELEPHONY_VOLUME
} KSPROPERTY_TELEPHONY_TOPOLOGY;

typedef struct _tagKSTOPOLOGY_ENDPOINTID
{
    WCHAR TopologyName[MAX_PATH];  // Reference string for topology filter of an endpoint
    ULONG  PinId;                  // Topology filter pin id to which endpoint is connected 
} KSTOPOLOGY_ENDPOINTID, *PKSTOPOLOGY_ENDPOINTID;

typedef struct _tagKSTOPOLOGY_ENDPOINTIDPAIR
{
    KSTOPOLOGY_ENDPOINTID    RenderEndpoint;
    KSTOPOLOGY_ENDPOINTID    CaptureEndpoint;
} KSTOPOLOGY_ENDPOINTIDPAIR, *PKSTOPOLOGY_ENDPOINTIDPAIR;

#define STATIC_KSPROPSETID_FMRXTopology\
    0xc46ce8f, 0xdc2d, 0x4204, 0x9d, 0xc9, 0xf5, 0x89, 0x63, 0x36, 0x65, 0x63
DEFINE_GUIDSTRUCT("0C46CE8F-DC2D-4204-9DC9-F58963366563", KSPROPSETID_FMRXTopology);
#define KSPROPSETID_FMRXTopology DEFINE_GUIDNAMED(KSPROPSETID_FMRXTopology)

typedef enum
{
    KSPROPERTY_FMRX_ENDPOINTID = 0,
    KSPROPERTY_FMRX_VOLUME,
    KSPROPERTY_FMRX_ANTENNAENDPOINTID
} KSPROPERTY_FMRX_TOPOLOGY;

#define STATIC_KSPROPSETID_FMRXControl\
    0x947BBA3A, 0xE8EE, 0x4786, 0x90, 0xC4, 0x84, 0x28, 0x18, 0x5F, 0x05, 0xBE
DEFINE_GUIDSTRUCT("947BBA3A-E8EE-4786-90C4-8428185F05BE", KSPROPSETID_FMRXControl);
#define KSPROPSETID_FMRXControl DEFINE_GUIDNAMED(KSPROPSETID_FMRXControl)

typedef enum
{
    KSPROPERTY_FMRX_STATE = 0
} KSPROPERTY_FMRX_CONTROL;


#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#if (NTDDI_VERSION >= NTDDI_WIN10_RS4)

#define STATIC_KSEVENTSETID_Telephony \
    0xb77f12b4, 0xceb4, 0x4484, 0x8d, 0x5e, 0x52, 0xc1, 0xe7, 0xd8, 0x76, 0x2d
DEFINE_GUIDSTRUCT("B77F12B4-CEB4-4484-8D5E-52C1E7D8762D", KSEVENTSETID_Telephony);
#define KSEVENTSETID_Telephony DEFINE_GUIDNAMED(KSEVENTSETID_Telephony)

typedef enum {
    KSEVENT_TELEPHONY_ENDPOINTPAIRS_CHANGED
} KSEVENT_TELEPHONY;

#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS4)

//===========================================================================
// Topology Node Type GUIDs

#define STATIC_KSNODETYPE_DAC\
    0x507AE360L, 0xC554, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("507AE360-C554-11D0-8A2B-00A0C9255AC1", KSNODETYPE_DAC);
#define KSNODETYPE_DAC DEFINE_GUIDNAMED(KSNODETYPE_DAC)

#define STATIC_KSNODETYPE_ADC\
    0x4D837FE0L, 0xC555, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("4D837FE0-C555-11D0-8A2B-00A0C9255AC1", KSNODETYPE_ADC);
#define KSNODETYPE_ADC DEFINE_GUIDNAMED(KSNODETYPE_ADC)

#define STATIC_KSNODETYPE_SRC\
    0x9DB7B9E0L, 0xC555, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("9DB7B9E0-C555-11D0-8A2B-00A0C9255AC1", KSNODETYPE_SRC);
#define KSNODETYPE_SRC DEFINE_GUIDNAMED(KSNODETYPE_SRC)

#define STATIC_KSNODETYPE_SUPERMIX\
    0xE573ADC0L, 0xC555, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("E573ADC0-C555-11D0-8A2B-00A0C9255AC1", KSNODETYPE_SUPERMIX);
#define KSNODETYPE_SUPERMIX DEFINE_GUIDNAMED(KSNODETYPE_SUPERMIX)

#define STATIC_KSNODETYPE_MUX\
    0x2CEAF780L, 0xC556, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("2CEAF780-C556-11D0-8A2B-00A0C9255AC1", KSNODETYPE_MUX);
#define KSNODETYPE_MUX DEFINE_GUIDNAMED(KSNODETYPE_MUX)

#define STATIC_KSNODETYPE_DEMUX\
    0xC0EB67D4L, 0xE807, 0x11D0, 0x95, 0x8A, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("C0EB67D4-E807-11D0-958A-00C04FB925D3", KSNODETYPE_DEMUX);
#define KSNODETYPE_DEMUX DEFINE_GUIDNAMED(KSNODETYPE_DEMUX)

#define STATIC_KSNODETYPE_SUM\
    0xDA441A60L, 0xC556, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("DA441A60-C556-11D0-8A2B-00A0C9255AC1", KSNODETYPE_SUM);
#define KSNODETYPE_SUM DEFINE_GUIDNAMED(KSNODETYPE_SUM)

#define STATIC_KSNODETYPE_MUTE\
    0x02B223C0L, 0xC557, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("02B223C0-C557-11D0-8A2B-00A0C9255AC1", KSNODETYPE_MUTE);
#define KSNODETYPE_MUTE DEFINE_GUIDNAMED(KSNODETYPE_MUTE)

#define STATIC_KSNODETYPE_VOLUME\
    0x3A5ACC00L, 0xC557, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("3A5ACC00-C557-11D0-8A2B-00A0C9255AC1", KSNODETYPE_VOLUME);
#define KSNODETYPE_VOLUME DEFINE_GUIDNAMED(KSNODETYPE_VOLUME)

#define STATIC_KSNODETYPE_TONE\
    0x7607E580L, 0xC557, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("7607E580-C557-11D0-8A2B-00A0C9255AC1", KSNODETYPE_TONE);
#define KSNODETYPE_TONE DEFINE_GUIDNAMED(KSNODETYPE_TONE)

#define STATIC_KSNODETYPE_EQUALIZER\
    0x9D41B4A0L, 0xC557, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("9D41B4A0-C557-11D0-8A2B-00A0C9255AC1", KSNODETYPE_EQUALIZER);
#define KSNODETYPE_EQUALIZER DEFINE_GUIDNAMED(KSNODETYPE_EQUALIZER)

#define STATIC_KSNODETYPE_AGC\
    0xE88C9BA0L, 0xC557, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("E88C9BA0-C557-11D0-8A2B-00A0C9255AC1", KSNODETYPE_AGC);
#define KSNODETYPE_AGC DEFINE_GUIDNAMED(KSNODETYPE_AGC)

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_NOISE_SUPPRESS\
    0xe07f903f, 0x62fd, 0x4e60, 0x8c, 0xdd, 0xde, 0xa7, 0x23, 0x66, 0x65, 0xb5
DEFINE_GUIDSTRUCT("E07F903F-62FD-4e60-8CDD-DEA7236665B5", KSNODETYPE_NOISE_SUPPRESS);
#define KSNODETYPE_NOISE_SUPPRESS DEFINE_GUIDNAMED(KSNODETYPE_NOISE_SUPPRESS)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_DELAY\
    0x144981E0L, 0xC558, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("144981E0-C558-11D0-8A2B-00A0C9255AC1", KSNODETYPE_DELAY);
#define KSNODETYPE_DELAY DEFINE_GUIDNAMED(KSNODETYPE_DELAY)

#define STATIC_KSNODETYPE_LOUDNESS\
    0x41887440L, 0xC558, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("41887440-C558-11D0-8A2B-00A0C9255AC1", KSNODETYPE_LOUDNESS);
#define KSNODETYPE_LOUDNESS DEFINE_GUIDNAMED(KSNODETYPE_LOUDNESS)

#define STATIC_KSNODETYPE_PROLOGIC_DECODER\
    0x831C2C80L, 0xC558, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("831C2C80-C558-11D0-8A2B-00A0C9255AC1", KSNODETYPE_PROLOGIC_DECODER);
#define KSNODETYPE_PROLOGIC_DECODER DEFINE_GUIDNAMED(KSNODETYPE_PROLOGIC_DECODER)

#define STATIC_KSNODETYPE_STEREO_WIDE\
    0xA9E69800L, 0xC558, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("A9E69800-C558-11D0-8A2B-00A0C9255AC1", KSNODETYPE_STEREO_WIDE);
#define KSNODETYPE_STEREO_WIDE DEFINE_GUIDNAMED(KSNODETYPE_STEREO_WIDE)

#define STATIC_KSNODETYPE_REVERB\
    0xEF0328E0L, 0xC558, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("EF0328E0-C558-11D0-8A2B-00A0C9255AC1", KSNODETYPE_REVERB);
#define KSNODETYPE_REVERB DEFINE_GUIDNAMED(KSNODETYPE_REVERB)

#define STATIC_KSNODETYPE_CHORUS\
    0x20173F20L, 0xC559, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("20173F20-C559-11D0-8A2B-00A0C9255AC1", KSNODETYPE_CHORUS);
#define KSNODETYPE_CHORUS DEFINE_GUIDNAMED(KSNODETYPE_CHORUS)

#define STATIC_KSNODETYPE_3D_EFFECTS\
    0x55515860L, 0xC559, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("55515860-C559-11D0-8A2B-00A0C9255AC1", KSNODETYPE_3D_EFFECTS);
#define KSNODETYPE_3D_EFFECTS DEFINE_GUIDNAMED(KSNODETYPE_3D_EFFECTS)

#define STATIC_KSNODETYPE_PARAMETRIC_EQUALIZER\
    0x19bb3a6a, 0xce2b, 0x4442, 0x87, 0xec, 0x67, 0x27, 0xc3, 0xca, 0xb4, 0x77
DEFINE_GUIDSTRUCT("19BB3A6A-CE2B-4442-87EC-6727C3CAB477", KSNODETYPE_PARAMETRIC_EQUALIZER);
#define KSNODETYPE_PARAMETRIC_EQUALIZER DEFINE_GUIDNAMED(KSNODETYPE_PARAMETRIC_EQUALIZER)

#define STATIC_KSNODETYPE_UPDOWN_MIX\
    0xb7edc5cf, 0x7b63, 0x4ee2, 0xa1, 0x0, 0x29, 0xee, 0x2c, 0xb6, 0xb2, 0xde
DEFINE_GUIDSTRUCT("B7EDC5CF-7B63-4ee2-A100-29EE2CB6B2DE", KSNODETYPE_UPDOWN_MIX);
#define KSNODETYPE_UPDOWN_MIX DEFINE_GUIDNAMED(KSNODETYPE_UPDOWN_MIX)

#define STATIC_KSNODETYPE_DYN_RANGE_COMPRESSOR\
    0x8c8a6a8, 0x601f, 0x4af8, 0x87, 0x93, 0xd9, 0x5, 0xff, 0x4c, 0xa9, 0x7d
DEFINE_GUIDSTRUCT("08C8A6A8-601F-4af8-8793-D905FF4CA97D", KSNODETYPE_DYN_RANGE_COMPRESSOR);
#define KSNODETYPE_DYN_RANGE_COMPRESSOR DEFINE_GUIDNAMED(KSNODETYPE_DYN_RANGE_COMPRESSOR)

#define STATIC_KSNODETYPE_ACOUSTIC_ECHO_CANCEL STATIC_KSCATEGORY_ACOUSTIC_ECHO_CANCEL
#define KSNODETYPE_ACOUSTIC_ECHO_CANCEL KSCATEGORY_ACOUSTIC_ECHO_CANCEL

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL\
    0x1c22c56dL, 0x9879, 0x4f5b, 0xa3, 0x89, 0x27, 0x99, 0x6d, 0xdc, 0x28, 0x10
DEFINE_GUIDSTRUCT("1C22C56D-9879-4f5b-A389-27996DDC2810", KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL);
#define KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL DEFINE_GUIDNAMED(KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL)

#define STATIC_KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS\
    0x5ab0882eL, 0x7274, 0x4516, 0x87, 0x7d, 0x4e, 0xee, 0x99, 0xba, 0x4f, 0xd0
DEFINE_GUIDSTRUCT("5AB0882E-7274-4516-877D-4EEE99BA4FD0", KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS);
#define KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS DEFINE_GUIDNAMED(KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS)

#define STATIC_KSALGORITHMINSTANCE_SYSTEM_AGC\
    0x950e55b9L, 0x877c, 0x4c67, 0xbe, 0x8, 0xe4, 0x7b, 0x56, 0x11, 0x13, 0xa
DEFINE_GUIDSTRUCT("950E55B9-877C-4c67-BE08-E47B5611130A", KSALGORITHMINSTANCE_SYSTEM_AGC);
#define KSALGORITHMINSTANCE_SYSTEM_AGC DEFINE_GUIDNAMED(KSALGORITHMINSTANCE_SYSTEM_AGC)

#define STATIC_KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR\
    0xB6F5A0A0L, 0x9E61, 0x4F8C, 0x91, 0xE3, 0x76, 0xCF, 0xF, 0x3C, 0x47, 0x1F
DEFINE_GUIDSTRUCT("B6F5A0A0-9E61-4f8c-91E3-76CF0F3C471F", KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR);
#define KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR DEFINE_GUIDNAMED(KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR)

#define STATIC_KSNODETYPE_MICROPHONE_ARRAY_PROCESSOR STATIC_KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR
#define KSNODETYPE_MICROPHONE_ARRAY_PROCESSOR KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_DEV_SPECIFIC\
    0x941C7AC0L, 0xC559, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1
DEFINE_GUIDSTRUCT("941C7AC0-C559-11D0-8A2B-00A0C9255AC1", KSNODETYPE_DEV_SPECIFIC);
#define KSNODETYPE_DEV_SPECIFIC DEFINE_GUIDNAMED(KSNODETYPE_DEV_SPECIFIC)

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSNODETYPE_PROLOGIC_ENCODER\
    0x8074C5B2L, 0x3C66, 0x11D2, 0xB4, 0x5A, 0x30, 0x78, 0x30, 0x2C, 0x20, 0x30
DEFINE_GUIDSTRUCT("8074C5B2-3C66-11D2-B45A-3078302C2030", KSNODETYPE_PROLOGIC_ENCODER);
#define KSNODETYPE_PROLOGIC_ENCODER DEFINE_GUIDNAMED(KSNODETYPE_PROLOGIC_ENCODER)
#define KSNODETYPE_SURROUND_ENCODER KSNODETYPE_PROLOGIC_ENCODER

#define STATIC_KSNODETYPE_PEAKMETER\
    0xa085651eL, 0x5f0d, 0x4b36, 0xa8, 0x69, 0xd1, 0x95, 0xd6, 0xab, 0x4b, 0x9e
DEFINE_GUIDSTRUCT("A085651E-5F0D-4b36-A869-D195D6AB4B9E", KSNODETYPE_PEAKMETER);
#define KSNODETYPE_PEAKMETER DEFINE_GUIDNAMED(KSNODETYPE_PEAKMETER)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#if (NTDDI_VERSION < NTDDI_WINXP)

#define STATIC_KSNODETYPE_SURROUND_ENCODER\
    0x8074C5B2L, 0x3C66, 0x11D2, 0xB4, 0x5A, 0x30, 0x78, 0x30, 0x2C, 0x20, 0x30
DEFINE_GUIDSTRUCT("8074C5B2-3C66-11D2-B45A-3078302C2030", KSNODETYPE_SURROUND_ENCODER);
#define KSNODETYPE_SURROUND_ENCODER DEFINE_GUIDNAMED(KSNODETYPE_SURROUND_ENCODER)

#endif // (NTDDI_VERSION < NTDDI_WINXP)

//===========================================================================
// Topology Node Name GUIDs for common audio nodes
#define STATIC_KSAUDFNAME_BASS\
    0x185FEDE0L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE0-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_BASS);
#define KSAUDFNAME_BASS DEFINE_GUIDNAMED(KSAUDFNAME_BASS)

#define STATIC_KSAUDFNAME_TREBLE\
    0x185FEDE1L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE1-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_TREBLE);
#define KSAUDFNAME_TREBLE DEFINE_GUIDNAMED(KSAUDFNAME_TREBLE)

#define STATIC_KSAUDFNAME_MIDRANGE\
    0xA2CBE478, 0xAE84, 0x49A1, 0x8B, 0x72, 0x4A, 0xD0, 0x9B, 0x78, 0xED, 0x34
DEFINE_GUIDSTRUCT("A2CBE478-AE84-49A1-8B72-4AD09B78ED34", KSAUDFNAME_MIDRANGE);
#define KSAUDFNAME_MIDRANGE DEFINE_GUIDNAMED(KSAUDFNAME_MIDRANGE)

#define STATIC_KSAUDFNAME_3D_STEREO\
    0x185FEDE2L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE2-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_3D_STEREO);
#define KSAUDFNAME_3D_STEREO DEFINE_GUIDNAMED(KSAUDFNAME_3D_STEREO)

#define STATIC_KSAUDFNAME_MASTER_VOLUME\
    0x185FEDE3L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE3-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MASTER_VOLUME);
#define KSAUDFNAME_MASTER_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MASTER_VOLUME)

#define STATIC_KSAUDFNAME_MASTER_MUTE\
    0x185FEDE4L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE4-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MASTER_MUTE);
#define KSAUDFNAME_MASTER_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_MASTER_MUTE)

#define STATIC_KSAUDFNAME_WAVE_VOLUME\
    0x185FEDE5L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE5-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_WAVE_VOLUME);
#define KSAUDFNAME_WAVE_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_WAVE_VOLUME)

#define STATIC_KSAUDFNAME_WAVE_MUTE\
    0x185FEDE6L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE6-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_WAVE_MUTE);
#define KSAUDFNAME_WAVE_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_WAVE_MUTE)

#define STATIC_KSAUDFNAME_MIDI_VOLUME\
    0x185FEDE7L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE7-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIDI_VOLUME);
#define KSAUDFNAME_MIDI_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MIDI_VOLUME)

#define STATIC_KSAUDFNAME_MIDI_MUTE\
    0x185FEDE8L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE8-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIDI_MUTE);
#define KSAUDFNAME_MIDI_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_MIDI_MUTE)

#define STATIC_KSAUDFNAME_CD_VOLUME\
    0x185FEDE9L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDE9-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_CD_VOLUME);
#define KSAUDFNAME_CD_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_CD_VOLUME)

#define STATIC_KSAUDFNAME_CD_MUTE\
    0x185FEDEAL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDEA-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_CD_MUTE);
#define KSAUDFNAME_CD_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_CD_MUTE)

#define STATIC_KSAUDFNAME_LINE_VOLUME\
    0x185FEDEBL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDEB-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_LINE_VOLUME);
#define KSAUDFNAME_LINE_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_LINE_VOLUME)

#define STATIC_KSAUDFNAME_LINE_MUTE\
    0x185FEDECL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDEC-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_LINE_MUTE);
#define KSAUDFNAME_LINE_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_LINE_MUTE)

#define STATIC_KSAUDFNAME_MIC_VOLUME\
    0x185FEDEDL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDED-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIC_VOLUME);
#define KSAUDFNAME_MIC_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MIC_VOLUME)

#define STATIC_KSAUDFNAME_MIC_MUTE\
    0x185FEDEEL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDEE-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIC_MUTE);
#define KSAUDFNAME_MIC_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_MIC_MUTE)

#define STATIC_KSAUDFNAME_RECORDING_SOURCE\
    0x185FEDEFL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDEF-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_RECORDING_SOURCE);
#define KSAUDFNAME_RECORDING_SOURCE DEFINE_GUIDNAMED(KSAUDFNAME_RECORDING_SOURCE)

#define STATIC_KSAUDFNAME_PC_SPEAKER_VOLUME\
    0x185FEDF0L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF0-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_PC_SPEAKER_VOLUME);
#define KSAUDFNAME_PC_SPEAKER_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_PC_SPEAKER_VOLUME)

#define STATIC_KSAUDFNAME_PC_SPEAKER_MUTE\
    0x185FEDF1L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF1-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_PC_SPEAKER_MUTE);
#define KSAUDFNAME_PC_SPEAKER_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_PC_SPEAKER_MUTE)

#define STATIC_KSAUDFNAME_MIDI_IN_VOLUME\
    0x185FEDF2L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF2-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIDI_IN_VOLUME);
#define KSAUDFNAME_MIDI_IN_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MIDI_IN_VOLUME)

#define STATIC_KSAUDFNAME_CD_IN_VOLUME\
    0x185FEDF3L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF3-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_CD_IN_VOLUME);
#define KSAUDFNAME_CD_IN_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_CD_IN_VOLUME)

#define STATIC_KSAUDFNAME_LINE_IN_VOLUME\
    0x185FEDF4L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF4-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_LINE_IN_VOLUME);
#define KSAUDFNAME_LINE_IN_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_LINE_IN_VOLUME)

#define STATIC_KSAUDFNAME_MIC_IN_VOLUME\
    0x185FEDF5L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF5-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIC_IN_VOLUME);
#define KSAUDFNAME_MIC_IN_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MIC_IN_VOLUME)

#define STATIC_KSAUDFNAME_WAVE_IN_VOLUME\
    0x185FEDF6L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF6-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_WAVE_IN_VOLUME);
#define KSAUDFNAME_WAVE_IN_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_WAVE_IN_VOLUME)

#define STATIC_KSAUDFNAME_VOLUME_CONTROL\
    0x185FEDF7L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF7-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_VOLUME_CONTROL);
#define KSAUDFNAME_VOLUME_CONTROL DEFINE_GUIDNAMED(KSAUDFNAME_VOLUME_CONTROL)

#define STATIC_KSAUDFNAME_MIDI\
    0x185FEDF8L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF8-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_MIDI);
#define KSAUDFNAME_MIDI DEFINE_GUIDNAMED(KSAUDFNAME_MIDI)

#define STATIC_KSAUDFNAME_LINE_IN\
    0x185FEDF9L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDF9-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_LINE_IN);
#define KSAUDFNAME_LINE_IN DEFINE_GUIDNAMED(KSAUDFNAME_LINE_IN)

#define STATIC_KSAUDFNAME_RECORDING_CONTROL\
    0x185FEDFAL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFA-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_RECORDING_CONTROL);
#define KSAUDFNAME_RECORDING_CONTROL DEFINE_GUIDNAMED(KSAUDFNAME_RECORDING_CONTROL)

#define STATIC_KSAUDFNAME_CD_AUDIO\
    0x185FEDFBL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFB-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_CD_AUDIO);
#define KSAUDFNAME_CD_AUDIO DEFINE_GUIDNAMED(KSAUDFNAME_CD_AUDIO)

#define STATIC_KSAUDFNAME_AUX_VOLUME\
    0x185FEDFCL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFC-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_AUX_VOLUME);
#define KSAUDFNAME_AUX_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_AUX_VOLUME)

#define STATIC_KSAUDFNAME_AUX_MUTE\
    0x185FEDFDL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFD-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_AUX_MUTE);
#define KSAUDFNAME_AUX_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_AUX_MUTE)

#define STATIC_KSAUDFNAME_AUX\
    0x185FEDFEL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFE-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_AUX);
#define KSAUDFNAME_AUX DEFINE_GUIDNAMED(KSAUDFNAME_AUX)

#define STATIC_KSAUDFNAME_PC_SPEAKER\
    0x185FEDFFL, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEDFF-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_PC_SPEAKER);
#define KSAUDFNAME_PC_SPEAKER DEFINE_GUIDNAMED(KSAUDFNAME_PC_SPEAKER)

#define STATIC_KSAUDFNAME_WAVE_OUT_MIX\
    0x185FEE00L, 0x9905, 0x11D1, 0x95, 0xA9, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("185FEE00-9905-11D1-95A9-00C04FB925D3", KSAUDFNAME_WAVE_OUT_MIX);
#define KSAUDFNAME_WAVE_OUT_MIX DEFINE_GUIDNAMED(KSAUDFNAME_WAVE_OUT_MIX)

#define STATIC_KSAUDFNAME_MONO_OUT\
    0xf9b41dc3L, 0x96e2, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("F9B41DC3-96E2-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_OUT);
#define KSAUDFNAME_MONO_OUT DEFINE_GUIDNAMED(KSAUDFNAME_MONO_OUT)

#define STATIC_KSAUDFNAME_STEREO_MIX\
    0xdff077L, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("00DFF077-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_STEREO_MIX);
#define KSAUDFNAME_STEREO_MIX DEFINE_GUIDNAMED(KSAUDFNAME_STEREO_MIX)

#define STATIC_KSAUDFNAME_MONO_MIX\
    0xdff078L, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("00DFF078-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_MIX);
#define KSAUDFNAME_MONO_MIX DEFINE_GUIDNAMED(KSAUDFNAME_MONO_MIX)

#define STATIC_KSAUDFNAME_MONO_OUT_VOLUME\
    0x1ad247ebL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("1AD247EB-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_OUT_VOLUME);
#define KSAUDFNAME_MONO_OUT_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MONO_OUT_VOLUME)

#define STATIC_KSAUDFNAME_MONO_OUT_MUTE\
    0x1ad247ecL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("1AD247EC-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_OUT_MUTE);
#define KSAUDFNAME_MONO_OUT_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_MONO_OUT_MUTE)

#define STATIC_KSAUDFNAME_STEREO_MIX_VOLUME\
    0x1ad247edL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("1AD247ED-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_STEREO_MIX_VOLUME);
#define KSAUDFNAME_STEREO_MIX_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_STEREO_MIX_VOLUME)

#define STATIC_KSAUDFNAME_STEREO_MIX_MUTE\
    0x22b0eafdL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("22B0EAFD-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_STEREO_MIX_MUTE);
#define KSAUDFNAME_STEREO_MIX_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_STEREO_MIX_MUTE)

#define STATIC_KSAUDFNAME_MONO_MIX_VOLUME\
    0x22b0eafeL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("22B0EAFE-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_MIX_VOLUME);
#define KSAUDFNAME_MONO_MIX_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_MONO_MIX_VOLUME)

#define STATIC_KSAUDFNAME_MONO_MIX_MUTE\
    0x2bc31d69L, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("2BC31D69-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MONO_MIX_MUTE);
#define KSAUDFNAME_MONO_MIX_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_MONO_MIX_MUTE)

#define STATIC_KSAUDFNAME_MICROPHONE_BOOST\
    0x2bc31d6aL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("2BC31D6A-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_MICROPHONE_BOOST);
#define KSAUDFNAME_MICROPHONE_BOOST DEFINE_GUIDNAMED(KSAUDFNAME_MICROPHONE_BOOST)

#define STATIC_KSAUDFNAME_ALTERNATE_MICROPHONE\
    0x2bc31d6bL, 0x96e3, 0x11d2, 0xac, 0x4c, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("2BC31D6B-96E3-11d2-AC4C-00C04F8EFB68", KSAUDFNAME_ALTERNATE_MICROPHONE);
#define KSAUDFNAME_ALTERNATE_MICROPHONE DEFINE_GUIDNAMED(KSAUDFNAME_ALTERNATE_MICROPHONE)

#define STATIC_KSAUDFNAME_3D_DEPTH\
    0x63ff5747L, 0x991f, 0x11d2, 0xac, 0x4d, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("63FF5747-991F-11d2-AC4D-00C04F8EFB68", KSAUDFNAME_3D_DEPTH);
#define KSAUDFNAME_3D_DEPTH DEFINE_GUIDNAMED(KSAUDFNAME_3D_DEPTH)

#define STATIC_KSAUDFNAME_3D_CENTER\
    0x9f0670b4L, 0x991f, 0x11d2, 0xac, 0x4d, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("9F0670B4-991F-11d2-AC4D-00C04F8EFB68", KSAUDFNAME_3D_CENTER);
#define KSAUDFNAME_3D_CENTER DEFINE_GUIDNAMED(KSAUDFNAME_3D_CENTER)

#define STATIC_KSAUDFNAME_VIDEO_VOLUME\
    0x9b46e708L, 0x992a, 0x11d2, 0xac, 0x4d, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("9B46E708-992A-11d2-AC4D-00C04F8EFB68", KSAUDFNAME_VIDEO_VOLUME);
#define KSAUDFNAME_VIDEO_VOLUME DEFINE_GUIDNAMED(KSAUDFNAME_VIDEO_VOLUME)

#define STATIC_KSAUDFNAME_VIDEO_MUTE\
    0x9b46e709L, 0x992a, 0x11d2, 0xac, 0x4d, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("9B46E709-992A-11d2-AC4D-00C04F8EFB68", KSAUDFNAME_VIDEO_MUTE);
#define KSAUDFNAME_VIDEO_MUTE DEFINE_GUIDNAMED(KSAUDFNAME_VIDEO_MUTE)

#define STATIC_KSAUDFNAME_VIDEO\
    0x915daec4L, 0xa434, 0x11d2, 0xac, 0x52, 0x0, 0xc0, 0x4f, 0x8e, 0xfb, 0x68
DEFINE_GUIDSTRUCT("915DAEC4-A434-11d2-AC52-00C04F8EFB68", KSAUDFNAME_VIDEO);
#define KSAUDFNAME_VIDEO DEFINE_GUIDNAMED(KSAUDFNAME_VIDEO)

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_KSAUDFNAME_PEAKMETER\
    0x57e24340L, 0xfc5b, 0x4612, 0xa5, 0x62, 0x72, 0xb1, 0x1a, 0x29, 0xdf, 0xae
DEFINE_GUIDSTRUCT("57E24340-FC5B-4612-A562-72B11A29DFAE", KSAUDFNAME_PEAKMETER);
#define KSAUDFNAME_PEAKMETER DEFINE_GUIDNAMED(KSAUDFNAME_PEAKMETER)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)


// Internal topology node pin definitions

#define KSNODEPIN_STANDARD_IN       1
#define KSNODEPIN_STANDARD_OUT      0

#define KSNODEPIN_SUM_MUX_IN        1   // can be >= 1
#define KSNODEPIN_SUM_MUX_OUT       0

#define KSNODEPIN_DEMUX_IN          0
#define KSNODEPIN_DEMUX_OUT         1   // can be >= 1

#if (NTDDI_VERSION < NTDDI_VISTA)

#define KSNODEPIN_AEC_RENDER_IN     1
#define KSNODEPIN_AEC_RENDER_OUT    0
#define KSNODEPIN_AEC_CAPTURE_IN    2
#define KSNODEPIN_AEC_CAPTURE_OUT   3

#endif // (NTDDI_VERSION < NTDDI_VISTA)

//===========================================================================
//===========================================================================

#define STATIC_KSMETHODSETID_Wavetable\
    0xDCEF31EBL, 0xD907, 0x11D0, 0x95, 0x83, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("DCEF31EB-D907-11D0-9583-00C04FB925D3", KSMETHODSETID_Wavetable);
#define KSMETHODSETID_Wavetable DEFINE_GUIDNAMED(KSMETHODSETID_Wavetable)

typedef enum {
    KSMETHOD_WAVETABLE_WAVE_ALLOC,
    KSMETHOD_WAVETABLE_WAVE_FREE,
    KSMETHOD_WAVETABLE_WAVE_FIND,
    KSMETHOD_WAVETABLE_WAVE_WRITE
} KSMETHOD_WAVETABLE;

typedef struct {
    KSIDENTIFIER        Identifier;                     // wave identifier
    ULONG               Size;                           // wave size
    BOOL                Looped;                         // wave looped flag
    ULONG               LoopPoint;                      // wave loop point
    BOOL                InROM;                          // wave InROM flag
    KSDATAFORMAT        Format;                         // wave format
} KSWAVETABLE_WAVE_DESC, *PKSWAVETABLE_WAVE_DESC;


//===========================================================================
//===========================================================================

/*
    Property sets and items
*/

//===========================================================================
//===========================================================================

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)
#define STATIC_KSPROPSETID_Acoustic_Echo_Cancel\
    0xd7a4af8bL, 0x3dc1, 0x4902, 0x91, 0xea, 0x8a, 0x15, 0xc9, 0x0e, 0x05, 0xb2
DEFINE_GUIDSTRUCT("D7A4AF8B-3DC1-4902-91EA-8A15C90E05B2", KSPROPSETID_Acoustic_Echo_Cancel);
#define KSPROPSETID_Acoustic_Echo_Cancel DEFINE_GUIDNAMED(KSPROPSETID_Acoustic_Echo_Cancel)

typedef enum {
    KSPROPERTY_AEC_NOISE_FILL_ENABLE = 0,
    KSPROPERTY_AEC_STATUS,
    KSPROPERTY_AEC_MODE
} KSPROPERTY_AEC;

#define AEC_STATUS_FD_HISTORY_UNINITIALIZED             0x0
#define AEC_STATUS_FD_HISTORY_CONTINUOUSLY_CONVERGED    0x1
#define AEC_STATUS_FD_HISTORY_PREVIOUSLY_DIVERGED       0x2
#define AEC_STATUS_FD_CURRENTLY_CONVERGED               0x8

#define AEC_MODE_PASS_THROUGH           0x0
#define AEC_MODE_HALF_DUPLEX            0x1
#define AEC_MODE_FULL_DUPLEX            0x2

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

//===========================================================================
//===========================================================================
#if (NTDDI_VERSION < NTDDI_WS03)

#define STATIC_KSPROPSETID_Wave_Queued\
    0x16a15b10L, 0x16f0, 0x11d0, 0xa1, 0x95, 0x00, 0x20, 0xaf, 0xd1, 0x56, 0xe4
DEFINE_GUIDSTRUCT("16a15b10-16f0-11d0-a195-0020afd156e4", KSPROPSETID_Wave_Queued);
#define KSPROPSETID_Wave_Queued DEFINE_GUIDNAMED(KSPROPSETID_Wave_Queued)

#define KSPROPERTY_WAVE_QUEUED_POSITION                 0x00000001

#define STATIC_KSMETHODSETID_Wave_Queued\
    0x7432c160L, 0x8827, 0x11cf, 0xa1, 0x02, 0x00, 0x20, 0xaf, 0xd1, 0x56, 0xe4
DEFINE_GUIDSTRUCT("7432c160-8827-11cf-a102-0020afd156e4", KSMETHODSETID_Wave_Queued);
#define KSMETHODSETID_Wave_Queued DEFINE_GUIDNAMED(KSMETHODSETID_Wave_Queued)

#define KSMETHOD_WAVE_QUEUED_BREAKLOOP                  0x00000001

#endif // (NTDDI_VERSION < NTDDI_WS03)


#define STATIC_KSPROPSETID_Wave\
    0x924e54b0L, 0x630f, 0x11cf, 0xad, 0xa7, 0x08, 0x00, 0x3e, 0x30, 0x49, 0x4a
DEFINE_GUIDSTRUCT("924e54b0-630f-11cf-ada7-08003e30494a", KSPROPSETID_Wave);
#define KSPROPSETID_Wave DEFINE_GUIDNAMED(KSPROPSETID_Wave)

typedef enum {
    KSPROPERTY_WAVE_COMPATIBLE_CAPABILITIES,
    KSPROPERTY_WAVE_INPUT_CAPABILITIES,
    KSPROPERTY_WAVE_OUTPUT_CAPABILITIES,
    KSPROPERTY_WAVE_BUFFER,
    KSPROPERTY_WAVE_FREQUENCY,
    KSPROPERTY_WAVE_VOLUME,
    KSPROPERTY_WAVE_PAN
} KSPROPERTY_WAVE;

typedef struct {
    ULONG        ulDeviceType;
} KSWAVE_COMPATCAPS, *PKSWAVE_COMPATCAPS;

#define KSWAVE_COMPATCAPS_INPUT                 0x00000000
#define KSWAVE_COMPATCAPS_OUTPUT                0x00000001

typedef struct {
    ULONG  MaximumChannelsPerConnection;
    ULONG  MinimumBitsPerSample;
    ULONG  MaximumBitsPerSample;
    ULONG  MinimumSampleFrequency;
    ULONG  MaximumSampleFrequency;
    ULONG  TotalConnections;
    ULONG  ActiveConnections;
} KSWAVE_INPUT_CAPABILITIES, *PKSWAVE_INPUT_CAPABILITIES;

typedef struct {
    ULONG  MaximumChannelsPerConnection;
    ULONG  MinimumBitsPerSample;
    ULONG  MaximumBitsPerSample;
    ULONG  MinimumSampleFrequency;
    ULONG  MaximumSampleFrequency;
    ULONG  TotalConnections;
    ULONG  StaticConnections;
    ULONG  StreamingConnections;
    ULONG  ActiveConnections;
    ULONG  ActiveStaticConnections;
    ULONG  ActiveStreamingConnections;
    ULONG  Total3DConnections;
    ULONG  Static3DConnections;
    ULONG  Streaming3DConnections;
    ULONG  Active3DConnections;
    ULONG  ActiveStatic3DConnections;
    ULONG  ActiveStreaming3DConnections;
    ULONG  TotalSampleMemory;
    ULONG  FreeSampleMemory;
    ULONG  LargestFreeContiguousSampleMemory;
} KSWAVE_OUTPUT_CAPABILITIES, *PKSWAVE_OUTPUT_CAPABILITIES;

typedef struct {
    LONG  LeftAttenuation;
    LONG  RightAttenuation;
} KSWAVE_VOLUME, *PKSWAVE_VOLUME;

#define KSWAVE_BUFFER_ATTRIBUTEF_LOOPING   0x00000001
#define KSWAVE_BUFFER_ATTRIBUTEF_STATIC    0x00000002

typedef struct {
    ULONG   Attributes;
    ULONG   BufferSize;
    PVOID   BufferAddress;
} KSWAVE_BUFFER, *PKSWAVE_BUFFER;

//===========================================================================
//===========================================================================

#define STATIC_KSMUSIC_TECHNOLOGY_PORT\
    0x86C92E60L, 0x62E8, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("86C92E60-62E8-11CF-A5D6-28DB04C10000", KSMUSIC_TECHNOLOGY_PORT);
#define KSMUSIC_TECHNOLOGY_PORT DEFINE_GUIDNAMED(KSMUSIC_TECHNOLOGY_PORT)

#define STATIC_KSMUSIC_TECHNOLOGY_SQSYNTH\
    0x0ECF4380L, 0x62E9, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("0ECF4380-62E9-11CF-A5D6-28DB04C10000", KSMUSIC_TECHNOLOGY_SQSYNTH);
#define KSMUSIC_TECHNOLOGY_SQSYNTH DEFINE_GUIDNAMED(KSMUSIC_TECHNOLOGY_SQSYNTH)

#define STATIC_KSMUSIC_TECHNOLOGY_FMSYNTH\
    0x252C5C80L, 0x62E9, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("252C5C80-62E9-11CF-A5D6-28DB04C10000", KSMUSIC_TECHNOLOGY_FMSYNTH);
#define KSMUSIC_TECHNOLOGY_FMSYNTH DEFINE_GUIDNAMED(KSMUSIC_TECHNOLOGY_FMSYNTH)

#define STATIC_KSMUSIC_TECHNOLOGY_WAVETABLE\
    0x394EC7C0L, 0x62E9, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("394EC7C0-62E9-11CF-A5D6-28DB04C10000", KSMUSIC_TECHNOLOGY_WAVETABLE);
#define KSMUSIC_TECHNOLOGY_WAVETABLE DEFINE_GUIDNAMED(KSMUSIC_TECHNOLOGY_WAVETABLE)

#define STATIC_KSMUSIC_TECHNOLOGY_SWSYNTH\
    0x37407736L, 0x3620, 0x11D1, 0x85, 0xD3, 0x00, 0x00, 0xF8, 0x75, 0x43, 0x80
DEFINE_GUIDSTRUCT("37407736-3620-11D1-85D3-0000F8754380", KSMUSIC_TECHNOLOGY_SWSYNTH);
#define KSMUSIC_TECHNOLOGY_SWSYNTH DEFINE_GUIDNAMED(KSMUSIC_TECHNOLOGY_SWSYNTH)

#if (NTDDI_VERSION < NTDDI_WS03)

#define STATIC_KSPROPSETID_WaveTable\
    0x8539E660L, 0x62E9, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("8539E660-62E9-11CF-A5D6-28DB04C10000", KSPROPSETID_WaveTable);
#define KSPROPSETID_WaveTable DEFINE_GUIDNAMED(KSPROPSETID_WaveTable)

typedef enum {
    KSPROPERTY_WAVETABLE_LOAD_SAMPLE,
    KSPROPERTY_WAVETABLE_UNLOAD_SAMPLE,
    KSPROPERTY_WAVETABLE_MEMORY,
    KSPROPERTY_WAVETABLE_VERSION
} KSPROPERTY_WAVETABLE;

#endif // (NTDDI_VERSION < NTDDI_WS03)

typedef struct {
   KSDATARANGE              DataRange;
   GUID                     Technology;
   ULONG                    Channels;
   ULONG                    Notes;
   ULONG                    ChannelMask;
} KSDATARANGE_MUSIC, *PKSDATARANGE_MUSIC;

//===========================================================================

#if (NTDDI_VERSION < NTDDI_WS03)

#define STATIC_KSEVENTSETID_Cyclic\
    0x142C1AC0L, 0x072A, 0x11D0, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("142C1AC0-072A-11D0-A5D6-28DB04C10000", KSEVENTSETID_Cyclic);
#define KSEVENTSETID_Cyclic DEFINE_GUIDNAMED(KSEVENTSETID_Cyclic)

typedef enum {
    KSEVENT_CYCLIC_TIME_INTERVAL,
} KSEVENT_CYCLIC_TIME;

#endif // (NTDDI_VERSION < NTDDI_WS03)

#define STATIC_KSPROPSETID_Cyclic\
    0x3FFEAEA0L, 0x2BEE, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("3FFEAEA0-2BEE-11CF-A5D6-28DB04C10000", KSPROPSETID_Cyclic);
#define KSPROPSETID_Cyclic DEFINE_GUIDNAMED(KSPROPSETID_Cyclic)

typedef enum {
    KSPROPERTY_CYCLIC_POSITION,
} KSPROPERTY_CYCLIC;

//===========================================================================
#define STATIC_KSEVENTSETID_AudioControlChange\
    0xE85E9698L, 0xFA2F, 0x11D1, 0x95, 0xBD, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0xD3
DEFINE_GUIDSTRUCT("E85E9698-FA2F-11D1-95BD-00C04FB925D3", KSEVENTSETID_AudioControlChange);
#define KSEVENTSETID_AudioControlChange DEFINE_GUIDNAMED(KSEVENTSETID_AudioControlChange)

typedef enum {
    KSEVENT_CONTROL_CHANGE,
} KSEVENT_AUDIO_CONTROL_CHANGE;

//===========================================================================

#define STATIC_KSEVENTSETID_LoopedStreaming\
    0x4682B940L, 0xC6EF, 0x11D0, 0x96, 0xD8, 0x00, 0xAA, 0x00, 0x51, 0xE5, 0x1D
DEFINE_GUIDSTRUCT("4682B940-C6EF-11D0-96D8-00AA0051E51D", KSEVENTSETID_LoopedStreaming);
#define KSEVENTSETID_LoopedStreaming DEFINE_GUIDNAMED(KSEVENTSETID_LoopedStreaming)

typedef enum {
    KSEVENT_LOOPEDSTREAMING_POSITION,
} KSEVENT_LOOPEDSTREAMING;

typedef struct {
    KSEVENTDATA KsEventData;
#if defined(_NTDDK_)
    ULONGLONG   Position;
#else // !_NTDDK_
    DWORDLONG   Position;
#endif // !_NTDDK_
} LOOPEDSTREAMING_POSITION_EVENT_DATA, *PLOOPEDSTREAMING_POSITION_EVENT_DATA ;

#if (NTDDI_VERSION <= NTDDI_WINXP)

#define STATIC_KSEVENTSETID_Sysaudio \
    0x04800320L, 0x4491, 0x11D1, 0xA0, 0x50, 0x40, 0x57, 0x05, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("04800320-4491-11D1-A050-405705C10000", KSEVENTSETID_Sysaudio);
#define KSEVENTSETID_Sysaudio DEFINE_GUIDNAMED(KSEVENTSETID_Sysaudio)

typedef enum {
    KSEVENT_SYSAUDIO_ADDREMOVE_DEVICE
#if (NTDDI_VERSION == NTDDI_WINXP)
    , KSEVENT_SYSAUDIO_CHANGE_DEVICE
#endif
} KSEVENT_SYSAUDIO;

#endif // (NTDDI_VERSION <= NTDDI_WINXP)


#if (NTDDI_VERSION < NTDDI_VISTA)

//===========================================================================
#define STATIC_KSPROPSETID_Sysaudio\
    0xCBE3FAA0L, 0xCC75, 0x11D0, 0xB4, 0x65, 0x00, 0x00, 0x1A, 0x18, 0x18, 0xE6
DEFINE_GUIDSTRUCT("CBE3FAA0-CC75-11D0-B465-00001A1818E6", KSPROPSETID_Sysaudio);
#define KSPROPSETID_Sysaudio DEFINE_GUIDNAMED(KSPROPSETID_Sysaudio)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

typedef enum {
    KSPROPERTY_SYSAUDIO_DEVICE_COUNT = 1,
    KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME = 2,
    KSPROPERTY_SYSAUDIO_DEVICE_INSTANCE = 3,
    KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME = 4,
    KSPROPERTY_SYSAUDIO_SELECT_GRAPH = 5,
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE = 6,
    KSPROPERTY_SYSAUDIO_DEVICE_DEFAULT = 7,
    KSPROPERTY_SYSAUDIO_INSTANCE_INFO = 14,
    KSPROPERTY_SYSAUDIO_COMPONENT_ID = 16,
} KSPROPERTY_SYSAUDIO;

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION < NTDDI_WINXP)

typedef enum {
    KSPROPERTY_SYSAUDIO_DEVICE_COUNT = 1,
    KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME,
    KSPROPERTY_SYSAUDIO_DEVICE_INSTANCE,
    KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME,
    KSPROPERTY_SYSAUDIO_SELECT_GRAPH,
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE,
    KSPROPERTY_SYSAUDIO_DEVICE_DEFAULT,
    KSPROPERTY_SYSAUDIO_ALWAYS_CREATE_VIRTUAL_SOURCE,
    KSPROPERTY_SYSAUDIO_ADDREMOVE_LOCK,
    KSPROPERTY_SYSAUDIO_ADDREMOVE_UNLOCK,
    KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES,
    KSPROPERTY_SYSAUDIO_RENDER_CONNECTION_INDEX,
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_ONLY,
    KSPROPERTY_SYSAUDIO_INSTANCE_INFO,
    KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE
} KSPROPERTY_SYSAUDIO;

#endif // (NTDDI_VERSION < NTDDI_WINXP)

#if (NTDDI_VERSION < NTDDI_VISTA)

typedef struct {
    KSPROPERTY Property;
    GUID PinCategory;
    GUID PinName;
} SYSAUDIO_CREATE_VIRTUAL_SOURCE, *PSYSAUDIO_CREATE_VIRTUAL_SOURCE;

#endif // (NTDDI_VERSION < NTDDI_VISTA)


#if (NTDDI_VERSION < NTDDI_VISTA)

typedef struct {
    KSPROPERTY Property;
    ULONG PinId;
    ULONG NodeId;
    ULONG Flags;
    ULONG Reserved;
} SYSAUDIO_SELECT_GRAPH, *PSYSAUDIO_SELECT_GRAPH;

typedef struct {
    KSPROPERTY Property;
    ULONG Flags;
    ULONG DeviceNumber;
} SYSAUDIO_INSTANCE_INFO, *PSYSAUDIO_INSTANCE_INFO;

#define SYSAUDIO_FLAGS_DONT_COMBINE_PINS        0x00000001

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION < NTDDI_WINXP)
typedef struct {
    KSPROPERTY Property;
    ULONG Flags;
    ULONG Index;            // KSPROPERTY_SYSAUDIO_DEFAULT_TYPE
} SYSAUDIO_PREFERRED_DEVICE, *PSYSAUDIO_PREFERRED_DEVICE;

#define SYSAUDIO_FLAGS_CLEAR_PREFERRED          0x00000002
#endif // (NTDDI_VERSION < NTDDI_WINXP)

#if (NTDDI_VERSION < NTDDI_VISTA)


#define STATIC_KSPROPSETID_Sysaudio_Pin \
    0xA3A53220L, 0xC6E4, 0x11D0, 0xB4, 0x65, 0x00, 0x00, 0x1A, 0x18, 0x18, 0xE6
DEFINE_GUIDSTRUCT("A3A53220-C6E4-11D0-B465-00001A1818E6", KSPROPSETID_Sysaudio_Pin);
#define KSPROPSETID_Sysaudio_Pin DEFINE_GUIDNAMED(KSPROPSETID_Sysaudio_Pin)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

typedef enum {
    KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE = 1,
} KSPROPERTY_SYSAUDIO_PIN;

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

#if (NTDDI_VERSION < NTDDI_WINXP)

typedef enum {
    KSPROPERTY_SYSAUDIO_TOPOLOGY_CONNECTION_INDEX,
    KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE,
    KSPROPERTY_SYSAUDIO_PIN_VOLUME_NODE
} KSPROPERTY_SYSAUDIO_PIN;

#endif // (NTDDI_VERSION < NTDDI_WINXP)

#if (NTDDI_VERSION < NTDDI_VISTA)

typedef struct {
    KSPROPERTY  Property;
    ULONG       MixerPinId;
    ULONG       Reserved;
} SYSAUDIO_ATTACH_VIRTUAL_SOURCE, *PSYSAUDIO_ATTACH_VIRTUAL_SOURCE;

#endif // (NTDDI_VERSION < NTDDI_VISTA)

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion
//===========================================================================

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

typedef struct {
    KSPROPERTY  Property;
    ULONG       NodeId;
    ULONG       Reserved;
} KSNODEPROPERTY, *PKSNODEPROPERTY;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

typedef struct {
    KSNODEPROPERTY NodeProperty;
    LONG           Channel;                   // value to get or set
    ULONG          Reserved;
} KSNODEPROPERTY_AUDIO_CHANNEL, *PKSNODEPROPERTY_AUDIO_CHANNEL;

typedef struct {
    KSNODEPROPERTY NodeProperty;
    ULONG   DevSpecificId;
    ULONG   DeviceInfo;
    ULONG   Length;
} KSNODEPROPERTY_AUDIO_DEV_SPECIFIC, *PKSNODEPROPERTY_AUDIO_DEV_SPECIFIC;

typedef struct {
    KSNODEPROPERTY   NodeProperty;
    PVOID            ListenerId;
#ifndef _WIN64
    ULONG            Reserved;
#endif // _WIN64
} KSNODEPROPERTY_AUDIO_3D_LISTENER, *PKSNODEPROPERTY_AUDIO_3D_LISTENER;

typedef struct {
    KSNODEPROPERTY   NodeProperty;
    PVOID            AppContext;
    ULONG            Length;
#ifndef _WIN64
    ULONG            Reserved;
#endif // _WIN64
} KSNODEPROPERTY_AUDIO_PROPERTY, *PKSNODEPROPERTY_AUDIO_PROPERTY;

#if (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

//===========================================================================
// {79A9312E-59AE-43b0-A350-8B05284CAB24}
#define STATIC_KSPROPSETID_AudioGfx\
    0x79a9312eL, 0x59ae, 0x43b0, 0xa3, 0x50, 0x8b, 0x5, 0x28, 0x4c, 0xab, 0x24
DEFINE_GUIDSTRUCT("79A9312E-59AE-43b0-A350-8B05284CAB24", KSPROPSETID_AudioGfx);
#define KSPROPSETID_AudioGfx DEFINE_GUIDNAMED(KSPROPSETID_AudioGfx)

typedef enum {
    KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID,
    KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID
} KSPROPERTY_AUDIOGFX;

#endif // (NTDDI_VERSION >= NTDDI_WINXP && NTDDI_VERSION < NTDDI_VISTA)

//===========================================================================

#if (NTDDI_VERSION < NTDDI_WS03)

#define STATIC_KSPROPSETID_Linear\
    0x5A2FFE80L, 0x16B9, 0x11D0, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("5A2FFE80-16B9-11D0-A5D6-28DB04C10000", KSPROPSETID_Linear);
#define KSPROPSETID_Linear DEFINE_GUIDNAMED(KSPROPSETID_Linear)

typedef enum {
    KSPROPERTY_LINEAR_POSITION,
} KSPROPERTY_LINEAR;

#endif // (NTDDI_VERSION < NTDDI_WS03)

//===========================================================================


//
// Midi definitions
//

/*
    Formats
*/

#define STATIC_KSDATAFORMAT_TYPE_MUSIC\
    0xE725D360L, 0x62CC, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("E725D360-62CC-11CF-A5D6-28DB04C10000", KSDATAFORMAT_TYPE_MUSIC);
#define KSDATAFORMAT_TYPE_MUSIC DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_MUSIC)

// 'mids' == MEDIATYPE_Midi
#define STATIC_KSDATAFORMAT_TYPE_MIDI\
    0x7364696DL, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("7364696D-0000-0010-8000-00aa00389b71", KSDATAFORMAT_TYPE_MIDI);
#define KSDATAFORMAT_TYPE_MIDI DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_MIDI)

#define STATIC_KSDATAFORMAT_SUBTYPE_MIDI\
    0x1D262760L, 0xE957, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("1D262760-E957-11CF-A5D6-28DB04C10000", KSDATAFORMAT_SUBTYPE_MIDI);
#define KSDATAFORMAT_SUBTYPE_MIDI DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MIDI)

#define STATIC_KSDATAFORMAT_SUBTYPE_MIDI_BUS\
    0x2CA15FA0L, 0x6CFE, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00
DEFINE_GUIDSTRUCT("2CA15FA0-6CFE-11CF-A5D6-28DB04C10000", KSDATAFORMAT_SUBTYPE_MIDI_BUS);
#define KSDATAFORMAT_SUBTYPE_MIDI_BUS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MIDI_BUS)

#define STATIC_KSDATAFORMAT_SUBTYPE_RIFFMIDI\
    0x4995DAF0L, 0x9EE6, 0x11D0, 0xA4, 0x0E, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("4995DAF0-9EE6-11D0-A40E-00A0C9223196", KSDATAFORMAT_SUBTYPE_RIFFMIDI);
#define KSDATAFORMAT_SUBTYPE_RIFFMIDI DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_RIFFMIDI)

/*
    KSDATAFORMAT_SUBTYPE_DIRECTMUSIC
    see DMusicKS.h
*/

// WARNING! This structure MUST be dword aligned
// regardless of the number of data bytes.

typedef struct {
    ULONG   TimeDeltaMs;        // Delta Milliseconds from the previous midiformat
                                // in the packet. The first midiformat in the packet
                                // is a delta from the PTS in the KSSTREAM_HEADER.
    ULONG   ByteCount;          // Number of bytes of data that follow this struct.
} KSMUSICFORMAT, *PKSMUSICFORMAT;

//
// This entire set of MPEG Standard/Dialect Guids are obsolete. Do not use them.
//
//====================================================================================================
//====================================================================================================
// The following official MPEG Formats, Subtypes and Specifiers are listed as required or optional
// These official MPEG GUIDs are the preferred method of supporting MPEG/AC-3 media types in new code.
// Older MPEG GUIDs should also be supported for compatibilty, but these new modes are still required.
//====================================================================================================
//====================================================================================================

/*
This is a summary of what media types/specifiers will be required for all DVD+DSS+DVB+DTV MPEG decoders.
These media types are what the decoder driver must accept, hardware support for all of these media types
may or may not actually be provided by the decoder natively.  These media types are intended to define
the "officially" supported MPEG/AC-3 media types that all WHQL certified decoders must implement.  This
specifically includes driver and/or hardware support for all the required standards and dialects.

All MPEG video decoders must support all of the MPEG video modes shown as [required] below.
All MPEG audio decoders must support all of the MPEG audio modes shown as [required] below.
All AC-3 audio decoders must support all of the AC-3 audio modes shown as [required] below.
The line items shown as [optional] need not be implemented, but are possible formats that might be implemented.

Note that the input/output pin formats are defined by 2 or 3 GUIDs: TYPE, SUBTYPE, and maybe SPECIFIER.
The specifiers are included if the data format is a "dialect" that needs to be differentiated during decoding.
The decoder MUST be prepared to deal with ALL requests for _required_ "Standard" formats OR _required_ "Dialects".

STATIC_KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM         [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]
STATIC_KSDATAFORMAT_TYPE_STANDARD_PES_PACKET                [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO            [optional]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO            [optional]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]
STATIC_KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER               [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]

Note that the SPECIFIER GUIDs normally identify particular versions of MPEG such as DSS and DVD.
This approach was taken to minimize the number of DSS/DVB/DVD/DTV etc. media SUBTYPES.
These specifiers are currently required to disambiguate MPEG syntax _parsing_ by the decoder
using alternate parsing routines or downloadable firmware or hardware decode settings.

In the future these specifiers will be extended to cover new KS MPEG flavors such as DVB and DTV.
Thus, the optional specifiers will be subject to clarification and/or definition as they are needed.

Important note: Per the ITU MPEG specs, MPEG 2 media may contain pure MPEG 1 syntax and
any "MPEG 2" PES packets may actually contain MPEG 1 payloads and MPEG 1 syntax.  Some MPEG
broadcasts can revert from MPEG2 to MPEG1 format data at their discretion, without warning.

CAUTION: Decoders MUST attempt to process MPEG data AS SOON AS POSSIBLE after reception.
In particular, elementary MPEG or MPEG PES packet streams should not be aggregated into DVD
"pack headers" internally before submission to the codec hardware if AT ALL POSSIBLE.  The
reason is that mpeg data may need to be processed immediately but there may be no additional
MPEG data forthcoming to fill up the PES packet OR DVD "pack" in a timely fashion.  This is
particularly true of MPEG dialects that utilize "repeat field signally" to reuse the last
decoded MPEG video field.

*/

/////////////////////////////////////////////////////////////////////////
// The major data type GUIDs that define the data packet encapsulation //
/////////////////////////////////////////////////////////////////////////

// STATIC_KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM
#define STATIC_KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM \
    0x36523b11L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B11-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM );
#define KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM)

// STATIC_KSDATAFORMAT_TYPE_STANDARD_PES_PACKET
#define STATIC_KSDATAFORMAT_TYPE_STANDARD_PES_PACKET \
    0x36523b12L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B12-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_TYPE_STANDARD_PES_PACKET );
#define KSDATAFORMAT_TYPE_STANDARD_PES_PACKET DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_STANDARD_PES_PACKET)

// STATIC_KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER
#define STATIC_KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER \
    0x36523b13L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B13-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER );
#define KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER)

///////////////////////////////////////////////////////////////////////////////
// The minor data subtype GUIDs that define the exact class of the data type.//
///////////////////////////////////////////////////////////////////////////////

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO
#define STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO \
    0x36523b21L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B21-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO );
#define KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO)

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO
#define STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO \
    0x36523b22L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B22-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO );
#define KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO)

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO
#define STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO \
    0x36523b23L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B23-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO );
#define KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO)

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO
#define STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO \
    0x36523b24L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B24-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO );
#define KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO)

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO
#define STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO \
    0x36523b25L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B25-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO );
#define KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO)

///////////////////////////////////////////////////////////////////////////////
// The low-level specifier GUIDs that define the flavor of the data subtype. //
// Some SUBTYPES, notably MPEG2_VIDEO, MPEG2_AUDIO have different dialects.  //
// These specifiers are intended to be accompanied by a specifier structure. //
///////////////////////////////////////////////////////////////////////////////

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO
#define STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO \
    0x36523b31L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B31-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO );
#define KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO)

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO
#define STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO \
    0x36523b32L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B32-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO );
#define KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO)

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO    Associated with KS_MPEGVIDEOINFO2 defined later
#define STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO \
    0x36523b33L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B33-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO );
#define KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO)

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO    Associated with KS_MPEGAUDIOINFO defined later
#define STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO \
    0x36523b34L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B34-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO );
#define KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO)

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO
#define STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO \
    0x36523b35L, 0x8ee5, 0x11d1, 0x8c, 0xa3, 0x00, 0x60, 0xb0, 0x57, 0x66, 0x4a
DEFINE_GUIDSTRUCT("36523B35-8EE5-11d1-8CA3-0060B057664A", KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO );
#define KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO)

//====================================================================================================
//====================================================================================================
//                              *** COMPATIBILITY WARNING ***
// The *following* older DSS, MPEG, DVD & AC-3 GUID definitions are retained for backward compability.
// These MPEG GUIDs should also be supported for compatibilty, but the above newer modes are still required.
//====================================================================================================
//====================================================================================================

//
// DSS definitions
//

#define STATIC_KSDATAFORMAT_SUBTYPE_DSS_VIDEO\
    0xa0af4f81L, 0xe163, 0x11d0, 0xba, 0xd9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("a0af4f81-e163-11d0-bad9-00609744111a", KSDATAFORMAT_SUBTYPE_DSS_VIDEO);
#define KSDATAFORMAT_SUBTYPE_DSS_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_DSS_VIDEO)

#define STATIC_KSDATAFORMAT_SUBTYPE_DSS_AUDIO\
    0xa0af4f82L, 0xe163, 0x11d0, 0xba, 0xd9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("a0af4f82-e163-11d0-bad9-00609744111a", KSDATAFORMAT_SUBTYPE_DSS_AUDIO);
#define KSDATAFORMAT_SUBTYPE_DSS_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_DSS_AUDIO)

//
// End of obsolete MPEG definitions.
//

//
// mpeg 1 definitions
//
#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG1Packet\
    0xe436eb80, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70
DEFINE_GUIDSTRUCT("e436eb80-524f-11ce-9F53-0020af0ba770", KSDATAFORMAT_SUBTYPE_MPEG1Packet);
#define KSDATAFORMAT_SUBTYPE_MPEG1Packet DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG1Packet)

#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG1Payload\
    0xe436eb81, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70
DEFINE_GUIDSTRUCT("e436eb81-524f-11ce-9F53-0020af0ba770", KSDATAFORMAT_SUBTYPE_MPEG1Payload);
#define KSDATAFORMAT_SUBTYPE_MPEG1Payload DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG1Payload)

// MEDIASUBTYPE_MPEG1Video
#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG1Video\
    0xe436eb86, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70
DEFINE_GUIDSTRUCT("e436eb86-524f-11ce-9f53-0020af0ba770", KSDATAFORMAT_SUBTYPE_MPEG1Video);
#define KSDATAFORMAT_SUBTYPE_MPEG1Video DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG1Video)

//FORMAT_MPEGVideo
#define STATIC_KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO\
    0x05589f82L, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a
DEFINE_GUIDSTRUCT("05589f82-c356-11ce-bf01-00aa0055595a", KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO);
#define KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO)

//
// mpeg 2 definitions
//
#define STATIC_KSDATAFORMAT_TYPE_MPEG2_PES\
    0xe06d8020L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8020-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_TYPE_MPEG2_PES);
#define KSDATAFORMAT_TYPE_MPEG2_PES DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_MPEG2_PES)

#define STATIC_KSDATAFORMAT_TYPE_MPEG2_PROGRAM\
    0xe06d8022L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8022-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_TYPE_MPEG2_PROGRAM);
#define KSDATAFORMAT_TYPE_MPEG2_PROGRAM DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_MPEG2_PROGRAM)

#define STATIC_KSDATAFORMAT_TYPE_MPEG2_TRANSPORT\
    0xe06d8023L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8023-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_TYPE_MPEG2_TRANSPORT);
#define KSDATAFORMAT_TYPE_MPEG2_TRANSPORT DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_MPEG2_TRANSPORT)

#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO\
    0xe06d8026L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8026-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO);
#define KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO)

// use MPEGVIDEOINFO2 (defined below) with KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO
#define STATIC_KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO\
    0xe06d80e3L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d80e3-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO);
#define KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO)

//
// Mpeg2 video properties
//


#define STATIC_KSPROPSETID_Mpeg2Vid\
    0xC8E11B60L, 0x0CC9, 0x11D0, 0xBD, 0x69, 0x00, 0x35, 0x05, 0xC1, 0x03, 0xA9
DEFINE_GUIDSTRUCT("C8E11B60-0CC9-11D0-BD69-003505C103A9", KSPROPSETID_Mpeg2Vid);
#define  KSPROPSETID_Mpeg2Vid DEFINE_GUIDNAMED( KSPROPSETID_Mpeg2Vid )


typedef enum {
    KSPROPERTY_MPEG2VID_MODES,          // available output modes of decoder
    KSPROPERTY_MPEG2VID_CUR_MODE,       // current mode of the decoder
    KSPROPERTY_MPEG2VID_4_3_RECT,       // output coordinates for 4:3 source
    KSPROPERTY_MPEG2VID_16_9_RECT,      // output coordinates for 16:9 source
    KSPROPERTY_MPEG2VID_16_9_PANSCAN,   // pan and scan vectors
} KSPROPERTY_MPEG2VID;

//
// bit field definitions for MPEG2 VIDEO mode
//

#define KSMPEGVIDMODE_PANSCAN   0x0001
#define KSMPEGVIDMODE_LTRBOX    0x0002
#define KSMPEGVIDMODE_SCALE     0x0004

//
// rectangle definitions for the 4/3 and 16/9 cropping properties of
// the MPEG2Video decoder
//

typedef struct _KSMPEGVID_RECT {
    ULONG StartX;
    ULONG StartY;
    ULONG EndX;
    ULONG EndY;
} KSMPEGVID_RECT, *PKSMPEGVID_RECT;

//
// Params for pan / scan
//


//
// MPEG2 Audio definition
//

#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO\
    0xe06d802bL, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d802b-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO);
#define KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO)

#define STATIC_KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO\
    0xe06d80e5L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d80e5-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO);
#define KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO)

//
// DVD LPCM Audio definition
//

#define STATIC_KSDATAFORMAT_SUBTYPE_LPCM_AUDIO\
    0xe06d8032L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8032-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_LPCM_AUDIO);
#define KSDATAFORMAT_SUBTYPE_LPCM_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_LPCM_AUDIO)

#define STATIC_KSDATAFORMAT_SPECIFIER_LPCM_AUDIO\
    0xe06d80e6L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d80e6-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SPECIFIER_LPCM_AUDIO);
#define KSDATAFORMAT_SPECIFIER_LPCM_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_LPCM_AUDIO)

//
// AC-3 definition
//

#define STATIC_KSDATAFORMAT_SUBTYPE_AC3_AUDIO\
    0xe06d802cL, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d802c-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_AC3_AUDIO);
#define KSDATAFORMAT_SUBTYPE_AC3_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_AC3_AUDIO)

#define STATIC_KSDATAFORMAT_SPECIFIER_AC3_AUDIO\
    0xe06d80e4L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d80e4-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SPECIFIER_AC3_AUDIO);
#define KSDATAFORMAT_SPECIFIER_AC3_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_AC3_AUDIO)

#define STATIC_KSPROPSETID_AC3\
    0xBFABE720L, 0x6E1F, 0x11D0, 0xBC, 0xF2, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00
DEFINE_GUIDSTRUCT("BFABE720-6E1F-11D0-BCF2-444553540000", KSPROPSETID_AC3);
#define KSPROPSETID_AC3 DEFINE_GUIDNAMED(KSPROPSETID_AC3)

typedef enum {
    KSPROPERTY_AC3_ERROR_CONCEALMENT = 1,
    KSPROPERTY_AC3_ALTERNATE_AUDIO,
    KSPROPERTY_AC3_DOWNMIX,
    KSPROPERTY_AC3_BIT_STREAM_MODE,
    KSPROPERTY_AC3_DIALOGUE_LEVEL,
    KSPROPERTY_AC3_LANGUAGE_CODE,
    KSPROPERTY_AC3_ROOM_TYPE
} KSPROPERTY_AC3;

typedef struct  {
    BOOL        fRepeatPreviousBlock;
    BOOL        fErrorInCurrentBlock;
} KSAC3_ERROR_CONCEALMENT, *PKSAC3_ERROR_CONCEALMENT;

typedef struct {
    BOOL    fStereo;
    ULONG   DualMode;
} KSAC3_ALTERNATE_AUDIO, *PKSAC3_ALTERNATE_AUDIO;

#define KSAC3_ALTERNATE_AUDIO_1     1
#define KSAC3_ALTERNATE_AUDIO_2     2
#define KSAC3_ALTERNATE_AUDIO_BOTH  3

typedef struct {
    BOOL        fDownMix;
    BOOL        fDolbySurround;
} KSAC3_DOWNMIX, *PKSAC3_DOWNMIX;

typedef struct {
    LONG        BitStreamMode;
} KSAC3_BIT_STREAM_MODE, *PKSAC3_BIT_STREAM_MODE;

#define KSAC3_SERVICE_MAIN_AUDIO            0
#define KSAC3_SERVICE_NO_DIALOG             1
#define KSAC3_SERVICE_VISUALLY_IMPAIRED     2
#define KSAC3_SERVICE_HEARING_IMPAIRED      3
#define KSAC3_SERVICE_DIALOG_ONLY           4
#define KSAC3_SERVICE_COMMENTARY            5
#define KSAC3_SERVICE_EMERGENCY_FLASH       6
#define KSAC3_SERVICE_VOICE_OVER            7

typedef struct {
    ULONG   DialogueLevel;
} KSAC3_DIALOGUE_LEVEL, *PKSAC3_DIALOGUE_LEVEL;

typedef struct {
    BOOL    fLargeRoom;
} KSAC3_ROOM_TYPE, *PKSAC3_ROOM_TYPE;

// New formats enabled by CEA 861 specifciation
#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_DOLBY_AC3_SPDIF)
DEFINE_GUIDSTRUCT("00000092-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_WMA_PRO\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_WMASPDIF)
DEFINE_GUIDSTRUCT("00000164-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_WMA_PRO);
#define KSDATAFORMAT_SUBTYPE_IEC61937_WMA_PRO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_WMA_PRO)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DTS\
    DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_DTS)
DEFINE_GUIDSTRUCT("00000008-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DTS);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DTS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DTS)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_MPEG1 \
    0x00000003L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000003-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_MPEG1);
#define KSDATAFORMAT_SUBTYPE_IEC61937_MPEG1 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_MPEG1)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_MPEG2 \
    0x00000004L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000004-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_MPEG2);
#define KSDATAFORMAT_SUBTYPE_IEC61937_MPEG2 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_MPEG2)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_MPEG3 \
    0x00000005L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000005-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_MPEG3);
#define KSDATAFORMAT_SUBTYPE_IEC61937_MPEG3 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_MPEG3)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_AAC \
    0x00000006L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000006-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_AAC);
#define KSDATAFORMAT_SUBTYPE_IEC61937_AAC DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_AAC)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_ATRAC \
    0x00000008L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000008-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_ATRAC);
#define KSDATAFORMAT_SUBTYPE_IEC61937_ATRAC DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_ATRAC)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_ONE_BIT_AUDIO \
    0x00000009L, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000009-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_ONE_BIT_AUDIO);
#define KSDATAFORMAT_SUBTYPE_IEC61937_ONE_BIT_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_ONE_BIT_AUDIO)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS \
    0x0000000aL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000000a-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS_ATMOS \
    0x0000010aL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000010a-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS_ATMOS);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS_ATMOS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_DIGITAL_PLUS_ATMOS)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DTS_HD \
    0x0000000bL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000000b-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DTS_HD);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DTS_HD DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DTS_HD)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E1 \
    0x0000010bL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000010b-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E1);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E1 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E1)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E2 \
    0x0000030bL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000030b-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E2);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E2 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DTSX_E2)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MLP \
    0x0000000cL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000000c-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MLP);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MLP DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MLP)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT20 \
    0x0000010cL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000010c-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT20);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT20 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT20)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT21 \
    0x0000030cL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000030c-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT21);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT21 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DOLBY_MAT21)

#define STATIC_KSDATAFORMAT_SUBTYPE_IEC61937_DST \
    0x0000000dL, 0x0cea, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("0000000d-0cea-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IEC61937_DST);
#define KSDATAFORMAT_SUBTYPE_IEC61937_DST DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IEC61937_DST)


//MP3
#define STATIC_KSDATAFORMAT_SUBTYPE_MPEGLAYER3 \
DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_MPEGLAYER3)
DEFINE_GUIDSTRUCT("00000055-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MPEGLAYER3);
#define KSDATAFORMAT_SUBTYPE_MPEGLAYER3 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEGLAYER3)

// AAC
#define STATIC_KSDATAFORMAT_SUBTYPE_MPEG_HEAAC \
DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_MPEG_HEAAC)
DEFINE_GUIDSTRUCT("00001610-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MPEG_HEAAC);
#define KSDATAFORMAT_SUBTYPE_MPEG_HEAAC DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MPEG_HEAAC)

//WMA STD
#define STATIC_KSDATAFORMAT_SUBTYPE_WMAUDIO2 \
DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_WMAUDIO2)
DEFINE_GUIDSTRUCT("00000161-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_WMAUDIO2);
#define KSDATAFORMAT_SUBTYPE_WMAUDIO2 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_WMAUDIO2)

//WMA PRO
#define STATIC_KSDATAFORMAT_SUBTYPE_WMAUDIO3 \
DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_WMAUDIO3)
DEFINE_GUIDSTRUCT("00000162-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_WMAUDIO3);
#define KSDATAFORMAT_SUBTYPE_WMAUDIO3 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_WMAUDIO3)

//WMA LOSSLESS
#define STATIC_KSDATAFORMAT_SUBTYPE_WMAUDIO_LOSSLESS \
DEFINE_WAVEFORMATEX_GUID(WAVE_FORMAT_WMAUDIO_LOSSLESS)
DEFINE_GUIDSTRUCT("00000163-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_WMAUDIO_LOSSLESS);
#define KSDATAFORMAT_SUBTYPE_WMAUDIO_LOSSLESS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_WMAUDIO_LOSSLESS)

#if (NTDDI_VERSION >= NTDDI_WINXP)

//
// DTS and SDDS definitions (media subtype GUIDs)
//
#define STATIC_KSDATAFORMAT_SUBTYPE_DTS_AUDIO\
    0xe06d8033L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8033-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_DTS_AUDIO);
#define KSDATAFORMAT_SUBTYPE_DTS_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_DTS_AUDIO)

#define STATIC_KSDATAFORMAT_SUBTYPE_SDDS_AUDIO\
    0xe06d8034L, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d8034-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_SDDS_AUDIO);
#define KSDATAFORMAT_SUBTYPE_SDDS_AUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_SDDS_AUDIO)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

//
// audio decoder output properties
//

#define STATIC_KSPROPSETID_AudioDecoderOut\
    0x6ca6e020L, 0x43bd, 0x11d0, 0xbd, 0x6a, 0x00, 0x35, 0x05, 0xc1, 0x03, 0xa9
DEFINE_GUIDSTRUCT("6ca6e020-43bd-11d0-bd6a-003505c103a9", KSPROPSETID_AudioDecoderOut);
#define KSPROPSETID_AudioDecoderOut DEFINE_GUIDNAMED(KSPROPSETID_AudioDecoderOut)

typedef enum {
    KSPROPERTY_AUDDECOUT_MODES,         // available output modes of decoder
    KSPROPERTY_AUDDECOUT_CUR_MODE,      // current mode of the decoder
} KSPROPERTY_AUDDECOUT;

#define KSAUDDECOUTMODE_STEREO_ANALOG   0x0001
#define KSAUDDECOUTMODE_PCM_51          0x0002
#define KSAUDDECOUTMODE_SPDIFF          0x0004



//
// subpicture definition
//

#define STATIC_KSDATAFORMAT_SUBTYPE_SUBPICTURE\
    0xe06d802dL, 0xdb46, 0x11cf, 0xb4, 0xd1, 0x00, 0x80, 0x5f, 0x6c, 0xbb, 0xea
DEFINE_GUIDSTRUCT("e06d802d-db46-11cf-b4d1-00805f6cbbea", KSDATAFORMAT_SUBTYPE_SUBPICTURE);
#define KSDATAFORMAT_SUBTYPE_SUBPICTURE DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_SUBPICTURE)


#define STATIC_KSPROPSETID_DvdSubPic\
    0xac390460L, 0x43af, 0x11d0, 0xbd, 0x6a, 0x00, 0x35, 0x05, 0xc1, 0x03, 0xa9
DEFINE_GUIDSTRUCT("ac390460-43af-11d0-bd6a-003505c103a9", KSPROPSETID_DvdSubPic);
#define KSPROPSETID_DvdSubPic DEFINE_GUIDNAMED(KSPROPSETID_DvdSubPic)

typedef enum {
    KSPROPERTY_DVDSUBPIC_PALETTE,
    KSPROPERTY_DVDSUBPIC_HLI,
    KSPROPERTY_DVDSUBPIC_COMPOSIT_ON,  // TRUE for subpicture is displayed
} KSPROPERTY_DVDSUBPIC;

typedef struct _KS_DVD_YCrCb {
    UCHAR   Reserved;
    UCHAR   Y;
    UCHAR   Cr;
    UCHAR   Cb;
} KS_DVD_YCrCb, *PKS_DVD_YCrCb;

/* The KS_DVD_YUV structure is now superseded by KS_DVD_YCrCb above and is
   here for backward compatibility only */

typedef struct _KS_DVD_YUV {
    UCHAR   Reserved;
    UCHAR   Y;
    UCHAR   V;
    UCHAR   U;
} KS_DVD_YUV, *PKS_DVD_YUV;

typedef struct _KSPROPERTY_SPPAL {
    KS_DVD_YUV sppal[16];
} KSPROPERTY_SPPAL, *PKSPROPERTY_SPPAL;

typedef struct _KS_COLCON {
    UCHAR emph1col:4;
    UCHAR emph2col:4;
    UCHAR backcol:4;
    UCHAR patcol:4;
    UCHAR emph1con:4;
    UCHAR emph2con:4;
    UCHAR backcon:4;
    UCHAR patcon:4;

} KS_COLCON, *PKS_COLCON;

typedef struct _KSPROPERTY_SPHLI {
    USHORT      HLISS;
    USHORT      Reserved;
    ULONG       StartPTM;   // start presentation time in x/90000
    ULONG       EndPTM;     // end PTM in x/90000
    USHORT      StartX;
    USHORT      StartY;
    USHORT      StopX;
    USHORT      StopY;
    KS_COLCON   ColCon;     // color contrast description (4 bytes as given in HLI)
} KSPROPERTY_SPHLI, *PKSPROPERTY_SPHLI;

typedef BOOL KSPROPERTY_COMPOSIT_ON, *PKSPROPERTY_COMPOSIT_ON;

#define STATIC_KSPROPSETID_CopyProt \
    0x0E8A0A40L, 0x6AEF, 0x11D0, 0x9E, 0xD0, 0x00, 0xA0, 0x24, 0xCA, 0x19, 0xB3
DEFINE_GUIDSTRUCT("0E8A0A40-6AEF-11D0-9ED0-00A024CA19B3", KSPROPSETID_CopyProt);
#define KSPROPSETID_CopyProt DEFINE_GUIDNAMED(KSPROPSETID_CopyProt)

typedef enum {

    KSPROPERTY_DVDCOPY_CHLG_KEY = 0x01,
    KSPROPERTY_DVDCOPY_DVD_KEY1,
    KSPROPERTY_DVDCOPY_DEC_KEY2,
    KSPROPERTY_DVDCOPY_TITLE_KEY,
    KSPROPERTY_COPY_MACROVISION,
    KSPROPERTY_DVDCOPY_REGION,
    KSPROPERTY_DVDCOPY_SET_COPY_STATE,
    KSPROPERTY_DVDCOPY_DISC_KEY = 0x80

} KSPROPERTY_COPYPROT;

typedef struct _KS_DVDCOPY_CHLGKEY {
    BYTE ChlgKey[10];
    BYTE Reserved[2];
} KS_DVDCOPY_CHLGKEY, *PKS_DVDCOPY_CHLGKEY;

typedef struct _KS_DVDCOPY_BUSKEY {
    BYTE BusKey[5];
    BYTE Reserved[1];
} KS_DVDCOPY_BUSKEY, *PKS_DVDCOPY_BUSKEY;


typedef struct _KS_DVDCOPY_DISCKEY {
    BYTE DiscKey[2048];
} KS_DVDCOPY_DISCKEY, *PKS_DVDCOPY_DISCKEY;

typedef struct _KS_DVDCOPY_REGION {
    UCHAR   Reserved;
    UCHAR   RegionData;
    UCHAR   Reserved2[2];
} KS_DVDCOPY_REGION, *PKS_DVDCOPY_REGION;

typedef struct _KS_DVDCOPY_TITLEKEY {
    ULONG KeyFlags;
    ULONG ReservedNT[2];
    UCHAR TitleKey[6];
    UCHAR Reserved[2];
} KS_DVDCOPY_TITLEKEY, *PKS_DVDCOPY_TITLEKEY;

typedef struct _KS_COPY_MACROVISION {
    ULONG MACROVISIONLevel;
} KS_COPY_MACROVISION, *PKS_COPY_MACROVISION;

typedef struct _KS_DVDCOPY_SET_COPY_STATE {
    ULONG DVDCopyState;
} KS_DVDCOPY_SET_COPY_STATE, *PKS_DVDCOPY_SET_COPY_STATE;

typedef enum {
    KS_DVDCOPYSTATE_INITIALIZE,         // indicates we are starting a full
                                        // copy protection sequence.
    KS_DVDCOPYSTATE_INITIALIZE_TITLE,   // indicates we are starting a title
                                        // key copy protection sequence
    KS_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED,
    KS_DVDCOPYSTATE_AUTHENTICATION_REQUIRED,
    KS_DVDCOPYSTATE_DONE,
} KS_DVDCOPYSTATE;

typedef enum {
    KS_MACROVISION_DISABLED,
    KS_MACROVISION_LEVEL1,
    KS_MACROVISION_LEVEL2,
    KS_MACROVISION_LEVEL3
} KS_COPY_MACROVISION_LEVEL, *PKS_COPY_MACROVISION_LEVEL;

//
// CGMS Copy Protection Flags
//

#define KS_DVD_CGMS_RESERVED_MASK      0x00000078

#define KS_DVD_CGMS_COPY_PROTECT_MASK  0x00000018
#define KS_DVD_CGMS_COPY_PERMITTED     0x00000000
#define KS_DVD_CGMS_COPY_ONCE          0x00000010
#define KS_DVD_CGMS_NO_COPY            0x00000018

#define KS_DVD_COPYRIGHT_MASK          0x00000040
#define KS_DVD_NOT_COPYRIGHTED         0x00000000
#define KS_DVD_COPYRIGHTED             0x00000040

#define KS_DVD_SECTOR_PROTECT_MASK     0x00000020
#define KS_DVD_SECTOR_NOT_PROTECTED    0x00000000
#define KS_DVD_SECTOR_PROTECTED        0x00000020


//===========================================================================
// The following MUST match the structures in WinGDI.h and AMVideo.h
//===========================================================================

#define STATIC_KSCATEGORY_TVTUNER \
    0xa799a800L, 0xa46d, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0x24, 0x01, 0xdc, 0xd4
DEFINE_GUIDSTRUCT("a799a800-a46d-11d0-a18c-00a02401dcd4", KSCATEGORY_TVTUNER);
#define KSCATEGORY_TVTUNER DEFINE_GUIDNAMED(KSCATEGORY_TVTUNER)

#define STATIC_KSCATEGORY_CROSSBAR \
    0xa799a801L, 0xa46d, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0x24, 0x01, 0xdc, 0xd4
DEFINE_GUIDSTRUCT("a799a801-a46d-11d0-a18c-00a02401dcd4", KSCATEGORY_CROSSBAR);
#define KSCATEGORY_CROSSBAR DEFINE_GUIDNAMED(KSCATEGORY_CROSSBAR)

#define STATIC_KSCATEGORY_TVAUDIO \
    0xa799a802L, 0xa46d, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0x24, 0x01, 0xdc, 0xd4
DEFINE_GUIDSTRUCT("a799a802-a46d-11d0-a18c-00a02401dcd4", KSCATEGORY_TVAUDIO);
#define KSCATEGORY_TVAUDIO DEFINE_GUIDNAMED(KSCATEGORY_TVAUDIO)

#define STATIC_KSCATEGORY_VPMUX \
    0xa799a803L, 0xa46d, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0x24, 0x01, 0xdc, 0xd4
DEFINE_GUIDSTRUCT("a799a803-a46d-11d0-a18c-00a02401dcd4", KSCATEGORY_VPMUX);
#define KSCATEGORY_VPMUX DEFINE_GUIDNAMED(KSCATEGORY_VPMUX)

#define STATIC_KSCATEGORY_VBICODEC \
    0x07dad660L, 0x22f1, 0x11d1, 0xa9, 0xf4, 0x00, 0xc0, 0x4f, 0xbb, 0xde, 0x8f
DEFINE_GUIDSTRUCT("07dad660-22f1-11d1-a9f4-00c04fbbde8f", KSCATEGORY_VBICODEC);
#define KSCATEGORY_VBICODEC DEFINE_GUIDNAMED(KSCATEGORY_VBICODEC)

// SUBTYPE_VPVideo
#define STATIC_KSDATAFORMAT_SUBTYPE_VPVideo\
    0x5a9b6a40L, 0x1a22, 0x11d1, 0xba, 0xd9, 0x0, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("5a9b6a40-1a22-11d1-bad9-00609744111a", KSDATAFORMAT_SUBTYPE_VPVideo);
#define KSDATAFORMAT_SUBTYPE_VPVideo DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_VPVideo)

// SUBTYPE_VPVBI
#define STATIC_KSDATAFORMAT_SUBTYPE_VPVBI\
    0x5a9b6a41L, 0x1a22, 0x11d1, 0xba, 0xd9, 0x0, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("5a9b6a41-1a22-11d1-bad9-00609744111a", KSDATAFORMAT_SUBTYPE_VPVBI);
#define KSDATAFORMAT_SUBTYPE_VPVBI DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_VPVBI)


// FORMAT_VideoInfo
#define STATIC_KSDATAFORMAT_SPECIFIER_VIDEOINFO\
    0x05589f80L, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a
DEFINE_GUIDSTRUCT("05589f80-c356-11ce-bf01-00aa0055595a", KSDATAFORMAT_SPECIFIER_VIDEOINFO);
#define KSDATAFORMAT_SPECIFIER_VIDEOINFO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_VIDEOINFO)

// FORMAT_VideoInfo2
#define STATIC_KSDATAFORMAT_SPECIFIER_VIDEOINFO2\
    0xf72a76A0L, 0xeb0a, 0x11d0, 0xac, 0xe4, 0x00, 0x00, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("f72a76A0-eb0a-11d0-ace4-0000c0cc16ba", KSDATAFORMAT_SPECIFIER_VIDEOINFO2);
#define KSDATAFORMAT_SPECIFIER_VIDEOINFO2 DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_VIDEOINFO2)

// FORMAT_UVCH264Video
#define STATIC_KSDATAFORMAT_SPECIFIER_H264_VIDEO\
    0x2017be05L, 0x6629, 0x4248, 0xaa, 0xed, 0x7e, 0x1a, 0x47, 0xbc, 0x9b, 0x9c
DEFINE_GUIDSTRUCT("2017be05-6629-4248-aaed-7e1a47bc9b9c", KSDATAFORMAT_SPECIFIER_H264_VIDEO);
#define KSDATAFORMAT_SPECIFIER_H264_VIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_H264_VIDEO)

// FORMAT_JPEGImage
#define STATIC_KSDATAFORMAT_SPECIFIER_JPEG_IMAGE\
    0x692fa379, 0xd3e8, 0x4651, 0xb5, 0xb4, 0xb, 0x94, 0xb0, 0x13, 0xee, 0xaf
DEFINE_GUIDSTRUCT("692fa379-d3e8-4651-b5b4-0b94b013eeaf", KSDATAFORMAT_SPECIFIER_JPEG_IMAGE);
#define KSDATAFORMAT_SPECIFIER_JPEG_IMAGE DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_JPEG_IMAGE)

// FORMAT_Image
#define STATIC_KSDATAFORMAT_SPECIFIER_IMAGE\
    0x692fa379, 0xd3e8, 0x4651, 0xb5, 0xb4, 0xb, 0x94, 0xb0, 0x13, 0xee, 0xaf
DEFINE_GUIDSTRUCT("692fa379-d3e8-4651-b5b4-0b94b013eeaf", KSDATAFORMAT_SPECIFIER_IMAGE);
#define KSDATAFORMAT_SPECIFIER_IMAGE DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_IMAGE)

// MEDIATYPE_Image: same as MFMEDIATYPE_Image
#define STATIC_KSDATAFORMAT_TYPE_IMAGE\
    0x72178c23, 0xe45b, 0x11d5, 0xbc, 0x2a, 0x00, 0xb0, 0xd0, 0xf3, 0xf4, 0xab
DEFINE_GUIDSTRUCT("72178c23-e45b-11d5-bc2a-00b0d0f3f4ab", KSDATAFORMAT_TYPE_IMAGE);
#define KSDATAFORMAT_TYPE_IMAGE DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_IMAGE)

// SUBTYPE_JPEG: same as WIC container format JPEG
#define STATIC_KSDATAFORMAT_SUBTYPE_JPEG\
    0x19e4a5aa, 0x5662, 0x4fc5, 0xa0, 0xc0, 0x17, 0x58, 0x2, 0x8e, 0x10, 0x57
DEFINE_GUIDSTRUCT("19e4a5aa-5662-4fc5-a0c0-1758028e1057", KSDATAFORMAT_SUBTYPE_JPEG);
#define KSDATAFORMAT_SUBTYPE_JPEG DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_JPEG)

// SUBTYPE_IMAGE_RGB32: same as MFVideoFormat_RGB32
#define STATIC_KSDATAFORMAT_SUBTYPE_IMAGE_RGB32\
    0x00000016, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000016-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_IMAGE_RGB32);
#define KSDATAFORMAT_SUBTYPE_IMAGE_RGB32 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_IMAGE_RGB32)

#if (NTDDI_VERSION >= NTDDI_WIN10)

// KSDATAFORMAT_SUBTYPE_L8:
#define STATIC_KSDATAFORMAT_SUBTYPE_L8\
    0x00000032, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000032-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L8);
#define KSDATAFORMAT_SUBTYPE_L8 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L8)

// KSDATAFORMAT_SUBTYPE_L8_IR:
#define STATIC_KSDATAFORMAT_SUBTYPE_L8_IR\
    0x00000032, 0x0002, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000032-0002-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L8_IR);
#define KSDATAFORMAT_SUBTYPE_L8_IR DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L8_IR)

// KSDATAFORMAT_SUBTYPE_L8_CUSTOM:
#define STATIC_KSDATAFORMAT_SUBTYPE_L8_CUSTOM\
    0x00000032, 0x8000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000032-8000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L8_CUSTOM);
#define KSDATAFORMAT_SUBTYPE_L8_CUSTOM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L8_CUSTOM)

// KSDATAFORMAT_SUBTYPE_L16:
#define STATIC_KSDATAFORMAT_SUBTYPE_L16\
    0x00000051, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000051-0000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L16);
#define KSDATAFORMAT_SUBTYPE_L16 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L16)

// KSDATAFORMAT_SUBTYPE_L16_IR:
#define STATIC_KSDATAFORMAT_SUBTYPE_L16_IR\
    0x00000051, 0x0002, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000051-0002-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L16_IR);
#define KSDATAFORMAT_SUBTYPE_L16_IR DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L16_IR)

// KSDATAFORMAT_SUBTYPE_D16:
#define STATIC_KSDATAFORMAT_SUBTYPE_D16\
    0x00000050, 0x0004, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000050-0004-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_D16);
#define KSDATAFORMAT_SUBTYPE_D16 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_D16)

// KSDATAFORMAT_SUBTYPE_L16_CUSTOM:
#define STATIC_KSDATAFORMAT_SUBTYPE_L16_CUSTOM\
    0x00000051, 0x8000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("00000051-8000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_L16_CUSTOM);
#define KSDATAFORMAT_SUBTYPE_L16_CUSTOM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_L16_CUSTOM)

// KSDATAFORMAT_SUBTYPE_MJPG_IR:
#define STATIC_KSDATAFORMAT_SUBTYPE_MJPG_IR\
    0x47504a4d, 0x0002, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("47504a4d-0002-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MJPG_IR);
#define KSDATAFORMAT_SUBTYPE_MJPG_IR DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MJPG_IR)

// KSDATAFORMAT_SUBTYPE_MJPG_DEPTH:
#define STATIC_KSDATAFORMAT_SUBTYPE_MJPG_DEPTH\
    0x47504a4d, 0x0004, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("47504a4d-0004-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MJPG_DEPTH);
#define KSDATAFORMAT_SUBTYPE_MJPG_DEPTH DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MJPG_DEPTH)

// KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM:
#define STATIC_KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM\
    0x47504a4d, 0x8000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
DEFINE_GUIDSTRUCT("47504a4d-8000-0010-8000-00aa00389b71", KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM);
#define KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_MJPG_CUSTOM)


#endif //(NTDDI_VERSION >= NTDDI_WIN10)

// MEDIATYPE_AnalogVideo
#define STATIC_KSDATAFORMAT_TYPE_ANALOGVIDEO\
    0x0482dde1L, 0x7817, 0x11cf, 0x8a, 0x03, 0x00, 0xaa, 0x00, 0x6e, 0xcb, 0x65
DEFINE_GUIDSTRUCT("0482dde1-7817-11cf-8a03-00aa006ecb65", KSDATAFORMAT_TYPE_ANALOGVIDEO);
#define KSDATAFORMAT_TYPE_ANALOGVIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_ANALOGVIDEO)

// FORMAT_AnalogVideo
#define STATIC_KSDATAFORMAT_SPECIFIER_ANALOGVIDEO\
    0x0482dde0L, 0x7817, 0x11cf, 0x8a, 0x03, 0x00, 0xaa, 0x00, 0x6e, 0xcb, 0x65
DEFINE_GUIDSTRUCT("0482dde0-7817-11cf-8a03-00aa006ecb65", KSDATAFORMAT_SPECIFIER_ANALOGVIDEO);
#define KSDATAFORMAT_SPECIFIER_ANALOGVIDEO DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_ANALOGVIDEO)

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

// MEDIATYPE_AnalogAudio
#define STATIC_KSDATAFORMAT_TYPE_ANALOGAUDIO \
    0x0482dee1L, 0x7817, 0x11cf, 0x8a, 0x03, 0x00, 0xaa, 0x00, 0x6e, 0xcb, 0x65
DEFINE_GUIDSTRUCT("0482DEE1-7817-11cf-8a03-00aa006ecb65", KSDATAFORMAT_TYPE_ANALOGAUDIO);
#define KSDATAFORMAT_TYPE_ANALOGAUDIO DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_ANALOGAUDIO)

#endif // XP SP2 and later (chronologically)

// FORMAT_VBI
#define STATIC_KSDATAFORMAT_SPECIFIER_VBI\
    0xf72a76e0L, 0xeb0a, 0x11d0, 0xac, 0xe4, 0x00, 0x00, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("f72a76e0-eb0a-11d0-ace4-0000c0cc16ba", KSDATAFORMAT_SPECIFIER_VBI);
#define KSDATAFORMAT_SPECIFIER_VBI DEFINE_GUIDNAMED(KSDATAFORMAT_SPECIFIER_VBI)

// MEDIATYPE_VBI
#define STATIC_KSDATAFORMAT_TYPE_VBI\
    0xf72a76e1L, 0xeb0a, 0x11d0, 0xac, 0xe4, 0x00, 0x00, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("f72a76e1-eb0a-11d0-ace4-0000c0cc16ba", KSDATAFORMAT_TYPE_VBI);
#define KSDATAFORMAT_TYPE_VBI DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_VBI)

// SUBTYPE_RAW8
#define STATIC_KSDATAFORMAT_SUBTYPE_RAW8\
    0xca20d9a0, 0x3e3e, 0x11d1, 0x9b, 0xf9, 0x0, 0xc0, 0x4f, 0xbb, 0xde, 0xbf
DEFINE_GUIDSTRUCT("ca20d9a0-3e3e-11d1-9bf9-00c04fbbdebf", KSDATAFORMAT_SUBTYPE_RAW8);
#define KSDATAFORMAT_SUBTYPE_RAW8 DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_RAW8)

#if (NTDDI_VERSION >= NTDDI_WINXP)

// MEDIASUBTYPE_CC
#define STATIC_KSDATAFORMAT_SUBTYPE_CC\
    0x33214cc1, 0x11f, 0x11d2, 0xb4, 0xb1, 0x0, 0xa0, 0xd1, 0x2, 0xcf, 0xbe
DEFINE_GUIDSTRUCT("33214CC1-011F-11D2-B4B1-00A0D102CFBE", KSDATAFORMAT_SUBTYPE_CC);
#define KSDATAFORMAT_SUBTYPE_CC DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_CC)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

// MEDIASUBTYPE_NABTS
#define STATIC_KSDATAFORMAT_SUBTYPE_NABTS\
    0xf72a76e2L, 0xeb0a, 0x11d0, 0xac, 0xe4, 0x00, 0x00, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("f72a76e2-eb0a-11d0-ace4-0000c0cc16ba", KSDATAFORMAT_SUBTYPE_NABTS);
#define KSDATAFORMAT_SUBTYPE_NABTS DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_NABTS)

// MEDIASUBTYPE_TELETEXT
#define STATIC_KSDATAFORMAT_SUBTYPE_TELETEXT\
    0xf72a76e3L, 0xeb0a, 0x11d0, 0xac, 0xe4, 0x00, 0x00, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("f72a76e3-eb0a-11d0-ace4-0000c0cc16ba", KSDATAFORMAT_SUBTYPE_TELETEXT);
#define KSDATAFORMAT_SUBTYPE_TELETEXT DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_TELETEXT)



/* constants for the biCompression field */
#define KS_BI_RGB        0L
#define KS_BI_RLE8       1L
#define KS_BI_RLE4       2L
#define KS_BI_BITFIELDS  3L
#define KS_BI_JPEG       4L

typedef struct tagKS_RGBQUAD { // rgbq
    BYTE    rgbBlue;
    BYTE    rgbGreen;
    BYTE    rgbRed;
    BYTE    rgbReserved;
} KS_RGBQUAD, *PKS_RGBQUAD;

/* constants for palettes */
#define KS_iPALETTE_COLORS 256     // Maximum colours in palette
#define KS_iEGA_COLORS 16          // Number colours in EGA palette
#define KS_iMASK_COLORS 3          // Maximum three components
#define KS_iTRUECOLOR 16           // Minimum true colour device
#define KS_iRED 0                  // Index position for RED mask
#define KS_iGREEN 1                // Index position for GREEN mask
#define KS_iBLUE 2                 // Index position for BLUE mask
#define KS_iPALETTE 8              // Maximum colour depth using a palette
#define KS_iMAXBITS 8              // Maximum bits per colour component
#define KS_SIZE_EGA_PALETTE (KS_iEGA_COLORS * sizeof(KS_RGBQUAD))
#define KS_SIZE_PALETTE (KS_iPALETTE_COLORS * sizeof(KS_RGBQUAD))

typedef struct tagKS_BITMAPINFOHEADER{
        DWORD      biSize;
        LONG       biWidth;
        LONG       biHeight;
        WORD       biPlanes;
        WORD       biBitCount;
        DWORD      biCompression;
        DWORD      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        DWORD      biClrUsed;
        DWORD      biClrImportant;
} KS_BITMAPINFOHEADER, *PKS_BITMAPINFOHEADER;

// Used for true colour images that also have a palette

typedef struct tag_KS_TRUECOLORINFO {
    DWORD   dwBitMasks[KS_iMASK_COLORS];
    KS_RGBQUAD bmiColors[KS_iPALETTE_COLORS];
} KS_TRUECOLORINFO, *PKS_TRUECOLORINFO;


#define KS_WIDTHBYTES(bits) ((DWORD)(((bits)+31) & (~31)) / 8)
#define KS_DIBWIDTHBYTES(bi) (DWORD)KS_WIDTHBYTES((DWORD)(bi).biWidth * (DWORD)(bi).biBitCount)
#define KS__DIBSIZE(bi) (KS_DIBWIDTHBYTES(bi) * (DWORD)(bi).biHeight)
#define KS_DIBSIZE(bi) ((bi).biHeight < 0 ? (-1)*(KS__DIBSIZE(bi)) : KS__DIBSIZE(bi))

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application and Games Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_GAMES)

typedef LONGLONG REFERENCE_TIME;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_GAMES) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

// The BITMAPINFOHEADER contains all the details about the video stream such
// as the actual image dimensions and their pixel depth. A source filter may
// also request that the sink take only a section of the video by providing a
// clipping rectangle in rcSource. In the worst case where the sink filter
// forgets to check this on connection it will simply render the whole thing
// which isn't a disaster. Ideally a sink filter will check the rcSource and
// if it doesn't support image extraction and the rectangle is not empty then
// it will reject the connection. A filter should use SetRectEmpty to reset a
// rectangle to all zeroes (and IsRectEmpty to later check the rectangle).
// The rcTarget specifies the destination rectangle for the video, for most
// source filters they will set this to all zeroes, a downstream filter may
// request that the video be placed in a particular area of the buffers it
// supplies in which case it will call QueryAccept with a non empty target

typedef struct tagKS_VIDEOINFOHEADER {

    RECT                rcSource;          // The bit we really want to use
    RECT                rcTarget;          // Where the video should go
    DWORD               dwBitRate;         // Approximate bit data rate
    DWORD               dwBitErrorRate;    // Bit error rate for this stream
    REFERENCE_TIME      AvgTimePerFrame;   // Average time per frame (100ns units)

    KS_BITMAPINFOHEADER bmiHeader;

} KS_VIDEOINFOHEADER, *PKS_VIDEOINFOHEADER;

// !!! WARNING !!!
// DO NOT use the following structure unless you are sure that the BITMAPINFOHEADER
// has a normal biSize == sizeof(BITMAPINFOHEADER) !
// !!! WARNING !!!

typedef struct tagKS_VIDEOINFO {

    RECT            rcSource;          // The bit we really want to use
    RECT            rcTarget;          // Where the video should go
    DWORD           dwBitRate;         // Approximate bit data rate
    DWORD           dwBitErrorRate;    // Bit error rate for this stream
    REFERENCE_TIME  AvgTimePerFrame;   // Average time per frame (100ns units)

    KS_BITMAPINFOHEADER bmiHeader;

    union {
        KS_RGBQUAD          bmiColors[KS_iPALETTE_COLORS];     // Colour palette
        DWORD               dwBitMasks[KS_iMASK_COLORS];       // True colour masks
        KS_TRUECOLORINFO    TrueColorInfo;                     // Both of the above
    };

} KS_VIDEOINFO, *PKS_VIDEOINFO;


#define KS_SIZE_MASKS (KS_iMASK_COLORS * sizeof(DWORD))
#define KS_SIZE_PREHEADER (FIELD_OFFSET(KS_VIDEOINFOHEADER,bmiHeader))

// For normal size
// #define KS_SIZE_VIDEOHEADER (sizeof(KS_BITMAPINFOHEADER) + KS_SIZE_PREHEADER)
// !!! for abnormal biSizes
#define KS_SIZE_VIDEOHEADER(pbmi) ((pbmi)->bmiHeader.biSize + KS_SIZE_PREHEADER)

// VBI
// Used for NABTS, CC, Intercast, WST
typedef struct tagKS_VBIINFOHEADER {
    ULONG       StartLine;              // inclusive
    ULONG       EndLine;                // inclusive
    ULONG       SamplingFrequency;      // Hz.
    ULONG       MinLineStartTime;       // microSec * 100 from HSync LE
    ULONG       MaxLineStartTime;       // microSec * 100 from HSync LE
    ULONG       ActualLineStartTime;    // microSec * 100 from HSync LE
    ULONG       ActualLineEndTime;      // microSec * 100 from HSync LE
    ULONG       VideoStandard;          // KS_AnalogVideoStandard*
    ULONG       SamplesPerLine;
    ULONG       StrideInBytes;          // May be > SamplesPerLine
    ULONG       BufferSize;             // Bytes
} KS_VBIINFOHEADER, *PKS_VBIINFOHEADER;

#if (NTDDI_VERSION >= NTDDI_WINXP)

// VBI Sampling Rates
#define KS_VBIDATARATE_NABTS            (5727272L)
#define KS_VBIDATARATE_CC               ( 503493L)    // ~= 1/1.986125e-6
#define KS_VBISAMPLINGRATE_4X_NABTS     ((long)(4*KS_VBIDATARATE_NABTS))
#define KS_VBISAMPLINGRATE_47X_NABTS    ((long)(27000000))
#define KS_VBISAMPLINGRATE_5X_NABTS     ((long)(5*KS_VBIDATARATE_NABTS))

#define KS_47NABTS_SCALER (KS_VBISAMPLINGRATE_47X_NABTS/(double)KS_VBIDATARATE_NABTS)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

// Analog video variant - Use this when the format is FORMAT_AnalogVideo
//
// rcSource defines the portion of the active video signal to use
// rcTarget defines the destination rectangle
//    both of the above are relative to the dwActiveWidth and dwActiveHeight fields
// dwActiveWidth is currently set to 720 for all formats (but could change for HDTV)
// dwActiveHeight is 483 for NTSC and 575 for PAL/SECAM  (but could change for HDTV)

typedef struct tagKS_AnalogVideoInfo {
    RECT            rcSource;           // Width max is 720, height varies w/ TransmissionStd
    RECT            rcTarget;           // Where the video should go
    DWORD           dwActiveWidth;      // Always 720 (CCIR-601 active samples per line)
    DWORD           dwActiveHeight;     // 483 for NTSC, 575 for PAL/SECAM
    REFERENCE_TIME  AvgTimePerFrame;    // Normal ActiveMovie units (100 nS)
} KS_ANALOGVIDEOINFO, *PKS_ANALOGVIDEOINFO;

//===========================================================================
// Data packet passed on Analog video stream channel change
//===========================================================================

#define KS_TVTUNER_CHANGE_BEGIN_TUNE    0x0001L  // Starting a tuning operation
#define KS_TVTUNER_CHANGE_END_TUNE      0x0002L  // Ending a tuning operation

typedef struct tagKS_TVTUNER_CHANGE_INFO {
   DWORD                    dwFlags;                // KS_TVTUNER_CHANGE_*
   DWORD                    dwCountryCode;
   DWORD                    dwAnalogVideoStandard;  // KS_AnalogVideoStandard
   DWORD                    dwChannel;
} KS_TVTUNER_CHANGE_INFO, *PKS_TVTUNER_CHANGE_INFO;

//===========================================================================
// Video format blocks
//===========================================================================

typedef enum {
    KS_MPEG2Level_Low,
    KS_MPEG2Level_Main,
    KS_MPEG2Level_High1440,
    KS_MPEG2Level_High
} KS_MPEG2Level;

typedef enum {
    KS_MPEG2Profile_Simple,
    KS_MPEG2Profile_Main,
    KS_MPEG2Profile_SNRScalable,
    KS_MPEG2Profile_SpatiallyScalable,
    KS_MPEG2Profile_High
} KS_MPEG2Profile;

#define KS_INTERLACE_IsInterlaced            0x00000001  // if 0, other interlace bits are irrelevent
#define KS_INTERLACE_1FieldPerSample         0x00000002  // else 2 fields per media sample
#define KS_INTERLACE_Field1First             0x00000004  // else Field 2 is first;  top field in PAL is field 1, top field in NTSC is field 2?
#define KS_INTERLACE_UNUSED                  0x00000008  //
#define KS_INTERLACE_FieldPatternMask        0x00000030  // use this mask with AMINTERLACE_FieldPat*
#define KS_INTERLACE_FieldPatField1Only      0x00000000  // Data never contains a Field2
#define KS_INTERLACE_FieldPatField2Only      0x00000010  // Data never contains a Field1
#define KS_INTERLACE_FieldPatBothRegular     0x00000020  // There will be a Field2 for every Field1 (required for Weave?)
#define KS_INTERLACE_FieldPatBothIrregular   0x00000030  // Random pattern of Field1s and Field2s
#define KS_INTERLACE_DisplayModeMask         0x000000c0
#define KS_INTERLACE_DisplayModeBobOnly      0x00000000
#define KS_INTERLACE_DisplayModeWeaveOnly    0x00000040
#define KS_INTERLACE_DisplayModeBobOrWeave   0x00000080

#define KS_COPYPROTECT_RestrictDuplication   0x00000001  // duplication of this stream should be restricted

#define KS_MPEG2_DoPanScan           0x00000001  //if set, the MPEG-2 video decoder should crop output image
                                                //  based on pan-scan vectors in picture_display_extension
                                                //  and change the picture aspect ratio accordingly.
#define KS_MPEG2_DVDLine21Field1     0x00000002  //if set, the MPEG-2 decoder must be able to produce an output
                                                //  pin for DVD style closed caption data found in GOP layer of field 1
#define KS_MPEG2_DVDLine21Field2     0x00000004  //if set, the MPEG-2 decoder must be able to produce an output
                                                //  pin for DVD style closed caption data found in GOP layer of field 2
#define KS_MPEG2_SourceIsLetterboxed 0x00000008  //if set, indicates that black bars have been encoded in the top
                                                //  and bottom of the video.
#define KS_MPEG2_FilmCameraMode      0x00000010  //if set, indicates "film mode" used for 625/50 content.  If cleared,
                                                //  indicates that "camera mode" was used.
#define KS_MPEG2_LetterboxAnalogOut  0x00000020  //if set and this stream is sent to an analog output, it should
                        //  be letterboxed.  Streams sent to VGA should be letterboxed only by renderers.
#define KS_MPEG2_DSS_UserData        0x00000040  //if set, the MPEG-2 decoder must process DSS style user data
#define KS_MPEG2_DVB_UserData        0x00000080  //if set, the MPEG-2 decoder must process DVB style user data
#define KS_MPEG2_27MhzTimebase       0x00000100  //if set, the PTS,DTS timestamps advance at 27MHz rather than 90KHz

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define KS_MPEG2_WidescreenAnalogOut 0x00000200  //if set and this stream is sent to an analog output, it should
                        //  be in widescreen format (4x3 content should be centered on a 16x9 output).
                        //  Streams sent to VGA should be widescreened only by renderers.

#define KS_AMCONTROL_USED              0x00000001 // Used to test if these flags are supported.  Set and test for AcceptMediaType.
                                                // If rejected, then you cannot use the AMCONTROL flags (send 0 for dwReserved1)
#define KS_AMCONTROL_PAD_TO_4x3        0x00000002 // if set means display the image in a 4x3 area
#define KS_AMCONTROL_PAD_TO_16x9       0x00000004 // if set means display the image in a 16x9 area
#define KS_AMCONTROL_COLORINFO_PRESENT 0x00000080 // if set, indicates DXVA color info is present in the upper (24) bits of the dwControlFlags

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

typedef struct tagKS_VIDEOINFOHEADER2 {
    RECT                rcSource;
    RECT                rcTarget;
    DWORD               dwBitRate;
    DWORD               dwBitErrorRate;
    REFERENCE_TIME      AvgTimePerFrame;
    DWORD               dwInterlaceFlags;   // use AMINTERLACE_* defines. Reject connection if undefined bits are not 0
    DWORD               dwCopyProtectFlags; // use KS_COPYPROTECT_* defines. Reject connection if undefined bits are not 0
    DWORD               dwPictAspectRatioX; // X dimension of picture aspect ratio, e.g. 16 for 16x9 display
    DWORD               dwPictAspectRatioY; // Y dimension of picture aspect ratio, e.g.  9 for 16x9 display
    union {
        DWORD dwControlFlags;               // use KS_AMCONTROL_* defines, use this from now on
        DWORD dwReserved1;                  // for backward compatiblity (was "must be 0";  connection rejected otherwise)
    };
    DWORD               dwReserved2;        // must be 0; reject connection otherwise
    KS_BITMAPINFOHEADER bmiHeader;
} KS_VIDEOINFOHEADER2, *PKS_VIDEOINFOHEADER2;

typedef struct tagKS_MPEG1VIDEOINFO {
    KS_VIDEOINFOHEADER hdr; // Compatible with VIDEOINFO
    DWORD dwStartTimeCode; // 25-bit Group of pictures time code at start of data
    DWORD cbSequenceHeader; // Length in bytes of bSequenceHeader
    BYTE bSequenceHeader[1]; // Sequence header including quantization matrices if any
} KS_MPEG1VIDEOINFO, *PKS_MPEG1VIDEOINFO;

#define KS_MAX_SIZE_MPEG1_SEQUENCE_INFO 140
#define KS_SIZE_MPEG1VIDEOINFO(pv) (FIELD_OFFSET(KS_MPEG1VIDEOINFO, bSequenceHeader[0]) + (pv)->cbSequenceHeader)
#define KS_MPEG1_SEQUENCE_INFO(pv) ((const BYTE *)(pv)->bSequenceHeader)

typedef struct tagKS_MPEGVIDEOINFO2 {
    KS_VIDEOINFOHEADER2 hdr;
    DWORD               dwStartTimeCode;        //  ?? not used for DVD ??
    DWORD               cbSequenceHeader;       // is 0 for DVD (no sequence header)
    DWORD               dwProfile;              // use enum MPEG2Profile
    DWORD               dwLevel;                // use enum MPEG2Level
    DWORD               dwFlags;                // use AMMPEG2_* defines.  Reject connection if undefined bits are not 0
    DWORD               bSequenceHeader[1];     // DWORD instead of Byte for alignment purposes
                                                //   For MPEG-2, if a sequence_header is included, the sequence_extension
                                                //   should also be included
} KS_MPEGVIDEOINFO2, *PKS_MPEGVIDEOINFO2;


typedef struct tagKS_H264VIDEOINFO {
    // from UVC 1.5 H.264 frame descriptor
    WORD wWidth;
    WORD wHeight;
    WORD wSARwidth;
    WORD wSARheight;
    WORD wProfile;
    BYTE bLevelIDC;
    WORD wConstrainedToolset;
    DWORD bmSupportedUsages;
    WORD bmCapabilities;
    DWORD bmSVCCapabilities;
    DWORD bmMVCCapabilities;
    DWORD dwFrameInterval;

    // from UVC 1.5 H.264 format descriptor
    BYTE bMaxCodecConfigDelay;
    BYTE bmSupportedSliceModes;
    BYTE bmSupportedSyncFrameTypes;
    BYTE bResolutionScaling;
    BYTE bSimulcastSupport;
    BYTE bmSupportedRateControlModes;
    WORD wMaxMBperSecOneResolutionNoScalability;
    WORD wMaxMBperSecTwoResolutionsNoScalability;
    WORD wMaxMBperSecThreeResolutionsNoScalability;
    WORD wMaxMBperSecFourResolutionsNoScalability;
    WORD wMaxMBperSecOneResolutionTemporalScalability;
    WORD wMaxMBperSecTwoResolutionsTemporalScalablility;
    WORD wMaxMBperSecThreeResolutionsTemporalScalability;
    WORD wMaxMBperSecFourResolutionsTemporalScalability;
    WORD wMaxMBperSecOneResolutionTemporalQualityScalability;
    WORD wMaxMBperSecTwoResolutionsTemporalQualityScalability;
    WORD wMaxMBperSecThreeResolutionsTemporalQualityScalablity;
    WORD wMaxMBperSecFourResolutionsTemporalQualityScalability;
    WORD wMaxMBperSecOneResolutionTemporalSpatialScalability;
    WORD wMaxMBperSecTwoResolutionsTemporalSpatialScalability;
    WORD wMaxMBperSecThreeResolutionsTemporalSpatialScalablity;
    WORD wMaxMBperSecFourResolutionsTemporalSpatialScalability;
    WORD wMaxMBperSecOneResolutionFullScalability;
    WORD wMaxMBperSecTwoResolutionsFullScalability;
    WORD wMaxMBperSecThreeResolutionsFullScalability;
    WORD wMaxMBperSecFourResolutionsFullScalability;
} KS_H264VIDEOINFO, *PKS_H264VIDEOINFO;


#define KS_SIZE_MPEGVIDEOINFO2(pv) (FIELD_OFFSET(KS_MPEGVIDEOINFO2, bSequenceHeader[0]) + (pv)->cbSequenceHeader)
#define KS_MPEG1_SEQUENCE_INFO(pv) ((const BYTE *)(pv)->bSequenceHeader)

//===========================================================================
// Audio format blocks
//===========================================================================

//if set, the PTS,DTS timestamps advance at 27MHz rather than 90KHz
#define KS_MPEGAUDIOINFO_27MhzTimebase      0x00000001

typedef struct tagKS_MPEAUDIOINFO {
    DWORD               dwFlags;            // use KS_MPEGAUDIOINFO_* defines.  Reject connection if undefined bits are not 0
    DWORD               dwReserved1;        // must be 0; reject connection otherwise
    DWORD               dwReserved2;        // must be 0; reject connection otherwise
    DWORD               dwReserved3;        // must be 0; reject connection otherwise
} KS_MPEGAUDIOINFO, *PKS_MPEGAUDIOINFO;

//===========================================================================
// Video DATAFORMATs
//===========================================================================

typedef struct tagKS_DATAFORMAT_VIDEOINFOHEADER {
    KSDATAFORMAT            DataFormat;
    KS_VIDEOINFOHEADER      VideoInfoHeader;
} KS_DATAFORMAT_VIDEOINFOHEADER, *PKS_DATAFORMAT_VIDEOINFOHEADER;

typedef struct tagKS_DATAFORMAT_VIDEOINFOHEADER2 {
    KSDATAFORMAT            DataFormat;
    KS_VIDEOINFOHEADER2     VideoInfoHeader2;
} KS_DATAFORMAT_VIDEOINFOHEADER2, *PKS_DATAFORMAT_VIDEOINFOHEADER2;

typedef struct tagKS_DATAFORMAT_MPEGVIDEOINFO2 {
    KSDATAFORMAT            DataFormat;
    KS_MPEGVIDEOINFO2       MpegVideoInfoHeader2;
} KS_DATAFORMAT_MPEGVIDEOINFO2, *PKS_DATAFORMAT_MPEGVIDEOINFO2;

typedef struct tagKS_DATAFORMAT_H264VIDEOINFO {
    KSDATAFORMAT            DataFormat;
    KS_H264VIDEOINFO        H264VideoInfoHeader;
} KS_DATAFORMAT_H264VIDEOINFO, *PKS_DATAFORMAT_H264VIDEOINFO;

typedef struct tagKS_DATAFORMAT_IMAGEINFO {
    KSDATAFORMAT            DataFormat;
    KS_BITMAPINFOHEADER     ImageInfoHeader;
} KS_DATAFORMAT_IMAGEINFO, *PKS_DATAFORMAT_IMAGEINFO;


typedef struct tagKS_DATAFORMAT_VIDEOINFO_PALETTE {
    KSDATAFORMAT            DataFormat;
    KS_VIDEOINFO            VideoInfo;
} KS_DATAFORMAT_VIDEOINFO_PALETTE, *PKS_DATAFORMAT_VIDEOINFO_PALETTE;

typedef struct tagKS_DATAFORMAT_VBIINFOHEADER {
    KSDATAFORMAT            DataFormat;
    KS_VBIINFOHEADER        VBIInfoHeader;
} KS_DATAFORMAT_VBIINFOHEADER, *PKS_DATAFORMAT_VBIINFOHEADER;

typedef struct  _KS_VIDEO_STREAM_CONFIG_CAPS  {
    GUID guid;                  // will be MEDIATYPE_Video
    ULONG VideoStandard;        // logical OR of all AnalogVideoStandards
                                // supported
    SIZE InputSize;             // the inherent size of the incoming signal
                                // (every pixel unique)
    SIZE MinCroppingSize;       // smallest rcSrc cropping rect allowed
    SIZE MaxCroppingSize;       // largest rcSrc cropping rect allowed
    int CropGranularityX;       // granularity of cropping size
    int CropGranularityY;
    int CropAlignX;             // alignment of cropping rect
    int CropAlignY;
    SIZE MinOutputSize;         // smallest bitmap stream can produce
    SIZE MaxOutputSize;         // largest  bitmap stream can produce
    int OutputGranularityX;     // granularity of output bitmap size
    int OutputGranularityY;
    int StretchTapsX;           // 0, no stretch, 1 pix dup, 2 interp, ...
    int StretchTapsY;           //    Describes quality of hardware scaler
    int ShrinkTapsX;            //
    int ShrinkTapsY;            //
    LONGLONG MinFrameInterval;  // 100 nS units
    LONGLONG MaxFrameInterval;
    LONG MinBitsPerSecond;
    LONG MaxBitsPerSecond;
} KS_VIDEO_STREAM_CONFIG_CAPS, *PKS_VIDEO_STREAM_CONFIG_CAPS;

//===========================================================================
// Video DATARANGEs
//===========================================================================

typedef struct tagKS_DATARANGE_VIDEO {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_VIDEOINFOHEADER           VideoInfoHeader;        // default format
} KS_DATARANGE_VIDEO, *PKS_DATARANGE_VIDEO;

typedef struct tagKS_DATARANGE_VIDEO2 {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_VIDEOINFOHEADER2          VideoInfoHeader;        // default format
} KS_DATARANGE_VIDEO2, *PKS_DATARANGE_VIDEO2;

typedef struct tagKS_DATARANGE_MPEG1_VIDEO {
    KSDATARANGE DataRange;
    BOOL bFixedSizeSamples; // all samples same size?
    BOOL bTemporalCompression; // all I frames?
    DWORD StreamDescriptionFlags; // KS_VIDEO_DESC_*
    DWORD MemoryAllocationFlags; // KS_VIDEO_ALLOC_*
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_MPEG1VIDEOINFO VideoInfoHeader; // default format
} KS_DATARANGE_MPEG1_VIDEO, *PKS_DATARANGE_MPEG1_VIDEO;

typedef struct tagKS_DATARANGE_MPEG2_VIDEO {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_MPEGVIDEOINFO2            VideoInfoHeader;        // default format
} KS_DATARANGE_MPEG2_VIDEO, *PKS_DATARANGE_MPEG2_VIDEO;

typedef struct tagKS_DATARANGE_H264_VIDEO {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_H264VIDEOINFO             VideoInfoHeader;        // default format
} KS_DATARANGE_H264_VIDEO, *PKS_DATARANGE_H264_VIDEO;

typedef struct tagKS_DATARANGE_IMAGE {
  KSDATARANGE                 DataRange;
  KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
  KS_BITMAPINFOHEADER         ImageInfoHeader;
} KS_DATARANGE_IMAGE, *PKS_DATARANGE_IMAGE;

typedef struct tagKS_DATARANGE_VIDEO_PALETTE {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_VIDEOINFO                 VideoInfo;              // default format
} KS_DATARANGE_VIDEO_PALETTE, *PKS_DATARANGE_VIDEO_PALETTE;

typedef struct tagKS_DATARANGE_VIDEO_VBI {
   KSDATARANGE                  DataRange;
   BOOL                         bFixedSizeSamples;      // all samples same size?
   BOOL                         bTemporalCompression;   // all I frames?
   DWORD                        StreamDescriptionFlags; // KS_VIDEO_DESC_*
   DWORD                        MemoryAllocationFlags;  // KS_VIDEO_ALLOC_*
   KS_VIDEO_STREAM_CONFIG_CAPS  ConfigCaps;
   KS_VBIINFOHEADER             VBIInfoHeader;          // default format
} KS_DATARANGE_VIDEO_VBI, *PKS_DATARANGE_VIDEO_VBI;

typedef struct tagKS_DATARANGE_ANALOGVIDEO {
   KSDATARANGE                  DataRange;
   KS_ANALOGVIDEOINFO           AnalogVideoInfo;
} KS_DATARANGE_ANALOGVIDEO, *PKS_DATARANGE_ANALOGVIDEO;

//===========================================================================
// StreamDescriptionFlags
//
// These define the "purpose" of each video stream
//===========================================================================

#define KS_VIDEOSTREAM_PREVIEW          0x0001  // Preview stream
#define KS_VIDEOSTREAM_CAPTURE          0x0002  // Capture stream
#define KS_VIDEOSTREAM_VBI              0x0010  // Field1 VBI
#define KS_VIDEOSTREAM_NABTS            0x0020  // Field1 NABTS
#define KS_VIDEOSTREAM_CC               0x0100  // Closed Captioning
#define KS_VIDEOSTREAM_EDS              0x0200  // Extended Data Services
#define KS_VIDEOSTREAM_TELETEXT         0x0400  // Field1 Teletext only
#define KS_VIDEOSTREAM_STILL            0x1000  // Still image input
#define KS_VIDEOSTREAM_IS_VPE           0x8000  // Is a VPE based stream?

// MemoryAllocationFlags
#define KS_VIDEO_ALLOC_VPE_SYSTEM       0x0001  // VPE surface in system memory
#define KS_VIDEO_ALLOC_VPE_DISPLAY      0x0002  // VPE surface in display memory
#define KS_VIDEO_ALLOC_VPE_AGP          0x0004  // VPE surface in AGP memory

#if (NTDDI_VERSION >= NTDDI_WINXP)

//////////////////////////////////////////////////////////////
// Capture driver VBI property sets
//////////////////////////////////////////////////////////////

// {F162C607-7B35-496f-AD7F-2DCA3B46B718}
#define STATIC_KSPROPSETID_VBICAP_PROPERTIES\
    0xf162c607, 0x7b35, 0x496f, 0xad, 0x7f, 0x2d, 0xca, 0x3b, 0x46, 0xb7, 0x18
DEFINE_GUIDSTRUCT("F162C607-7B35-496f-AD7F-2DCA3B46B718", KSPROPSETID_VBICAP_PROPERTIES);
#define KSPROPSETID_VBICAP_PROPERTIES DEFINE_GUIDNAMED(KSPROPSETID_VBICAP_PROPERTIES)

typedef enum {
    KSPROPERTY_VBICAP_PROPERTIES_PROTECTION = 0x01,
} KSPROPERTY_VBICAP;

typedef struct _VBICAP_PROPERTIES_PROTECTION_S {
    KSPROPERTY Property;
    ULONG      StreamIndex;                     // Index of stream
    ULONG      Status;
} VBICAP_PROPERTIES_PROTECTION_S, *PVBICAP_PROPERTIES_PROTECTION_S;
#define KS_VBICAP_PROTECTION_MV_PRESENT     0x0001L
#define KS_VBICAP_PROTECTION_MV_HARDWARE    0x0002L
#define KS_VBICAP_PROTECTION_MV_DETECTED    0x0004L

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

/***************************************************************************/
/* VBI Related GUIDs, structs and properties for codecs(generic, cc, nabts)*/
/***************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////
// IP/NABTS Protocol Reserved Group IDs - Overall Range 0x800-0x8FF [Decimal 2048-2079]
// Intervening values(0-F) are used if there are multiple providers at a particular tier
///////////////////////////////////////////////////////////////////////////////////////

// Used by individual content creators in show footage/data
#define KS_NABTS_GROUPID_ORIGINAL_CONTENT_BASE                 0x800
#define KS_NABTS_GROUPID_ORIGINAL_CONTENT_ADVERTISER_BASE      0x810

// Used by production company in finished show data
#define KS_NABTS_GROUPID_PRODUCTION_COMPANY_CONTENT_BASE       0x820
#define KS_NABTS_GROUPID_PRODUCTION_COMPANY_ADVERTISER_BASE    0x830

// Used by broadcast syndicates in syndicated show data
#define KS_NABTS_GROUPID_SYNDICATED_SHOW_CONTENT_BASE          0x840
#define KS_NABTS_GROUPID_SYNDICATED_SHOW_ADVERTISER_BASE       0x850

// Used by tv networks in network television data
#define KS_NABTS_GROUPID_NETWORK_WIDE_CONTENT_BASE             0x860
#define KS_NABTS_GROUPID_NETWORK_WIDE_ADVERTISER_BASE          0x870

// Used by telvision stations in local programming data
#define KS_NABTS_GROUPID_TELEVISION_STATION_CONTENT_BASE       0x880
#define KS_NABTS_GROUPID_TELEVISION_STATION_ADVERTISER_BASE    0x890

// Used by cable system in cable head-end originated data
#define KS_NABTS_GROUPID_LOCAL_CABLE_SYSTEM_CONTENT_BASE       0x8A0
#define KS_NABTS_GROUPID_LOCAL_CABLE_SYSTEM_ADVERTISER_BASE    0x8B0

// The values between 0x8C0 - 0x8EF are reserved for future expansion

// Used by Microsoft for Testing purposes (0x8F0 - 0x8FF)
#define KS_NABTS_GROUPID_MICROSOFT_RESERVED_TEST_DATA_BASE     0x8F0

//////////////////////////////////////////////////////////////
// Stream Format FEC-corrected NABTS bundles
//////////////////////////////////////////////////////////////

#define STATIC_KSDATAFORMAT_TYPE_NABTS \
 0xe757bca0, 0x39ac, 0x11d1, 0xa9, 0xf5, 0x0, 0xc0, 0x4f, 0xbb, 0xde, 0x8f
DEFINE_GUIDSTRUCT("E757BCA0-39AC-11d1-A9F5-00C04FBBDE8F", KSDATAFORMAT_TYPE_NABTS);
#define KSDATAFORMAT_TYPE_NABTS DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_NABTS)

#define STATIC_KSDATAFORMAT_SUBTYPE_NABTS_FEC \
 0xe757bca1, 0x39ac, 0x11d1, 0xa9, 0xf5, 0x0, 0xc0, 0x4f, 0xbb, 0xde, 0x8f
DEFINE_GUIDSTRUCT("E757BCA1-39AC-11d1-A9F5-00C04FBBDE8F", KSDATAFORMAT_SUBTYPE_NABTS_FEC);
#define KSDATAFORMAT_SUBTYPE_NABTS_FEC DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_NABTS_FEC)


//////////////////////////////////////////////////////////////
// NABTS Bundle data structure definition
//////////////////////////////////////////////////////////////

#define MAX_NABTS_VBI_LINES_PER_FIELD   11
#define NABTS_LINES_PER_BUNDLE          16
#define NABTS_PAYLOAD_PER_LINE          28
#define NABTS_BYTES_PER_LINE            36

typedef struct _NABTSFEC_BUFFER {
    ULONG       dataSize;
    USHORT      groupID;
    USHORT      Reserved;
    UCHAR       data[NABTS_LINES_PER_BUNDLE * NABTS_PAYLOAD_PER_LINE];
} NABTSFEC_BUFFER, *PNABTSFEC_BUFFER;

//////////////////////////////////////////////////////////////
// vbi codec filtering pin properties
//////////////////////////////////////////////////////////////

#define STATIC_KSPROPSETID_VBICodecFiltering \
    0xcafeb0caL, 0x8715, 0x11d0, 0xbd, 0x6a, 0x00, 0x35, 0xc0, 0xed, 0xba, 0xbe
DEFINE_GUIDSTRUCT("cafeb0ca-8715-11d0-bd6a-0035c0edbabe", KSPROPSETID_VBICodecFiltering);
#define KSPROPSETID_VBICodecFiltering DEFINE_GUIDNAMED(KSPROPSETID_VBICodecFiltering)

typedef enum {
    KSPROPERTY_VBICODECFILTERING_SCANLINES_REQUESTED_BIT_ARRAY = 0x01,
    KSPROPERTY_VBICODECFILTERING_SCANLINES_DISCOVERED_BIT_ARRAY,
    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_REQUESTED_BIT_ARRAY,
    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_DISCOVERED_BIT_ARRAY,
    KSPROPERTY_VBICODECFILTERING_STATISTICS,
} KSPROPERTY_VBICODECFILTERING;

typedef struct _VBICODECFILTERING_SCANLINES {
    DWORD   DwordBitArray[32];      // An array of scanline bits 0..1024(32*32)
} VBICODECFILTERING_SCANLINES, *PVBICODECFILTERING_SCANLINES;

typedef struct _VBICODECFILTERING_NABTS_SUBSTREAMS {
    DWORD   SubstreamMask[128];   // An array of 4096 bits (one for each NABTS GroupID)
} VBICODECFILTERING_NABTS_SUBSTREAMS, *PVBICODECFILTERING_NABTS_SUBSTREAMS;

typedef struct _VBICODECFILTERING_CC_SUBSTREAMS {
    DWORD   SubstreamMask;        // An array of 32 bits (see KS_CC_SUBSTREAM *)
} VBICODECFILTERING_CC_SUBSTREAMS, *PVBICODECFILTERING_CC_SUBSTREAMS;

// These KS_CC_SUBSTREAM_* bitmasks are used with VBICODECFILTERING_CC_SUBSTREAMS
#define KS_CC_SUBSTREAM_ODD               0x0001L // Unfiltered Field 1 Data
#define KS_CC_SUBSTREAM_EVEN              0x0002L // Unfiltered Field 2 Data

#if (NTDDI_VERSION >= NTDDI_WINXP)

// The following flags describe CC field 1 substreams: CC1,CC2,TT1,TT2
#define KS_CC_SUBSTREAM_FIELD1_MASK       0x00F0L
#define KS_CC_SUBSTREAM_SERVICE_CC1       0x0010L
#define KS_CC_SUBSTREAM_SERVICE_CC2       0x0020L
#define KS_CC_SUBSTREAM_SERVICE_T1        0x0040L
#define KS_CC_SUBSTREAM_SERVICE_T2        0x0080L

// The following flags describe CC field 2 substreams: CC3,CC4,TT3,TT4,XDS
#define KS_CC_SUBSTREAM_FIELD2_MASK       0x1F00L
#define KS_CC_SUBSTREAM_SERVICE_CC3       0x0100L
#define KS_CC_SUBSTREAM_SERVICE_CC4       0x0200L
#define KS_CC_SUBSTREAM_SERVICE_T3        0x0400L
#define KS_CC_SUBSTREAM_SERVICE_T4        0x0800L
#define KS_CC_SUBSTREAM_SERVICE_XDS       0x1000L

// Special Note: field 1 or 2 substreams are usually on found on field 1 and 2 respectively
// If the VBI odd/even polarity is reversed, the correct filtered data will still be found.

///////////////////////////////////////////////////////////////////
// Hardware decoded CC stream format
///////////////////////////////////////////////////////////////////

#define CC_MAX_HW_DECODE_LINES 12
typedef struct _CC_BYTE_PAIR {
    BYTE        Decoded[2];
    USHORT      Reserved;
} CC_BYTE_PAIR, *PCC_BYTE_PAIR;

typedef struct _CC_HW_FIELD {
    VBICODECFILTERING_SCANLINES  ScanlinesRequested;
    ULONG                        fieldFlags;    // KS_VBI_FLAG_FIELD1,2
    LONGLONG                     PictureNumber;
    CC_BYTE_PAIR                 Lines[CC_MAX_HW_DECODE_LINES];
} CC_HW_FIELD, *PCC_HW_FIELD;

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

///////////////////////////////////////////////////////////////////
// Raw NABTS stream format (TYPE_NABTS, SUBTYPE_NABTS)
///////////////////////////////////////////////////////////////////

// These low-level structures are byte packed( -Zp1 )
#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
#include <pshpack1.h>
#endif
typedef struct _NABTS_BUFFER_LINE {
    BYTE                            Confidence;
    BYTE                            Bytes[NABTS_BYTES_PER_LINE];
} NABTS_BUFFER_LINE, *PNABTS_BUFFER_LINE;

#define NABTS_BUFFER_PICTURENUMBER_SUPPORT 1
typedef struct _NABTS_BUFFER {
    VBICODECFILTERING_SCANLINES     ScanlinesRequested;
    LONGLONG                        PictureNumber;
    NABTS_BUFFER_LINE               NabtsLines[MAX_NABTS_VBI_LINES_PER_FIELD];
} NABTS_BUFFER, *PNABTS_BUFFER;
#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
#include <poppack.h>
#endif

#if (NTDDI_VERSION >= NTDDI_WINXP)

//////////////////////////////////////////////////////////////
// WST Codec Teletext Media Sample Format
//////////////////////////////////////////////////////////////

#define WST_TVTUNER_CHANGE_BEGIN_TUNE    0x1000L  // Starting a tuning operation
#define WST_TVTUNER_CHANGE_END_TUNE      0x2000L  // Ending a tuning operation

#define MAX_WST_VBI_LINES_PER_FIELD   17
#define WST_BYTES_PER_LINE            42

typedef struct _WST_BUFFER_LINE {
    BYTE                            Confidence;
    BYTE                            Bytes[WST_BYTES_PER_LINE];
} WST_BUFFER_LINE, *PWST_BUFFER_LINE;

typedef struct _WST_BUFFER {
    VBICODECFILTERING_SCANLINES        ScanlinesRequested;
    WST_BUFFER_LINE                    WstLines[MAX_WST_VBI_LINES_PER_FIELD];
} WST_BUFFER, *PWST_BUFFER;

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

//
// Common codec statistics
//

typedef struct _VBICODECFILTERING_STATISTICS_COMMON {
    DWORD   InputSRBsProcessed;         // upstream SRBs received
    DWORD   OutputSRBsProcessed;        // downstream SRBs sent
    DWORD   SRBsIgnored;                // SRBs ignored due to no requests
    DWORD   InputSRBsMissing;           // SRBs dropped upstream
    DWORD   OutputSRBsMissing;          // Output dropped because no SRB pending
    DWORD   OutputFailures;             // dropped because of other failure
    DWORD   InternalErrors;             // could not process due to int. failure
    DWORD   ExternalErrors;             // could not process due to ext. failure
    DWORD   InputDiscontinuities;       // discontinuities received
    DWORD   DSPFailures;                // DSP confidence failure
    DWORD   TvTunerChanges;             // number of received KS_TVTUNER_CHANGE_BEGIN_TUNE and KS_TVTUNER_CHANGE_END_TUNE pairs.
    DWORD   VBIHeaderChanges;           // number of received KS_VBI_FLAG_VBIINFOHEADER_CHANGE
    DWORD   LineConfidenceAvg;          // Average of all DSP confidence results
    DWORD   BytesOutput;                // Bytes sent downstream
} VBICODECFILTERING_STATISTICS_COMMON, *PVBICODECFILTERING_STATISTICS_COMMON;

typedef struct _VBICODECFILTERING_STATISTICS_COMMON_PIN {
    DWORD   SRBsProcessed;              // SRBs sent/received
    DWORD   SRBsIgnored;                // SRBs ignored due to filtering
    DWORD   SRBsMissing;                // SRBs not sent/received
    DWORD   InternalErrors;             // could not send/receive due to int. failure
    DWORD   ExternalErrors;             // could not send/receive due to ext. failure
    DWORD   Discontinuities;            // discontinuities received/sent
    DWORD   LineConfidenceAvg;          // Average of all DSP confidence results for this pin
    DWORD   BytesOutput;                // Bytes sent downstream
} VBICODECFILTERING_STATISTICS_COMMON_PIN, *PVBICODECFILTERING_STATISTICS_COMMON_PIN;

//
// Codec-specific statistics - NABTS
//

typedef struct _VBICODECFILTERING_STATISTICS_NABTS {
    VBICODECFILTERING_STATISTICS_COMMON Common; // Generic VBI statistics
    DWORD   FECBundleBadLines;          // Un-FEC-correctable lines
    DWORD   FECQueueOverflows;          // Number of times FEC queue overflowed
    DWORD   FECCorrectedLines;          // Lines CSUM corrected by FEC
    DWORD   FECUncorrectableLines;      // FEC input lines not CSUM correctable
    DWORD   BundlesProcessed;           // Bundles received from FEC
    DWORD   BundlesSent2IP;             // Bundles sent to IP driver
    DWORD   FilteredLines;              // Lines processed and then dropped
                                        // because no one was interested
} VBICODECFILTERING_STATISTICS_NABTS, *PVBICODECFILTERING_STATISTICS_NABTS;

typedef struct _VBICODECFILTERING_STATISTICS_NABTS_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;// Generic VBI pin statistics
} VBICODECFILTERING_STATISTICS_NABTS_PIN, *PVBICODECFILTERING_STATISTICS_NABTS_PIN;

//
// Codec-specific statistics - Closed Caption
//

typedef struct _VBICODECFILTERING_STATISTICS_CC {
    VBICODECFILTERING_STATISTICS_COMMON Common; // Generic VBI statistics
} VBICODECFILTERING_STATISTICS_CC, *PVBICODECFILTERING_STATISTICS_CC;


typedef struct _VBICODECFILTERING_STATISTICS_CC_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;// Generic VBI pin statistics
} VBICODECFILTERING_STATISTICS_CC_PIN, *PVBICODECFILTERING_STATISTICS_CC_PIN;

#if (NTDDI_VERSION >= NTDDI_WINXP)

//
// Codec-specific statistics - Teletext
//

typedef struct _VBICODECFILTERING_STATISTICS_TELETEXT {
    VBICODECFILTERING_STATISTICS_COMMON Common; // Generic VBI statistics
} VBICODECFILTERING_STATISTICS_TELETEXT, *PVBICODECFILTERING_STATISTICS_TELETEXT;

typedef struct _VBICODECFILTERING_STATISTICS_TELETEXT_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;// Generic VBI pin statistics
} VBICODECFILTERING_STATISTICS_TELETEXT_PIN, *PVBICODECFILTERING_STATISTICS_TELETEXT_PIN;

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

////////////////////////////////////////////////////////////////////////////
// VBI codec property structures(based on KSPROPERTY_VBICODECFILTERING enum)
////////////////////////////////////////////////////////////////////////////

// *** Most codecs support this property
//    KSPROPERTY_VBICODECFILTERING_SCANLINES_REQUESTED_BIT_ARRAY
//    KSPROPERTY_VBICODECFILTERING_SCANLINES_DISCOVERED_BIT_ARRAY,
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_SCANLINES         Scanlines;
} KSPROPERTY_VBICODECFILTERING_SCANLINES_S, *PKSPROPERTY_VBICODECFILTERING_SCANLINES_S;

// *** NABTS codecs support this property
//    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_REQUESTED_BIT_ARRAY,
//    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_DISCOVERED_BIT_ARRAY,
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_NABTS_SUBSTREAMS  Substreams;
} KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S, *PKSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S;

// *** Closed captioning codecs support this property
//    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_REQUESTED_BIT_ARRAY,
//    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_DISCOVERED_BIT_ARRAY,
typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_CC_SUBSTREAMS         Substreams;
} KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S, *PKSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S;

// *** Most codecs support these versions of the global and pin properties
//    KSPROPERTY_VBICODECFILTERING_STATISTICS
typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_COMMON     Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S;

typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_COMMON_PIN Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S;

// *** NABTS codecs support this version of the global and pin properties
//    KSPROPERTY_VBICODECFILTERING_STATISTICS
typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_NABTS      Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_S;

typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_NABTS_PIN  Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_PIN_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_PIN_S;

// *** Closed captioning codecs support this version of the global and pin properties
//    KSPROPERTY_VBICODECFILTERING_STATISTICS

typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_CC         Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S;

typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_CC_PIN     Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S, *PKSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S;

// Standard Pin Names for the video capture filter
//===========================================================================

#define STATIC_PINNAME_VIDEO_CAPTURE \
    0xfb6c4281, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
#define STATIC_PINNAME_CAPTURE STATIC_PINNAME_VIDEO_CAPTURE
DEFINE_GUIDSTRUCT("FB6C4281-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_CAPTURE);
#define PINNAME_VIDEO_CAPTURE DEFINE_GUIDNAMED(PINNAME_VIDEO_CAPTURE)
#define PINNAME_CAPTURE PINNAME_VIDEO_CAPTURE

#if (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_PINNAME_VIDEO_CC_CAPTURE \
    0x1aad8061, 0x12d, 0x11d2, 0xb4, 0xb1, 0x0, 0xa0, 0xd1, 0x2, 0xcf, 0xbe
#define STATIC_PINNAME_CC_CAPTURE STATIC_PINNAME_VIDEO_CC_CAPTURE
DEFINE_GUIDSTRUCT("1AAD8061-012D-11d2-B4B1-00A0D102CFBE", PINNAME_VIDEO_CC_CAPTURE);
#define PINNAME_VIDEO_CC_CAPTURE DEFINE_GUIDNAMED(PINNAME_VIDEO_CC_CAPTURE)

#define STATIC_PINNAME_VIDEO_NABTS_CAPTURE \
    0x29703660, 0x498a, 0x11d2, 0xb4, 0xb1, 0x0, 0xa0, 0xd1, 0x2, 0xcf, 0xbe
#define STATIC_PINNAME_NABTS_CAPTURE STATIC_PINNAME_VIDEO_NABTS_CAPTURE
DEFINE_GUIDSTRUCT("29703660-498A-11d2-B4B1-00A0D102CFBE", PINNAME_VIDEO_NABTS_CAPTURE);
#define PINNAME_VIDEO_NABTS_CAPTURE DEFINE_GUIDNAMED(PINNAME_VIDEO_NABTS_CAPTURE)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define STATIC_PINNAME_VIDEO_PREVIEW \
    0xfb6c4282, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
#define STATIC_PINNAME_PREVIEW STATIC_PINNAME_VIDEO_PREVIEW
DEFINE_GUIDSTRUCT("FB6C4282-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_PREVIEW);
#define PINNAME_VIDEO_PREVIEW DEFINE_GUIDNAMED(PINNAME_VIDEO_PREVIEW)
#define PINNAME_PREVIEW PINNAME_VIDEO_PREVIEW

#define STATIC_PINNAME_VIDEO_ANALOGVIDEOIN \
    0xfb6c4283, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4283-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_ANALOGVIDEOIN);
#define PINNAME_VIDEO_ANALOGVIDEOIN DEFINE_GUIDNAMED(PINNAME_VIDEO_ANALOGVIDEOIN)

#define STATIC_PINNAME_VIDEO_VBI \
    0xfb6c4284, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4284-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_VBI);
#define PINNAME_VIDEO_VBI DEFINE_GUIDNAMED(PINNAME_VIDEO_VBI)

#define STATIC_PINNAME_VIDEO_VIDEOPORT \
    0xfb6c4285, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4285-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_VIDEOPORT);
#define PINNAME_VIDEO_VIDEOPORT DEFINE_GUIDNAMED(PINNAME_VIDEO_VIDEOPORT)

#define STATIC_PINNAME_VIDEO_NABTS \
    0xfb6c4286, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4286-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_NABTS);
#define PINNAME_VIDEO_NABTS DEFINE_GUIDNAMED(PINNAME_VIDEO_NABTS)

#define STATIC_PINNAME_VIDEO_EDS \
    0xfb6c4287, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4287-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_EDS);
#define PINNAME_VIDEO_EDS DEFINE_GUIDNAMED(PINNAME_VIDEO_EDS)

#define STATIC_PINNAME_VIDEO_TELETEXT \
    0xfb6c4288, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4288-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_TELETEXT);
#define PINNAME_VIDEO_TELETEXT DEFINE_GUIDNAMED(PINNAME_VIDEO_TELETEXT)

#define STATIC_PINNAME_VIDEO_CC \
    0xfb6c4289, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C4289-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_CC);
#define PINNAME_VIDEO_CC DEFINE_GUIDNAMED(PINNAME_VIDEO_CC)

#define STATIC_PINNAME_VIDEO_STILL \
    0xfb6c428A, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C428A-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_STILL);
#define PINNAME_VIDEO_STILL DEFINE_GUIDNAMED(PINNAME_VIDEO_STILL)

#define STATIC_PINNAME_IMAGE \
    0x38a0cd98, 0xd49b, 0x4ce8, 0xb4, 0x8a, 0x34, 0x46, 0x67, 0xa1, 0x78, 0x30
DEFINE_GUIDSTRUCT("38A0CD98-D49B-4ce8-B48A-344667A17830", PINNAME_IMAGE);
#define PINNAME_IMAGE DEFINE_GUIDNAMED(PINNAME_IMAGE)

#define STATIC_PINNAME_VIDEO_TIMECODE \
    0xfb6c428B, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C428B-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_TIMECODE);
#define PINNAME_VIDEO_TIMECODE DEFINE_GUIDNAMED(PINNAME_VIDEO_TIMECODE)

#define STATIC_PINNAME_VIDEO_VIDEOPORT_VBI \
    0xfb6c428C, 0x353, 0x11d1, 0x90, 0x5f, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("FB6C428C-0353-11d1-905F-0000C0CC16BA", PINNAME_VIDEO_VIDEOPORT_VBI);
#define PINNAME_VIDEO_VIDEOPORT_VBI DEFINE_GUIDNAMED(PINNAME_VIDEO_VIDEOPORT_VBI)

// KSPROPSETID_VIDMEM_TRANSPORT related guids, structs and enums
//===========================================================================

//
// Capture MemoryAllocationFlags
//
typedef enum {
        KS_CAPTURE_ALLOC_INVALID                = 0,
        KS_CAPTURE_ALLOC_SYSTEM                 = 0x0001,  // surface in system memory
        KS_CAPTURE_ALLOC_VRAM                   = 0x0002,  // surface in display memory
        KS_CAPTURE_ALLOC_SYSTEM_AGP             = 0x0004,  // surface in system memory tagged as AGP accessible
        KS_CAPTURE_ALLOC_VRAM_MAPPED            = 0x0008,  // surface in system memory mapped into VRAM address space
        KS_CAPTURE_ALLOC_SECURE_BUFFER          = 0x0010   // secure buffer in VTL1
}CAPTURE_MEMORY_ALLOCATION_FLAGS, *PCAPTURE_MEMORY_ALLOCATION_FLAGS;

//
//Video memory capture KSPROPSETID
//
#define STATIC_KSPROPSETID_VramCapture\
    0xe73face3, 0x2880, 0x4902, 0xb7, 0x99, 0x88, 0xd0, 0xcd, 0x63, 0x4e, 0xf
DEFINE_GUIDSTRUCT("E73FACE3-2880-4902-B799-88D0CD634E0F", KSPROPSETID_VramCapture);
#define KSPROPSETID_VramCapture DEFINE_GUIDNAMED(KSPROPSETID_VramCapture)

typedef enum { 
    //
    // enum value '0' means an invalid KSPROPERTY request. 
    // Drivers should return an error.
    //
    KSPROPERTY_DISPLAY_ADAPTER_GUID = 1,                        //Returns the Adapter GUID. 
    KSPROPERTY_PREFERRED_CAPTURE_SURFACE,                       //Returns the memory surface preferred by that pin
    KSPROPERTY_CURRENT_CAPTURE_SURFACE,                         //Sets/Gets currently selected capture surface
    KSPROPERTY_MAP_CAPTURE_HANDLE_TO_VRAM_ADDRESS       //Maps VRAM surface handle to VRAM physical address
} KSPROPERTY_VIDMEM_TRANSPORT;

#define DEFINE_KSPROPERTY_ITEM_DISPLAY_ADAPTER_GUID(GetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_DISPLAY_ADAPTER_GUID,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(GUID),\
        NULL,\
        NULL, 0, NULL, NULL, 0)
#define DEFINE_KSPROPERTY_PREFERRED_CAPTURE_SURFACE(GetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_PREFERRED_CAPTURE_SURFACE,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(CAPTURE_MEMORY_ALLOCATION_FLAGS),\
        NULL,\
        NULL, 0, NULL, NULL, 0)
#define DEFINE_KSPROPERTY_CURRENT_CAPTURE_SURFACE(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_CURRENT_CAPTURE_SURFACE,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(CAPTURE_MEMORY_ALLOCATION_FLAGS),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)
#define DEFINE_KSPROPERTY_MAP_CAPTURE_HANDLE_TO_VRAM_ADDRESS(GetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_MAP_CAPTURE_HANDLE_TO_VRAM_ADDRESS,\
        (GetHandler),\
        sizeof(VRAM_SURFACE_INFO_PROPERTY_S),\
        sizeof(DWORD),\
        NULL,\
        NULL, 0, NULL, NULL, 0)

//
//Surface info passed on to the mini driver. 
//
typedef struct {
    UINT_PTR hSurface;
    LONGLONG VramPhysicalAddress;
    DWORD cbCaptured;
    DWORD dwWidth; 
    DWORD dwHeight;
    DWORD dwLinearSize;
    LONG  lPitch;  
    ULONGLONG ullReserved[16];
} VRAM_SURFACE_INFO, *PVRAM_SURFACE_INFO;

typedef struct {
        KSPROPERTY Property;
        PVRAM_SURFACE_INFO pVramSurfaceInfo;
}VRAM_SURFACE_INFO_PROPERTY_S, *PVRAM_SURFACE_INFO_PROPERTY_S;

//
//Secure buffer info passed on to the mini driver. 
//
typedef struct {
    GUID guidBufferIdentifier;
    DWORD cbBufferSize;
    DWORD cbCaptured;
    ULONGLONG ullReserved[16];
} SECURE_BUFFER_INFO, *PSECURE_BUFFER_INFO;

// Sceanrio ID for secure buffer for camera
#define STATIC_KS_SECURE_CAMERA_SCENARIO_ID \
    0xAE53FC6E, 0x8D89, 0x4488, 0x9D, 0x2E, 0x4D, 0x00, 0x87, 0x31, 0xC5, 0xFD
DEFINE_GUIDSTRUCT("AE53FC6E-8D89-4488-9D2E-4D008731C5FD", KS_SECURE_CAMERA_SCENARIO_ID);
#define KS_SECURE_CAMERA_SCENARIO_ID DEFINE_GUIDNAMED(KS_SECURE_CAMERA_SCENARIO_ID)

#define STATIC_KSPROPSETID_MPEG4_MediaType_Attributes\
    0xff6c4bfa, 0x7a9, 0x4c7b, 0xa2, 0x37, 0x67, 0x2f, 0x9d, 0x68, 0x6, 0x5f
DEFINE_GUIDSTRUCT("FF6C4BFA-07A9-4c7b-A237-672F9D68065F", KSPROPSETID_MPEG4_MediaType_Attributes);
#define KSPROPSETID_MPEG4_MediaType_Attributes DEFINE_GUIDNAMED(KSPROPSETID_MPEG4_MediaType_Attributes)

typedef enum {
    KSPROPERTY_MPEG4_MEDIATYPE_SD_BOX = 1
}KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES;

#define STATIC_KSEVENTSETID_DynamicFormatChange\
    0x162ac456, 0x83d7, 0x4239, 0x96, 0xdf, 0xc7, 0x5f, 0xfa, 0x13, 0x8b, 0xc6
DEFINE_GUIDSTRUCT("162AC456-83D7-4239-96DF-C75FFA138BC6", KSEVENTSETID_DynamicFormatChange);
#define KSEVENTSETID_DynamicFormatChange DEFINE_GUIDNAMED(KSEVENTSETID_DynamicFormatChange)

typedef enum {
    KSEVENT_DYNAMIC_FORMAT_CHANGE = 0
} KSEVENT_DYNAMICFORMATCHANGE;

//===========================================================================
// KSSTREAM_HEADER extensions for digital video
//===========================================================================

#define KS_VIDEO_FLAG_FIELD_MASK   0x0003L        // Frame or Field (default is frame)
#define KS_VIDEO_FLAG_FRAME        0x0000L        // Frame or Field (default is frame)
#define KS_VIDEO_FLAG_FIELD1       0x0001L
#define KS_VIDEO_FLAG_FIELD2       0x0002L
#define KS_VIDEO_FLAG_FIELD1FIRST  0x0004L
#define KS_VIDEO_FLAG_WEAVE        0x0008L

#define KS_VIDEO_FLAG_IPB_MASK     0x0030L        // I, B, or P (default is I)
#define KS_VIDEO_FLAG_I_FRAME      0x0000L        // I, B, or P (default is I)
#define KS_VIDEO_FLAG_P_FRAME      0x0010L
#define KS_VIDEO_FLAG_B_FRAME      0x0020L
#define KS_VIDEO_FLAG_REPEAT_FIELD 0x0040L


typedef struct tagKS_FRAME_INFO {
    ULONG                   ExtendedHeaderSize; // Size of this extended header
    DWORD                   dwFrameFlags;       // Field1, Field2, or Frame
    LONGLONG                PictureNumber;
    LONGLONG                DropCount;

    // The following are only set when using OverlayMixer
    HANDLE                  hDirectDraw;        // user mode DDraw handle
    HANDLE                  hSurfaceHandle;     // user mode surface handle
    RECT                    DirectDrawRect;     // portion of surface locked
    union {
        LONG                    lSurfacePitch;
  // Contains surface pitch a.k.a stride
        DWORD                   Reserved1;
    };

    DWORD                   Reserved2;

    union {
        struct { 
            DWORD       Reserved3;
            DWORD       Reserved4;
        };
        ULONGLONG   FrameCompletionNumber;
    };

} KS_FRAME_INFO, *PKS_FRAME_INFO;

//===========================================================================
// KSSTREAM_HEADER extensions for VBI
//===========================================================================

#if (NTDDI_VERSION < NTDDI_WINXP)
#define KS_VBI_FLAG_FRAME                0x0000L // Frame or Field (default is frame)
#endif
#define KS_VBI_FLAG_FIELD1               0x0001L
#define KS_VBI_FLAG_FIELD2               0x0002L

#if (NTDDI_VERSION >= NTDDI_WINXP)
#define KS_VBI_FLAG_MV_PRESENT           0x0100L
#define KS_VBI_FLAG_MV_HARDWARE          0x0200L
#define KS_VBI_FLAG_MV_DETECTED          0x0400L
#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#define KS_VBI_FLAG_TVTUNER_CHANGE       0x0010L // TvTunerChangeInfo is valid
#define KS_VBI_FLAG_VBIINFOHEADER_CHANGE 0x0020L // VBIInfoHeader is valid

typedef struct tagKS_VBI_FRAME_INFO {
    ULONG                   ExtendedHeaderSize; // Size of this extended header
    DWORD                   dwFrameFlags;  // Field1, Field2, or Frame; & etc
    LONGLONG                PictureNumber; // Test only?
    LONGLONG                DropCount;     // Test only?
    DWORD                   dwSamplingFrequency;
    KS_TVTUNER_CHANGE_INFO  TvTunerChangeInfo;
    KS_VBIINFOHEADER        VBIInfoHeader;
    //
    //The following are for VRAM surface transport to support LDDM Capture
    //
        //VRAM_SURFACE_INFO             VramSurfaceInfo;    
} KS_VBI_FRAME_INFO, *PKS_VBI_FRAME_INFO;


//===========================================================================
// Analog video formats, used with:
//      Analog Video Decoders
//      TVTuners
//      Analog Video Encoders
//
// XXX_STANDARDS_SUPPORTED returns a bitmask
//===========================================================================

typedef enum
{
    KS_AnalogVideo_None     = 0x00000000,  // This is a digital sensor
    KS_AnalogVideo_NTSC_M   = 0x00000001,  //        75 IRE Setup
    KS_AnalogVideo_NTSC_M_J = 0x00000002,  // Japan,  0 IRE Setup
    KS_AnalogVideo_NTSC_433 = 0x00000004,

    KS_AnalogVideo_PAL_B    = 0x00000010,
    KS_AnalogVideo_PAL_D    = 0x00000020,
    KS_AnalogVideo_PAL_G    = 0x00000040,
    KS_AnalogVideo_PAL_H    = 0x00000080,
    KS_AnalogVideo_PAL_I    = 0x00000100,
    KS_AnalogVideo_PAL_M    = 0x00000200,
    KS_AnalogVideo_PAL_N    = 0x00000400,

    KS_AnalogVideo_PAL_60   = 0x00000800,

    KS_AnalogVideo_SECAM_B  = 0x00001000,
    KS_AnalogVideo_SECAM_D  = 0x00002000,
    KS_AnalogVideo_SECAM_G  = 0x00004000,
    KS_AnalogVideo_SECAM_H  = 0x00008000,
    KS_AnalogVideo_SECAM_K  = 0x00010000,
    KS_AnalogVideo_SECAM_K1 = 0x00020000,
    KS_AnalogVideo_SECAM_L  = 0x00040000,
    KS_AnalogVideo_SECAM_L1 = 0x00080000

#if (NTDDI_VERSION >= NTDDI_WINXP)
    , KS_AnalogVideo_PAL_N_COMBO
                            = 0x00100000
#endif // (NTDDI_VERSION >= NTDDI_WINXP)

} KS_AnalogVideoStandard;

#define KS_AnalogVideo_NTSC_Mask  0x00000007
#if (NTDDI_VERSION >= NTDDI_WINXP)
#define KS_AnalogVideo_PAL_Mask   0x00100FF0
#else
#define KS_AnalogVideo_PAL_Mask   0x00000FF0
#endif
#define KS_AnalogVideo_SECAM_Mask 0x000FF000

//===========================================================================
// Property set definitions
// The comments show whether a given property is:
//      R  : READ only
//      w  : WRITE only
//      RW : READ / WRITE
//      O  : Optional (return E_UNSUPPORTED if you don't handle this)
//===========================================================================

#define STATIC_PROPSETID_ALLOCATOR_CONTROL\
    0x53171960, 0x148e, 0x11d2, 0x99, 0x79, 0x0, 0x0, 0xc0, 0xcc, 0x16, 0xba
DEFINE_GUIDSTRUCT("53171960-148E-11d2-9979-0000C0CC16BA", PROPSETID_ALLOCATOR_CONTROL);
#define PROPSETID_ALLOCATOR_CONTROL DEFINE_GUIDNAMED(PROPSETID_ALLOCATOR_CONTROL)
typedef enum {
    KSPROPERTY_ALLOCATOR_CONTROL_HONOR_COUNT,      // R O (will allocate exactly this number of buffers)
    KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE      // R O (return 2 DWORDs specifying surface size)

#if (NTDDI_VERSION >= NTDDI_WINXP)

    // W I (informn a capture driver whether interleave capture is possible or
    //      not - a value of 1 means that interleaved capture is supported)
    , KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS
 
    // R O (if value == 1, then the ovmixer will turn on the DDVP_INTERLEAVE
    //      flag thus allowing interleaved capture of the video)
    , KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

} KSPROPERTY_ALLOCATOR_CONTROL;

#if (NTDDI_VERSION >= NTDDI_WINXP)

typedef struct {
    //KSPROPERTY Property;
    ULONG       CX;
        ULONG   CY;
} KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S, *PKSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S; 
 
typedef struct {
    //KSPROPERTY Property;
    ULONG       InterleavedCapSupported;
} KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S, *PKSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S;

 
typedef struct {
    //KSPROPERTY Property;
    ULONG       InterleavedCapPossible;
} KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S, *PKSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S;

#endif // (NTDDI_VERSION >= NTDDI_WINXP)


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion
//===========================================================================

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

#define STATIC_PROPSETID_VIDCAP_VIDEOPROCAMP\
    0xC6E13360L, 0x30AC, 0x11d0, 0xa1, 0x8c, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("C6E13360-30AC-11d0-A18C-00A0C9118956", PROPSETID_VIDCAP_VIDEOPROCAMP);
#define PROPSETID_VIDCAP_VIDEOPROCAMP DEFINE_GUIDNAMED(PROPSETID_VIDCAP_VIDEOPROCAMP)

typedef enum {
    KSPROPERTY_VIDEOPROCAMP_BRIGHTNESS,                 // RW O
    KSPROPERTY_VIDEOPROCAMP_CONTRAST,                   // RW O
    KSPROPERTY_VIDEOPROCAMP_HUE,                        // RW O
    KSPROPERTY_VIDEOPROCAMP_SATURATION,                 // RW O
    KSPROPERTY_VIDEOPROCAMP_SHARPNESS,                  // RW O
    KSPROPERTY_VIDEOPROCAMP_GAMMA,                      // RW O
    KSPROPERTY_VIDEOPROCAMP_COLORENABLE,                // RW O
    KSPROPERTY_VIDEOPROCAMP_WHITEBALANCE,               // RW O
    KSPROPERTY_VIDEOPROCAMP_BACKLIGHT_COMPENSATION      // RW O

#if (NTDDI_VERSION >= NTDDI_WINXP)

    , KSPROPERTY_VIDEOPROCAMP_GAIN                      // RW O

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

    , KSPROPERTY_VIDEOPROCAMP_DIGITAL_MULTIPLIER        // RW O
    , KSPROPERTY_VIDEOPROCAMP_DIGITAL_MULTIPLIER_LIMIT  // RW O
    , KSPROPERTY_VIDEOPROCAMP_WHITEBALANCE_COMPONENT    // RW O
    , KSPROPERTY_VIDEOPROCAMP_POWERLINE_FREQUENCY       // RW O    

#endif // XP SP2 and later (chronologically)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

} KSPROPERTY_VIDCAP_VIDEOPROCAMP;

typedef struct {
    KSPROPERTY Property;
    LONG   Value;                       // Value to set or get
    ULONG  Flags;                       // KSPROPERTY_VIDEOPROCAMP_FLAGS_*
    ULONG  Capabilities;                // KSPROPERTY_VIDEOPROCAMP_FLAGS_*
} KSPROPERTY_VIDEOPROCAMP_S, *PKSPROPERTY_VIDEOPROCAMP_S;

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

typedef struct {
    KSP_NODE NodeProperty;
    LONG  Value;                        // Value to set or get
    ULONG Flags;                        // KSPROPERTY_VIDEOPROCAMP_FLAGS_*
    ULONG Capabilities;                 // KSPROPERTY_VIDEOPROCAMP_FLAGS_*
} KSPROPERTY_VIDEOPROCAMP_NODE_S, *PKSPROPERTY_VIDEOPROCAMP_NODE_S;

typedef struct {
    KSPROPERTY Property;
    LONG Value1;
    ULONG Flags;
    ULONG Capabilities;
    LONG Value2;
} KSPROPERTY_VIDEOPROCAMP_S2, *PKSPROPERTY_VIDEOPROCAMP_S2;

typedef struct {
    KSP_NODE NodeProperty;
    LONG Value1;
    ULONG Flags;
    ULONG Capabilities;
    LONG Value2;
} KSPROPERTY_VIDEOPROCAMP_NODE_S2, *PKSPROPERTY_VIDEOPROCAMP_NODE_S2;

#endif // XP SP2 and later (chronologically)

#define KSPROPERTY_VIDEOPROCAMP_FLAGS_AUTO        0X0001L
#define KSPROPERTY_VIDEOPROCAMP_FLAGS_MANUAL      0X0002L

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion
//===========================================================================

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

#define STATIC_PROPSETID_VIDCAP_SELECTOR \
    0x1ABDAECA, 0x68B6, 0x4F83, 0x93, 0x71, 0xB4, 0x13, 0x90, 0x7C, 0x7B, 0x9F
DEFINE_GUIDSTRUCT("1ABDAECA-68B6-4F83-9371-B413907C7B9F", PROPSETID_VIDCAP_SELECTOR);
#define PROPSETID_VIDCAP_SELECTOR DEFINE_GUIDNAMED(PROPSETID_VIDCAP_SELECTOR)

typedef enum {
    KSPROPERTY_SELECTOR_SOURCE_NODE_ID,              // RW
    KSPROPERTY_SELECTOR_NUM_SOURCES                  // R
} KSPROPERTY_VIDCAP_SELECTOR, *PKSPROPERTY_VIDCAP_SELECTOR;

typedef struct {
    KSPROPERTY Property;
    LONG  Value;                        // Value to set or get
    ULONG Flags;                        
    ULONG Capabilities;                 
} KSPROPERTY_SELECTOR_S, *PKSPROPERTY_SELECTOR_S;

typedef struct {
    KSP_NODE NodeProperty;
    LONG  Value;                        // Value to set or get
    ULONG Flags;
    ULONG Capabilities;
} KSPROPERTY_SELECTOR_NODE_S, *PKSPROPERTY_SELECTOR_NODE_S;

#endif // XP SP2 and later (chronologically)

//===========================================================================


#define STATIC_PROPSETID_TUNER\
    0x6a2e0605L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0605-28e4-11d0-a18c-00a0c9118956", PROPSETID_TUNER);
#define PROPSETID_TUNER DEFINE_GUIDNAMED(PROPSETID_TUNER)

typedef enum {
    KSPROPERTY_TUNER_CAPS,              // R  -overall device capabilities
    KSPROPERTY_TUNER_MODE_CAPS,         // R  -capabilities in this mode
    KSPROPERTY_TUNER_MODE,              // RW -set a mode (TV, FM, AM, DSS)
    KSPROPERTY_TUNER_STANDARD,          // R  -get TV standard (only if TV mode)
    KSPROPERTY_TUNER_FREQUENCY,         // RW -set/get frequency
    KSPROPERTY_TUNER_INPUT,             // RW -select an input
    KSPROPERTY_TUNER_STATUS,            // R  -tuning status
    KSPROPERTY_TUNER_IF_MEDIUM,         // R O-Medium for IF or Transport Pin
    KSPROPERTY_TUNER_SCAN_CAPS,         // R  -overall device capabilities for scanning
    KSPROPERTY_TUNER_SCAN_STATUS,       // R  -status of scan
    KSPROPERTY_TUNER_STANDARD_MODE,     // RW -autodetect mode for signal standard
    KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS // R -network type specific tuner capabilities
} KSPROPERTY_TUNER;


//
// Tuning support definitions and interfaces
//

// Definitions

typedef enum {
    KSPROPERTY_TUNER_MODE_TV            = 0X0001,
    KSPROPERTY_TUNER_MODE_FM_RADIO      = 0X0002,
    KSPROPERTY_TUNER_MODE_AM_RADIO      = 0X0004,
    KSPROPERTY_TUNER_MODE_DSS           = 0X0008,
    KSPROPERTY_TUNER_MODE_ATSC          = 0X0010,  // also used for DVB-T, DVB-C
} KSPROPERTY_TUNER_MODES;

// Describes how the device tunes.  Only one of these flags may be set
// in KSPROPERTY_TUNER_MODE_CAPS_S.Strategy

// Describe how the driver should attempt to tune:
// EXACT:   just go to the frequency specified (no fine tuning)
// FINE:    (slow) do an exhaustive search for the best signal
// COARSE:  (fast) use larger frequency jumps to just determine if any signal

typedef enum {
    KS_TUNER_TUNING_EXACT = 1,        // No fine tuning
    KS_TUNER_TUNING_FINE,             // Fine grained search
    KS_TUNER_TUNING_COARSE,           // Coarse search
}KS_TUNER_TUNING_FLAGS;

typedef enum {
    KS_TUNER_STRATEGY_PLL             = 0X01, // Tune by PLL offset
    KS_TUNER_STRATEGY_SIGNAL_STRENGTH = 0X02, // Tune by signal strength
    KS_TUNER_STRATEGY_DRIVER_TUNES    = 0X04, // Driver does fine tuning
}KS_TUNER_STRATEGY;


// Tuning operations

typedef struct {
    KSPROPERTY Property;
    ULONG  ModesSupported;              // KS_PROPERTY_TUNER_MODES_*
    KSPIN_MEDIUM VideoMedium;           // GUID_NULL (no pin), or GUID
    KSPIN_MEDIUM TVAudioMedium;         // GUID_NULL (no pin), or GUID
    KSPIN_MEDIUM RadioAudioMedium;      // GUID_NULL (no pin), or GUID
} KSPROPERTY_TUNER_CAPS_S, *PKSPROPERTY_TUNER_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    KSPIN_MEDIUM IFMedium;              // GUID_NULL (no pin), or GUID
} KSPROPERTY_TUNER_IF_MEDIUM_S, *PKSPROPERTY_TUNER_IF_MEDIUM_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  Mode;                        // IN: KSPROPERTY_TUNER_MODE
    ULONG  StandardsSupported;          // KS_AnalogVideo_* (if TV or DSS)
    ULONG  MinFrequency;                // Hz
    ULONG  MaxFrequency;                // Hz
    ULONG  TuningGranularity;           // Hz
    ULONG  NumberOfInputs;              // count of inputs
    ULONG  SettlingTime;                // milliSeconds
    ULONG  Strategy;                    // KS_TUNER_STRATEGY
} KSPROPERTY_TUNER_MODE_CAPS_S, *PKSPROPERTY_TUNER_MODE_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  Mode;                        // IN: KSPROPERTY_TUNER_MODE
} KSPROPERTY_TUNER_MODE_S, *PKSPROPERTY_TUNER_MODE_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  Frequency;                   // Hz
    ULONG  LastFrequency;               // Hz (last known good)
    ULONG  TuningFlags;                 // KS_TUNER_TUNING_FLAGS
    ULONG  VideoSubChannel;             // DSS
    ULONG  AudioSubChannel;             // DSS
    ULONG  Channel;                     // VBI decoders
    ULONG  Country;                     // VBI decoders
} KSPROPERTY_TUNER_FREQUENCY_S, *PKSPROPERTY_TUNER_FREQUENCY_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  Standard;                    // KS_AnalogVideo_*
} KSPROPERTY_TUNER_STANDARD_S, *PKSPROPERTY_TUNER_STANDARD_S;

typedef struct {
    KSPROPERTY Property;
    BOOL AutoDetect;                 // RW - specifies whether the driver is in auto-detect mode for the signal standard
} KSPROPERTY_TUNER_STANDARD_MODE_S, *PKSPROPERTY_TUNER_STANDARD_MODE_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  InputIndex;                  // 0 to (n-1) inputs
} KSPROPERTY_TUNER_INPUT_S, *PKSPROPERTY_TUNER_INPUT_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  CurrentFrequency;            // Hz
    ULONG  PLLOffset;                   // if Strategy.KS_TUNER_STRATEGY_PLL
    ULONG  SignalStrength;              // if Stretegy.KS_TUNER_STRATEGY_SIGNAL_STRENGTH
    ULONG  Busy;                        // TRUE if in the process of tuning
} KSPROPERTY_TUNER_STATUS_S, *PKSPROPERTY_TUNER_STATUS_S;


//
// Exhaustive Scanning tuner support definitions and interfaces
//

// Definitions

typedef enum _TunerDecoderLockType {
    Tuner_LockType_None                      = 0x00,   // Not locked on a signal. Can be returned at end of scan.
    Tuner_LockType_Within_Scan_Sensing_Range = 0x01,   // Signal is near by, not able to report exact frequency. Can be returned at end of scan.
    Tuner_LockType_Locked                    = 0x02    // Fine tune signal lock established. Can be returned at end of scan.
} TunerLockType;

// Data structures returned for KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S operations

typedef struct {
    ULONG  Mode;                        // IN -KSPROPERTY_TUNER_MODE
    ULONG  StandardsSupported;          // KS_AnalogVideo_* (defined in KS_AnalogVideoStandard)
    ULONG  MinFrequency;                // R -Hz
    ULONG  MaxFrequency;                // R -Hz
    ULONG  TuningGranularity;           // R -Hz
    ULONG  SettlingTime;                // R -milliSeconds
    ULONG  ScanSensingRange;            // R -max range (Hz) in which tuner can detect presence of a signal
    ULONG  FineTuneSensingRange;        // R -max range (Hz) in which tuner can detect actual frequency of a signal
}TUNER_ANALOG_CAPS_S, *PTUNER_ANALOG_CAPS_S;

// ... 
// More to come if new structures are needed for different network types.

#define STATIC_EVENTSETID_TUNER\
    0x6a2e0606L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0606-28e4-11d0-a18c-00a0c9118956", EVENTSETID_TUNER);
#define EVENTSETID_TUNER DEFINE_GUIDNAMED(EVENTSETID_TUNER)

typedef enum {
    KSEVENT_TUNER_CHANGED,
    KSEVENT_TUNER_INITIATE_SCAN    // initiate frequency scan 
} KSEVENT_TUNER;


// Exhaustive Scanning operations

// Determine if ES is possible with device
typedef struct {
    KSPROPERTY Property;
    BOOL fSupportsHardwareAssistedScanning; // R 
    ULONG SupportedBroadcastStandards;      // R 
    PVOID GUIDBucket;                       // RW
    ULONG lengthofBucket;                   // R   
} KSPROPERTY_TUNER_SCAN_CAPS_S, *PKSPROPERTY_TUNER_SCAN_CAPS_S;

// Get specific network type capabilities structure (such as TUNER_ANALOG_CAPS_S for example)
typedef struct {
    KSPROPERTY Property;
    GUID   NetworkType;               // R  -one of the interested GUIDs returned in KSPROPERTY_TUNER_SCAN_CAPS_S 
    ULONG  BufferSize;                // R  -size of the buffer;
    PVOID  NetworkTunerCapabilities;  // RW -Buffer
}KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S, *PKSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S;

// Obtain current scan operation status
typedef struct {
    KSPROPERTY Property;
    TunerLockType LockStatus; // R -none, within scan sensing range, or locked
    ULONG CurrentFrequency;   // R -current frequency
} KSPROPERTY_TUNER_SCAN_STATUS_S, *PKSPROPERTY_TUNER_SCAN_STATUS_S;

// Start a scan
typedef struct {
    KSEVENTDATA EventData;
    ULONG StartFrequency;          // W -initial frequency for the scan
    ULONG EndFrequency;            // W -final frequency for the scan
} KSEVENT_TUNER_INITIATE_SCAN_S, *PKSEVENT_TUNER_INITIATE_SCAN_S;



//
// Kernel Streaming Video node type definitions
//

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

//===========================================================================
// USB Video Class Definitions

#define STATIC_KSNODETYPE_VIDEO_STREAMING \
    0xDFF229E1L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96 
DEFINE_GUIDSTRUCT("DFF229E1-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_STREAMING);
#define KSNODETYPE_VIDEO_STREAMING DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_STREAMING)

#define STATIC_KSNODETYPE_VIDEO_INPUT_TERMINAL \
    0xDFF229E2L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E2-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_INPUT_TERMINAL);
#define KSNODETYPE_VIDEO_INPUT_TERMINAL DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_INPUT_TERMINAL)

#define STATIC_KSNODETYPE_VIDEO_OUTPUT_TERMINAL \
    0xDFF229E3L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E3-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_OUTPUT_TERMINAL);
#define KSNODETYPE_VIDEO_OUTPUT_TERMINAL DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_OUTPUT_TERMINAL)

#define STATIC_KSNODETYPE_VIDEO_SELECTOR \
    0xDFF229E4L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E4-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_SELECTOR);
#define KSNODETYPE_VIDEO_SELECTOR DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_SELECTOR)

#define STATIC_KSNODETYPE_VIDEO_PROCESSING \
    0xDFF229E5L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E5-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_PROCESSING);
#define KSNODETYPE_VIDEO_PROCESSING DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_PROCESSING)

#define STATIC_KSNODETYPE_VIDEO_CAMERA_TERMINAL \
    0xDFF229E6L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E6-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_CAMERA_TERMINAL);
#define KSNODETYPE_VIDEO_CAMERA_TERMINAL DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_CAMERA_TERMINAL)

#define STATIC_KSNODETYPE_VIDEO_INPUT_MTT \
    0xDFF229E7L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E7-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_INPUT_MTT);
#define KSNODETYPE_VIDEO_INPUT_MTT DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_INPUT_MTT)

#define STATIC_KSNODETYPE_VIDEO_OUTPUT_MTT \
    0xDFF229E8L, 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("DFF229E8-F70F-11D0-B917-00A0C9223196", KSNODETYPE_VIDEO_OUTPUT_MTT);
#define KSNODETYPE_VIDEO_OUTPUT_MTT DEFINE_GUIDNAMED(KSNODETYPE_VIDEO_OUTPUT_MTT)

#endif // XP SP2 and later (chronologically)

//===========================================================================


#define STATIC_PROPSETID_VIDCAP_VIDEOENCODER\
    0x6a2e0610L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0610-28e4-11d0-a18c-00a0c9118956", PROPSETID_VIDCAP_VIDEOENCODER);
#define PROPSETID_VIDCAP_VIDEOENCODER DEFINE_GUIDNAMED(PROPSETID_VIDCAP_VIDEOENCODER)

typedef enum {
    KSPROPERTY_VIDEOENCODER_CAPS,                       // R
    KSPROPERTY_VIDEOENCODER_STANDARD,                   // RW
    KSPROPERTY_VIDEOENCODER_COPYPROTECTION,             // RW O
    KSPROPERTY_VIDEOENCODER_CC_ENABLE,                  // RW O
} KSPROPERTY_VIDCAP_VIDEOENCODER;

typedef struct {
    KSPROPERTY Property;
    LONG       Value;                   // value to get or set
    ULONG      Flags;                   //
    ULONG      Capabilities;            //
} KSPROPERTY_VIDEOENCODER_S, *PKSPROPERTY_VIDEOENCODER_S;

//===========================================================================

#define STATIC_PROPSETID_VIDCAP_VIDEODECODER\
    0xC6E13350L, 0x30AC, 0x11d0, 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("C6E13350-30AC-11d0-A18C-00A0C9118956", PROPSETID_VIDCAP_VIDEODECODER);
#define PROPSETID_VIDCAP_VIDEODECODER DEFINE_GUIDNAMED(PROPSETID_VIDCAP_VIDEODECODER)

typedef enum {
    KSPROPERTY_VIDEODECODER_CAPS,                       // R
    KSPROPERTY_VIDEODECODER_STANDARD,                   // RW
    KSPROPERTY_VIDEODECODER_STATUS,                     // R
    KSPROPERTY_VIDEODECODER_OUTPUT_ENABLE,              // Rw O
    KSPROPERTY_VIDEODECODER_VCR_TIMING,                 // RW O
    KSPROPERTY_VIDEODECODER_STATUS2                     // R
} KSPROPERTY_VIDCAP_VIDEODECODER;

typedef enum {
    KS_VIDEODECODER_FLAGS_CAN_DISABLE_OUTPUT  = 0X0001, // VP Output can tri-stae
    KS_VIDEODECODER_FLAGS_CAN_USE_VCR_LOCKING = 0X0002, // VCR PLL timings
    KS_VIDEODECODER_FLAGS_CAN_INDICATE_LOCKED = 0X0004, // Can indicate valid signal
}KS_VIDEODECODER_FLAGS;

typedef struct {
    KSPROPERTY Property;
    ULONG      StandardsSupported;      // KS_AnalogVideo_*
    ULONG      Capabilities;            // KS_VIDEODECODER_FLAGS_*
    ULONG      SettlingTime;            // milliseconds
    ULONG      HSyncPerVSync;           // Number of HSync Pulses per VSync
} KSPROPERTY_VIDEODECODER_CAPS_S, *PKSPROPERTY_VIDEODECODER_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      NumberOfLines;           // 525 or 625 lines detected
    ULONG      SignalLocked;            // TRUE if signal is locked
} KSPROPERTY_VIDEODECODER_STATUS_S, *PKSPROPERTY_VIDEODECODER_STATUS_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      NumberOfLines;       // R - 525 or 625 lines detected
    ULONG      SignalLocked;        // R - TRUE if signal is locked
    ULONG      ChromaLock;          // R - TRUE if a chroma signal is present
} KSPROPERTY_VIDEODECODER_STATUS2_S, *PKSPROPERTY_VIDEODECODER_STATUS2_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      Value;                   // Get or set a value
} KSPROPERTY_VIDEODECODER_S, *PKSPROPERTY_VIDEODECODER_S;

#define STATIC_EVENTSETID_VIDEODECODER\
    0x6a2e0621L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0621-28e4-11d0-a18c-00a0c9118956", EVENTSETID_VIDEODECODER);
#define EVENTSETID_VIDEODECODER DEFINE_GUIDNAMED(EVENTSETID_VIDEODECODER)

typedef enum {
    KSEVENT_VIDEODECODER_CHANGED
} KSEVENT_VIDEODECODER;

//===========================================================================

#if (NTDDI_VERSION >= NTDDI_WIN8)
#define STATIC_KSEVENTSETID_CameraAsyncControl\
    0x22A11754L, 0x9701, 0x4088, 0xB3, 0x3F, 0x6B, 0x9C, 0xBC, 0x52, 0xDF, 0x5E
DEFINE_GUIDSTRUCT("22A11754-9701-4088-B33F-6B9CBC52DF5E", KSEVENTSETID_CameraAsyncControl);
#define KSEVENTSETID_CameraAsyncControl DEFINE_GUIDNAMED(KSEVENTSETID_CameraAsyncControl)

typedef enum {
    KSEVENT_CAMERACONTROL_FOCUS,
    KSEVENT_CAMERACONTROL_ZOOM
} KSEVENT_CAMERACONTROL;
#endif

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

#define STATIC_PROPSETID_VIDCAP_CAMERACONTROL\
    0xC6E13370L, 0x30AC, 0x11d0, 0xa1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("C6E13370-30AC-11d0-A18C-00A0C9118956", PROPSETID_VIDCAP_CAMERACONTROL);
#define PROPSETID_VIDCAP_CAMERACONTROL DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CAMERACONTROL)

typedef enum {
    KSPROPERTY_CAMERACONTROL_PAN,                       // RW O
    KSPROPERTY_CAMERACONTROL_TILT,                      // RW O
    KSPROPERTY_CAMERACONTROL_ROLL,                      // RW O
    KSPROPERTY_CAMERACONTROL_ZOOM,                      // RW O
    KSPROPERTY_CAMERACONTROL_EXPOSURE,                  // RW O
    KSPROPERTY_CAMERACONTROL_IRIS,                      // RW O
    KSPROPERTY_CAMERACONTROL_FOCUS                      // RW O

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

    , KSPROPERTY_CAMERACONTROL_SCANMODE                 // RW O
    , KSPROPERTY_CAMERACONTROL_PRIVACY                  // RW O
    , KSPROPERTY_CAMERACONTROL_PANTILT                  // RW O
    , KSPROPERTY_CAMERACONTROL_PAN_RELATIVE             // RW O
    , KSPROPERTY_CAMERACONTROL_TILT_RELATIVE            // RW O
    , KSPROPERTY_CAMERACONTROL_ROLL_RELATIVE            // RW O
    , KSPROPERTY_CAMERACONTROL_ZOOM_RELATIVE            // RW O
    , KSPROPERTY_CAMERACONTROL_EXPOSURE_RELATIVE        // RW O
    , KSPROPERTY_CAMERACONTROL_IRIS_RELATIVE            // RW O
    , KSPROPERTY_CAMERACONTROL_FOCUS_RELATIVE           // RW O
    , KSPROPERTY_CAMERACONTROL_PANTILT_RELATIVE         // RW O
    , KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH             // R  O    
    , KSPROPERTY_CAMERACONTROL_AUTO_EXPOSURE_PRIORITY   // RW O

#endif // XP SP2 and later (chronologically)

} KSPROPERTY_VIDCAP_CAMERACONTROL;

#if (NTDDI_VERSION >= NTDDI_WIN8)
typedef enum {
    KS_CAMERACONTROL_ASYNC_START  = 0x0001,
    KS_CAMERACONTROL_ASYNC_STOP   = 0x0002,
    KS_CAMERACONTROL_ASYNC_RESET  = 0x0003
} KS_CameraControlAsyncOperation;

typedef struct {
    KSPROPERTY Property;
    LONG       Value;                   // value to get or set
    ULONG      Flags;                   // KSPROPERTY_CAMERACONTROL_FLAGS_*
    ULONG      Capabilities;            // KSPROPERTY_CAMERACONTROL_FLAGS_*
    RECT       FocusRect;
} KSPROPERTY_CAMERACONTROL_S_EX, *PKSPROPERTY_CAMERACONTROL_S_EX;
#endif

typedef struct {
    KSPROPERTY Property;
    LONG       Value;                   // value to get or set
    ULONG      Flags;                   // KSPROPERTY_CAMERACONTROL_FLAGS_*
    ULONG      Capabilities;            // KSPROPERTY_CAMERACONTROL_FLAGS_*
} KSPROPERTY_CAMERACONTROL_S, *PKSPROPERTY_CAMERACONTROL_S;

#define KSPROPERTY_CAMERACONTROL_FLAGS_AUTO        0X0001L
#define KSPROPERTY_CAMERACONTROL_FLAGS_MANUAL      0X0002L
#if (NTDDI_VERSION >= NTDDI_WIN8)
#define KSPROPERTY_CAMERACONTROL_FLAGS_ASYNCHRONOUS 0X0004L
#endif

#define KSPROPERTY_CAMERACONTROL_FLAGS_ABSOLUTE    0X0000L
#define KSPROPERTY_CAMERACONTROL_FLAGS_RELATIVE    0X0010L

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

typedef struct {
    KSP_NODE NodeProperty;
    LONG  Value;                        // value to get or set
    ULONG Flags;                        // KSPROPERTY_CAMERACONTROL_FLAGS_*
    ULONG Capabilities;                 // KSPROPERTY_CAMERACONTROL_FLAGS_*
} KSPROPERTY_CAMERACONTROL_NODE_S, PKSPROPERTY_CAMERACONTROL_NODE_S;

typedef struct {
    KSPROPERTY Property;
    LONG Value1;
    ULONG Flags;
    ULONG Capabilities;
    LONG Value2;
} KSPROPERTY_CAMERACONTROL_S2, *PKSPROPERTY_CAMERACONTROL_S2;

typedef struct {
    KSP_NODE NodeProperty;
    LONG Value1;
    ULONG Flags;
    ULONG Capabilities;
    LONG Value2;
} KSPROPERTY_CAMERACONTROL_NODE_S2, *PKSPROPERTY_CAMERACONTROL_NODE_S2;

typedef struct {
    KSPROPERTY Property;
    LONG lOcularFocalLength;
    LONG lObjectiveFocalLengthMin;
    LONG lObjectiveFocalLengthMax;
} KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S, *PKSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S;

typedef struct {
    KSNODEPROPERTY NodeProperty;
    LONG lOcularFocalLength;
    LONG lObjectiveFocalLengthMin;
    LONG lObjectiveFocalLengthMax;
} KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S, *PKSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S;
#endif // XP SP2 and later (chronologically)

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)
#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

#if (NTDDI_VERSION >= NTDDI_WIN8)

#define STATIC_PROPSETID_VIDCAP_CAMERACONTROL_FLASH \
    0x785e8f49, 0x63a2, 0x4144, 0xab, 0x70, 0xff, 0xb2, 0x78, 0xfa, 0x26, 0xce
DEFINE_GUIDSTRUCT("785E8F49-63A2-4144-AB70-FFB278FA26CE", PROPSETID_VIDCAP_CAMERACONTROL_FLASH );
#define PROPSETID_VIDCAP_CAMERACONTROL_FLASH DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CAMERACONTROL_FLASH )

typedef enum {
    KSPROPERTY_CAMERACONTROL_FLASH_PROPERTY_ID = 0
} KSPROPERTY_CAMERACONTROL_FLASH;

#define KSPROPERTY_CAMERACONTROL_FLASH_OFF    0x00000000L
#define KSPROPERTY_CAMERACONTROL_FLASH_ON     0x00000001L
#define KSPROPERTY_CAMERACONTROL_FLASH_AUTO   0x00000002L

#define KSPROPERTY_CAMERACONTROL_FLASH_FLAGS_AUTO        0x00000001L
#define KSPROPERTY_CAMERACONTROL_FLASH_FLAGS_MANUAL      0x00000002L

typedef struct {
  ULONG      Flash;
  ULONG      Capabilities;
} KSPROPERTY_CAMERACONTROL_FLASH_S, *PKSPROPERTY_CAMERACONTROL_FLASH_S;

#define STATIC_PROPSETID_VIDCAP_CAMERACONTROL_VIDEO_STABILIZATION  \
    0x43964bd3, 0x7716, 0x404e, 0x8b, 0xe1, 0xd2, 0x99, 0xb2, 0xe, 0x50, 0xfd
DEFINE_GUIDSTRUCT("43964BD3-7716-404e-8BE1-D299B20E50FD", PROPSETID_VIDCAP_CAMERACONTROL_VIDEO_STABILIZATION);
#define PROPSETID_VIDCAP_CAMERACONTROL_VIDEO_STABILIZATION DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CAMERACONTROL_VIDEO_STABILIZATION)

typedef enum {
    KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE_PROPERTY_ID = 0
} KSPROPERTY_CAMERACONTROL_VIDEO_STABILIZATION_MODE;

#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_OFF     0x00000000L
#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_HIGH    0x00000001L
#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_MEDIUM  0x00000002L
#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_LOW     0x00000003L
#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_AUTO    0x00000004L

#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_FLAGS_AUTO        0x00000001L
#define KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_FLAGS_MANUAL      0x00000002L

typedef struct {
  ULONG      VideoStabilizationMode;
  ULONG      Capabilities;
} KSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S, *PKSPROPERTY_CAMERACONTROL_VIDEOSTABILIZATION_MODE_S;

#define STATIC_PROPSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST  \
    0x9d12d198, 0xf86c, 0x4fed, 0xb0, 0x23, 0x5d, 0x87, 0x65, 0x3d, 0xa7, 0x93
DEFINE_GUIDSTRUCT("9D12D198-F86C-4fed-B023-5D87653DA793", PROPSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST);
#define PROPSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST)

typedef enum {
    KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_PROPERTY_ID = 0
} KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST;

#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_AUTO      0x00000001L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_MANUAL    0x00000002L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_FLAGS_ASYNC     0x80000000L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_FOCUS    0x00000100L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_EXPOSURE 0x00000200L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONFIG_WB       0x00000400L
#define KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_CONVERGEMODE    0x40000000L

#define STATIC_EVENTSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST  \
    0x2FDFFC5D, 0xC732, 0x4BA6, 0xB5, 0xDF, 0x6B, 0x4D, 0x7F, 0xC8, 0x8B, 0x8B
DEFINE_GUIDSTRUCT("2FDFFC5D-C732-4BA6-B5DF-6B4D7FC88B8B", EVENTSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST);
#define EVENTSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST DEFINE_GUIDNAMED(EVENTSETID_VIDCAP_CAMERACONTROL_REGION_OF_INTEREST)

typedef struct {
  RECT      FocusRect; 
  BOOL      AutoFocusLock;
  BOOL      AutoExposureLock;
  BOOL      AutoWhitebalanceLock;
  union {
    ULONG     Capabilities;
    ULONG     Configuration;
  };
} KSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S, *PKSPROPERTY_CAMERACONTROL_REGION_OF_INTEREST_S;

#define STATIC_PROPSETID_VIDCAP_CAMERACONTROL_IMAGE_PIN_CAPABILITY  \
    0x9d3d7bbf, 0x5c6d, 0x4138, 0xbb, 0x0, 0x58, 0x4e, 0xdd, 0x20, 0xf7, 0xc5
DEFINE_GUIDSTRUCT("9D3D7BBF-5C6D-4138-BB00-584EDD20F7C5", PROPSETID_VIDCAP_CAMERACONTROL_IMAGE_PIN_CAPABILITY);
#define PROPSETID_VIDCAP_CAMERACONTROL_IMAGE_PIN_CAPABILITY DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CAMERACONTROL_IMAGE_PIN_CAPABILITY)

typedef enum {
    KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_PROPERTY_ID = 0
} KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY;

#define KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_EXCLUSIVE_WITH_RECORD             0x00000001L
#define KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_SEQUENCE_EXCLUSIVE_WITH_RECORD    0x00000002L

typedef struct {
  ULONG      Capabilities;
  ULONG      Reserved0;
} KSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S, *PKSPROPERTY_CAMERACONTROL_IMAGE_PIN_CAPABILITY_S;

#endif

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

#if (NTDDI_VERSION >= NTDDI_WIN8)

typedef enum {
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOMODE,                            // 0
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOFRAMERATE,                       // 1
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOMAXFRAMERATE,                    // 2
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOTRIGGERTIME,                     // 3
    KSPROPERTY_CAMERACONTROL_EXTENDED_WARMSTART,                            // 4
    KSPROPERTY_CAMERACONTROL_EXTENDED_MAXVIDFPS_PHOTORES,                   // 5
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOTHUMBNAIL,                       // 6
    KSPROPERTY_CAMERACONTROL_EXTENDED_SCENEMODE,                            // 7
    KSPROPERTY_CAMERACONTROL_EXTENDED_TORCHMODE,                            // 8
    KSPROPERTY_CAMERACONTROL_EXTENDED_FLASHMODE,                            // 9
    KSPROPERTY_CAMERACONTROL_EXTENDED_OPTIMIZATIONHINT,                     // 10
    KSPROPERTY_CAMERACONTROL_EXTENDED_WHITEBALANCEMODE,                     // 11
    KSPROPERTY_CAMERACONTROL_EXTENDED_EXPOSUREMODE,                         // 12
    KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSMODE,                            // 13
    KSPROPERTY_CAMERACONTROL_EXTENDED_ISO,                                  // 14
    KSPROPERTY_CAMERACONTROL_EXTENDED_FIELDOFVIEW,                          // 15
    KSPROPERTY_CAMERACONTROL_EXTENDED_EVCOMPENSATION,                       // 16
    KSPROPERTY_CAMERACONTROL_EXTENDED_CAMERAANGLEOFFSET,                    // 17
#if (NTDDI_VERSION >= NTDDI_WINBLUE)
    KSPROPERTY_CAMERACONTROL_EXTENDED_METADATA,                             // 18
    KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSPRIORITY,                        // 19
    KSPROPERTY_CAMERACONTROL_EXTENDED_FOCUSSTATE,                           // 20
    KSPROPERTY_CAMERACONTROL_EXTENDED_ROI_CONFIGCAPS,                       // 21
    KSPROPERTY_CAMERACONTROL_EXTENDED_ROI_ISPCONTROL,                       // 22
    KSPROPERTY_CAMERACONTROL_EXTENDED_PHOTOCONFIRMATION,                    // 23
    KSPROPERTY_CAMERACONTROL_EXTENDED_ZOOM,                                 // 24
    KSPROPERTY_CAMERACONTROL_EXTENDED_MCC,                                  // 25
    KSPROPERTY_CAMERACONTROL_EXTENDED_ISO_ADVANCED,                         // 26
#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)  

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
    KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOSTABILIZATION,                   // 27
    KSPROPERTY_CAMERACONTROL_EXTENDED_VFR,                                  // 28
    KSPROPERTY_CAMERACONTROL_EXTENDED_FACEDETECTION,                        // 29
    KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOHDR,                             // 30
    KSPROPERTY_CAMERACONTROL_EXTENDED_HISTOGRAM,                            // 31
    KSPROPERTY_CAMERACONTROL_EXTENDED_OIS,                                  // 32
    KSPROPERTY_CAMERACONTROL_EXTENDED_ADVANCEDPHOTO,                        // 33
    KSPROPERTY_CAMERACONTROL_EXTENDED_PROFILE,                              // 34
#endif

#if (NTDDI_VERSION >= NTDDI_WIN10_RS1)
    KSPROPERTY_CAMERACONTROL_EXTENDED_FACEAUTH_MODE,                        // 35
#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS1)

    KSPROPERTY_CAMERACONTROL_EXTENDED_SECURE_MODE,                          // 36

#if (NTDDI_VERSION >= NTDDI_WIN10_RS3)
    KSPROPERTY_CAMERACONTROL_EXTENDED_VIDEOTEMPORALDENOISING,               // 37
#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS3)

#if (NTDDI_VERSION >= NTDDI_WIN10_19H1)
    KSPROPERTY_CAMERACONTROL_EXTENDED_IRTORCHMODE,                          // 38
#endif // (NTDDI_VERSION >= NTDDI_WIN10_19H1)

#if (NTDDI_VERSION >= NTDDI_WIN10_VB)
    KSPROPERTY_CAMERACONTROL_EXTENDED_RELATIVEPANELOPTIMIZATION,            // 39
#endif //  (NTDDI_VERSION >= NTDDI_WIN10_VB)

#if(NTDDI_VERSION >= NTDDI_WIN10_MN)
    KSPROPERTY_CAMERACONTROL_EXTENDED_EYEGAZECORRECTION,                    // 40
    KSPROPERTY_CAMERACONTROL_EXTENDED_BACKGROUNDSEGMENTATION,               // 41
#endif //  (NTDDI_VERSION >= NTDDI_WIN10_MN)

#if (NTDDI_VERSION >= NTDDI_WIN10_FE)
    KSPROPERTY_CAMERACONTROL_EXTENDED_DIGITALWINDOW_CONFIGCAPS,             // 42
    KSPROPERTY_CAMERACONTROL_EXTENDED_DIGITALWINDOW,                        // 43
#endif //  (NTDDI_VERSION >= NTDDI_WIN10_FE)

    KSPROPERTY_CAMERACONTROL_EXTENDED_END,                                  // All new controls must be before this!
    KSPROPERTY_CAMERACONTROL_EXTENDED_END2 = KSPROPERTY_CAMERACONTROL_EXTENDED_END
} KSPROPERTY_CAMERACONTROL_EXTENDED_PROPERTY;


#define STATIC_KSPROPERTYSETID_ExtendedCameraControl \
     0x1CB79112, 0xC0D2, 0x4213, 0x9C, 0xA6, 0xCD, 0x4F, 0xDB, 0x92, 0x79, 0x72
DEFINE_GUIDSTRUCT("1CB79112-C0D2-4213-9CA6-CD4FDB927972", KSPROPERTYSETID_ExtendedCameraControl);
#define KSPROPERTYSETID_ExtendedCameraControl DEFINE_GUIDNAMED(KSPROPERTYSETID_ExtendedCameraControl)

#define STATIC_KSEVENTSETID_ExtendedCameraControl \
    0x571C92C9, 0x13A2, 0x47E3, 0xA6, 0x49, 0xD2, 0xA7, 0x78, 0x16, 0x63, 0x84
DEFINE_GUIDSTRUCT("571C92C9-13A2-47E3-A649-D2A778166384", KSEVENTSETID_ExtendedCameraControl);
#define KSEVENTSETID_ExtendedCameraControl DEFINE_GUIDNAMED(KSEVENTSETID_ExtendedCameraControl)

#define KSCAMERA_EXTENDEDPROP_FILTERSCOPE                               0xFFFFFFFF

#if (NTDDI_VERSION >= NTDDI_WINBLUE)

#define KSCAMERA_EXTENDEDPROP_CAPS_RESERVED                             0xFF00000000000000 

#define STATIC_KSEVENTSETID_CameraEvent \
    0x7899b2e0, 0x6b43, 0x4964, 0x9d, 0x2a, 0xa2, 0x1f, 0x40, 0x61, 0xf5, 0x76
DEFINE_GUIDSTRUCT("7899B2E0-6B43-4964-9D2A-A21F4061F576", KSEVENTSETID_CameraEvent);
#define KSEVENTSETID_CameraEvent DEFINE_GUIDNAMED(KSEVENTSETID_CameraEvent)

typedef enum {  
    KSEVENT_PHOTO_SAMPLE_SCANNED,  
} KSEVENT_CAMERAEVENT;  
  
#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)



#define KSCAMERA_EXTENDEDPROP_CAPS_ASYNCCONTROL                         0x8000000000000000
#define KSCAMERA_EXTENDEDPROP_CAPS_CANCELLABLE                          0x4000000000000000

#define KSCAMERA_EXTENDEDPROP_FLAG_CANCELOPERATION                      0x8000000000000000

// This mask represents the reserved bits for all capability flags.  All EXTENDEDPROP capability
// flags defined below must NOT use the upper 8 bits.
// Same applies to the flags.
#define KSCAMERA_EXTENDEDPROP_CAPS_MASK                                 0xFF00000000000000
#define KSCAMERA_EXTENDEDPROP_FLAG_MASK                                 0xFF00000000000000

#define KSCAMERA_EXTENDEDPROP_PHOTOMODE_NORMAL                          0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE                        0x0000000000000001

#define KSCAMERA_EXTENDEDPROP_WARMSTART_MODE_DISABLED                   0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_WARMSTART_MODE_ENABLED                    0x0000000000000001

#define KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_DISABLE                    0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_2X                         0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_4X                         0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_8X                         0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_PHOTOTHUMBNAIL_16X                        0x0000000000000008

#define KSCAMERA_EXTENDEDPROP_SCENEMODE_AUTO                            0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_MACRO                           0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_PORTRAIT                        0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_SPORT                           0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_SNOW                            0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_NIGHT                           0x0000000000000010
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_BEACH                           0x0000000000000020
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_SUNSET                          0x0000000000000040
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_CANDLELIGHT                     0x0000000000000080
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_LANDSCAPE                       0x0000000000000100
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_NIGHTPORTRAIT                   0x0000000000000200
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_BACKLIT                         0x0000000000000400
#define KSCAMERA_EXTENDEDPROP_SCENEMODE_MANUAL                          0x0080000000000000

#define KSCAMERA_EXTENDEDPROP_VIDEOTORCH_OFF                            0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_VIDEOTORCH_ON                             0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_VIDEOTORCH_ON_ADJUSTABLEPOWER             0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_FLASH_OFF                                 0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_FLASH_ON                                  0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_FLASH_ON_ADJUSTABLEPOWER                  0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_FLASH_AUTO                                0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_FLASH_AUTO_ADJUSTABLEPOWER                0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_FLASH_REDEYEREDUCTION                     0x0000000000000010
#define KSCAMERA_EXTENDEDPROP_FLASH_SINGLEFLASH                         0x0000000000000020
#define KSCAMERA_EXTENDEDPROP_FLASH_MULTIFLASHSUPPORTED                 0x0000000000000040
#define KSCAMERA_EXTENDEDPROP_FLASH_MODE_MASK                           (KSCAMERA_EXTENDEDPROP_FLASH_ON|\
                                                                         KSCAMERA_EXTENDEDPROP_FLASH_ON_ADJUSTABLEPOWER|\
                                                                         KSCAMERA_EXTENDEDPROP_FLASH_AUTO|\
                                                                         KSCAMERA_EXTENDEDPROP_FLASH_AUTO_ADJUSTABLEPOWER)


#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_PHOTO                        0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_VIDEO                        0x0000000000000002

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_DEFAULT                      0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_QUALITY                      0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_LATENCY                      0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_POWER                        0x0000000000000010

#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_PERF_MASK                    (KSCAMERA_EXTENDEDPROP_OPTIMIZATION_QUALITY| \
                                                                         KSCAMERA_EXTENDEDPROP_OPTIMIZATION_LATENCY| \
                                                                         KSCAMERA_EXTENDEDPROP_OPTIMIZATION_POWER)                                      

#define KSCAMERA_EXTENDEDPROP_OPTIMIZATION_PRIMARYUSE_MASK              (KSCAMERA_EXTENDEDPROP_OPTIMIZATION_PHOTO|   \
                                                                         KSCAMERA_EXTENDEDPROP_OPTIMIZATION_VIDEO)                                      

#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#define KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_AUTO                        0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_MANUAL                      0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_LOCK                        0x0000000000000004

// This combines the generic Video Proc bits shared by all video proc controls.
#define KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_MASK                        (KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_AUTO|\
                                                                         KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_MANUAL|\
                                                                         KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_LOCK)

typedef enum {
    KSCAMERA_EXTENDEDPROP_WHITEBALANCE_TEMPERATURE = 1,
    KSCAMERA_EXTENDEDPROP_WHITEBALANCE_PRESET
} KSCAMERA_EXTENDEDPROP_WHITEBALANCE_MODE;

typedef enum {
    KSCAMERA_EXTENDEDPROP_WBPRESET_CLOUDY = 1,
    KSCAMERA_EXTENDEDPROP_WBPRESET_DAYLIGHT,
    KSCAMERA_EXTENDEDPROP_WBPRESET_FLASH,
    KSCAMERA_EXTENDEDPROP_WBPRESET_FLUORESCENT,
    KSCAMERA_EXTENDEDPROP_WBPRESET_TUNGSTEN,
    KSCAMERA_EXTENDEDPROP_WBPRESET_CANDLELIGHT,
} KSCAMERA_EXTENDEDPROP_WBPRESET;

#define KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUS                          0x0000000000000100

// Focus control extends the generic video proc mask by adding the continous flag.
#define KSCAMERA_EXTENDEDPROP_FOCUS_MODE_MASK                           (KSCAMERA_EXTENDEDPROP_VIDEOPROCFLAG_MASK|      \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUS)        

#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_MACRO                         0x0000000000010000
#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_NORMAL                        0x0000000000020000
#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_FULLRANGE                     0x0000000000040000
#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_INFINITY                      0x0000000000080000
#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_HYPERFOCAL                    0x0000000000100000
#define KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_MASK                          (KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_MACRO|       \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_NORMAL|      \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_FULLRANGE|   \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_INFINITY|    \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_RANGE_HYPERFOCAL)


#if (NTDDI_VERSION >= NTDDI_WINBLUE)

// Spare bits 0x200000 - 0x800000 in case of future range expansion
#define KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_INFINITY                   0x0000000001000000
#define KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_HYPERFOCAL                 0x0000000002000000
#define KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_NEAREST                    0x0000000004000000
#define KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_MASK                       (KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_INFINITY|   \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_HYPERFOCAL| \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_DISTANCE_NEAREST)
#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)



#define KSCAMERA_EXTENDEDPROP_ISO_AUTO                                  0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_ISO_50                                    0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_ISO_80                                    0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_ISO_100                                   0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_ISO_200                                   0x0000000000000010
#define KSCAMERA_EXTENDEDPROP_ISO_400                                   0x0000000000000020
#define KSCAMERA_EXTENDEDPROP_ISO_800                                   0x0000000000000040
#define KSCAMERA_EXTENDEDPROP_ISO_1600                                  0x0000000000000080
#define KSCAMERA_EXTENDEDPROP_ISO_3200                                  0x0000000000000100
#define KSCAMERA_EXTENDEDPROP_ISO_6400                                  0x0000000000000200
#define KSCAMERA_EXTENDEDPROP_ISO_12800                                 0x0000000000000400
#define KSCAMERA_EXTENDEDPROP_ISO_25600                                 0x0000000000000800


#if (NTDDI_VERSION >= NTDDI_WINBLUE)

#define KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUSLOCK                      0x0000000000000200
#define KSCAMERA_EXTENDEDPROP_FOCUS_UNLOCK                              0x0000000000000400
#define KSCAMERA_EXTENDEDPROP_FOCUS_DRIVERFALLBACK_OFF                  0x0000000000000800
#define KSCAMERA_EXTENDEDPROP_FOCUS_REGIONBASED                         0x0000000000001000

#define KSCAMERA_EXTENDEDPROP_FOCUS_MODE_ADVANCED_MASK                  (KSCAMERA_EXTENDEDPROP_FOCUS_CONTINUOUSLOCK|     \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_UNLOCK|             \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_DRIVERFALLBACK_OFF| \
                                                                         KSCAMERA_EXTENDEDPROP_FOCUS_REGIONBASED)

#define KSCAMERA_EXTENDEDPROP_ISO_MANUAL                                0x0080000000000000

#define KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_OFF                       0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_ON                        0x0000000000000080
#define KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_AUTO                      0x0000000000000100
#define KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_MASK                      (KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_ON|\
                                                                         KSCAMERA_EXTENDEDPROP_FLASH_ASSISTANT_AUTO)

#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)     


#define KSCAMERA_EXTENDEDPROP_EVCOMP_SIXTHSTEP                          0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_EVCOMP_QUARTERSTEP                        0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_EVCOMP_THIRDSTEP                          0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_EVCOMP_HALFSTEP                           0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_EVCOMP_FULLSTEP                           0x0000000000000010

typedef enum {
    KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_CLEAR,
    KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_SET,
} KSPROPERTY_CAMERA_PHOTOTRIGGERTIME_FLAGS;

typedef struct tagKSCAMERA_EXTENDEDPROP_HEADER {
    ULONG               Version;
    ULONG               PinId;
    ULONG               Size;
    ULONG               Result;
    ULONGLONG           Flags;
    ULONGLONG           Capability;
} KSCAMERA_EXTENDEDPROP_HEADER, *PKSCAMERA_EXTENDEDPROP_HEADER;

typedef struct tagKSCAMERA_EXTENDEDPROP_VALUE {
    union
    {
        double          dbl;
        ULONGLONG       ull;
        ULONG           ul;
        ULARGE_INTEGER  ratio;
        LONG            l;
        LONGLONG        ll;
    } Value;
} KSCAMERA_EXTENDEDPROP_VALUE, *PKSCAMERA_EXTENDEDPROP_VALUE;

// This is the payload structure fo the Maximum video sensor frame rate possible
// based on the photo resolution being programmed on the sensor.  The PhotoRes fields
// are provided by the application, the preview/capture FPS fields are filled in
// by the driver to indicate the maximum sensor frame rate.
typedef struct tagKSCAMERA_MAXVIDEOFPS_FORPHOTORES
{
    ULONG   PhotoResWidth;
    ULONG   PhotoResHeight;
    ULONG   PreviewFPSNum;
    ULONG   PreviewFPSDenom;
    ULONG   CaptureFPSNum;
    ULONG   CaptureFPSDenom;
} KSCAMERA_MAXVIDEOFPS_FORPHOTORES, *PKSCAMERA_MAXVIDEOFPS_FORPHOTORES;


#if (NTDDI_VERSION >= NTDDI_WINBLUE)

#define KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE_SUB_NONE               0x00000000
#define KSCAMERA_EXTENDEDPROP_PHOTOMODE_SEQUENCE_SUB_VARIABLE           0x00000001

#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)


typedef struct tagKSCAMERA_EXTENDEDPROP_PHOTOMODE {
    ULONG       RequestedHistoryFrames;
    ULONG       MaxHistoryFrames;
    ULONG       SubMode;
    ULONG       Reserved;
} KSCAMERA_EXTENDEDPROP_PHOTOMODE, *PKSCAMERA_EXTENDEDPROP_PHOTOMODE;

typedef struct tagKSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING {
    ULONG                               Mode;
    LONG                                Min;
    LONG                                Max;
    LONG                                Step;
    KSCAMERA_EXTENDEDPROP_VALUE         VideoProc;
    ULONGLONG                           Reserved;
} KSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING, *PKSCAMERA_EXTENDEDPROP_VIDEOPROCSETTING;

typedef struct tagKSCAMERA_EXTENDEDPROP_EVCOMPENSATION {
    ULONG       Mode;
    LONG        Min;
    LONG        Max;
    LONG        Value;
    ULONGLONG   Reserved;
} KSCAMERA_EXTENDEDPROP_EVCOMPENSATION, *PKSCAMERA_EXTENDEDPROP_EVCOMPENSATION;

typedef struct tagKSCAMERA_EXTENDEDPROP_FIELDOFVIEW {
    ULONG   NormalizedFocalLengthX;
    ULONG   NormalizedFocalLengthY;
    ULONG   Flag;
    ULONG   Reserved;
} KSCAMERA_EXTENDEDPROP_FIELDOFVIEW, *PKSCAMERA_EXTENDEDPROP_FIELDOFVIEW;

typedef struct tagKSCAMERA_EXTENDEDPROP_CAMERAOFFSET {
    LONG    PitchAngle;
    LONG    YawAngle;
    ULONG   Flag;
    ULONG   Reserved;
} KSCAMERA_EXTENDEDPROP_CAMERAOFFSET, *PKSCAMERA_EXTENDEDPROP_CAMERAOFFSET;


#if (NTDDI_VERSION >= NTDDI_WINBLUE)

// Metadata
typedef struct tagKSCAMERA_EXTENDEDPROP_METADATAINFO {
    LONG    BufferAlignment;         // Required alignment for metadata buffer  
    ULONG   MaxMetadataBufferSize;   // Required metadata buffer size  
} KSCAMERA_EXTENDEDPROP_METADATAINFO, *PKSCAMERA_EXTENDEDPROP_METADATAINFO;

typedef enum {
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_16 = 4,                     // Aligned at 16 bytes
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_32,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_64,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_128,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_256,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_512,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_1024,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_2048,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_4096,
    KSCAMERA_EXTENDEDPROP_MetadataAlignment_8192  
} KSCAMERA_EXTENDEDPROP_MetadataAlignment;

#define KSCAMERA_EXTENDEDPROP_METADATA_MEMORYTYPE_MASK                  0x00000000000000FF

#define KSCAMERA_EXTENDEDPROP_METADATA_SYSTEMMEMORY                     0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_METADATA_ALIGNMENTREQUIRED                0x0000000000000100

typedef enum {
    MetadataId_Standard_Start = 1,
    MetadataId_PhotoConfirmation = MetadataId_Standard_Start,
    MetadataId_UsbVideoHeader,
    MetadataId_CaptureStats,
    MetadataId_CameraExtrinsics,
    MetadataId_CameraIntrinsics,
    MetadataId_FrameIllumination,
    MetadataId_DigitalWindow,
    MetadataId_BackgroundSegmentationMask,
    MetadataId_Standard_End = MetadataId_BackgroundSegmentationMask,
    MetadataId_Custom_Start = 0x80000000,
} KSCAMERA_MetadataId;

typedef struct tagKSCAMERA_METADATA_ITEMHEADER {
    ULONG   MetadataId;     
    ULONG   Size;         // Size of this header + metadata payload following
} KSCAMERA_METADATA_ITEMHEADER, *PKSCAMERA_METADATA_ITEMHEADER;

typedef struct tagKSCAMERA_METADATA_PHOTOCONFIRMATION {
    KSCAMERA_METADATA_ITEMHEADER   Header;
    ULONG                          PhotoConfirmationIndex;  
    ULONG                          Reserved;
}KSCAMERA_METADATA_PHOTOCONFIRMATION, *PKSCAMERA_METADATA_PHOTOCONFIRMATION;

typedef struct tagKSCAMERA_METADATA_FRAMEILLUMINATION {
    KSCAMERA_METADATA_ITEMHEADER   Header;
    ULONG                          Flags;
    ULONG                          Reserved;
}KSCAMERA_METADATA_FRAMEILLUMINATION, *PKSCAMERA_METADATA_FRAMEILLUMINATION;

#define KSCAMERA_METADATA_FRAMEILLUMINATION_FLAG_ON                     0x00000001

typedef struct tagKSCAMERA_METADATA_CAPTURESTATS {
    KSCAMERA_METADATA_ITEMHEADER   Header;
    ULONG                          Flags;
    ULONG                          Reserved;
    ULONGLONG                      ExposureTime;
    ULONGLONG                      ExposureCompensationFlags;
    LONG                           ExposureCompensationValue;
    ULONG                          IsoSpeed;
    ULONG                          FocusState;
    ULONG                          LensPosition; // a.k.a Focus
    ULONG                          WhiteBalance;
    ULONG                          Flash;
    ULONG                          FlashPower;
    ULONG                          ZoomFactor;
    ULONGLONG                      SceneMode;
    ULONGLONG                      SensorFramerate;
}KSCAMERA_METADATA_CAPTURESTATS, *PKSCAMERA_METADATA_CAPTURESTATS;

#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_EXPOSURETIME                0x00000001
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_EXPOSURECOMPENSATION        0x00000002
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_ISOSPEED                    0x00000004
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_FOCUSSTATE                  0x00000008
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_LENSPOSITION                0x00000010
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_WHITEBALANCE                0x00000020
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_FLASH                       0x00000040
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_FLASHPOWER                  0x00000080
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_ZOOMFACTOR                  0x00000100
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_SCENEMODE                   0x00000200
#define KSCAMERA_METADATA_CAPTURESTATS_FLAG_SENSORFRAMERATE             0x00000400


// Focus Priority
#define KSCAMERA_EXTENDEDPROP_FOCUSPRIORITY_OFF                         0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_FOCUSPRIORITY_ON                          0x0000000000000001

// Focus State
typedef enum
{
    KSCAMERA_EXTENDEDPROP_FOCUSSTATE_UNINITIALIZED = 0, 
    KSCAMERA_EXTENDEDPROP_FOCUSSTATE_LOST,
    KSCAMERA_EXTENDEDPROP_FOCUSSTATE_SEARCHING, 
    KSCAMERA_EXTENDEDPROP_FOCUSSTATE_FOCUSED,
    KSCAMERA_EXTENDEDPROP_FOCUSSTATE_FAILED,
} KSCAMERA_EXTENDEDPROP_FOCUSSTATE;

// Extended ROI
typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER {
    ULONG       Size;                   // Size of this header + all _CONFIGCAPS structures followed 
    ULONG       ConfigCapCount;         // Number of _CONFIGCAPS structures followed 
    ULONGLONG   Reserved;
} KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER, *PKSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPSHEADER;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS {
    ULONG       ControlId;              // ISP control ID (focus, exposure, or white balance)
    ULONG       MaxNumberOfROIs;        // Max ROIs supported for this ISP control
    ULONGLONG   Capability;             // Caps for this ISP control   
} KSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS, *PKSCAMERA_EXTENDEDPROP_ROI_CONFIGCAPS;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER {
    ULONG       Size;                   // Size of this header + all _ ISPCONTROL + all _RECTINFO
    ULONG       ControlCount;           // Number of ISP controls. 0 indicating clear all ROIs
    ULONGLONG   Reserved;
} KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER, *PKSCAMERA_EXTENDEDPROP_ROI_ISPCONTROLHEADER;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL {
    ULONG       ControlId;              // ISP control ID (focus, exposure, or white balance) 
    ULONG       ROICount;               // Number of ROIs associated with this ISP control
    ULONG       Result;                 // Error results of the last SET operation for this ISP control
    ULONG       Reserved;
} KSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL, *PKSCAMERA_EXTENDEDPROP_ROI_ISPCONTROL;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_INFO {
    RECT        Region;                 // Relative coordinates on the frame that face detection is running (Q31 format)
    ULONGLONG   Flags;                  // VIDEOPROCFLAG flags indicating the op mode for the ISP control. Default is 0 for focus
    LONG        Weight;                 // Weight of the region   (0 -100)  
    LONG        RegionOfInterestType;   // KSCAMERA_EXTENDEDPROP_ROITYPE_FACE, if the region is a face; Unknown otherwise
} KSCAMERA_EXTENDEDPROP_ROI_INFO, *PKSCAMERA_EXTENDEDPROP_ROI_INFO;

typedef enum 
{
    KSCAMERA_EXTENDEDPROP_ROITYPE_UNKNOWN = 0,
    KSCAMERA_EXTENDEDPROP_ROITYPE_FACE,
} KSCAMERA_EXTENDEDPROP_ROITYPE;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE {
    KSCAMERA_EXTENDEDPROP_ROI_INFO   ROIInfo;   // Must be the first field
    ULONGLONG                        Reserved;     
} KSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE, *PKSCAMERA_EXTENDEDPROP_ROI_WHITEBALANCE;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_EXPOSURE {
    KSCAMERA_EXTENDEDPROP_ROI_INFO   ROIInfo;   // Must be the first field
    ULONGLONG                        Reserved;     
} KSCAMERA_EXTENDEDPROP_ROI_EXPOSURE, *PKSCAMERA_EXTENDEDPROP_ROI_EXPOSURE;

typedef struct tagKSCAMERA_EXTENDEDPROP_ROI_FOCUS {
    KSCAMERA_EXTENDEDPROP_ROI_INFO   ROIInfo;   // Must be the first field
    ULONGLONG                        Reserved;     
} KSCAMERA_EXTENDEDPROP_ROI_FOCUS, *PKSCAMERA_EXTENDEDPROP_ROI_FOCUS;

// Photo confirmation (aka still confirmation)
#define KSCAMERA_EXTENDEDPROP_PHOTOCONFIRMATION_OFF                     0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_PHOTOCONFIRMATION_ON                      0x0000000000000001

//
// Per Frame Settings
//
#define STATIC_KSPROPERTYSETID_PerFrameSettingControl \
    0xf1f3e261, 0xdee6, 0x4537, 0xbf, 0xf5, 0xee, 0x20, 0x6d, 0xb5, 0x4a, 0xac
DEFINE_GUIDSTRUCT("F1F3E261-DEE6-4537-BFF5-EE206DB54AAC", KSPROPERTYSETID_PerFrameSettingControl);
#define KSPROPERTYSETID_PerFrameSettingControl DEFINE_GUIDNAMED(KSPROPERTYSETID_PerFrameSettingControl)

typedef enum {
    KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_CAPABILITY = 0,
    KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_SET,
    KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_CLEAR
} KSPROPERTY_CAMERACONTROL_PERFRAMESETTING_PROPERTY;

#define KSCAMERA_PERFRAMESETTING_AUTO                                   0x0000000100000000
#define KSCAMERA_PERFRAMESETTING_MANUAL                                 0x0000000200000000

typedef enum {
    KSCAMERA_PERFRAMESETTING_ITEM_EXPOSURE_TIME = 1,
    KSCAMERA_PERFRAMESETTING_ITEM_FLASH,
    KSCAMERA_PERFRAMESETTING_ITEM_EXPOSURE_COMPENSATION,
    KSCAMERA_PERFRAMESETTING_ITEM_ISO,
    KSCAMERA_PERFRAMESETTING_ITEM_FOCUS,
    KSCAMERA_PERFRAMESETTING_ITEM_PHOTOCONFIRMATION,
    KSCAMERA_PERFRAMESETTING_ITEM_CUSTOM
} KSCAMERA_PERFRAMESETTING_ITEM_TYPE;

typedef struct {
    ULONG               Size;
    ULONG               Type;   // KSCAMERA_PERFRAMESETTING_ITEM_TYPE
    ULONGLONG           Flags;  // Supported Flags
} KSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER, *PKSCAMERA_PERFRAMESETTING_CAP_ITEM_HEADER;

typedef struct {
    ULONG               Size;
    ULONG               ItemCount;
    ULONGLONG           Flags;
} KSCAMERA_PERFRAMESETTING_CAP_HEADER, *PKSCAMERA_PERFRAMESETTING_CAP_HEADER;

typedef struct {
    ULONG               Size;
    ULONG               Reserved;
    GUID                Id;
} KSCAMERA_PERFRAMESETTING_CUSTOM_ITEM, *PKSCAMERA_PERFRAMESETTING_CUSTOM_ITEM;

typedef struct {
    ULONG               Size;
    ULONG               Type;   // KSCAMERA_PERFRAMESETTING_ITEM_TYPE
    ULONGLONG           Flags;
} KSCAMERA_PERFRAMESETTING_ITEM_HEADER, *PKSCAMERA_PERFRAMESETTING_ITEM_HEADER;

typedef struct {
    ULONG               Size;
    ULONG               Id;
    ULONG               ItemCount;
    ULONG               Reserved;
} KSCAMERA_PERFRAMESETTING_FRAME_HEADER, *PKSCAMERA_PERFRAMESETTING_FRAME_HEADER;

typedef struct {
    ULONG               Size;
    ULONG               FrameCount;
    GUID                Id;
    ULONGLONG           Flags;
    ULONG               LoopCount;
    ULONG               Reserved;
} KSCAMERA_PERFRAMESETTING_HEADER, *PKSCAMERA_PERFRAMESETTING_HEADER;

#endif // (NTDDI_VERSION >= NTDDI_WINBLUE)


#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
#define KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_OFF                        0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_ON                         0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_VIDEOSTABILIZATION_AUTO                       0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_VFR_OFF                                       0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_VFR_ON                                        0x0000000000000001 

#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_OFF                             0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_ON                              0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_PREVIEW                         0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_VIDEO                           0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_PHOTO                           0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_BLINK                           0x0000000000000008
#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_SMILE                           0x0000000000000010

#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_MASK                            (KSCAMERA_EXTENDEDPROP_FACEDETECTION_PREVIEW| \
                                                                             KSCAMERA_EXTENDEDPROP_FACEDETECTION_VIDEO|   \
                                                                             KSCAMERA_EXTENDEDPROP_FACEDETECTION_PHOTO)

#define KSCAMERA_EXTENDEDPROP_FACEDETECTION_ADVANCED_MASK                   (KSCAMERA_EXTENDEDPROP_FACEDETECTION_BLINK|   \
                                                                             KSCAMERA_EXTENDEDPROP_FACEDETECTION_SMILE)

#define KSCAMERA_EXTENDEDPROP_VIDEOHDR_OFF                                  0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_VIDEOHDR_ON                                   0x0000000000000001 
#define KSCAMERA_EXTENDEDPROP_VIDEOHDR_AUTO                                 0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_HISTOGRAM_OFF                                 0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_HISTOGRAM_ON                                  0x0000000000000001

#define KSCAMERA_EXTENDEDPROP_OIS_OFF                                       0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_OIS_ON                                        0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_OIS_AUTO                                      0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_OFF                             0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_AUTO                            0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_HDR                             0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_FNF                             0x0000000000000004
#define KSCAMERA_EXTENDEDPROP_ADVANCEDPHOTO_ULTRALOWLIGHT                   0x0000000000000008

#define KSCAMERA_EXTENDEDPROP_ZOOM_DEFAULT                                  0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_ZOOM_DIRECT                                   0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_ZOOM_SMOOTH                                   0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_DISABLED                        0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_ALTERNATIVE_FRAME_ILLUMINATION  0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_FACEAUTH_MODE_BACKGROUND_SUBTRACTION          0x0000000000000004

#define KSCAMERA_EXTENDEDPROP_SECUREMODE_DISABLED                           0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_SECUREMODE_ENABLED                            0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_AUTO                   0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_OFF                    0x0000000000000002 
#define KSCAMERA_EXTENDEDPROP_VIDEOTEMPORALDENOISING_ON                     0x0000000000000004

#define KSCAMERA_EXTENDEDPROP_IRTORCHMODE_OFF                               0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_IRTORCHMODE_ALWAYS_ON                         0x0000000000000002
#define KSCAMERA_EXTENDEDPROP_IRTORCHMODE_ALTERNATING_FRAME_ILLUMINATION    0x0000000000000004

#define KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_OFF                 0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_ON                  0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_DYNAMIC             0x0000000000000002

#define KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_MASK                (KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_ON| \
                                                                             KSCAMERA_EXTENDEDPROP_RELATIVEPANELOPTIMIZATION_DYNAMIC)


#define KSCAMERA_EXTENDEDPROP_EYEGAZECORRECTION_OFF                         0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_EYEGAZECORRECTION_ON                          0x0000000000000001
#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
#define KSCAMERA_EXTENDEDPROP_EYEGAZECORRECTION_STARE                       0x0000000000000002
#endif //  (NTDDI_VERSION >= NTDDI_WIN10_NI)

#define KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_OFF                    0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_BLUR                   0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_MASK                   0x0000000000000002
#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
#define KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_SHALLOWFOCUS           0x0000000000000004
#endif //  (NTDDI_VERSION >= NTDDI_WIN10_NI)

// Digital Window Framing Flags
#define KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_MANUAL                         0x0000000000000000
#define KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_AUTOFACEFRAMING                0x0000000000000001
#define KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_MASK                           (KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_MANUAL | \
                                                                            KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_AUTOFACEFRAMING)

// Digital Window Region
typedef struct tagKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING {
    LONG        OriginX;                // in Q24
    LONG        OriginY;                // in Q24
    LONG        WindowSize;             // in Q24
    ULONG       Reserved;
} KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING, *PKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING;

typedef struct tagKSCAMERA_METADATA_DIGITALWINDOW {
    KSCAMERA_METADATA_ITEMHEADER   Header;
    KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_SETTING  Window;
}KSCAMERA_METADATA_DIGITALWINDOW, *PKSCAMERA_METADATA_DIGITALWINDOW;

// Digital Window Capabilities
typedef struct tagKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER {
    ULONG       Size;                   // Size of this header + all _CONFIGCAPS structures followed 
    ULONG       Count;                  // Number of _CONFIGCAPS structures followed
} KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER, *PKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPSHEADER;

typedef struct tagKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS {
    LONG        ResolutionX;            // Output width in pixels
    LONG        ResolutionY;            // Output height in pixels
    LONG        PorchTop;               // Upper porch region in Q24
    LONG        PorchLeft;              // Left-most porch region in Q24
    LONG        PorchBottom;            // Lower porch region in Q24
    LONG        PorchRight;             // Right-most porch region in Q24
    LONG        NonUpscalingWindowSize; // Q24 value to get no scaling
    LONG        MinWindowSize;          // Smallest legal WindowSize
    LONG        MaxWindowSize;          // Largest legal WindowSize
    LONG        Reserved;               // Reserved
} KSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS, *PKSCAMERA_EXTENDEDPROP_DIGITALWINDOW_CONFIGCAPS;

#if (NTDDI_VERSION >= NTDDI_WIN10_CO)

typedef struct tagKSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS {
    // Output width and height in pixels
    SIZE Resolution;

    // The maximum frame rate the driver can accommodate  for achieving 
    // background segmentation for each frame corresponding to Resolution
    struct
    {
        LONG Numerator; 
        LONG Denominator;
    } MaxFrameRate;
    
    // The width and height of the mask produced when streaming
    // with a MediaType corresponding to Resolution and MaxFrameRate
    SIZE MaskResolution;

    // Optional subtype for which this configuration capability applies. If left 
    // to zero, all streams conforming the Resolution and MaxFrameRate will support 
    // background segmentation with the specified MaskResolution.
    GUID SubType;
 
} KSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS, *PKSCAMERA_EXTENDEDPROP_BACKGROUNDSEGMENTATION_CONFIGCAPS;

typedef struct tagKSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK {
    KSCAMERA_METADATA_ITEMHEADER   Header;
    RECT                           MaskCoverageBoundingBox;
    SIZE                           MaskResolution;
    RECT                           ForegroundBoundingBox;
    BYTE                           MaskData[1]; // Array of mask data of dimension MaskResolution.cx * MaskResolution.cy
}KSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK, *PKSCAMERA_METADATA_BACKGROUNDSEGMENTATIONMASK;

#endif //  (NTDDI_VERSION >= NTDDI_WIN10_CO)

typedef struct _KSCAMERA_EXTENDEDPROP_PROFILE
{
    GUID    ProfileId;
    UINT32  Index;
    UINT32  Reserved;
} KSCAMERA_EXTENDEDPROP_PROFILE, *PKSCAMERA_EXTENDEDPROP_PROFILE;

#define STATIC_KSCAMERAPROFILE_Legacy \
    0xB4894D81, 0x62B7, 0x4EEC, 0x87, 0x40, 0x80, 0x65, 0x8C, 0x4A, 0x9D, 0x3E
DEFINE_GUIDSTRUCT("B4894D81-62B7-4EEC-8740-80658C4A9D3E", KSCAMERAPROFILE_Legacy);
#define KSCAMERAPROFILE_Legacy DEFINE_GUIDNAMED(KSCAMERAPROFILE_Legacy)

#define STATIC_KSCAMERAPROFILE_VideoRecording \
    0xA0E517E8, 0x8F8C, 0x4F6F, 0x9A, 0x57, 0x46, 0xFC, 0x2F, 0x64, 0x7E, 0xC0
DEFINE_GUIDSTRUCT("A0E517E8-8F8C-4F6F-9A57-46FC2F647EC0", KSCAMERAPROFILE_VideoRecording);
#define KSCAMERAPROFILE_VideoRecording DEFINE_GUIDNAMED(KSCAMERAPROFILE_VideoRecording)

#define STATIC_KSCAMERAPROFILE_HighQualityPhoto \
    0x32440725, 0x961B, 0x4CA3, 0xB5, 0xB2, 0x85, 0x4E, 0x71, 0x9D, 0x9E, 0x1B
DEFINE_GUIDSTRUCT("32440725-961B-4CA3-B5B2-854E719D9E1B", KSCAMERAPROFILE_HighQualityPhoto);
#define KSCAMERAPROFILE_HighQualityPhoto DEFINE_GUIDNAMED(KSCAMERAPROFILE_HighQualityPhoto)

#define STATIC_KSCAMERAPROFILE_BalancedVideoAndPhoto \
    0x6B52B017, 0x42C7, 0x4A21, 0xBF, 0xE3, 0x23, 0xF0, 0x09, 0x14, 0x98, 0x87
DEFINE_GUIDSTRUCT("6B52B017-42C7-4A21-BFE3-23F009149887", KSCAMERAPROFILE_BalancedVideoAndPhoto);
#define KSCAMERAPROFILE_BalancedVideoAndPhoto DEFINE_GUIDNAMED(KSCAMERAPROFILE_BalancedVideoAndPhoto)

#define STATIC_KSCAMERAPROFILE_VideoConferencing \
    0xC5444A88, 0xE1BF, 0x4597, 0xB2, 0xDD, 0x9E, 0x1E, 0xAD, 0x86, 0x4B, 0xB8
DEFINE_GUIDSTRUCT("C5444A88-E1BF-4597-B2DD-9E1EAD864BB8", KSCAMERAPROFILE_VideoConferencing);
#define KSCAMERAPROFILE_VideoConferencing DEFINE_GUIDNAMED(KSCAMERAPROFILE_VideoConferencing)

#define STATIC_KSCAMERAPROFILE_PhotoSequence \
    0x02399D9D, 0x4EE8, 0x49BA, 0xBC, 0x07, 0x5F, 0xF1, 0x56, 0x53, 0x14, 0x13
DEFINE_GUIDSTRUCT("02399D9D-4EE8-49BA-BC07-5FF156531413", KSCAMERAPROFILE_PhotoSequence);
#define KSCAMERAPROFILE_PhotoSequence DEFINE_GUIDNAMED(KSCAMERAPROFILE_PhotoSequence)

#define STATIC_KSCAMERAPROFILE_FaceAuth_Mode \
    0x81361b22, 0x700b, 0x4546, 0xa2, 0xd4, 0xc5, 0x2e, 0x90, 0x7b, 0xfc, 0x27
DEFINE_GUIDSTRUCT("81361B22-700B-4546-A2D4-C52E907BFC27", KSCAMERAPROFILE_FaceAuth_Mode);
#define KSCAMERAPROFILE_FaceAuth_Mode DEFINE_GUIDNAMED(KSCAMERAPROFILE_FaceAuth_Mode)

#define STATIC_KSCAMERAPROFILE_HighFrameRate \
    0x566E6113, 0x8C35, 0x48E7, 0xB8, 0x9F, 0xD2, 0x3F, 0xDC, 0x12, 0x19, 0xDC
DEFINE_GUIDSTRUCT("566E6113-8C35-48E7-B89F-D23FDC1219DC", KSCAMERAPROFILE_HighFrameRate);
#define KSCAMERAPROFILE_HighFrameRate DEFINE_GUIDNAMED(KSCAMERAPROFILE_HighFrameRate)

#define STATIC_KSCAMERAPROFILE_HDRWithWCGVideo \
    0x4B27C336, 0x4924, 0x4989, 0xB9, 0x94, 0xFD, 0xAF, 0x1D, 0xC7, 0xCD, 0x85
DEFINE_GUIDSTRUCT("4B27C336-4924-4989-B994-FDAF1DC7CD85", KSCAMERAPROFILE_HDRWithWCGVideo);
#define KSCAMERAPROFILE_HDRWithWCGVideo DEFINE_GUIDNAMED(KSCAMERAPROFILE_HDRWithWCGVideo)

#define STATIC_KSCAMERAPROFILE_HDRWithWCGPhoto \
    0x9BF6F1FF, 0xB555, 0x4625, 0xB3, 0x26, 0xA4, 0x6D, 0xEF, 0x31, 0x8F, 0xB7
DEFINE_GUIDSTRUCT("9BF6F1FF-B555-4625-B326-A46DEF318FB7", KSCAMERAPROFILE_HDRWithWCGPhoto);
#define KSCAMERAPROFILE_HDRWithWCGPhoto DEFINE_GUIDNAMED(KSCAMERAPROFILE_HDRWithWCGPhoto)

#define STATIC_KSCAMERAPROFILE_VariablePhotoSequence \
    0x9FF2CB56, 0xE75A, 0x49B1, 0xA9, 0x28, 0x99, 0x85, 0xD5, 0x94, 0x6F, 0x87
DEFINE_GUIDSTRUCT("9FF2CB56-E75A-49B1-A928-9985D5946F87", KSCAMERAPROFILE_VariablePhotoSequence);
#define KSCAMERAPROFILE_VariablePhotoSequence DEFINE_GUIDNAMED(KSCAMERAPROFILE_VariablePhotoSequence)

#define STATIC_KSCAMERAPROFILE_VideoHDR8 \
    0xD4F3F4EC, 0xBDFF, 0x4314, 0xB1, 0xD4, 0x00, 0x8E, 0x28, 0x1F, 0x74, 0xE7
DEFINE_GUIDSTRUCT("D4F3F4EC-BDFF-4314-B1D4-008E281F74E7", KSCAMERAPROFILE_VideoHDR8);
#define KSCAMERAPROFILE_VideoHDR8 DEFINE_GUIDNAMED(KSCAMERAPROFILE_VideoHDR8)

#if (NTDDI_VERSION >= NTDDI_WIN10_MN)
#define STATIC_KSCAMERAPROFILE_CompressedCamera \
   0xe34cdc1, 0x27ad, 0x437f, 0xab, 0xde, 0x2, 0xb6, 0x29, 0xf3, 0x7b, 0x44
DEFINE_GUIDSTRUCT("0E34CDC1-27AD-437F-ABDE-02B629F37B44", KSCAMERAPROFILE_CompressedCamera);
#define KSCAMERAPROFILE_CompressedCamera DEFINE_GUIDNAMED(KSCAMERAPROFILE_CompressedCamera)
#endif

#define KSCAMERAPROFILE_FLAGS_VIDEOSTABLIZATION     0x0000000000000001
#define KSCAMERAPROFILE_FLAGS_VIDEOHDR              0x0000000000000002
#define KSCAMERAPROFILE_FLAGS_PHOTOHDR              0x0000000000000004
#define KSCAMERAPROFILE_FLAGS_FACEDETECTION         0x0000000000000008
#define KSCAMERAPROFILE_FLAGS_VARIABLEPHOTOSEQUENCE 0x0000000000000010
#define KSCAMERAPROFILE_FLAGS_PREVIEW_RES_MUSTMATCH 0x0000000000000020

#define KSDEVICE_PROFILE_TYPE_UNKNOWN               0x00000000
#define KSDEVICE_PROFILE_TYPE_CAMERA                0x00000001

//
// Camera Pin Sensor output type should be in sync with MFFrameSourceTypes
//
#define KSCameraProfileSensorType_RGB               0x0001
#define KSCameraProfileSensorType_Infrared          0x0002
#define KSCameraProfileSensorType_Depth             0x0004
#define KSCameraProfileSensorType_PoseTracking      0x0008
#define KSCameraProfileSensorType_ImageSegmentation 0x0010
#define KSCameraProfileSensorType_Custom            0x0080

typedef struct _KSCAMERA_PROFILE_MEDIAINFO
{
    struct 
    {
        UINT32  X;
        UINT32  Y;
    } Resolution;
    struct
    {
        UINT32  Numerator;
        UINT32  Denominator;
    } MaxFrameRate;

    ULONGLONG   Flags;
    UINT32      Data0;
    UINT32      Data1;
    UINT32      Data2;
    UINT32      Data3;
} KSCAMERA_PROFILE_MEDIAINFO, *PKSCAMERA_PROFILE_MEDIAINFO;

typedef struct _KSCAMERA_PROFILE_PININFO
{
    GUID                         PinCategory;
    union  
    {
        struct
        {   
            USHORT PinIndex;
            USHORT ProfileSensorType;
        };
        UINT32                       Reserved;
    };
    UINT32                       MediaInfoCount;
    PKSCAMERA_PROFILE_MEDIAINFO  MediaInfos; 
} KSCAMERA_PROFILE_PININFO, *PKSCAMERA_PROFILE_PININFO;

typedef struct _KSCAMERA_PROFILE_INFO
{
    GUID                        ProfileId;
    UINT32                      Index;
    UINT32                      PinCount;                          
    PKSCAMERA_PROFILE_PININFO   Pins;
} KSCAMERA_PROFILE_INFO, *PKSCAMERA_PROFILE_INFO;

typedef struct _KSCAMERA_PROFILE_CONCURRENCYINFO
{
    GUID                    ReferenceGuid;    
    UINT32                  Reserved;           
    UINT32                  ProfileCount;
    PKSCAMERA_PROFILE_INFO  Profiles;
} KSCAMERA_PROFILE_CONCURRENCYINFO,*PKSCAMERA_PROFILE_CONCURRENCYINFO;

typedef struct _KSDEVICE_PROFILE_INFO
{
    UINT32  Type;
    UINT32  Size;
    union
    {
        struct
        {
            KSCAMERA_PROFILE_INFO               Info;
            UINT32                              Reserved;
            UINT32                              ConcurrencyCount;
            PKSCAMERA_PROFILE_CONCURRENCYINFO   Concurrency;
        } Camera;

        // Add other device type specific "profiles" here.
    };
} KSDEVICE_PROFILE_INFO, *PKSDEVICE_PROFILE_INFO;

#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#endif // (NTDDI_VERSION >= NTDDI_WIN8)

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

#if (NTDDI_VERSION >= NTDDI_WIN8)

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)


#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#endif // (NTDDI_VERSION >= NTDDI_WIN8)


typedef struct _WNF_KSCAMERA_STREAMSTATE_INFO
{
    ULONG   ProcessId;
    ULONG   SessionId;
    ULONG   StreamState;
    ULONG   Reserved;
} WNF_KSCAMERA_STREAMSTATE_INFO, *PWNF_KSCAMERA_STREAMSTATE_INFO;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

//
// Network Camera related definitions
//
typedef enum 
{ 
    KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE_DISABLE = 0, 
    KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE_HOSTNTP, 
    KSPROPERYT_NETWORKCAMERACONTROL_NTPINFO_TYPE_CUSTOM, 
} KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE; 

typedef struct 
{
    ULONG      Size;
    KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_TYPE Type;
}
KSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER, *PKSPROPERTY_NETWORKCAMERACONTROL_NTPINFO_HEADER;

#define STATIC_KSPROPERTYSETID_NetworkCameraControl \
    0xe780f09, 0x5745, 0x4e3a,  0xbc, 0x9f, 0xf2, 0x26, 0xea, 0x43, 0xa6, 0xec
DEFINE_GUIDSTRUCT("0E780F09-5745-4E3A-BC9F-F226EA43A6EC", KSPROPERTYSETID_NetworkCameraControl);
#define KSPROPERTYSETID_NetworkCameraControl DEFINE_GUIDNAMED(KSPROPERTYSETID_NetworkCameraControl)

typedef enum 
{
  KSPROPERTY_NETWORKCAMERACONTROL_NTP,
  KSPROPERTY_NETWORKCAMERACONTROL_URI,
#if(NTDDI_VERSION >= NTDDI_WIN10_FE)  
  KSPROPERTY_NETWORKCAMERACONTROL_METADATA, 
  KSPROPERTY_NETWORKCAMERACONTROL_EVENTTOPICS_XML, 
#endif
} KSPROPERTY_NETWORKCAMERACONTROL_PROPERTY;

#if(NTDDI_VERSION >= NTDDI_WIN10_FE)
typedef enum 
{ 
    KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE_EVENTSINFO, 
} KSPROPERTY_NETWORKCAMERACONTROL_METADATA_TYPE;

typedef struct _KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO
{
     ULONG  MetadataItems;
     ULONG  Size;
     BOOL   PTZStatus;
     BOOL   Events;
     BOOL   Analytics;
     BOOL   Reserved;
} KSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO, *PKSPROPERTY_NETWORKCAMERACONTROL_METADATA_INFO;

typedef struct _KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO
{
    KSCAMERA_METADATA_ITEMHEADER Header;
    WCHAR                        EventFilter[1];
}KSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO, *PKSPROPERTY_NETWORKCAMERACONTROL_EVENT_INFO;

#endif // NTDDI_VERSION >= NTDDI_WIN10_FE

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

#if(NTDDI_VERSION >= NTDDI_WIN10_NI)
#endif

#ifndef __EDevCtrl__
#define __EDevCtrl__
//===========================================================================

#define STATIC_PROPSETID_EXT_DEVICE\
    0xB5730A90L, 0x1A2C, 0x11cf, 0x8c, 0x23, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14
DEFINE_GUIDSTRUCT("B5730A90-1A2C-11cf-8C23-00AA006B6814", PROPSETID_EXT_DEVICE);
#define PROPSETID_EXT_DEVICE DEFINE_GUIDNAMED(PROPSETID_EXT_DEVICE)

typedef enum {
    KSPROPERTY_EXTDEVICE_ID,                // R
    KSPROPERTY_EXTDEVICE_VERSION,           // R
    KSPROPERTY_EXTDEVICE_POWER_STATE,       // RW
    KSPROPERTY_EXTDEVICE_PORT,              // R
    KSPROPERTY_EXTDEVICE_CAPABILITIES       // R
} KSPROPERTY_EXTDEVICE;

typedef struct tagDEVCAPS{
    LONG CanRecord;
    LONG CanRecordStrobe;
    LONG HasAudio;
    LONG HasVideo;
    LONG UsesFiles;
    LONG CanSave;
    LONG DeviceType;
    LONG TCRead;
    LONG TCWrite;
    LONG CTLRead;
    LONG IndexRead;
    LONG Preroll;
    LONG Postroll;
    LONG SyncAcc;
    LONG NormRate;
    LONG CanPreview;
    LONG CanMonitorSrc;
    LONG CanTest;
    LONG VideoIn;
    LONG AudioIn;
    LONG Calibrate;
    LONG SeekType;
    LONG SimulatedHardware;        
} DEVCAPS, *PDEVCAPS;

typedef struct {
    KSPROPERTY Property;
    union {
        DEVCAPS  Capabilities;          // Device capabilities
        ULONG    DevPort;               // 1394, USB, etc.
        ULONG    PowerState;            // On, standby or off
        WCHAR    pawchString[MAX_PATH]; // Version
        DWORD    NodeUniqueID[2];       // Unique NodeID
    } u;
} KSPROPERTY_EXTDEVICE_S, *PKSPROPERTY_EXTDEVICE_S;

//===========================================================================

#define STATIC_PROPSETID_EXT_TRANSPORT\
    0xA03CD5F0L, 0x3045, 0x11cf, 0x8c, 0x44, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14
DEFINE_GUIDSTRUCT("A03CD5F0-3045-11cf-8C44-00AA006B6814", PROPSETID_EXT_TRANSPORT);
#define PROPSETID_EXT_TRANSPORT DEFINE_GUIDNAMED(PROPSETID_EXT_TRANSPORT)

typedef enum {
    KSPROPERTY_EXTXPORT_CAPABILITIES,       // (R)  Transport specific capability 
    KSPROPERTY_EXTXPORT_INPUT_SIGNAL_MODE,  // (RW) Input signal: e.g. dvsd/NTSC/PAL, dvsl/NTSC/PAL, MPEG2-TS etc
    KSPROPERTY_EXTXPORT_OUTPUT_SIGNAL_MODE, // (RW) Output signal: e.g. dvsd/NTSC/PAL, dvsl/NTSC/PAL, MPEG2-TS etc
    KSPROPERTY_EXTXPORT_LOAD_MEDIUM,        // (RW) Eject, open tray, close tray
    KSPROPERTY_EXTXPORT_MEDIUM_INFO,        // (R)  Cassettte type, tape grade and write protection
    KSPROPERTY_EXTXPORT_STATE,              // (RW) Current transport mode and state
    KSPROPERTY_EXTXPORT_STATE_NOTIFY,       // (RW) Notify of transport mode and state change
    KSPROPERTY_EXTXPORT_TIMECODE_SEARCH,    // (W)  Search to a specific timecode on a tape
    KSPROPERTY_EXTXPORT_ATN_SEARCH,         // (W)  Search to a specific absolute track number (ATN) on a tape
    KSPROPERTY_EXTXPORT_RTC_SEARCH,         // (W)  Search to a specific relative time counter (RTC) on a tape
    KSPROPERTY_RAW_AVC_CMD                  // (RW) Issue a raw AVC commnad
} KSPROPERTY_EXTXPORT;

typedef struct tagTRANSPORTSTATUS{
    LONG Mode;
    LONG LastError;
    LONG RecordInhibit;
    LONG ServoLock;
    LONG MediaPresent;
    LONG MediaLength;
    LONG MediaSize;
    LONG MediaTrackCount;
    LONG MediaTrackLength;
    LONG MediaTrackSide;
    LONG MediaType;
    LONG LinkMode;
    LONG NotifyOn;
} TRANSPORTSTATUS, *PTRANSPORTSTATUS;

typedef struct tagTRANSPORTBASICPARMS{
    LONG TimeFormat;
    LONG TimeReference;
    LONG Superimpose;
    LONG EndStopAction;
    LONG RecordFormat;
    LONG StepFrames;
    LONG SetpField;
    LONG Preroll;
    LONG RecPreroll;
    LONG Postroll;
    LONG EditDelay;
    LONG PlayTCDelay;
    LONG RecTCDelay;
    LONG EditField;
    LONG FrameServo;
    LONG ColorFrameServo;
    LONG ServoRef;
    LONG WarnGenlock;
    LONG SetTracking;
    TCHAR VolumeName[40];
    LONG Ballistic[20];
    LONG Speed;
    LONG CounterFormat;
    LONG TunerChannel;
    LONG TunerNumber;
    LONG TimerEvent;
    LONG TimerStartDay;
    LONG TimerStartTime;
    LONG TimerStopDay;
    LONG TimerStopTime;
} TRANSPORTBASICPARMS, *PTRANSPORTBASICPARMS;

typedef struct tagTRANSPORTVIDEOPARMS{
    LONG OutputMode;
    LONG Input;
} TRANSPORTVIDEOPARMS, *PTRANSPORTVIDEOPARMS;

typedef struct tagTRANSPORTAUDIOPARMS{
    LONG EnableOutput;
    LONG EnableRecord;
    LONG EnableSelsync;
    LONG Input;
    LONG MonitorSource;
} TRANSPORTAUDIOPARMS, *PTRANSPORTAUDIOPARMS;

typedef struct {
    BOOL  MediaPresent;      
    ULONG MediaType;         
    BOOL  RecordInhibit;    
} MEDIUM_INFO, *PMEDIUM_INFO;

typedef struct {
    ULONG Mode;              
    ULONG State;
} TRANSPORT_STATE, *PTRANSPORT_STATE;

typedef struct {
    KSPROPERTY Property;
    union {    
        ULONG      Capabilities;
        ULONG      SignalMode;
        ULONG      LoadMedium;
        MEDIUM_INFO MediumInfo;
        TRANSPORT_STATE XPrtState;
        struct {
          BYTE frame;        
          BYTE second;
          BYTE minute;
          BYTE hour;
        } Timecode;
        DWORD dwTimecode;            
        DWORD dwAbsTrackNumber;      
        struct {
            ULONG   PayloadSize;
            BYTE    Payload[512];  
        } RawAVC;                    
    } u;
     
} KSPROPERTY_EXTXPORT_S, *PKSPROPERTY_EXTXPORT_S;

typedef struct {
    KSP_NODE NodeProperty;
    union {    
        ULONG      Capabilities;
        ULONG      SignalMode;
        ULONG      LoadMedium;
        MEDIUM_INFO MediumInfo;
        TRANSPORT_STATE XPrtState;
        struct {
          BYTE frame;        
          BYTE second;
          BYTE minute;
          BYTE hour;
        } Timecode;
        DWORD dwTimecode;            
        DWORD dwAbsTrackNumber;      
        struct {
            ULONG   PayloadSize;
            BYTE    Payload[512];  
        } RawAVC;                    
    } u;
     
} KSPROPERTY_EXTXPORT_NODE_S, *PKSPROPERTY_EXTXPORT_NODE_S;

//===========================================================================

#define STATIC_PROPSETID_TIMECODE_READER\
    0x9B496CE1L, 0x811B, 0x11cf, 0x8C, 0x77, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14
DEFINE_GUIDSTRUCT("9B496CE1-811B-11cf-8C77-00AA006B6814", PROPSETID_TIMECODE_READER);
#define PROPSETID_TIMECODE_READER DEFINE_GUIDNAMED(PROPSETID_TIMECODE_READER)

typedef enum {
    KSPROPERTY_TIMECODE_READER,  // (R) Timecode for the current tape position
    KSPROPERTY_ATN_READER,       // (R) Absolute track number for the current tape position
    KSPROPERTY_RTC_READER        // (R) Relative time counter for the current tape position
} KSPROPERTY_TIMECODE;

#ifndef TIMECODE_DEFINED
#define TIMECODE_DEFINED
typedef union _timecode {
    struct {
        WORD   wFrameRate;
        WORD   wFrameFract;
        DWORD  dwFrames;
        };
    DWORDLONG  qw;
} TIMECODE;
typedef TIMECODE *PTIMECODE;

typedef struct tagTIMECODE_SAMPLE {
    LONGLONG qwTick;
    TIMECODE timecode;
    DWORD dwUser;
    DWORD dwFlags;
} TIMECODE_SAMPLE;

typedef TIMECODE_SAMPLE *PTIMECODE_SAMPLE;

#endif /* TIMECODE_DEFINED */

typedef struct {
    KSPROPERTY Property;
    TIMECODE_SAMPLE TimecodeSamp;
} KSPROPERTY_TIMECODE_S, *PKSPROPERTY_TIMECODE_S;

typedef struct {
    KSP_NODE NodeProperty;
    TIMECODE_SAMPLE TimecodeSamp;
} KSPROPERTY_TIMECODE_NODE_S, *PKSPROPERTY_TIMECODE_NODE_S;

//===========================================================================

#define STATIC_KSEVENTSETID_EXTDEV_Command\
    0x109c7988L, 0xb3cb, 0x11d2, 0xb4, 0x8e, 0x00, 0x60, 0x97, 0xb3, 0x39, 0x1b
DEFINE_GUIDSTRUCT("109c7988-b3cb-11d2-b48e-006097b3391b", KSEVENTSETID_EXTDEV_Command);
#define KSEVENTSETID_EXTDEV_Command DEFINE_GUIDNAMED(KSEVENTSETID_EXTDEV_Command)

typedef enum {
    KSEVENT_EXTDEV_COMMAND_NOTIFY_INTERIM_READY,     // Final response is ready for notify command 
    KSEVENT_EXTDEV_COMMAND_CONTROL_INTERIM_READY,    // Final response is ready for control command.
    KSEVENT_EXTDEV_COMMAND_BUSRESET,                 // A bus reset has occured.
    KSEVENT_EXTDEV_TIMECODE_UPDATE,                  // Timecode has changed.
    KSEVENT_EXTDEV_OPERATION_MODE_UPDATE,            // Operting mode (VCR,Camera, etc.) has changed.
    KSEVENT_EXTDEV_TRANSPORT_STATE_UPDATE,           // Transport state has changed.
    KSEVENT_EXTDEV_NOTIFY_REMOVAL,                   // Device was surprise removal.
    KSEVENT_EXTDEV_NOTIFY_MEDIUM_CHANGE              // Tape medium is removed or added.
} KSEVENT_DEVCMD;

#endif // __EDevCtrl__

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#endif // XP SP2 and later (chronologically)

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

//===========================================================================

#define STATIC_PROPSETID_VIDCAP_CROSSBAR\
    0x6a2e0640L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0640-28e4-11d0-a18c-00a0c9118956", PROPSETID_VIDCAP_CROSSBAR);
#define PROPSETID_VIDCAP_CROSSBAR DEFINE_GUIDNAMED(PROPSETID_VIDCAP_CROSSBAR)

typedef enum {
    KSPROPERTY_CROSSBAR_CAPS,                     // R
    KSPROPERTY_CROSSBAR_PININFO,                  // R
    KSPROPERTY_CROSSBAR_CAN_ROUTE,                // R
    KSPROPERTY_CROSSBAR_ROUTE,                    // RW
    KSPROPERTY_CROSSBAR_INPUT_ACTIVE              // R
} KSPROPERTY_VIDCAP_CROSSBAR;

typedef struct {
    KSPROPERTY Property;
    ULONG  NumberOfInputs;      // the number of audio and video input pins
    ULONG  NumberOfOutputs;     // the number of audio and video output pins
} KSPROPERTY_CROSSBAR_CAPS_S, *PKSPROPERTY_CROSSBAR_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    KSPIN_DATAFLOW Direction;     // KSPIN_DATAFLOW_IN or KSPIN_DATAFLOW_OUT?
    ULONG  Index;                 // Which pin to return data for?
    ULONG  PinType;               // KS_PhysConn_Video_* or KS_PhysConn_Audio_*
    ULONG  RelatedPinIndex;       // For video pins, this is the related audio pin
    KSPIN_MEDIUM  Medium;         // Identifies the hardware connection
} KSPROPERTY_CROSSBAR_PININFO_S, *PKSPROPERTY_CROSSBAR_PININFO_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  IndexInputPin;        // Zero based index of the input pin
    ULONG  IndexOutputPin;       // Zero based index of the output pin
    ULONG  CanRoute;             // returns non-zero on CAN_ROUTE if routing is possible
} KSPROPERTY_CROSSBAR_ROUTE_S, *PKSPROPERTY_CROSSBAR_ROUTE_S;

typedef struct {
    KSPROPERTY Property;
    ULONG  IndexInputPin;        // W - Zero based index of the input pin
    ULONG  Active;               // R - returns whether an active signal is present on the given input
} KSPROPERTY_CROSSBAR_ACTIVE_S, *PKSPROPERTY_CROSSBAR_ACTIVE_S;

#define STATIC_EVENTSETID_CROSSBAR\
    0x6a2e0641L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0641-28e4-11d0-a18c-00a0c9118956", EVENTSETID_CROSSBAR);
#define EVENTSETID_CROSSBAR DEFINE_GUIDNAMED(EVENTSETID_CROSSBAR)

typedef enum {
    KSEVENT_CROSSBAR_CHANGED
} KSEVENT_CROSSBAR;

// The following IDs should match the AM equivalents
typedef enum {
    KS_PhysConn_Video_Tuner = 1,
    KS_PhysConn_Video_Composite,
    KS_PhysConn_Video_SVideo,
    KS_PhysConn_Video_RGB,
    KS_PhysConn_Video_YRYBY,
    KS_PhysConn_Video_SerialDigital,
    KS_PhysConn_Video_ParallelDigital,
    KS_PhysConn_Video_SCSI,
    KS_PhysConn_Video_AUX,
    KS_PhysConn_Video_1394,
    KS_PhysConn_Video_USB,
    KS_PhysConn_Video_VideoDecoder,
    KS_PhysConn_Video_VideoEncoder,
    KS_PhysConn_Video_SCART,

    KS_PhysConn_Audio_Tuner = 4096,
    KS_PhysConn_Audio_Line,
    KS_PhysConn_Audio_Mic,
    KS_PhysConn_Audio_AESDigital,
    KS_PhysConn_Audio_SPDIFDigital,
    KS_PhysConn_Audio_SCSI,
    KS_PhysConn_Audio_AUX,
    KS_PhysConn_Audio_1394,
    KS_PhysConn_Audio_USB,
    KS_PhysConn_Audio_AudioDecoder
} KS_PhysicalConnectorType;


//===========================================================================

#define STATIC_PROPSETID_VIDCAP_TVAUDIO\
    0x6a2e0650L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0650-28e4-11d0-a18c-00a0c9118956", PROPSETID_VIDCAP_TVAUDIO);
#define PROPSETID_VIDCAP_TVAUDIO DEFINE_GUIDNAMED(PROPSETID_VIDCAP_TVAUDIO)

typedef enum {
    KSPROPERTY_TVAUDIO_CAPS,                            // R
    KSPROPERTY_TVAUDIO_MODE,                            // RW
    KSPROPERTY_TVAUDIO_CURRENTLY_AVAILABLE_MODES        // R
} KSPROPERTY_VIDCAP_TVAUDIO;

#define KS_TVAUDIO_MODE_MONO           0x0001          // Mono
#define KS_TVAUDIO_MODE_STEREO         0x0002          // Stereo
#define KS_TVAUDIO_MODE_LANG_A         0x0010          // Primary language
#define KS_TVAUDIO_MODE_LANG_B         0x0020          // 2nd avail language
#define KS_TVAUDIO_MODE_LANG_C         0x0040          // 3rd avail language
#if (NTDDI_VERSION >= NTDDI_VISTA)
#define KS_TVAUDIO_PRESET_STEREO       0x0200          // if present, stereo
#define KS_TVAUDIO_PRESET_LANG_A       0x1000          // if present, Language A
#define KS_TVAUDIO_PRESET_LANG_B       0x2000          // if present, Language B
#define KS_TVAUDIO_PRESET_LANG_C       0x4000          // if present, Language C
#endif // (NTDDI_VERSION >= NTDDI_VISTA

typedef struct {
    KSPROPERTY Property;
    ULONG      Capabilities;             // Bitmask of KS_TVAUDIO_MODE_*
    KSPIN_MEDIUM InputMedium;
    KSPIN_MEDIUM OutputMedium;
} KSPROPERTY_TVAUDIO_CAPS_S, *PKSPROPERTY_TVAUDIO_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      Mode;                     // KS_TVAUDIO_MODE_*
} KSPROPERTY_TVAUDIO_S, *PKSPROPERTY_TVAUDIO_S;


#define STATIC_KSEVENTSETID_VIDCAP_TVAUDIO\
    0x6a2e0651L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0651-28e4-11d0-a18c-00a0c9118956", KSEVENTSETID_VIDCAP_TVAUDIO);
#define KSEVENTSETID_VIDCAP_TVAUDIO DEFINE_GUIDNAMED(KSEVENTSETID_VIDCAP_TVAUDIO)

typedef enum {
    KSEVENT_TVAUDIO_CHANGED,
} KSEVENT_TVAUDIO;

//===========================================================================
#define STATIC_PROPSETID_VIDCAP_VIDEOCOMPRESSION\
    0xC6E13343L, 0x30AC, 0x11d0, 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("C6E13343-30AC-11d0-A18C-00A0C9118956", PROPSETID_VIDCAP_VIDEOCOMPRESSION);
#define PROPSETID_VIDCAP_VIDEOCOMPRESSION DEFINE_GUIDNAMED(PROPSETID_VIDCAP_VIDEOCOMPRESSION)

typedef enum {
    KSPROPERTY_VIDEOCOMPRESSION_GETINFO,              // R
    KSPROPERTY_VIDEOCOMPRESSION_KEYFRAME_RATE,        // RW
    KSPROPERTY_VIDEOCOMPRESSION_PFRAMES_PER_KEYFRAME, // RW
    KSPROPERTY_VIDEOCOMPRESSION_QUALITY,              // RW
    KSPROPERTY_VIDEOCOMPRESSION_OVERRIDE_KEYFRAME,    // W
    KSPROPERTY_VIDEOCOMPRESSION_OVERRIDE_FRAME_SIZE,  // W
    KSPROPERTY_VIDEOCOMPRESSION_WINDOWSIZE            // RW
} KSPROPERTY_VIDCAP_VIDEOCOMPRESSION;

typedef enum {
    KS_CompressionCaps_CanQuality = 1,
    KS_CompressionCaps_CanCrunch = 2,
    KS_CompressionCaps_CanKeyFrame = 4,
    KS_CompressionCaps_CanBFrame = 8,
    KS_CompressionCaps_CanWindow = 0x10
} KS_CompressionCaps;

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

typedef enum {
    KS_StreamingHint_FrameInterval = 0x0100,
    KS_StreamingHint_KeyFrameRate = 0x0200,
    KS_StreamingHint_PFrameRate = 0x0400,
    KS_StreamingHint_CompQuality = 0x0800,
    KS_StreamingHint_CompWindowSize = 0x1000
} KS_VideoStreamingHints;

#endif // XP SP2 and later (chronologically)

typedef struct {
    KSPROPERTY Property;
    // Note, no VersionString!
    // Note, no DescriptionString!
    ULONG      StreamIndex;             // zero based index of stream
    LONG       DefaultKeyFrameRate;     // Key frame rate
    LONG       DefaultPFrameRate;       // Predeicted frames per Key frame
    LONG       DefaultQuality;          // 0 to 10000
    LONG       NumberOfQualitySettings; // How many discreet quality settings?
    LONG       Capabilities;            // KS_CompressionCaps_*
} KSPROPERTY_VIDEOCOMPRESSION_GETINFO_S, *PKSPROPERTY_VIDEOCOMPRESSION_GETINFO_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      StreamIndex;             // zero based index of stream
    LONG       Value;                   // value to get or set
} KSPROPERTY_VIDEOCOMPRESSION_S, *PKSPROPERTY_VIDEOCOMPRESSION_S;

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;             // zero based index of stream
    LONG        Value;                   // value to get or set
    ULONG       Flags;
} KSPROPERTY_VIDEOCOMPRESSION_S1, *PKSPROPERTY_VIDEOCOMPRESSION_S1;

#endif // XP SP2 and later (chronologically)

//===========================================================================
// MEDIASUBTYPE_Overlay
#define STATIC_KSDATAFORMAT_SUBTYPE_OVERLAY\
    0xe436eb7fL, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70
DEFINE_GUIDSTRUCT("e436eb7f-524f-11ce-9f53-0020af0ba770", KSDATAFORMAT_SUBTYPE_OVERLAY);
#define KSDATAFORMAT_SUBTYPE_OVERLAY DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_OVERLAY)

#define STATIC_KSPROPSETID_OverlayUpdate\
    0x490EA5CFL, 0x7681, 0x11D1, 0xA2, 0x1C, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96
DEFINE_GUIDSTRUCT("490EA5CF-7681-11D1-A21C-00A0C9223196", KSPROPSETID_OverlayUpdate);
#define KSPROPSETID_OverlayUpdate DEFINE_GUIDNAMED(KSPROPSETID_OverlayUpdate)

typedef enum {
    KSPROPERTY_OVERLAYUPDATE_INTERESTS,
    KSPROPERTY_OVERLAYUPDATE_CLIPLIST = 0x1,
    KSPROPERTY_OVERLAYUPDATE_PALETTE = 0x2,
    KSPROPERTY_OVERLAYUPDATE_COLORKEY = 0x4,
    KSPROPERTY_OVERLAYUPDATE_VIDEOPOSITION = 0x8,
    KSPROPERTY_OVERLAYUPDATE_DISPLAYCHANGE = 0x10,
    KSPROPERTY_OVERLAYUPDATE_COLORREF = 0x10000000
} KSPROPERTY_OVERLAYUPDATE;

typedef struct {
    ULONG   PelsWidth;
    ULONG   PelsHeight;
    ULONG   BitsPerPel;
    WCHAR   DeviceID[1];
} KSDISPLAYCHANGE, *PKSDISPLAYCHANGE;

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_INTERESTS(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_INTERESTS,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(ULONG),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_PALETTE(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_PALETTE,\
        NULL,\
        sizeof(KSPROPERTY),\
        0,\
        (Handler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_COLORKEY(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_COLORKEY,\
        NULL,\
        sizeof(KSPROPERTY),\
        sizeof(COLORKEY),\
        (Handler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_CLIPLIST(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_CLIPLIST,\
        NULL,\
        sizeof(KSPROPERTY),\
        2 * sizeof(RECT) + sizeof(RGNDATAHEADER),\
        (Handler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_VIDEOPOSITION(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_VIDEOPOSITION,\
        NULL,\
        sizeof(KSPROPERTY),\
        2 * sizeof(RECT),\
        (Handler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_DISPLAYCHANGE(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_DISPLAYCHANGE,\
        NULL,\
        sizeof(KSPROPERTY),\
        sizeof(KSDISPLAYCHANGE),\
        (Handler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_OVERLAYUPDATE_COLORREF(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_OVERLAYUPDATE_COLORREF,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(COLORREF),\
        NULL,\
        NULL, 0, NULL, NULL, 0)

//===========================================================================
#define STATIC_PROPSETID_VIDCAP_VIDEOCONTROL\
    0x6a2e0670L, 0x28e4, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("6a2e0670-28e4-11d0-a18c-00a0c9118956", PROPSETID_VIDCAP_VIDEOCONTROL);
#define PROPSETID_VIDCAP_VIDEOCONTROL DEFINE_GUIDNAMED(PROPSETID_VIDCAP_VIDEOCONTROL)

typedef enum {
    KSPROPERTY_VIDEOCONTROL_CAPS,               // R
    KSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE,  // R O
    KSPROPERTY_VIDEOCONTROL_FRAME_RATES,        // R O
    KSPROPERTY_VIDEOCONTROL_MODE                // RWO
} KSPROPERTY_VIDCAP_VIDEOCONTROL;

typedef enum {
    KS_VideoControlFlag_FlipHorizontal        = 0x0001,
    KS_VideoControlFlag_FlipVertical          = 0x0002,
    KS_Obsolete_VideoControlFlag_ExternalTriggerEnable = 0x0010,    // ***WARNING *** Flag msimatch with DSHOW.
    KS_Obsolete_VideoControlFlag_Trigger               = 0x0020,  // ***WARNING *** Flag msimatch with DSHOW.
    KS_VideoControlFlag_ExternalTriggerEnable = 0x0004,
    KS_VideoControlFlag_Trigger                      = 0x0008,
    KS_VideoControlFlag_IndependentImagePin          = 0x0040
    #if (NTDDI_VERSION >= NTDDI_WIN8)
    , KS_VideoControlFlag_StillCapturePreviewFrame     = 0x0080,
    KS_VideoControlFlag_StartPhotoSequenceCapture         = 0x0100,
    KS_VideoControlFlag_StopPhotoSequenceCapture          = 0x0200
    #endif
} KS_VideoControlFlags;

typedef struct {
    KSPROPERTY Property;
    ULONG      StreamIndex;
    ULONG      VideoControlCaps;                // KS_VideoControlFlags_*
} KSPROPERTY_VIDEOCONTROL_CAPS_S, *PKSPROPERTY_VIDEOCONTROL_CAPS_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      StreamIndex;
    LONG       Mode;                            // KS_VideoControlFlags_*
} KSPROPERTY_VIDEOCONTROL_MODE_S, *PKSPROPERTY_VIDEOCONTROL_MODE_S;

typedef struct {
    KSPROPERTY Property;
    ULONG      StreamIndex;                     // Index of stream
    ULONG      RangeIndex;                      // Index of range
    SIZE       Dimensions;                      // Size of image
    LONGLONG   CurrentActualFrameRate;          // Only correct if pin is open
    LONGLONG   CurrentMaxAvailableFrameRate;    // Max Rate temporarily limited on USB or 1394?
} KSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE_S, *PKSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE_S;

// KSPROPERTY_VIDEOCONTROL_FRAME_RATES returns a list of available frame rates in 100 nS units
typedef struct {
    KSPROPERTY Property;
    ULONG      StreamIndex;                     // Index of stream
    ULONG      RangeIndex;                      // Index of range
    SIZE       Dimensions;                      // Size of image
} KSPROPERTY_VIDEOCONTROL_FRAME_RATES_S, *PKSPROPERTY_VIDEOCONTROL_FRAME_RATES_S;

//===========================================================================
#define STATIC_PROPSETID_VIDCAP_DROPPEDFRAMES\
    0xC6E13344L, 0x30AC, 0x11d0, 0xa1, 0x8c, 0x00, 0xa0, 0xc9, 0x11, 0x89, 0x56
DEFINE_GUIDSTRUCT("C6E13344-30AC-11d0-A18C-00A0C9118956", PROPSETID_VIDCAP_DROPPEDFRAMES);
#define PROPSETID_VIDCAP_DROPPEDFRAMES DEFINE_GUIDNAMED(PROPSETID_VIDCAP_DROPPEDFRAMES)

typedef enum {
    KSPROPERTY_DROPPEDFRAMES_CURRENT            // R
} KSPROPERTY_VIDCAP_DROPPEDFRAMES;

typedef struct {
    KSPROPERTY Property;
    LONGLONG   PictureNumber;                   // Current Picture Number
    LONGLONG   DropCount;                       // Count of frames dropped
    ULONG      AverageFrameSize;                // Average size of frames captured
} KSPROPERTY_DROPPEDFRAMES_CURRENT_S, *PKSPROPERTY_DROPPEDFRAMES_CURRENT_S;

//===========================================================================
// VPE

#define STATIC_KSPROPSETID_VPConfig\
    0xbc29a660L, 0x30e3, 0x11d0, 0x9e, 0x69, 0x00, 0xc0, 0x4f, 0xd7, 0xc1, 0x5b
DEFINE_GUIDSTRUCT("bc29a660-30e3-11d0-9e69-00c04fd7c15b", KSPROPSETID_VPConfig);
#define KSPROPSETID_VPConfig DEFINE_GUIDNAMED(KSPROPSETID_VPConfig)

#define STATIC_KSPROPSETID_VPVBIConfig\
    0xec529b00L, 0x1a1f, 0x11d1, 0xba, 0xd9, 0x0, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("ec529b00-1a1f-11d1-bad9-00609744111a", KSPROPSETID_VPVBIConfig);
#define KSPROPSETID_VPVBIConfig DEFINE_GUIDNAMED(KSPROPSETID_VPVBIConfig)

// Both of the above property sets use the same list of properties below

typedef enum {
    KSPROPERTY_VPCONFIG_NUMCONNECTINFO,
    KSPROPERTY_VPCONFIG_GETCONNECTINFO,
    KSPROPERTY_VPCONFIG_SETCONNECTINFO,
    KSPROPERTY_VPCONFIG_VPDATAINFO,
    KSPROPERTY_VPCONFIG_MAXPIXELRATE,
    KSPROPERTY_VPCONFIG_INFORMVPINPUT,
    KSPROPERTY_VPCONFIG_NUMVIDEOFORMAT,
    KSPROPERTY_VPCONFIG_GETVIDEOFORMAT,
    KSPROPERTY_VPCONFIG_SETVIDEOFORMAT,
    KSPROPERTY_VPCONFIG_INVERTPOLARITY,
    KSPROPERTY_VPCONFIG_DECIMATIONCAPABILITY,   // E_NOTIMPL for VBI
    KSPROPERTY_VPCONFIG_SCALEFACTOR,            // E_NOTIMPL for VBI
    KSPROPERTY_VPCONFIG_DDRAWHANDLE,
    KSPROPERTY_VPCONFIG_VIDEOPORTID,
    KSPROPERTY_VPCONFIG_DDRAWSURFACEHANDLE,
    KSPROPERTY_VPCONFIG_SURFACEPARAMS
} KSPROPERTY_VPCONFIG;

#if (NTDDI_VERSION >= NTDDI_WINXP)
//=========================
// IBasicAudio
//
#define STATIC_CLSID_KsIBasicAudioInterfaceHandler\
    0xb9f8ac3e, 0x0f71, 0x11d2, 0xb7, 0x2c, 0x00, 0xc0, 0x4f, 0xb6, 0xbd, 0x3d
DEFINE_GUIDSTRUCT("b9f8ac3e-0f71-11d2-b72c-00c04fb6bd3d", CLSID_KsIBasicAudioInterfaceHandler);
#define CLSID_KsIBasicAudioInterfaceHandler DEFINE_GUIDNAMED(CLSID_KsIBasicAudioInterfaceHandler)

#endif // (NTDDI_VERSION >= NTDDI_WINXP)

#if defined(__IVPType__)

typedef struct {
    AMVPSIZE    Size;
    DWORD       MaxPixelsPerSecond;
    DWORD       Reserved;
} KSVPMAXPIXELRATE, *PKSVPMAXPIXELRATE;

typedef struct {
    KSPROPERTY      Property;
    AMVPSIZE        Size;
} KSVPSIZE_PROP, *PKSVPSIZE_PROP;

typedef struct {
    DWORD   dwPitch;
    DWORD   dwXOrigin;
    DWORD   dwYOrigin;
} KSVPSURFACEPARAMS, *PKSVPSURFACEPARAMS;

#else  // !defined(__IVPType__)

#if !defined(__DDRAW_INCLUDED__)

//==========================================================================
// The following definitions must be in sync with DDraw.h in DirectX SDK
//==========================================================================

/*
 * The FourCC code is valid.
 */
#define DDPF_FOURCC                             0x00000004l

#ifndef _DDPIXELFORMAT_DEFINED
#define _DDPIXELFORMAT_DEFINED
typedef struct _DDPIXELFORMAT
{
    DWORD       dwSize;                 // size of structure
    DWORD       dwFlags;                // pixel format flags
    DWORD       dwFourCC;               // (FOURCC code)
    union
    {
    DWORD   dwRGBBitCount;          // how many bits per pixel (BD_1,2,4,8,16,24,32)
    DWORD   dwYUVBitCount;          // how many bits per pixel (BD_4,8,16,24,32)
    DWORD   dwZBufferBitDepth;      // how many bits for z buffers (BD_8,16,24,32)
    DWORD   dwAlphaBitDepth;        // how many bits for alpha channels (BD_1,2,4,8)
    };
    union
    {
    DWORD   dwRBitMask;             // mask for red bit
    DWORD   dwYBitMask;             // mask for Y bits
    };
    union
    {
    DWORD   dwGBitMask;             // mask for green bits
    DWORD   dwUBitMask;             // mask for U bits
    };
    union
    {
    DWORD   dwBBitMask;             // mask for blue bits
    DWORD   dwVBitMask;             // mask for V bits
    };
    union
    {
    DWORD   dwRGBAlphaBitMask;      // mask for alpha channel
    DWORD   dwYUVAlphaBitMask;      // mask for alpha channel
    DWORD   dwRGBZBitMask;          // mask for Z channel
    DWORD   dwYUVZBitMask;          // mask for Z channel
    };
} DDPIXELFORMAT, * LPDDPIXELFORMAT;
#endif // _DDPIXELFORMAT_DEFINED

#endif // !defined(__DDRAW_INCLUDED__)

//==========================================================================
// End of DDraw.h header info
//==========================================================================

//==========================================================================
// The following definitions must be in sync with DVP.h in DirectX SDK
//==========================================================================

#if !defined(__DVP_INCLUDED__)

typedef struct _DDVIDEOPORTCONNECT {
    DWORD dwSize;           // size of the DDVIDEOPORTCONNECT structure
    DWORD dwPortWidth;      // Width of the video port
    GUID  guidTypeID;       // Description of video port connection
    DWORD dwFlags;          // Connection flags
    ULONG_PTR dwReserved1;  // Reserved, set to zero.
} DDVIDEOPORTCONNECT, * LPDDVIDEOPORTCONNECT;

#define DDVPTYPE_E_HREFH_VREFH  \
    0x54F39980L,0xDA60,0x11CF,0x9B,0x06,0x00,0xA0,0xC9,0x03,0xA3,0xB8

#define DDVPTYPE_E_HREFL_VREFL  \
    0xE09C77E0L,0xDA60,0x11CF,0x9B,0x06,0x00,0xA0,0xC9,0x03,0xA3,0xB8

#endif // !defined(__DVP_INCLUDED__)

//==========================================================================
// End of DVP.h header info
//==========================================================================


//==========================================================================
// The following definitions must be in sync with VPType.h in AM 2.0 SDK
//==========================================================================

// pixel aspect ratios corresponding to a 720x480 NTSC image or a 720x576 image
typedef enum // AMPixAspectRatio
{
    KS_PixAspectRatio_NTSC4x3,
    KS_PixAspectRatio_NTSC16x9,
    KS_PixAspectRatio_PAL4x3,
    KS_PixAspectRatio_PAL16x9
} KS_AMPixAspectRatio ;

typedef enum // AMVP_SELECTFORMATBY
{
    KS_AMVP_DO_NOT_CARE,
    KS_AMVP_BEST_BANDWIDTH,
    KS_AMVP_INPUT_SAME_AS_OUTPUT
} KS_AMVP_SELECTFORMATBY;

typedef enum // AMVP_MODE
{
    KS_AMVP_MODE_WEAVE,
    KS_AMVP_MODE_BOBINTERLEAVED,
    KS_AMVP_MODE_BOBNONINTERLEAVED,
    KS_AMVP_MODE_SKIPEVEN,
    KS_AMVP_MODE_SKIPODD
} KS_AMVP_MODE ;

typedef struct tagKS_AMVPDIMINFO      // AMVPDIMINFO
{
    DWORD dwFieldWidth ;            // [out] field width
    DWORD dwFieldHeight ;           // [out] field height
    DWORD dwVBIWidth ;              // [out] VBI data width
    DWORD dwVBIHeight ;             // [out] VBI data height
    RECT  rcValidRegion ;           // [out] valid rect for data cropping
} KS_AMVPDIMINFO, *PKS_AMVPDIMINFO ;

typedef struct tagKS_AMVPDATAINFO   // AMVPDATAINFO
{
    DWORD           dwSize;                 // Size of the struct
    DWORD           dwMicrosecondsPerField; // Time taken by each field
    KS_AMVPDIMINFO  amvpDimInfo;            // Dimensional Information
    DWORD           dwPictAspectRatioX;     // Pict aspect ratio in X dimn
    DWORD           dwPictAspectRatioY;     // Pict aspect ratio in Y dimn
    BOOL            bEnableDoubleClock;     // Videoport should enable double clocking
    BOOL            bEnableVACT;            // Videoport should use an external VACT signal
    BOOL            bDataIsInterlaced;      // Indicates that the signal is interlaced
    LONG            lHalfLinesOdd;          // number of halflines in the odd field
    BOOL            bFieldPolarityInverted; // Device inverts the polarity by default
    DWORD           dwNumLinesInVREF;       // Number of lines of data in VREF
    LONG            lHalfLinesEven;         // number of halflines in the even field
    DWORD           dwReserved1;            // Reserved for future use
} KS_AMVPDATAINFO, *PKS_AMVPDATAINFO;

typedef struct tagKS_AMVPSIZE   // AMVPSIZE
{
    DWORD dwWidth ;                  // [in] width in pixels
    DWORD dwHeight ;                 // [in] height in pixels
} KS_AMVPSIZE, *PKS_AMVPSIZE ;

//==========================================================================
// End of VPType.h header info
//==========================================================================

typedef struct {
    KS_AMVPSIZE     Size;
    DWORD           MaxPixelsPerSecond;
    DWORD           Reserved;
} KSVPMAXPIXELRATE, *PKSVPMAXPIXELRATE;

typedef struct {
    KSPROPERTY      Property;
    KS_AMVPSIZE     Size;
} KSVPSIZE_PROP, *PKSVPSIZE_PROP;

typedef struct {
    DWORD   dwPitch;
    DWORD   dwXOrigin;
    DWORD   dwYOrigin;
} KSVPSURFACEPARAMS, *PKSVPSURFACEPARAMS;

#endif // !defined(__IVPType__)

//
//  IVPNotify event notification
//
#define STATIC_KSEVENTSETID_VPNotify\
    0x20c5598eL, 0xd3c8, 0x11d0, 0x8d, 0xfc, 0x00, 0xc0, 0x4f, 0xd7, 0xc0, 0x8b
DEFINE_GUIDSTRUCT("20c5598e-d3c8-11d0-8dfc-00c04fd7c08b", KSEVENTSETID_VPNotify);
#define KSEVENTSETID_VPNotify DEFINE_GUIDNAMED(KSEVENTSETID_VPNotify)

typedef enum {
    KSEVENT_VPNOTIFY_FORMATCHANGE
} KSEVENT_VPNOTIFY;

//
//  VIDCAPTOSTI event notification
//
#define STATIC_KSEVENTSETID_VIDCAPTOSTI\
    0xdb47de20, 0xf628, 0x11d1, 0xba, 0x41, 0x0, 0xa0, 0xc9, 0xd, 0x2b, 0x5
DEFINE_GUIDSTRUCT("DB47DE20-F628-11d1-BA41-00A0C90D2B05", KSEVENTSETID_VIDCAPTOSTI);
#define KSEVENTSETID_VIDCAPNotify DEFINE_GUIDNAMED(KSEVENTSETID_VIDCAPTOSTI)

typedef enum {
    KSEVENT_VIDCAPTOSTI_EXT_TRIGGER
#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)
    , KSEVENT_VIDCAP_AUTO_UPDATE
    , KSEVENT_VIDCAP_SEARCH
#endif // XP SP2 and later (chronologically)
} KSEVENT_VIDCAPTOSTI;

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

//
// Extension Unit Properties
//
typedef enum {
    KSPROPERTY_EXTENSION_UNIT_INFO,                  // (R)
    KSPROPERTY_EXTENSION_UNIT_CONTROL,               // (RW) 
    KSPROPERTY_EXTENSION_UNIT_PASS_THROUGH = 0xffff  // (RW) 
} KSPROPERTY_EXTENSION_UNIT, *PKSPROPERTY_EXTENSION_UNIT;

#endif // XP SP2 and later (chronologically)

//
//  IVPVBINotify event notification
//
#define STATIC_KSEVENTSETID_VPVBINotify\
    0xec529b01L, 0x1a1f, 0x11d1, 0xba, 0xd9, 0x0, 0x60, 0x97, 0x44, 0x11, 0x1a
DEFINE_GUIDSTRUCT("ec529b01-1a1f-11d1-bad9-00609744111a", KSEVENTSETID_VPVBINotify);
#define KSEVENTSETID_VPVBINotify DEFINE_GUIDNAMED(KSEVENTSETID_VPVBINotify)

typedef enum {
    KSEVENT_VPVBINOTIFY_FORMATCHANGE
} KSEVENT_VPVBINOTIFY;


//
// closed caption information
//

#define STATIC_KSDATAFORMAT_TYPE_AUXLine21Data \
0x670aea80L, 0x3a82, 0x11d0, 0xb7, 0x9b, 0x00, 0xaa, 0x00, 0x37, 0x67, 0xa7
DEFINE_GUIDSTRUCT("670aea80-3a82-11d0-b79b-00aa003767a7", KSDATAFORMAT_TYPE_AUXLine21Data);
#define KSDATAFORMAT_TYPE_AUXLine21Data DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_AUXLine21Data)

#define STATIC_KSDATAFORMAT_SUBTYPE_Line21_BytePair \
0x6e8d4a22L, 0x310c, 0x11d0, 0xb7, 0x9a, 0x00, 0xaa, 0x00, 0x37, 0x67, 0xa7
DEFINE_GUIDSTRUCT("6e8d4a22-310c-11d0-b79a-00aa003767a7", KSDATAFORMAT_SUBTYPE_Line21_BytePair);
#define KSDATAFORMAT_SUBTYPE_Line21_BytePair DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_Line21_BytePair)

#define STATIC_KSDATAFORMAT_SUBTYPE_Line21_GOPPacket \
0x6e8d4a23L, 0x310c, 0x11d0, 0xb7, 0x9a, 0x00, 0xaa, 0x00, 0x37, 0x67, 0xa7
DEFINE_GUIDSTRUCT("6e8d4a23-310c-11d0-b79a-00aa003767a7", KSDATAFORMAT_SUBTYPE_Line21_GOPPacket);
#define KSDATAFORMAT_SUBTYPE_Line21_GOPPacket DEFINE_GUIDNAMED(KSDATAFORMAT_SUBTYPE_Line21_GOPPacket)

typedef struct _KSGOP_USERDATA {
    ULONG sc;
    ULONG reserved1;
    BYTE cFields;
    CHAR l21Data[3];
} KSGOP_USERDATA, *PKSGOP_USERDATA;

//
// DVD encrypted PACK format type definition
//

#define STATIC_KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK\
    0xed0b916a, 0x044d, 0x11d1, 0xaa, 0x78, 0x00, 0xc0, 0x4f, 0xc3, 0x1d, 0x60
DEFINE_GUIDSTRUCT("ed0b916a-044d-11d1-aa78-00c04fc31d60", KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK);
#define KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK DEFINE_GUIDNAMED(KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK)

#define KS_AM_UseNewCSSKey              0x0001L
// -----------------------------------------------------------------------
// KS_AM_KSPROPSETID_TSRateChange property set definitions for time stamp
// rate changes.
// -----------------------------------------------------------------------


#define STATIC_KSPROPSETID_TSRateChange\
    0xa503c5c0, 0x1d1d, 0x11d1, 0xad, 0x80, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0

DEFINE_GUIDSTRUCT("A503C5C0-1D1D-11D1-AD80-444553540000", KSPROPSETID_TSRateChange);
#define KSPROPSETID_TSRateChange DEFINE_GUIDNAMED(KSPROPSETID_TSRateChange)
typedef enum {
    KS_AM_RATE_SimpleRateChange=1,  // rw, use KS_AM_SimpleRateChange
    KS_AM_RATE_ExactRateChange=2,   // rw, use KS_AM_ExactRateChange
    KS_AM_RATE_MaxFullDataRate=3,   // r, use KS_AM_MaxFullDataRate
    KS_AM_RATE_Step=4               // w, use KS_AM_Step
} KS_AM_PROPERTY_TS_RATE_CHANGE;

typedef struct {
    // this is the simplest mechanism to set a time stamp rate change on
    // a filter (simplest for the person setting the rate change, harder
    // for the filter doing the rate change).
    REFERENCE_TIME  StartTime;  //stream time at which to start this rate
    LONG        Rate;       //new rate * 10000 (decimal)
} KS_AM_SimpleRateChange, *PKS_AM_SimpleRateChange;

typedef struct {
    REFERENCE_TIME  OutputZeroTime; //input TS that maps to zero output TS
    LONG        Rate;       //new rate * 10000 (decimal)
} KS_AM_ExactRateChange, *PKS_AM_ExactRateChange;

typedef LONG KS_AM_MaxFullDataRate; //rate * 10000 (decimal)

typedef DWORD KS_AM_Step; // number of frame to step

#if (NTDDI_VERSION >= NTDDI_WINXPSP1)

//===========================================================================
//ENCODER API DEFINITIONS
//===========================================================================

#define STATIC_KSCATEGORY_ENCODER \
    0x19689bf6, 0xc384, 0x48fd, 0xad, 0x51, 0x90, 0xe5, 0x8c, 0x79, 0xf7, 0xb
DEFINE_GUIDSTRUCT("19689BF6-C384-48fd-AD51-90E58C79F70B", KSCATEGORY_ENCODER);
#define KSCATEGORY_ENCODER DEFINE_GUIDNAMED(KSCATEGORY_ENCODER)

#define STATIC_KSCATEGORY_MULTIPLEXER \
    0x7a5de1d3, 0x1a1, 0x452c, 0xb4, 0x81, 0x4f, 0xa2, 0xb9, 0x62, 0x71, 0xe8
DEFINE_GUIDSTRUCT("7A5DE1D3-01A1-452c-B481-4FA2B96271E8", KSCATEGORY_MULTIPLEXER);
#define KSCATEGORY_MULTIPLEXER DEFINE_GUIDNAMED(KSCATEGORY_MULTIPLEXER)

#ifndef __ENCODER_API_GUIDS__
#define __ENCODER_API_GUIDS__

#define STATIC_ENCAPIPARAM_BITRATE \
    0x49cc4c43, 0xca83, 0x4ad4, 0xa9, 0xaf, 0xf3, 0x69, 0x6a, 0xf6, 0x66, 0xdf
DEFINE_GUIDSTRUCT("49CC4C43-CA83-4ad4-A9AF-F3696AF666DF", ENCAPIPARAM_BITRATE);
#define ENCAPIPARAM_BITRATE DEFINE_GUIDNAMED(ENCAPIPARAM_BITRATE)

#define STATIC_ENCAPIPARAM_PEAK_BITRATE \
    0x703f16a9, 0x3d48, 0x44a1, 0xb0, 0x77, 0x1, 0x8d, 0xff, 0x91, 0x5d, 0x19
DEFINE_GUIDSTRUCT("703F16A9-3D48-44a1-B077-018DFF915D19", ENCAPIPARAM_PEAK_BITRATE);
#define ENCAPIPARAM_PEAK_BITRATE DEFINE_GUIDNAMED(ENCAPIPARAM_PEAK_BITRATE)

#define STATIC_ENCAPIPARAM_BITRATE_MODE \
    0xee5fb25c, 0xc713, 0x40d1, 0x9d, 0x58, 0xc0, 0xd7, 0x24, 0x1e, 0x25, 0xf
DEFINE_GUIDSTRUCT("EE5FB25C-C713-40d1-9D58-C0D7241E250F", ENCAPIPARAM_BITRATE_MODE);
#define ENCAPIPARAM_BITRATE_MODE DEFINE_GUIDNAMED(ENCAPIPARAM_BITRATE_MODE)

#if ( (NTDDI_VERSION >= NTDDI_WINXPSP2) && (NTDDI_VERSION < NTDDI_WS03) ) || (NTDDI_VERSION >= NTDDI_WS03SP1)

#define STATIC_CODECAPI_CHANGELISTS \
    0x62b12acf, 0xf6b0, 0x47d9, 0x94, 0x56, 0x96, 0xf2, 0x2c, 0x4e, 0x0b, 0x9d
DEFINE_GUIDSTRUCT("62B12ACF-F6B0-47D9-9456-96F22C4E0B9D", CODECAPI_CHANGELISTS );
#define CODECAPI_CHANGELISTS DEFINE_GUIDNAMED(CODECAPI_CHANGELISTS )

#define STATIC_CODECAPI_VIDEO_ENCODER \
    0x7112e8e1, 0x3d03, 0x47ef, 0x8e, 0x60, 0x03, 0xf1, 0xcf, 0x53, 0x73, 0x01
DEFINE_GUIDSTRUCT("7112E8E1-3D03-47EF-8E60-03F1CF537301", CODECAPI_VIDEO_ENCODER );
#define CODECAPI_VIDEO_ENCODER DEFINE_GUIDNAMED(CODECAPI_VIDEO_ENCODER )

#define STATIC_CODECAPI_AUDIO_ENCODER \
    0xb9d19a3e, 0xf897, 0x429c, 0xbc, 0x46, 0x81, 0x38, 0xb7, 0x27, 0x2b, 0x2d
DEFINE_GUIDSTRUCT("B9D19A3E-F897-429C-BC46-8138B7272B2D", CODECAPI_AUDIO_ENCODER );
#define CODECAPI_AUDIO_ENCODER DEFINE_GUIDNAMED(CODECAPI_AUDIO_ENCODER )

#define STATIC_CODECAPI_SETALLDEFAULTS \
    0x6c5e6a7c, 0xacf8, 0x4f55, 0xa9, 0x99, 0x1a, 0x62, 0x81, 0x09, 0x05, 0x1b
DEFINE_GUIDSTRUCT("6C5E6A7C-ACF8-4F55-A999-1A628109051B", CODECAPI_SETALLDEFAULTS );
#define CODECAPI_SETALLDEFAULTS DEFINE_GUIDNAMED(CODECAPI_SETALLDEFAULTS )

#define STATIC_CODECAPI_ALLSETTINGS \
    0x6a577e92, 0x83e1, 0x4113, 0xad, 0xc2, 0x4f, 0xce, 0xc3, 0x2f, 0x83, 0xa1
DEFINE_GUIDSTRUCT("6A577E92-83E1-4113-ADC2-4FCEC32F83A1", CODECAPI_ALLSETTINGS );
#define CODECAPI_ALLSETTINGS DEFINE_GUIDNAMED(CODECAPI_ALLSETTINGS )

#define STATIC_CODECAPI_SUPPORTSEVENTS \
    0x0581af97, 0x7693, 0x4dbd, 0x9d, 0xca, 0x3f, 0x9e, 0xbd, 0x65, 0x85, 0xa1 
DEFINE_GUIDSTRUCT("0581AF97-7693-4DBD-9DCA-3F9EBD6585A1", CODECAPI_SUPPORTSEVENTS );
#define CODECAPI_SUPPORTSEVENTS DEFINE_GUIDNAMED(CODECAPI_SUPPORTSEVENTS )

#define STATIC_CODECAPI_CURRENTCHANGELIST \
    0x1cb14e83, 0x7d72, 0x4657, 0x83, 0xfd, 0x47, 0xa2, 0xc5, 0xb9, 0xd1, 0x3d 
DEFINE_GUIDSTRUCT("1CB14E83-7D72-4657-83FD-47A2C5B9D13D", CODECAPI_CURRENTCHANGELIST );
#define CODECAPI_CURRENTCHANGELIST DEFINE_GUIDNAMED(CODECAPI_CURRENTCHANGELIST )

#endif // XP SP2 and later (chronologically)

#endif // __ENCODER_API_GUIDS__

#ifndef __ENCODER_API_DEFINES__
#define __ENCODER_API_DEFINES__

typedef enum {

    //
    // Bit rate used for encoding is constant
    //
    ConstantBitRate = 0,

    //
    // Bit rate used for encoding is variable with the specified bitrate used
    // as a guaranteed average over a specified window.  The default window 
    // size is considered to be 5 minutes.
    //
    VariableBitRateAverage,

    //
    // Bit rate used for encoding is variable with the specified bitrate used
    // as an average with a peak not to exceed the specified peak bitrate over 
    // a specified window.  The default window size is considered to be 500ms 
    // (classically one GOP).
    //
    VariableBitRatePeak

} VIDEOENCODER_BITRATE_MODE;

#endif // __ENCODER_API_DEFINES__

//===========================================================================
// JACK DESCRIPTION DEFINITIONS
//===========================================================================
#define STATIC_KSPROPSETID_Jack\
    0x4509f757, 0x2d46, 0x4637, 0x8e, 0x62, 0xce, 0x7d, 0xb9, 0x44, 0xf5, 0x7b
DEFINE_GUIDSTRUCT("4509F757-2D46-4637-8E62-CE7DB944F57B", KSPROPSETID_Jack);
#define KSPROPSETID_Jack DEFINE_GUIDNAMED(KSPROPSETID_Jack)

// define new property id 
typedef enum {
    KSPROPERTY_JACK_DESCRIPTION = 1,
    KSPROPERTY_JACK_DESCRIPTION2,
    KSPROPERTY_JACK_SINK_INFO,
    KSPROPERTY_JACK_CONTAINERID
#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
    , KSPROPERTY_JACK_DESCRIPTION3
#endif // (NTDDI_VERSION >= NTDDI_WIN10_NI)
} KSPROPERTY_JACK;

// Enums used in KSPROPERTY_JACK_INFO_STRUCT

typedef enum
{
    eConnTypeUnknown,
    eConnType3Point5mm,
    eConnTypeQuarter,
    eConnTypeAtapiInternal,
    eConnTypeRCA,
    eConnTypeOptical,
    eConnTypeOtherDigital,
    eConnTypeOtherAnalog,
    eConnTypeMultichannelAnalogDIN,
    eConnTypeXlrProfessional,
    eConnTypeRJ11Modem,
    eConnTypeCombination
} EPcxConnectionType;

#define eGeoLocReserved5 eGeoLocNotApplicable
typedef enum
{
    eGeoLocRear = 0x1,
    eGeoLocFront,
    eGeoLocLeft,
    eGeoLocRight,
    eGeoLocTop,
    eGeoLocBottom,
    eGeoLocRearPanel,
    eGeoLocRiser,
    eGeoLocInsideMobileLid,
    eGeoLocDrivebay,
    eGeoLocHDMI,
    eGeoLocOutsideMobileLid,
    eGeoLocATAPI,
    eGeoLocNotApplicable,
    eGeoLocReserved6,
    EPcxGeoLocation_enum_count
} EPcxGeoLocation;

typedef enum
{
    eGenLocPrimaryBox = 0,
    eGenLocInternal,
    eGenLocSeparate,
    eGenLocOther,
    EPcxGenLocation_enum_count
} EPcxGenLocation;

typedef enum
{
    ePortConnJack = 0,
    ePortConnIntegratedDevice,
    ePortConnBothIntegratedAndJack,
    ePortConnUnknown
} EPxcPortConnection;

// structure for KSPROPERTY_JACK_DESCRIPTION pin property
typedef struct 
{
    DWORD                 ChannelMapping;
    DWORD                 Color;   // 0x00rrggbb; (NOT a COLORREF)
    EPcxConnectionType    ConnectionType;
    EPcxGeoLocation       GeoLocation;
    EPcxGenLocation       GenLocation;
    EPxcPortConnection    PortConnection;
    BOOL                  IsConnected;
} KSJACK_DESCRIPTION, *PKSJACK_DESCRIPTION;

typedef enum 
{
    KSJACK_SINK_CONNECTIONTYPE_HDMI = 0,            // HDMI
    KSJACK_SINK_CONNECTIONTYPE_DISPLAYPORT,         // DisplayPort
} KSJACK_SINK_CONNECTIONTYPE;

#define MAX_SINK_DESCRIPTION_NAME_LENGTH 32
typedef struct _tagKSJACK_SINK_INFORMATION
{
  KSJACK_SINK_CONNECTIONTYPE ConnType;              // Connection Type
  WORD  ManufacturerId;                             // Sink manufacturer ID
  WORD  ProductId;                                  // Sink product ID
  WORD  AudioLatency;                                    // Sink audio latency
  BOOL  HDCPCapable;                                // HDCP Support
  BOOL  AICapable;                                  // ACP Packet, ISRC1, and ISRC2 Support
  UCHAR SinkDescriptionLength;                      // Monitor/Sink name length
  WCHAR SinkDescription[MAX_SINK_DESCRIPTION_NAME_LENGTH];   // Monitor/Sink name
  LUID  PortId;                                     // Video port identifier
}  KSJACK_SINK_INFORMATION, *PKSJACK_SINK_INFORMATION;

#define JACKDESC2_PRESENCE_DETECT_CAPABILITY       0x00000001 
#define JACKDESC2_DYNAMIC_FORMAT_CHANGE_CAPABILITY 0x00000002

typedef struct _tagKSJACK_DESCRIPTION2
{
  DWORD              DeviceStateInfo; // Top 16 bits: Report current device state, active, streaming, idle, or hardware not ready
                                      // Bottom 16 bits: detailed reason to further explain state in top 16 bits
  DWORD              JackCapabilities; // Report jack capabilities such as jack presence detection capability 
                                       // or dynamic format changing capability         
} KSJACK_DESCRIPTION2, *PKSJACK_DESCRIPTION2;

#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
typedef struct _tagKSJACK_DESCRIPTION3
{
  ULONG              ConfigId; // Driver defined bitmask or enum describing the current configuration, changing this value causes
                               // audioendpointbuilder to refresh the cache to ensure that the published endpoint matches the current config.
} KSJACK_DESCRIPTION3, *PKSJACK_DESCRIPTION3;
#endif // (NTDDI_VERSION >= NTDDI_WIN10_NI)

#endif // (NTDDI_VERSION >= NTDDI_WINXPSP1)

#if (NTDDI_VERSION >= NTDDI_WIN10_FE)
//===========================================================================
// AUDIO POSTURE DEFINITIONS
//===========================================================================
// {A3FB7B0D-474E-4F51-A379-51282DD4FA8F}
#define STATIC_KSPROPSETID_AudioPosture\
    0xa3fb7b0d, 0x474e, 0x4f51, 0xa3, 0x79, 0x51, 0x28, 0x2d, 0xd4, 0xfa, 0x8f
DEFINE_GUIDSTRUCT("A3FB7B0D-474E-4F51-A379-51282DD4FA8F", KSPROPSETID_AudioPosture);
#define KSPROPSETID_AudioPosture DEFINE_GUIDNAMED(KSPROPSETID_AudioPosture)

typedef enum {
    KSPROPERTY_AUDIOPOSTURE_ORIENTATION         = 1
} KSPROPERTY_AUDIOPOSTURE;

typedef enum
{
    AUDIOPOSTURE_ORIENTATION_NOTROTATED = 0,
    AUDIOPOSTURE_ORIENTATION_ROTATED90DEGREESCOUNTERCLOCKWISE,
    AUDIOPOSTURE_ORIENTATION_ROTATED180DEGREESCOUNTERCLOCKWISE,
    AUDIOPOSTURE_ORIENTATION_ROTATED270DEGREESCOUNTERCLOCKWISE
} AUDIOPOSTURE_ORIENTATION;

#endif // (NTDDI_VERSION >= NTDDI_WIN10_FE)

//===========================================================================
// Audio Buffer Duration
#define STATIC_KSPROPSETID_AudioBufferDuration\
    0x4e73c07f, 0x23cc, 0x4955, 0xa7, 0xea, 0x3d, 0xa5, 0x2, 0x49, 0x62, 0x90 
DEFINE_GUIDSTRUCT("4E73C07F-23CC-4955-A7EA-3DA502496290", KSPROPSETID_AudioBufferDuration);
#define KSPROPSETID_AudioBufferDuration DEFINE_GUIDNAMED(KSPROPSETID_AudioBufferDuration)

// define new property id 
#define KSPROPERTY_AUDIO_BUFFER_DURATION 1

//===========================================================================
// HARDWARE AUDIO ENGINE DEFINITIONS
//===========================================================================
#define STATIC_KSPROPSETID_AudioEngine\
    0x3A2F82DCL, 0x886F, 0x4BAA, 0x9E, 0xB4, 0x8, 0x2B, 0x90, 0x25, 0xC5, 0x36
DEFINE_GUIDSTRUCT("3A2F82DC-886F-4BAA-9EB4-082B9025C536", KSPROPSETID_AudioEngine);
#define KSPROPSETID_AudioEngine DEFINE_GUIDNAMED(KSPROPSETID_AudioEngine)

typedef enum {
    KSPROPERTY_AUDIOENGINE_LFXENABLE = 0,
    KSPROPERTY_AUDIOENGINE_GFXENABLE = 1,
    KSPROPERTY_AUDIOENGINE_MIXFORMAT = 2,
    // constant "3" was skipped on purpose for backward compatibility 
    // from the removal of unused KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD
    KSPROPERTY_AUDIOENGINE_DEVICEFORMAT = 4,
    KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS = 5,
    KSPROPERTY_AUDIOENGINE_DESCRIPTOR = 6,
    KSPROPERTY_AUDIOENGINE_BUFFER_SIZE_RANGE = 7,
    KSPROPERTY_AUDIOENGINE_LOOPBACK_PROTECTION = 8,
    KSPROPERTY_AUDIOENGINE_VOLUMELEVEL = 9,
#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
    KSPROPERTY_AUDIOENGINE_DEVICECONTROLS = 10,
#endif // (NTDDI_VERSION >= NTDDI_WIN10_NI)
} KSPROPERTY_AUDIOENGINE;

typedef struct _tagKSAUDIOENGINE_DESCRIPTOR
{
    UINT    nHostPinId;
    UINT    nOffloadPinId;
    UINT    nLoopbackPinId;
} KSAUDIOENGINE_DESCRIPTOR, *PKSAUDIOENGINE_DESCRIPTOR;

typedef struct _tagKSAUDIOENGINE_BUFFER_SIZE_RANGE
{
    ULONG MinBufferBytes;
    ULONG MaxBufferBytes;
} KSAUDIOENGINE_BUFFER_SIZE_RANGE, *PKSAUDIOENGINE_BUFFER_SIZE_RANGE;

#ifndef _AUDIO_CURVE_TYPE_
#define _AUDIO_CURVE_TYPE_
typedef enum {
    AUDIO_CURVE_TYPE_NONE           = 0,
    AUDIO_CURVE_TYPE_WINDOWS_FADE   = 1,
} AUDIO_CURVE_TYPE;
#endif // _AUDIO_CURVE_TYPE_

typedef struct _tagKSAUDIOENGINE_VOLUMELEVEL
{
    LONG                                TargetVolume;
    AUDIO_CURVE_TYPE                    CurveType;
    ULONGLONG                           CurveDuration;
} KSAUDIOENGINE_VOLUMELEVEL, *PKSAUDIOENGINE_VOLUMELEVEL;

#if (NTDDI_VERSION >= NTDDI_WIN10_NI)
typedef enum {
    eDeviceControlUseMissing    = 0,
    eDeviceControlUsePrimary    = 1,
    eDeviceControlUseSecondary  = 2,
} EDeviceControlUseType;

typedef struct _tagKSAUDIOENGINE_DEVICECONTROLS
{
    EDeviceControlUseType   Volume;
    EDeviceControlUseType   Mute;
    EDeviceControlUseType   PeakMeter;
} KSAUDIOENGINE_DEVICECONTROLS, *PKSAUDIOENGINE_DEVICECONTROLS;
#endif // (NTDDI_VERSION >= NTDDI_WIN10_NI)

//===========================================================================
// AUDIO SIGNAL PROCESSING DEFINITIONS
//===========================================================================

#define STATIC_KSPROPSETID_AudioSignalProcessing\
    0x4f67b528, 0x30c9, 0x40de, 0xb2, 0xfb, 0x85, 0x9d, 0xdd, 0x1f, 0x34, 0x70
DEFINE_GUIDSTRUCT("4F67B528-30C9-40DE-B2FB-859DDD1F3470", KSPROPSETID_AudioSignalProcessing);
#define KSPROPSETID_AudioSignalProcessing DEFINE_GUIDNAMED(KSPROPSETID_AudioSignalProcessing)

typedef enum {
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES,
} KSPROPERTY_AUDIOSIGNALPROCESSING;

#define STATIC_KSATTRIBUTEID_AUDIOSIGNALPROCESSING_MODE 0xe1f89eb5, 0x5f46, 0x419b, 0x96, 0x7b, 0xff, 0x67, 0x70, 0xb9, 0x84, 0x1
DEFINE_GUIDSTRUCT("E1F89EB5-5F46-419B-967B-FF6770B98401", KSATTRIBUTEID_AUDIOSIGNALPROCESSING_MODE);
#define KSATTRIBUTEID_AUDIOSIGNALPROCESSING_MODE DEFINE_GUIDNAMED(KSATTRIBUTEID_AUDIOSIGNALPROCESSING_MODE)

// Define structure of the KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE attribute
typedef struct tagKSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE
{
    KSATTRIBUTE AttributeHeader;
    GUID        SignalProcessingMode;
} KSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE, *PKSATTRIBUTE_AUDIOSIGNALPROCESSING_MODE;

#define STATIC_AUDIO_SIGNALPROCESSINGMODE_DEFAULT 0xc18e2f7e, 0x933d, 0x4965, 0xb7, 0xd1, 0x1e, 0xef, 0x22, 0x8d, 0x2a, 0xf3
DEFINE_GUIDSTRUCT("C18E2F7E-933D-4965-B7D1-1EEF228D2AF3", AUDIO_SIGNALPROCESSINGMODE_DEFAULT);
#define AUDIO_SIGNALPROCESSINGMODE_DEFAULT DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_DEFAULT)

#define STATIC_AUDIO_SIGNALPROCESSINGMODE_RAW 0x9e90ea20, 0xb493, 0x4fd1, 0xa1, 0xa8, 0x7e, 0x13, 0x61, 0xa9, 0x56, 0xcf
DEFINE_GUIDSTRUCT("9E90EA20-B493-4FD1-A1A8-7E1361A956CF", AUDIO_SIGNALPROCESSINGMODE_RAW);
#define AUDIO_SIGNALPROCESSINGMODE_RAW DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_RAW)

#if (NTDDI_VERSION >= NTDDI_WIN10_CO)
//===========================================================================
// AUDIO RESOURCE MANAGEMENT DEFINITIONS
//===========================================================================
// {D0B305E1-B2CC-484C-8F23-E5D28AD9CF88}
#define STATIC_KSPROPSETID_AudioResourceManagement\
    0xd0b305e1, 0xb2cc, 0x484c, 0x8f, 0x23, 0xe5, 0xd2, 0x8a, 0xd9, 0xcf, 0x88
DEFINE_GUIDSTRUCT("D0B305E1-B2CC-484C-8F23-E5D28AD9CF88", KSPROPSETID_AudioResourceManagement); 
#define KSPROPSETID_AudioResourceManagement DEFINE_GUIDNAMED(KSPROPSETID_AudioResourceManagement)

// define new property id
typedef enum {
    KSPROPERTY_AUDIORESOURCEMANAGEMENT_RESOURCEGROUP
} KSPROPERTY_AUDIORESOURCEMANAGEMENT;

#define MAX_RESOURCEGROUPID_LENGTH 256

// structure for KSPROPERTY_AUDIORESOURCEMANAGEMENT_RESOURCEGROUP
typedef struct
{
    BOOL    ResourceGroupAcquired;
    WCHAR   ResourceGroupName[MAX_RESOURCEGROUPID_LENGTH];
} AUDIORESOURCEMANAGEMENT_RESOURCEGROUP, *PAUDIORESOURCEMANAGEMENT_RESOURCEGROUP;

#endif // (NTDDI_VERSION >= NTDDI_WIN10_CO)

//
// UUIDs defined for Bluetooth Midi
//
#if (NTDDI_VERSION >= NTDDI_WIN10_RS1)

// Bluetooth MIDI service UUID
#define STATIC_BLUETOOTHLE_MIDI_SERVICE_UUID \
    0x03B80E5AL, 0xEDE8, 0x4B33, 0xA7, 0x51, 0x6C, 0xE3, 0x4E, 0xC4, 0xC7, 0x00
DEFINE_GUIDSTRUCT("03B80E5A-EDE8-4B33-A751-6CE34EC4C700", BLUETOOTHLE_MIDI_SERVICE_UUID);
#define BLUETOOTHLE_MIDI_SERVICE_UUID DEFINE_GUIDNAMED(BLUETOOTHLE_MIDI_SERVICE_UUID)

// Bluetooth MIDI IO Characteristic UUID
#define STATIC_BLUETOOTH_MIDI_DATAIO_CHARACTERISTIC \
    0x7772E5DBL, 0x3868, 0x4112, 0xA1, 0xA9, 0xF2, 0x66, 0x9D, 0x10, 0x6B, 0xF3
DEFINE_GUIDSTRUCT("7772E5DB-3868-4112-A1A9-F2669D106BF3", BLUETOOTH_MIDI_DATAIO_CHARACTERISTIC);
#define BLUETOOTH_MIDI_DATAIO_CHARACTERISTIC DEFINE_GUIDNAMED(BLUETOOTH_MIDI_DATAIO_CHARACTERISTIC)

//
// UUID for Audio Processing Object (APO) device class
//
#define STATIC_APO_CLASS_UUID \
    0x5989fce8L, 0x9cd0, 0x467d, 0x8a, 0x6a, 0x54, 0x19, 0xe3, 0x15, 0x29, 0xd4
DEFINE_GUIDSTRUCT("5989fce8-9cd0-467d-8a6a-5419e31529d4", APO_CLASS_UUID);
#define APO_CLASS_UUID DEFINE_GUIDNAMED(APO_CLASS_UUID)

//
// UUID for audio endpoint device class
//
#define STATIC_AUDIOENDPOINT_CLASS_UUID \
    0xC166523CL, 0xFE0C, 0x4A94, 0xA5, 0x86, 0xF1, 0xA8, 0x0C, 0xFB, 0xBF, 0x3E
DEFINE_GUIDSTRUCT("C166523C-FE0C-4A94-A586-F1A80CFBBF3E", AUDIOENDPOINT_CLASS_UUID);
#define AUDIOENDPOINT_CLASS_UUID DEFINE_GUIDNAMED(AUDIOENDPOINT_CLASS_UUID)

#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS1)

#if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

// Communications mode specifies that the application expects VoIP specific signal processing at the lowest latency and the hardware preferred sample rate for wideband speech (such as 16 kHz).
// For both Capture and Render.
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_COMMUNICATIONS 0x98951333, 0xb9cd, 0x48b1, 0xa0, 0xa3, 0xff, 0x40, 0x68, 0x2d, 0x73, 0xf7
DEFINE_GUIDSTRUCT("98951333-B9CD-48B1-A0A3-FF40682D73F7", AUDIO_SIGNALPROCESSINGMODE_COMMUNICATIONS);
#define AUDIO_SIGNALPROCESSINGMODE_COMMUNICATIONS DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_COMMUNICATIONS)

// Speech mode specifies that the application expects speech recognition specific signal processing at the lowest latency and the hardware preferred sample rate for wideband speech (such as 16 kHz).
// For Capture only.
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_SPEECH 0xfc1cfc9b, 0xb9d6, 0x4cfa, 0xb5, 0xe0, 0x4b, 0xb2, 0x16, 0x68, 0x78, 0xb2
DEFINE_GUIDSTRUCT("FC1CFC9B-B9D6-4CFA-B5E0-4BB2166878B2", AUDIO_SIGNALPROCESSINGMODE_SPEECH);
#define AUDIO_SIGNALPROCESSINGMODE_SPEECH DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_SPEECH)

// Notification Mode 
// For both render and capture.
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_NOTIFICATION 0x9cf2a70b, 0xf377, 0x403b, 0xbd, 0x6b, 0x36, 0x8, 0x63, 0xe0, 0x35, 0x5c
DEFINE_GUIDSTRUCT("9CF2A70B-F377-403B-BD6B-360863E0355C", AUDIO_SIGNALPROCESSINGMODE_NOTIFICATION);
#define AUDIO_SIGNALPROCESSINGMODE_NOTIFICATION DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_NOTIFICATION)

// Media Mode specifies that the application expects post processing suitable for media content if available or else the same treatments as Default mode.
// For Render only.
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_MEDIA 0x4780004e, 0x7133, 0x41d8, 0x8c, 0x74, 0x66, 0x0d, 0xad, 0xd2, 0xc0, 0xee
DEFINE_GUIDSTRUCT("4780004E-7133-41D8-8C74-660DADD2C0EE", AUDIO_SIGNALPROCESSINGMODE_MEDIA);
#define AUDIO_SIGNALPROCESSINGMODE_MEDIA DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_MEDIA)

// Movie Mode specifies that the application expects post processing suitable for movie or video content if available or else the same treatments as Default mode.
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_MOVIE 0xb26feb0d, 0xec94, 0x477c, 0x94, 0x94, 0xd1, 0xab, 0x8e, 0x75, 0x3f, 0x6e
DEFINE_GUIDSTRUCT("B26FEB0D-EC94-477C-9494-D1AB8E753F6E", AUDIO_SIGNALPROCESSINGMODE_MOVIE);
#define AUDIO_SIGNALPROCESSINGMODE_MOVIE DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_MOVIE)

#endif // (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)

#if (NTDDI_VERSION >= NTDDI_WIN10_FE)

// Far-Field speech mode specifies that the application expects speech recognition from the far-field
// For capture only
#define STATIC_AUDIO_SIGNALPROCESSINGMODE_FAR_FIELD_SPEECH 0x28941cba, 0x3be6, 0x4a78, 0x9a, 0x76, 0x30, 0xfd, 0x91, 0x55, 0x9b, 0x64
DEFINE_GUIDSTRUCT("28941CBA-3BE6-4A78-9A76-30FD91559B64", AUDIO_SIGNALPROCESSINGMODE_FAR_FIELD_SPEECH);
#define AUDIO_SIGNALPROCESSINGMODE_FAR_FIELD_SPEECH DEFINE_GUIDNAMED(AUDIO_SIGNALPROCESSINGMODE_FAR_FIELD_SPEECH)

#endif // (NTDDI_VERSION >= NTDDI_WIN10_FE)

#define STATIC_AUDIO_EFFECT_TYPE_ACOUSTIC_ECHO_CANCELLATION 0x6f64adbe, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adbe-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_ACOUSTIC_ECHO_CANCELLATION);
#define AUDIO_EFFECT_TYPE_ACOUSTIC_ECHO_CANCELLATION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_ACOUSTIC_ECHO_CANCELLATION)

#define STATIC_AUDIO_EFFECT_TYPE_NOISE_SUPPRESSION          0x6f64adbf, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adbf-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_NOISE_SUPPRESSION);
#define AUDIO_EFFECT_TYPE_NOISE_SUPPRESSION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_NOISE_SUPPRESSION)

#define STATIC_AUDIO_EFFECT_TYPE_AUTOMATIC_GAIN_CONTROL     0x6f64adc0, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc0-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_AUTOMATIC_GAIN_CONTROL);
#define AUDIO_EFFECT_TYPE_AUTOMATIC_GAIN_CONTROL DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_AUTOMATIC_GAIN_CONTROL)

#define STATIC_AUDIO_EFFECT_TYPE_BEAMFORMING                0x6f64adc1, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc1-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_BEAMFORMING);
#define AUDIO_EFFECT_TYPE_BEAMFORMING DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_BEAMFORMING)

#define STATIC_AUDIO_EFFECT_TYPE_CONSTANT_TONE_REMOVAL      0x6f64adc2, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc2-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_CONSTANT_TONE_REMOVAL);
#define AUDIO_EFFECT_TYPE_CONSTANT_TONE_REMOVAL DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_CONSTANT_TONE_REMOVAL)

#define STATIC_AUDIO_EFFECT_TYPE_EQUALIZER                  0x6f64adc3, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc3-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_EQUALIZER);
#define AUDIO_EFFECT_TYPE_EQUALIZER DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_EQUALIZER)

#define STATIC_AUDIO_EFFECT_TYPE_LOUDNESS_EQUALIZER         0x6f64adc4, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc4-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_LOUDNESS_EQUALIZER);
#define AUDIO_EFFECT_TYPE_LOUDNESS_EQUALIZER DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_LOUDNESS_EQUALIZER)

#define STATIC_AUDIO_EFFECT_TYPE_BASS_BOOST                 0x6f64adc5, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc5-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_BASS_BOOST);
#define AUDIO_EFFECT_TYPE_BASS_BOOST DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_BASS_BOOST)

#define STATIC_AUDIO_EFFECT_TYPE_VIRTUAL_SURROUND           0x6f64adc6, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc6-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_VIRTUAL_SURROUND);
#define AUDIO_EFFECT_TYPE_VIRTUAL_SURROUND DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_VIRTUAL_SURROUND)

#define STATIC_AUDIO_EFFECT_TYPE_VIRTUAL_HEADPHONES         0x6f64adc7, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc7-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_VIRTUAL_HEADPHONES);
#define AUDIO_EFFECT_TYPE_VIRTUAL_HEADPHONES DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_VIRTUAL_HEADPHONES)

#define STATIC_AUDIO_EFFECT_TYPE_SPEAKER_FILL               0x6f64adc8, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc8-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_SPEAKER_FILL);
#define AUDIO_EFFECT_TYPE_SPEAKER_FILL DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_SPEAKER_FILL)

#define STATIC_AUDIO_EFFECT_TYPE_ROOM_CORRECTION            0x6f64adc9, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adc9-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_ROOM_CORRECTION);
#define AUDIO_EFFECT_TYPE_ROOM_CORRECTION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_ROOM_CORRECTION)

#define STATIC_AUDIO_EFFECT_TYPE_BASS_MANAGEMENT            0x6f64adca, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adca-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_BASS_MANAGEMENT);
#define AUDIO_EFFECT_TYPE_BASS_MANAGEMENT DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_BASS_MANAGEMENT)

#define STATIC_AUDIO_EFFECT_TYPE_ENVIRONMENTAL_EFFECTS      0x6f64adcb, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adcb-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_ENVIRONMENTAL_EFFECTS);
#define AUDIO_EFFECT_TYPE_ENVIRONMENTAL_EFFECTS DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_ENVIRONMENTAL_EFFECTS)

#define STATIC_AUDIO_EFFECT_TYPE_SPEAKER_PROTECTION         0x6f64adcc, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adcc-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_SPEAKER_PROTECTION);
#define AUDIO_EFFECT_TYPE_SPEAKER_PROTECTION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_SPEAKER_PROTECTION)

#define STATIC_AUDIO_EFFECT_TYPE_SPEAKER_COMPENSATION       0x6f64adcd, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adcd-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_SPEAKER_COMPENSATION);
#define AUDIO_EFFECT_TYPE_SPEAKER_COMPENSATION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_SPEAKER_COMPENSATION)

#define STATIC_AUDIO_EFFECT_TYPE_DYNAMIC_RANGE_COMPRESSION  0x6f64adce, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adce-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_DYNAMIC_RANGE_COMPRESSION);
#define AUDIO_EFFECT_TYPE_DYNAMIC_RANGE_COMPRESSION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_DYNAMIC_RANGE_COMPRESSION)

#if (NTDDI_VERSION >= NTDDI_WIN10_FE)

#define STATIC_AUDIO_EFFECT_TYPE_FAR_FIELD_BEAMFORMING      0x6f64adcf, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64adcf-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_FAR_FIELD_BEAMFORMING);
#define AUDIO_EFFECT_TYPE_FAR_FIELD_BEAMFORMING DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_FAR_FIELD_BEAMFORMING)

#define STATIC_AUDIO_EFFECT_TYPE_DEEP_NOISE_SUPPRESSION     0x6f64add0, 0x8211, 0x11e2, 0x8c, 0x70, 0x2c, 0x27, 0xd7, 0xf0, 0x01, 0xfa
DEFINE_GUIDSTRUCT("6f64add0-8211-11e2-8c70-2c27d7f001fa", AUDIO_EFFECT_TYPE_DEEP_NOISE_SUPPRESSION);
#define AUDIO_EFFECT_TYPE_DEEP_NOISE_SUPPRESSION DEFINE_GUIDNAMED(AUDIO_EFFECT_TYPE_DEEP_NOISE_SUPPRESSION)

#endif // (NTDDI_VERSION >= NTDDI_WIN10_FE)

#if (NTDDI_VERSION >= NTDDI_WIN10_RS2)
//
// Interface to get audio modules information.
//
#define STATIC_KSPROPSETID_AudioModule \
    0xc034fdb0, 0xff75, 0x47c8, 0xaa, 0x3c, 0xee, 0x46, 0x71, 0x6b, 0x50, 0xc6
DEFINE_GUIDSTRUCT("C034FDB0-FF75-47C8-AA3C-EE46716B50C6", KSPROPSETID_AudioModule);
#define KSPROPSETID_AudioModule DEFINE_GUIDNAMED(KSPROPSETID_AudioModule)

typedef enum {
    KSPROPERTY_AUDIOMODULE_DESCRIPTORS            = 1,
    KSPROPERTY_AUDIOMODULE_COMMAND                = 2,
    KSPROPERTY_AUDIOMODULE_NOTIFICATION_DEVICE_ID = 3,
} KSPROPERTY_AUDIOMODULE; 

#define AUDIOMODULE_MAX_DATA_SIZE 64000 
#define AUDIOMODULE_MAX_NAME_CCH_SIZE 128

typedef struct _KSAUDIOMODULE_DESCRIPTOR
{
    GUID        ClassId; 
    ULONG       InstanceId;
    ULONG       VersionMajor;
    ULONG       VersionMinor;
    WCHAR       Name[AUDIOMODULE_MAX_NAME_CCH_SIZE];
} KSAUDIOMODULE_DESCRIPTOR, *PKSAUDIOMODULE_DESCRIPTOR;

typedef struct _KSAUDIOMODULE_PROPERTY
{
    KSPROPERTY  Property;
    GUID        ClassId; 
    ULONG       InstanceId;
} KSAUDIOMODULE_PROPERTY, *PKSAUDIOMODULE_PROPERTY;

//
// Audio module notification definitions.
//
#define STATIC_KSNOTIFICATIONID_AudioModule \
    0x9C2220F0, 0xD9A6, 0x4D5C, 0xA0, 0x36, 0x57, 0x38, 0x57, 0xFD, 0x50, 0xD2
DEFINE_GUIDSTRUCT("9C2220F0-D9A6-4D5C-A036-573857FD50D2", KSNOTIFICATIONID_AudioModule);
#define KSNOTIFICATIONID_AudioModule DEFINE_GUIDNAMED(KSNOTIFICATIONID_AudioModule)

typedef struct _KSAUDIOMODULE_NOTIFICATION {
    union {
        struct {
            GUID        DeviceId;
            GUID        ClassId;
            ULONG       InstanceId;
            ULONG       Reserved;
        } ProviderId;
        LONGLONG        Alignment;
    };
} KSAUDIOMODULE_NOTIFICATION, *PKSAUDIOMODULE_NOTIFICATION;

#endif // (NTDDI_VERSION >= NTDDI_WIN10_RS2)


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#endif // !defined(_KSMEDIA_)

