/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int n) {
        if (n > 0) {
            this.elementData = new Object[n];
        } else if (n == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
    }

    public ArrayList() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        if (this.size != 0) {
            if (this.elementData.getClass() != Object[].class) {
                this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        int n2;
        int n3 = n2 = this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA ? 0 : 10;
        if (n > n2) {
            this.ensureExplicitCapacity(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        if (this.elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            n = Math.max(10, n);
        }
        this.ensureExplicitCapacity(n);
    }

    private void ensureExplicitCapacity(int n) {
        ++this.modCount;
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = ArrayList.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    public E get(int n) {
        this.rangeCheck(n);
        return this.elementData(n);
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.rangeCheckForAdd(n);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        ++this.modCount;
        E e = this.elementData(n);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return e;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityInternal(this.size + n);
        System.arraycopy(objectArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.rangeCheckForAdd(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityInternal(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3;
        ++this.modCount;
        int n4 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n4);
        for (int i = n3 = this.size - (n2 - n); i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = n3;
    }

    private void rangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void rangeCheckForAdd(int n) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return this.batchRemove(collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return this.batchRemove(collection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        boolean bl2;
        int n;
        block8: {
            int n2;
            Object[] objectArray = this.elementData;
            n = 0;
            bl2 = false;
            try {
                for (n2 = 0; n2 < this.size; ++n2) {
                    if (collection.contains(objectArray[n2]) != bl) continue;
                    objectArray[n++] = objectArray[n2];
                }
                if (n2 == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (n2 != this.size) {
                    System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
                    n += this.size - n2;
                }
                if (n != this.size) {
                    for (int i = n; i < this.size; ++i) {
                        objectArray[i] = null;
                    }
                    this.modCount += this.size - n;
                    this.size = n;
                    bl2 = true;
                }
                throw throwable;
            }
            System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
            n += this.size - n2;
        }
        if (n != this.size) {
            for (int i = n; i < this.size; ++i) {
                objectArray[i] = null;
            }
            this.modCount += this.size - n;
            this.size = n;
            bl2 = true;
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.elementData = EMPTY_ELEMENTDATA;
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        if (this.size > 0) {
            this.ensureCapacityInternal(this.size);
            Object[] objectArray = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                objectArray[i] = objectInputStream.readObject();
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this, null);
    }

    @Override
    public List<E> subList(int n, int n2) {
        ArrayList.subListRangeCheck(n, n2, this.size);
        return new SubList(this, (AbstractList)this, 0, n, n2);
    }

    static void subListRangeCheck(int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Objects.requireNonNull(consumer);
        int n = this.modCount;
        Object[] objectArray = this.elementData;
        int n2 = this.size;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            consumer.accept(objectArray[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ArrayListSpliterator(0, -1, 0);
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        int n;
        Objects.requireNonNull(predicate);
        int n2 = 0;
        BitSet bitSet = new BitSet(this.size);
        int n3 = this.modCount;
        int n4 = this.size;
        for (n = 0; this.modCount == n3 && n < n4; ++n) {
            Object object = this.elementData[n];
            if (!predicate.test(object)) continue;
            bitSet.set(n);
            ++n2;
        }
        if (this.modCount != n3) {
            throw new ConcurrentModificationException();
        }
        int n5 = n = n2 > 0 ? 1 : 0;
        if (n != 0) {
            int n6 = n4 - n2;
            int n7 = 0;
            for (int i = 0; n7 < n4 && i < n6; ++n7, ++i) {
                n7 = bitSet.nextClearBit(n7);
                this.elementData[i] = this.elementData[n7];
            }
            for (n7 = n6; n7 < n4; ++n7) {
                this.elementData[n7] = null;
            }
            this.size = n6;
            if (this.modCount != n3) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return n != 0;
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        int n = this.modCount;
        int n2 = this.size;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            this.elementData[i] = unaryOperator.apply(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        int n = this.modCount;
        Arrays.sort(this.elementData, 0, this.size, comparator);
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    static /* synthetic */ int access$100(ArrayList arrayList) {
        return arrayList.size;
    }

    final class ArrayListSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = ArrayList.this.modCount;
                hi = this.fence = ArrayList.this.size;
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Object e = ArrayList.this.elementData[i];
                action.accept(e);
                if (ArrayList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = ArrayList.this.elementData;
            if (ArrayList.this.elementData != null) {
                int i;
                int mc;
                int hi = this.fence;
                if (hi < 0) {
                    mc = ArrayList.this.modCount;
                    hi = ArrayList.this.size;
                } else {
                    mc = this.expectedModCount;
                }
                if (i >= 0 && (this.index = hi) <= a.length) {
                    for (i = this.index; i < hi; ++i) {
                        Object e = a[i];
                        action.accept(e);
                    }
                    if (ArrayList.this.modCount == mc) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ArrayList<E> root;
        private final SubList<E> parent;
        private final int offset;
        private int size;

        public SubList(ArrayList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = root.modCount;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = parent.modCount;
        }

        @Override
        public E set(int index, E element) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E oldValue = this.root.elementData(this.offset + index);
            this.root.elementData[this.offset + index] = element;
            return oldValue;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            return this.root.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            this.root.replaceAllRange(operator, this.offset, this.offset + this.size);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.batchRemove(c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.batchRemove(c, true);
        }

        private boolean batchRemove(Collection<?> c, boolean complement) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.batchRemove(c, complement, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.removeIf(filter, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkForComodification();
            if (a.length < this.size) {
                return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size, a.getClass());
            }
            System.arraycopy(this.root.elementData, this.offset, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            boolean equal = this.root.equalsRange((List)o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return equal;
        }

        @Override
        public int hashCode() {
            int hash = this.root.hashCodeRange(this.offset, this.offset + this.size);
            this.checkForComodification();
            return hash;
        }

        @Override
        public int indexOf(Object o) {
            int index = this.root.indexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = this.root.lastIndexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        Object[] es = root.elementData;
                        if (offset + i >= es.length) {
                            throw new ConcurrentModificationException();
                        }
                        for (i = this.cursor; i < size && root.modCount == this.expectedModCount; ++i) {
                            action.accept(ArrayList.elementAt((Object[])es, (int)(offset + i)));
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                        this.checkForComodification();
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        root.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (root.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (this.root.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = this.root.modCount;
            } while ((slist = slist.parent) != null);
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator arrayListSpliterator;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        arrayListSpliterator = null;
                    } else {
                        ArrayList arrayList = root;
                        Objects.requireNonNull(arrayList);
                        this.index = mid;
                        ArrayListSpliterator arrayListSpliterator2 = arrayList.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                        arrayListSpliterator = arrayListSpliterator2;
                    }
                    return arrayListSpliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        Object e = root.elementData[i];
                        action.accept(e);
                        if (root.modCount != this.expectedModCount) {
                            throw new ConcurrentModificationException();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    ArrayList lst = root;
                    Object[] a = lst.elementData;
                    if (lst.elementData != null) {
                        int i;
                        int mc;
                        int hi = this.fence;
                        if (hi < 0) {
                            mc = modCount;
                            hi = offset + size;
                        } else {
                            mc = this.expectedModCount;
                        }
                        if (i >= 0 && (this.index = hi) <= a.length) {
                            for (i = this.index; i < hi; ++i) {
                                Object e = a[i];
                                action.accept(e);
                            }
                            if (lst.modCount == mc) {
                                return;
                            }
                        }
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = ArrayList.this.size;
            if (i < size) {
                Object[] es = ArrayList.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && ArrayList.this.modCount == this.expectedModCount; ++i) {
                    action.accept(ArrayList.elementAt((Object[])es, (int)i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

